/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.service.tcc.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.business.helper.AutoMatchServiceHelper;
import kd.tmc.bei.business.helper.MatchAmountDealHelper;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.bei.service.tcc.IAutoMatchTccService;
import kd.tmc.bei.service.tcc.TccLockEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransUpDownTccServiceImpl
implements IAutoMatchTccService {
    private static final Log LOGGER = LogFactory.getLog(TransUpDownTccServiceImpl.class);
    private final String key;

    public TransUpDownTccServiceImpl(String key) {
        this.key = key;
    }

    @Override
    public boolean lockOrRelease(TccLockEnum lock, List<AutoMatchInfoParam> tAutoMatchInfoParamList, String version) {
        LOGGER.info("TransUpDownTccServiceImpl,key:{},tAutoMatchInfoParamList:{},version:{}", new Object[]{this.key, tAutoMatchInfoParamList, version});
        List collectInEntry = tAutoMatchInfoParamList.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getRecedBillEntryId())).collect(Collectors.toList());
        if (!collectInEntry.isEmpty()) {
            String tUpdateSql = this.getUpdateSql((AutoMatchInfoParam)collectInEntry.get(0), lock);
            Set billIdSet = collectInEntry.stream().map(AutoMatchInfoParam::getRecedBillEntryId).collect(Collectors.toSet());
            List paramList = billIdSet.stream().map(id -> new Object[]{version, id}).collect(Collectors.toList());
            return AutoMatchServiceHelper.executeBatchSql((String)this.key, (String)tUpdateSql, paramList);
        }
        List collectInHead = tAutoMatchInfoParamList.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getRecedBillEntryId())).collect(Collectors.toList());
        if (!collectInHead.isEmpty()) {
            String tUpdateSql = this.getUpdateSql((AutoMatchInfoParam)collectInHead.get(0), lock);
            Set billIdSet = collectInHead.stream().map(AutoMatchInfoParam::getRecedBillId).collect(Collectors.toSet());
            List paramList = billIdSet.stream().map(id -> new Object[]{version, id}).collect(Collectors.toList());
            return AutoMatchServiceHelper.executeBatchSql((String)this.key, (String)tUpdateSql, paramList);
        }
        return true;
    }

    @Override
    public void update(DynamicObject tRecedBill, AutoMatchInfoParam tAutoMatchInfoParam, String receredway, CommonParam tComParam) {
        if (tAutoMatchInfoParam.getRecedBillEntryId() == 0L) {
            MatchAmountDealHelper.matchManyToOne((DynamicObject)tRecedBill, (String)tAutoMatchInfoParam.getRecedBillType(), (BigDecimal)tAutoMatchInfoParam.getAmount(), (Object)0, (String)receredway);
            if (tRecedBill.getDataEntityType().getProperties().stream().anyMatch(o -> "bankcheckflag_tag".equals(o.getName()))) {
                String bankcheckBill = tRecedBill.getString("bankcheckflag_tag");
                tRecedBill.set("bankcheckflag_tag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)bankcheckBill, (String)tAutoMatchInfoParam.getBankCheckFlag(), (int)0));
                tRecedBill.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)bankcheckBill, (String)tAutoMatchInfoParam.getBankCheckFlag(), (int)255));
            } else if (tRecedBill.getDataEntityType().getProperties().stream().anyMatch(o -> "bankcheckflag".equals(o.getName()))) {
                String bankcheckBill = tRecedBill.getString("bankcheckflag");
                tRecedBill.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)bankcheckBill, (String)tAutoMatchInfoParam.getBankCheckFlag(), (int)255));
            }
            Date traceDate = tAutoMatchInfoParam.getBizDate();
            String filedName = "acttradedate";
            if (tRecedBill.getDataEntityType().getProperties().stream().anyMatch(o -> filedName.equals(o.getName()))) {
                Date exchangedate = tRecedBill.getDate(filedName);
                if (exchangedate != null && exchangedate.compareTo(traceDate) > 0) {
                    traceDate = exchangedate;
                }
                tRecedBill.set(filedName, (Object)traceDate);
            }
            return;
        }
        DynamicObject tRecedBillEntry = tRecedBill.getDynamicObjectCollection("entrys").stream().filter(item -> item.getLong("id") == tAutoMatchInfoParam.getRecedBillEntryId().longValue()).findFirst().orElse(null);
        if (tRecedBillEntry == null) {
            LOGGER.error("\u5355\u636e\u7f16\u53f7\uff1a" + tRecedBill.getString("billno") + "\uff0c\u4e0d\u5b58\u5728ID\u4e3a\u201c" + tAutoMatchInfoParam.getRecedBillEntryId() + "\u201d\u7684\u5206\u5f55\uff0c\u8be5\u6570\u636e\u5c06\u4f1a\u88ab\u820d\u5f03\uff01");
            return;
        }
        MatchAmountDealHelper.matchManyToOne((DynamicObject)tRecedBill, (String)tAutoMatchInfoParam.getRecedBillType(), (BigDecimal)tAutoMatchInfoParam.getAmount(), (Object)tAutoMatchInfoParam.getRecedBillEntryId(), (String)receredway);
        String bankcheckflag = "bankcheckflag";
        tRecedBillEntry.set(bankcheckflag, (Object)AutoMatchServiceHelper.getbankcheckBill((String)tRecedBillEntry.getString(bankcheckflag), (String)tAutoMatchInfoParam.getBankCheckFlag(), (int)50));
        tRecedBillEntry.set("matchresult", (Object)"1");
    }

    @Override
    public void cancel(List<AutoMatchInfoParam> tAutoMatchInfoParamList) {
    }

    private String getUpdateSql(AutoMatchInfoParam autoMatchInfoParam, TccLockEnum lock) {
        String tableName = "fca_transupbill".equals(this.key) ? "t_fca_transupbill" : "t_fca_transdownbill";
        String updateSql = TccLockEnum.TRY == lock ? (autoMatchInfoParam.getRecedBillEntryId() != 0L ? "UPDATE " + tableName + "_entry set fversion=?,fentryispreflag='1' where fversion=' ' and fentrymatchflag in ('0','2') and fentryispreflag='0' and fentryid=?" : "UPDATE " + tableName + " set fversion=?,fispreflag='1' where fversion=' ' and fmatchflag in ('0','2') and fispreflag='0' and fid=?") : (autoMatchInfoParam.getRecedBillEntryId() != 0L ? "UPDATE " + tableName + "_entry set fversion=' ',fentryispreflag='0' where fversion=? and fentryispreflag='1' and fentryid=?" : "UPDATE " + tableName + " set fversion=' ',fispreflag='0' where fversion=? and fispreflag='1' and fid=?");
        return updateSql;
    }
}

