/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.bei.common.convert.IBillTranslateMapper;
import kd.tmc.bei.common.helper.DynamicObjectHelper;
import kd.tmc.bei.common.util.EntityMetadataUtils;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;

public abstract class AbstractBillConverter
implements IBillTranslateMapper {
    protected abstract Map<String, String> getMapper();

    protected void setSrcBillIdAndSrcBillNo(DynamicObject sourceBill, DynamicObject targetRow) {
        targetRow.set("e_sourcebillid", sourceBill.get("id"));
        targetRow.set("e_sourcebillno", sourceBill.get("billno"));
    }

    public DynamicObject convertToTargetBills(DynamicObject ... sourceBills) {
        MainEntityType targetDataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getTargetEntityKey());
        long pk = DB.genLongId((String)targetDataEntityType.getAlias());
        DynamicObject targetBill = new DynamicObject((DynamicObjectType)targetDataEntityType, (Object)pk);
        Map<String, String> fieldMapper = this.getMapper();
        MainEntityType sourceDataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getSourceEntityKey());
        boolean containsSourceEntry = EntityMetadataUtils.containsEntryField(fieldMapper.values(), sourceDataEntityType);
        boolean containsTargetEntry = EntityMetadataUtils.containsEntryField(fieldMapper.keySet(), targetDataEntityType);
        HashMap<DynamicObject, DynamicObject> entryMapper = new HashMap<DynamicObject, DynamicObject>();
        Set orgSets = Arrays.stream(sourceBills).map(s -> s.getDynamicObject("company").getPkValue()).collect(Collectors.toSet());
        for (DynamicObject sourceBill : sourceBills) {
            DynamicObjectCollection sourceEntry = new DynamicObjectCollection();
            if (containsSourceEntry) {
                sourceEntry = sourceBill.getDynamicObjectCollection(EntityMetadataUtils.getEntryProp((IDataEntityType)sourceDataEntityType).getName());
            }
            DynamicObjectType targetEntryDt = null;
            DynamicObjectCollection targetEntry = new DynamicObjectCollection();
            if (containsTargetEntry) {
                targetEntryDt = ((EntryProp)targetDataEntityType.getProperty(EntityMetadataUtils.getEntryProp((IDataEntityType)targetDataEntityType).getName())).getDynamicCollectionItemPropertyType();
                targetEntry = targetBill.getDynamicObjectCollection(EntityMetadataUtils.getEntryProp((IDataEntityType)targetDataEntityType).getName());
            }
            for (Map.Entry<String, String> mapEntry : fieldMapper.entrySet()) {
                String targetFieldName = mapEntry.getKey();
                String sourceFieldName = mapEntry.getValue();
                if (EntityMetadataUtils.isEntryField(sourceDataEntityType, sourceFieldName)) {
                    for (DynamicObject sEntryRow : sourceEntry) {
                        String status = sEntryRow.getString("status");
                        boolean isUpdateState = sEntryRow.getBoolean("isupdatestate");
                        if (isUpdateState || BeBillStatusEnum.TS.getValue().equals(status) || null == targetEntryDt) continue;
                        DynamicObject targetRow = (DynamicObject)entryMapper.get(sEntryRow);
                        if (targetRow == null) {
                            targetRow = new DynamicObject(targetEntryDt);
                            entryMapper.put(sEntryRow, targetRow);
                            targetEntry.add((Object)targetRow);
                            targetRow.set("seq", (Object)targetEntry.size());
                            this.setSrcBillIdAndSrcBillNo(sourceBill, targetRow);
                        }
                        targetRow.set(targetFieldName, DynamicObjectHelper.getValue(sEntryRow, sourceFieldName));
                    }
                    continue;
                }
                if (EntityMetadataUtils.isEntryField(targetDataEntityType, targetFieldName)) {
                    if (null == targetEntryDt) continue;
                    DynamicObject targetRow = (DynamicObject)entryMapper.get(sourceBill);
                    if (targetRow == null) {
                        targetRow = new DynamicObject(targetEntryDt);
                        entryMapper.put(sourceBill, targetRow);
                        targetEntry.add((Object)targetRow);
                        targetRow.set("seq", (Object)targetEntry.size());
                    }
                    targetRow.set(targetFieldName, DynamicObjectHelper.getValue(sourceBill, sourceFieldName));
                    this.setSrcBillIdAndSrcBillNo(sourceBill, targetRow);
                    continue;
                }
                targetBill.set(targetFieldName, DynamicObjectHelper.getValue(sourceBill, sourceFieldName));
            }
            if (orgSets.size() != 1) continue;
            targetBill.set("company_id", sourceBill.getDynamicObject("company").getPkValue());
        }
        targetBill.set("sourcetype", (Object)sourceBills[0].getDataEntityType().getName());
        targetBill.set("modifier_id", (Object)RequestContext.get().getCurrUserId());
        targetBill.set("modifytime", (Object)new Date());
        return targetBill;
    }

    @Override
    public Collection<String> getAllSourceFields() {
        return new ArrayList<String>(this.getMapper().keySet());
    }

    @Override
    public List<String> getGroupFields() {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getSummaryFields() {
        return new ArrayList<String>();
    }
}

