/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.convert;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.bei.common.convert.AbstractBillConverter;

public class BankPayingUpdateStatPushConverter
extends AbstractBillConverter {
    private final Map<String, String> fieldMapper = new HashMap<String, String>();

    public BankPayingUpdateStatPushConverter() {
        this.fieldMapper.put("recuser", "payeename");
        this.fieldMapper.put("payacct", "payeeacct");
        this.fieldMapper.put("recbank", "payeebank");
        this.fieldMapper.put("payamt", "amount");
        this.fieldMapper.put("bankreturnmsg", "bankreturnmsg");
        this.fieldMapper.put("paystatus", "bankpaystate");
        this.fieldMapper.put("sourceentryid", "id");
    }

    @Override
    public String getSourceEntityKey() {
        return "bei_bankpaybill";
    }

    @Override
    public String getTargetEntityKey() {
        return "bei_paybillupdatestatus";
    }

    @Override
    public String getTargetField(String sourceField) {
        return this.fieldMapper.get(sourceField);
    }

    @Override
    public String getSourceField(String targetField) {
        for (Map.Entry<String, String> entry : this.fieldMapper.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(targetField)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    protected Map<String, String> getMapper() {
        return this.fieldMapper;
    }

    @Override
    protected void setSrcBillIdAndSrcBillNo(DynamicObject sourceBill, DynamicObject targetRow) {
        super.setSrcBillIdAndSrcBillNo(sourceBill, targetRow);
        targetRow.set("e_supersrcbillid", sourceBill.get("sourcebillid"));
        targetRow.set("e_supersrctype", sourceBill.get("srcbilltype"));
        targetRow.set("e_currency_id", sourceBill.getDynamicObject("currency").getPkValue());
        targetRow.set("e_isencryption", (Object)false);
    }
}

