/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.convert;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.bei.common.convert.AbstractBillConverter;

public class BankTransUpdateStatPushConverter
extends AbstractBillConverter {
    private String sourceEntityKey;
    private final Map<String, String> fieldMapper = new HashMap<String, String>();

    public final void setSourceEntityKey(String sourceEntityKey) {
        this.sourceEntityKey = sourceEntityKey;
    }

    public BankTransUpdateStatPushConverter() {
        this.fieldMapper.put("recuser", "subacct.company.name");
        this.fieldMapper.put("payacct", "subacct.number");
        this.fieldMapper.put("recbank", "subacct.bank.name");
        this.fieldMapper.put("payamt", "entrys.transamt");
        this.fieldMapper.put("bankreturnmsg", "entrys.bankreturnmsg");
        this.fieldMapper.put("paystatus", "entrys.status");
        this.fieldMapper.put("sourceentryid", "entrys.id");
    }

    public BankTransUpdateStatPushConverter(String sourceEntityKey) {
        this.fieldMapper.put("recuser", "subacct.company.name");
        this.fieldMapper.put("payacct", "subacct.number");
        this.fieldMapper.put("recbank", "subacct.bank.name");
        this.fieldMapper.put("payamt", "entrys.transamt");
        this.fieldMapper.put("bankreturnmsg", "entrys.bankreturnmsg");
        this.fieldMapper.put("paystatus", "entrys.status");
        this.fieldMapper.put("sourceentryid", "entrys.id");
        this.setSourceEntityKey(sourceEntityKey);
    }

    @Override
    public String getSourceEntityKey() {
        return this.sourceEntityKey;
    }

    @Override
    public String getTargetEntityKey() {
        return "bei_paybillupdatestatus";
    }

    @Override
    public String getTargetField(String sourceField) {
        return this.fieldMapper.get(sourceField);
    }

    @Override
    public String getSourceField(String targetField) {
        for (Map.Entry<String, String> entry : this.fieldMapper.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(targetField)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    protected Map<String, String> getMapper() {
        return this.fieldMapper;
    }

    @Override
    protected void setSrcBillIdAndSrcBillNo(DynamicObject sourceBill, DynamicObject targetRow) {
        super.setSrcBillIdAndSrcBillNo(sourceBill, targetRow);
        targetRow.set("e_supersrcbillid", sourceBill.get("sourcebillid"));
        targetRow.set("e_supersrctype", sourceBill.get("sourcetype"));
        targetRow.set("e_currency_id", sourceBill.getDynamicObject("currency").getPkValue());
        targetRow.set("e_isencryption", (Object)false);
    }
}

