/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.tmc.bei.common.helper.OperateServiceHelper;

public class BeiThreadHelper {
    private static final Log LOGGER = LogFactory.getLog(BeiThreadHelper.class);
    private static ExecutorService service = ThreadPools.newCachedExecutorService((String)"BeiThreadHelper", (int)2, (int)5);

    public static OperateErrorInfo getOperateErrorInfo(Object pk, String meg) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(pk);
        operateErrorInfo.setMessage(meg);
        return operateErrorInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<OperationResult> doPushAndSaveOp(List<String> ids) {
        ArrayList<OperationResult> returnRes = new ArrayList<OperationResult>();
        int taskSize = 300;
        int threadSize = ids.size() % taskSize > 0 ? ids.size() / taskSize + 1 : ids.size() / taskSize;
        CountDownLatch countDownLatch = new CountDownLatch(threadSize);
        LOGGER.info("\u603b\u4efb\u52a1\u6570=[{}],\u7ebf\u7a0b\u5927\u5c0f=[{}]\uff0c\u7ebf\u7a0b\u4efb\u52a1\u6570=[{}]", new Object[]{ids.size(), threadSize, taskSize});
        ArrayList<List<String>> taskList = new ArrayList<List<String>>(threadSize);
        for (int i = 1; i <= threadSize; ++i) {
            if (ids.size() >= taskSize * i) {
                taskList.add(ids.subList(taskSize * (i - 1), taskSize * i));
                continue;
            }
            taskList.add(ids.subList(taskSize * (i - 1), ids.size()));
        }
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>(0);
        for (int i = 0; i < taskList.size(); ++i) {
            List list = (List)taskList.get(i);
            Integer index = i;
            Future<List> pushFuture = service.submit(() -> BeiThreadHelper.getOperationResults(countDownLatch, list, index));
            futures.add(pushFuture);
        }
        try {
            if (!countDownLatch.await(1L, TimeUnit.HOURS)) {
                // empty if block
            }
        }
        catch (Exception e) {
            LOGGER.error("doPushAndSaveOp excute too long time!", (Throwable)e);
        }
        Iterator iterator = futures.iterator();
        while (iterator.hasNext()) {
            Future future = (Future)iterator.next();
            try {
                returnRes.addAll((Collection)future.get());
            }
            catch (Exception e) {
                LOGGER.error("doPushAndSaveOp get future too long time!", (Throwable)e);
                continue;
            }
            break;
        }
        return returnRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<OperationResult> getOperationResults(CountDownLatch countDownLatch, List<String> task, int i) {
        Long startTime = System.currentTimeMillis();
        LOGGER.info("\u591a\u7ebf\u7a0b\u6279\u6b21=[{}]\uff0c\u6267\u884c\u5f00\u59cb", (Object)(i + 1));
        ArrayList<OperationResult> results = new ArrayList<OperationResult>();
        for (String id : task) {
            OperationResult operationResult = null;
            try {
                operationResult = OperateServiceHelper.execOperate("pushandsave", "bei_intelrec", new Object[]{Long.valueOf(id)}, OperateOption.create());
                results.add(operationResult);
            }
            catch (Exception e) {
                operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.addErrorInfo(BeiThreadHelper.getOperateErrorInfo(id, e.getMessage()));
                results.add(operationResult);
            }
            finally {
                countDownLatch.countDown();
            }
        }
        LOGGER.info("\u591a\u7ebf\u7a0b\u6279\u6b21=[{}],\u6267\u884c\u7ed3\u675f\uff0c\u8017\u65f6=[{}]", (Object)(i + 1), (Object)(System.currentTimeMillis() - startTime));
        return results;
    }
}

