/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.convert.AbstractBillConverter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayStateUpdateHelper {
    public static boolean isUpdatingStatus(DynamicObject sourceBill, String entityName) {
        boolean isUpdatingStatus = sourceBill.getBoolean("isupdatingstatus");
        if (!isUpdatingStatus) {
            return false;
        }
        QFilter submitFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue());
        submitFilter.and("sourcetype", "=", (Object)entityName);
        submitFilter.and("entrys.e_sourcebillid", "=", sourceBill.getPkValue());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bei_paybillupdatestatus", (String)"id", (QFilter[])submitFilter.toArray());
        return EmptyUtil.isNoEmpty((DynamicObjectCollection)query) && query.size() > 0;
    }

    public static void setIsUpdatingStatus(DynamicObject[] dataEntities, String status) {
        Map<String, List<DynamicObject>> groupedList = Arrays.stream(dataEntities).collect(Collectors.groupingBy(o -> o.getString("sourcetype")));
        for (Map.Entry<String, List<DynamicObject>> grpEntry : groupedList.entrySet()) {
            DynamicObject[] srcDataList;
            List<DynamicObject> grpUpdateList = grpEntry.getValue();
            ArrayList srcbBillIds = new ArrayList(10);
            grpUpdateList.forEach(s -> {
                List collect = s.getDynamicObjectCollection("entrys").stream().map(e -> e.getLong("e_sourcebillid")).collect(Collectors.toList());
                srcbBillIds.addAll(collect);
            });
            for (DynamicObject sourceBill : srcDataList = TmcDataServiceHelper.load((Object[])srcbBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)grpEntry.getKey()))) {
                boolean isUpdatingStatus = sourceBill.getBoolean("isupdatingstatus");
                if ("1".equals(status) && isUpdatingStatus) {
                    throw new KDBizException(ResManager.loadKDString((String)"%s\uff1a\u9009\u62e9\u8bb0\u5f55\u5305\u542b\u672a\u5ba1\u6838\u5b8c\u6210\u7684\u4ed8\u6b3e\u72b6\u6001\u53d8\u66f4\u5355, \u8bf7\u7b49\u5f85\u4ed8\u6b3e\u72b6\u6001\u53d8\u66f4\u5355\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PayStateUpdateHelper_0", (String)"tmc-bei-common", (Object[])new Object[]{sourceBill.getString("billno")}));
                }
                sourceBill.set("isupdatingstatus", (Object)status);
            }
            TmcDataServiceHelper.save((DynamicObject[])srcDataList);
        }
    }

    public static void showTemplateEditForm(IFormView view, List<Object> successPkIds, String entityName, AbstractBillConverter converter) {
        DynamicObject[] bankTransBills = TmcDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        DynamicObject targetBill = converter.convertToTargetBills(bankTransBills);
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_paybillupdatestatus"));
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        String fileContent = jser.serializeToString((Object)targetBill, null);
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("bei_paybillupdatestatus");
        parameter.setCustomParam("targetBillStr", (Object)fileContent);
        parameter.setCustomParam("targetBillEntryStr", (Object)"bei_paybillupdatestatus");
        view.showForm((FormShowParameter)parameter);
    }
}

