/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.helper;

import java.io.InputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.type1.Type1Font;
import org.apache.pdfbox.pdmodel.font.CIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.FontFormat;
import org.apache.pdfbox.pdmodel.font.FontInfo;
import org.apache.pdfbox.pdmodel.font.PDPanoseClassification;

public class PrintFontInfo
extends FontInfo {
    private final String postScriptName;
    private final FontFormat format;
    private final CIDSystemInfo cidSystemInfo;
    private final int usWeightClass;
    private final int sFamilyClass;
    private final int ulCodePageRange1;
    private final int ulCodePageRange2;
    private final int macStyle;
    private final InputStream fontFileStream;
    private final FontBoxFont boxFont;
    private static final Log logger = LogFactory.getLog(PrintFontInfo.class);

    public PrintFontInfo(InputStream fontFileStream, FontFormat format, String postScriptName, CIDSystemInfo cidSystemInfo, int usWeightClass, int sFamilyClass, int ulCodePageRange1, int ulCodePageRange2, int macStyle) {
        this.fontFileStream = fontFileStream;
        this.format = format;
        this.postScriptName = postScriptName;
        this.cidSystemInfo = cidSystemInfo;
        this.usWeightClass = usWeightClass;
        this.sFamilyClass = sFamilyClass;
        this.ulCodePageRange1 = ulCodePageRange1;
        this.ulCodePageRange2 = ulCodePageRange2;
        this.macStyle = macStyle;
        try {
            switch (format) {
                case PFB: {
                    this.boxFont = Type1Font.createWithPFB((InputStream)fontFileStream);
                    break;
                }
                case OTF: {
                    this.boxFont = new OTFParser(false, true).parse(fontFileStream);
                    break;
                }
                case TTF: {
                    this.boxFont = new TTFParser(false, true).parse(fontFileStream);
                    break;
                }
                default: {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u4f53\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a%s\u3002", (String)"PrintFontInfo_0", (String)"tmc-bei-common", (Object[])new Object[]{format}));
                }
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u5b57\u4f53\u6587\u4ef6\u5f02\u5e38\uff1a%s\u3002", (String)"PrintFontInfo_1", (String)"tmc-bei-common", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public PrintFontInfo(InputStream fontFileStream, FontFormat format, String postScriptName) {
        this(fontFileStream, format, postScriptName, null, 0, 0, 0, 0, 0);
    }

    public String getPostScriptName() {
        return this.postScriptName;
    }

    public FontFormat getFormat() {
        return this.format;
    }

    public CIDSystemInfo getCIDSystemInfo() {
        return this.cidSystemInfo;
    }

    public FontBoxFont getFont() {
        return this.boxFont;
    }

    public int getFamilyClass() {
        return this.sFamilyClass;
    }

    public int getWeightClass() {
        return this.usWeightClass;
    }

    public int getCodePageRange1() {
        return this.ulCodePageRange1;
    }

    public int getCodePageRange2() {
        return this.ulCodePageRange2;
    }

    public int getMacStyle() {
        return this.macStyle;
    }

    public PDPanoseClassification getPanose() {
        return null;
    }

    public String toString() {
        return super.toString() + " " + this.fontFileStream;
    }
}

