/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.helper;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.matchtpl.MatcherResult;
import kd.bos.print.matchtpl.MatcherTpl;
import kd.bos.print.matchtpl.TplMatcherParam;
import kd.bos.print.matchtpl.TplMatcherUtil;
import kd.bos.print.matchtpl.ViewType;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.session.SessionManager;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.FileNameUtils;
import kd.tmc.bei.common.helper.PrintFontInfo;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.FontFormat;
import org.apache.pdfbox.pdmodel.font.FontInfo;
import org.apache.pdfbox.pdmodel.font.FontMapper;
import org.apache.pdfbox.pdmodel.font.FontMappers;
import org.apache.pdfbox.rendering.PDFRenderer;

public class ReceiptPrintHelper {
    private static final Log logger = LogFactory.getLog(ReceiptPrintHelper.class);
    public static final String FONT_RES_SIMKAI = "resources/fonts/simkai.ttf";
    private static Map<String, FontInfo> fontInfoMap = new HashMap<String, FontInfo>(64);

    private ReceiptPrintHelper() {
    }

    public static List<String> pdfToPng(File file, String newImageUrl) {
        ArrayList<String> urlList = new ArrayList<String>(4);
        if (file.exists()) {
            try (PDDocument doc = PDDocument.load((File)file);){
                ReceiptPrintHelper.loadFonts(FONT_RES_SIMKAI, "FZSongTi");
                PDFRenderer renderer = new PDFRenderer(doc);
                int pageCount = doc.getNumberOfPages();
                logger.info("\u8bfb\u53d6\u7535\u5b50\u56de\u5355pdf\u6587\u4ef6" + pageCount + "\u9875");
                if (pageCount > 1) {
                    for (int i = 0; i < pageCount; ++i) {
                        String url = i > 0 ? newImageUrl.substring(0, newImageUrl.lastIndexOf(".")) + i + newImageUrl.substring(newImageUrl.lastIndexOf(".")) : newImageUrl;
                        File imageFile = new File(FilenameUtils.getName((String)url));
                        if (!imageFile.exists()) continue;
                        BufferedImage image = renderer.renderImage(i, 2.5f);
                        ImageIO.write((RenderedImage)image, "png", imageFile);
                        urlList.add(url);
                    }
                } else {
                    File imageFile = new File(FilenameUtils.getName((String)newImageUrl));
                    if (imageFile.exists()) {
                        BufferedImage image = renderer.renderImage(0, 2.5f);
                        ImageIO.write((RenderedImage)image, "png", imageFile);
                        urlList.add(newImageUrl);
                    }
                }
            }
            catch (Exception e) {
                logger.error("ReceiptPrintHelper.pdfToPng \u7535\u5b50\u56de\u5355pdf\u8f6cpng\u8f6c\u6362\u5f02\u5e38 {}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        } else {
            logger.error("ReceiptPrintHelper.pdfToPng \u83b7\u53d6\u7684\u7535\u5b50\u56de\u5355\u6587\u4ef6\u4e3a\u7a7a {}", (Object)file.getName());
        }
        return urlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<byte[]> pdfToPng(InputStream inputStream, String fileUrl, String fileType) throws IOException {
        if (EmptyUtil.isNoEmpty((String)fileUrl)) {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            inputStream = fileService.getInputStream(fileUrl);
        }
        ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>(4);
        if (inputStream != null) {
            BufferedImage bufferedImage;
            if ("pdf".equals(fileType)) {
                try (PDDocument doc = PDDocument.load((InputStream)inputStream);){
                    ReceiptPrintHelper.loadFonts(FONT_RES_SIMKAI, "FZSongTi");
                    PDFRenderer renderer = new PDFRenderer(doc);
                    int pageCount = doc.getNumberOfPages();
                    logger.info("Read Receipt PdfFile" + pageCount + "Pages.");
                    for (int i = 0; i < pageCount; ++i) {
                        BufferedImage image2 = renderer.renderImage(i, 2.5f);
                        imageList.add(image2);
                    }
                }
                catch (Exception e) {
                    logger.error("ReceiptPrintHelper.pdfToPng Exception: {}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
                finally {
                    inputStream.close();
                }
            } else if ("image".equals(fileType) && (bufferedImage = ImageIO.read(inputStream)) != null) {
                imageList.add(bufferedImage);
            }
        } else {
            logger.error("ReceiptPrintHelper.pdfToPng pdfFileStream is Empty: " + fileUrl);
            throw new KDBizException("pdfFileStream is Empty.");
        }
        imageList = imageList.stream().map(image -> {
            image = ReceiptPrintHelper.receiptImageProcess(image);
            return image;
        }).collect(Collectors.toList());
        return ReceiptPrintHelper.bufferedImage2ByteArray(imageList);
    }

    public static String getRealUploadUrl(DynamicObject receipt) {
        String uploadFilName = receipt.getString("uploadfilename");
        String realPath = "";
        if (StringUtils.isNotEmpty((CharSequence)uploadFilName)) {
            realPath = uploadFilName;
            if (!uploadFilName.contains(".") && !uploadFilName.contains("/")) {
                try {
                    FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
                    realPath = attachmentFileService.getFileServiceExt().getRealPath(uploadFilName);
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6587\u4ef6\u771f\u5b9e\u8def\u5f84\u5931\u8d25\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
        return realPath;
    }

    public static String getRealUploadUrl(DynamicObject entity, String fileFieldName) {
        String uploadFilName = entity.getString(fileFieldName);
        String realPath = "";
        if (StringUtils.isNotEmpty((CharSequence)uploadFilName)) {
            realPath = uploadFilName;
            if (!uploadFilName.contains(".") && !uploadFilName.contains("/")) {
                try {
                    FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
                    realPath = attachmentFileService.getFileServiceExt().getRealPath(uploadFilName);
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6587\u4ef6\u771f\u5b9e\u8def\u5f84\u5931\u8d25\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
        return realPath;
    }

    public static String getRealUploadUrl(String fileUrl) {
        String realPath = "";
        if (StringUtils.isNotEmpty((CharSequence)fileUrl)) {
            realPath = fileUrl;
            if (!fileUrl.contains(".") && !fileUrl.contains("/")) {
                try {
                    FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
                    realPath = attachmentFileService.getFileServiceExt().getRealPath(fileUrl);
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6587\u4ef6\u771f\u5b9e\u8def\u5f84\u5931\u8d25\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
        return realPath;
    }

    public static OutputStream downloadFile(String desPlace, String realUploadUrl) {
        FileOutputStream out;
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            String userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36";
            out = new FileOutputStream(desPlace);
            fileService.download(realUploadUrl, (OutputStream)out, "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36");
        }
        catch (Exception e) {
            logger.error("ReceiptPrintHelper.downloadFile fail: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(new BeiBizResource().getReceiptDownloadError());
        }
        return out;
    }

    public static File inputStream2File(InputStream inputStream, String tempRoute) {
        File file = new File(FilenameUtils.getName((String)tempRoute));
        if (file.exists()) {
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                int idx;
                byte[] bytes = new byte[1024];
                while ((idx = inputStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, idx);
                    outputStream.flush();
                }
            }
            catch (Exception e) {
                logger.error("ReceiptPrintNewPlugin \u56de\u5355\u6587\u4ef6\u8f6c\u6362\u5931\u8d25 {}", (Object)tempRoute);
            }
        }
        return file;
    }

    public static String generateUploadPath(String fileName) {
        String slash = "/";
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        RequestContext rc = RequestContext.get();
        return rootPath + FileNameUtils.getAttachmentFileName((String)rc.getTenantCode(), (String)rc.getAccountId(), (Object)"elecreceipt", (String)"receipt") + "/" + System.currentTimeMillis() + '/' + fileName;
    }

    public static String uploadPngToServer(String newImageName, String pngStoreRoute, InputStream inputStream) {
        String imagePath;
        FileService fileService = FileServiceFactory.getImageFileService();
        try (FileItem file = null;){
            if (inputStream == null || inputStream.available() <= 0) {
                throw new KDBizException("fileInputStream is Empty.");
            }
            file = new FileItem(newImageName, pngStoreRoute, inputStream);
            file.setCreateNewFileWhenExists(true);
            imagePath = fileService.upload(file);
            inputStream.close();
        }
        return imagePath;
    }

    public static String getFilePreviewUrl(String fileUrl) {
        String previewUrl = UrlService.getAttachmentPreviewUrl((String)fileUrl);
        String csrfTokenValue = SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
        previewUrl = previewUrl + "&kd_cs_ticket=" + csrfTokenValue;
        previewUrl = previewUrl + "&randomStr=" + UUID.randomUUID();
        return previewUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] mergeMultiPdf(List<byte[]> pdfPages) {
        if (pdfPages == null || pdfPages.isEmpty()) {
            logger.error("mergeMultiPdf input pdfPages is empty.");
            return new byte[0];
        }
        logger.info("mergeMultiPdf start, pdfPages.size = " + pdfPages.size());
        if (pdfPages.size() == 1) {
            return pdfPages.get(0);
        }
        ByteArrayOutputStream newOutput = new ByteArrayOutputStream();
        Document document = new Document();
        try {
            PdfCopy copy = new PdfCopy(document, (OutputStream)newOutput);
            document.open();
            for (byte[] pdfPage : pdfPages) {
                PdfReader reader = new PdfReader(pdfPage);
                Field field = PdfReader.class.getDeclaredField("ownerPasswordUsed");
                ReflectionUtils.makeAccessible((Field)field);
                field.set(reader, Boolean.TRUE);
                int n = reader.getNumberOfPages();
                int page = 0;
                while (page < n) {
                    try {
                        copy.addPage(copy.getImportedPage(reader, ++page));
                    }
                    catch (BadPdfFormatException e) {
                        logger.error(e.getMessage());
                    }
                }
                copy.freeReader(reader);
                reader.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                newOutput.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        return newOutput.toByteArray();
    }

    private static BufferedImage receiptImageProcess(BufferedImage image) {
        try {
            int width = image.getWidth();
            int height = image.getHeight();
            logger.info("\u5f00\u59cb\u56fe\u50cf\u53bb\u767d\u8fb9\u5904\u7406 {} * {}", (Object)width, (Object)height);
            BufferedImage binaryImage = new BufferedImage(width, height, 10);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int rgb = image.getRGB(x, y);
                    int r = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb & 0xFF;
                    int newPixel = ReceiptPrintHelper.colorToRGB(r, g, b);
                    binaryImage.setRGB(x, y, newPixel);
                }
            }
            int[] edgeIndex = ReceiptPrintHelper.getEdgeIndex(binaryImage, width, height);
            image = image.getSubimage(edgeIndex[0], edgeIndex[1], edgeIndex[2] - edgeIndex[0], edgeIndex[3] - edgeIndex[1]);
            logger.info("\u56fe\u50cf\u53bb\u767d\u8fb9\u5904\u7406\u6210\u529f {} * {}", (Object)(edgeIndex[2] - edgeIndex[0]), (Object)(edgeIndex[3] - edgeIndex[1]));
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u56de\u5355\u56fe\u7247\u4e8c\u503c\u5316\u5f02\u5e38 {}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return image;
    }

    public static void imageConvertPdf(String sourceUrl, List<byte[]> resList, InputStream ins) throws DocumentException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            int result;
            int len;
            if (ins == null) {
                FileService fs = FileServiceFactory.getAttachmentFileService();
                ins = fs.getInputStream(sourceUrl);
            }
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((len = ins.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            bos.close();
            byte[] imageBytes = bos.toByteArray();
            ins.close();
            Document document = new Document();
            Image image = Image.getInstance((byte[])imageBytes);
            document.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
            fos = new FileOutputStream("./test.pdf");
            PdfWriter.getInstance((Document)document, (OutputStream)fos);
            document.open();
            float imageHeight = image.getScaledHeight();
            float imageWidth = image.getScaledWidth();
            Rectangle rectangle = new Rectangle(imageWidth, imageHeight);
            document.setPageSize(rectangle);
            image.setAlignment(1);
            document.newPage();
            document.add((Element)image);
            document.close();
            fos.flush();
            ReceiptPrintHelper.closeStream(fos);
            file = new File("./test.pdf");
            fis = new FileInputStream(file);
            byte[] bytes = new byte[fis.available()];
            int bytesToRead = fis.available();
            for (int bytesRead = 0; bytesRead < bytesToRead && (result = fis.read(bytes, bytesRead, bytesToRead - bytesRead)) != -1; bytesRead += result) {
            }
            resList.add(bytes);
        }
        catch (IOException e) {
            try {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            catch (Throwable throwable) {
                ReceiptPrintHelper.closeStream(fis);
                ReceiptPrintHelper.closeStream(fos);
                if (file != null && !file.delete()) {
                    logger.error("ReceiptPrintHelper.imageConvertPdf \u4e34\u65f6\u6587\u4ef6\u5220\u9664\u5931\u8d25");
                }
                throw throwable;
            }
        }
        ReceiptPrintHelper.closeStream(fis);
        ReceiptPrintHelper.closeStream(fos);
        if (file != null && !file.delete()) {
            logger.error("ReceiptPrintHelper.imageConvertPdf \u4e34\u65f6\u6587\u4ef6\u5220\u9664\u5931\u8d25");
        }
    }

    public static Map<Object, Set<MatcherTpl>> getMatchReceiptTemplate(String appId, String entityId, Set<Long> pkIds, ViewType viewType, String pageId) {
        int endMatchLevel;
        if (pkIds == null || pkIds.isEmpty()) {
            logger.warn("ReceiptPrintHelper.getMatchReceiptTemplate \u83b7\u53d6\u6253\u5370\u6a21\u677f\u5931\u8d25 \u5355\u636eid\u4e3a\u7a7a");
            return Collections.emptyMap();
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "bei";
        } else if (StringUtils.isBlank((CharSequence)entityId)) {
            entityId = "bei_elecreceipt";
        }
        ArrayList<Long> pkList = new ArrayList<Long>(pkIds.size());
        pkList.addAll(pkIds);
        TplMatcherParam param = new TplMatcherParam();
        param.setEntityId(entityId);
        param.setPkIds(pkList);
        param.setAppId(appId);
        param.setPageId(pageId);
        param.setViewType(viewType);
        TplMatcherUtil matcherUtil = new TplMatcherUtil(param);
        matcherUtil.reset();
        MatcherResult result = matcherUtil.runMatcher();
        if (result.getPkTplMap().isEmpty()) {
            matcherUtil.reset();
            result = matcherUtil.buildMatcherResultByDefault();
        }
        if ((endMatchLevel = result.getEndMatchLevel()) == 0) {
            logger.warn("ReceiptPrintHelper.getMatchReceiptTemplate \u5355\u636e" + entityId + pkIds + "\u672a\u5339\u914d\u5230\u6253\u5370\u6a21\u677f");
            return Collections.emptyMap();
        }
        logger.info("ReceiptPrintHelper.getMatchReceiptTemplate \u6253\u5370\u6a21\u677f\u5339\u914d\u8282\u70b9 " + endMatchLevel);
        return result.getPkTplMap();
    }

    public static PrtAttach doNewPrint(String pageId, String formId, String templateId, Object pkId) {
        PrintWork work = new PrintWork();
        work.setPageId(pageId);
        work.setPrintLang(RequestContext.get().getLang().toString());
        work.setExpType("pdf");
        PrintTask printTask = new PrintTask();
        printTask.setPageId(pageId);
        printTask.setFormId(formId);
        printTask.setTplId(templateId);
        printTask.setPkIds(Collections.singletonList(pkId));
        ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(1);
        taskList.add(printTask);
        work.setTaskList(taskList);
        return BosPrintServiceHelper.execPrint((PrintWork)work);
    }

    private static List<byte[]> bufferedImage2ByteArray(List<BufferedImage> imageList) throws IOException {
        ArrayList<byte[]> imagePages = new ArrayList<byte[]>(10);
        if (imageList == null || imageList.isEmpty()) {
            return imagePages;
        }
        for (BufferedImage bufferedImage : imageList) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
            imagePages.add(outputStream.toByteArray());
            outputStream.close();
        }
        return imagePages;
    }

    private static int[] getEdgeIndex(BufferedImage binaryImage, int width, int height) {
        int y;
        int x;
        int pixel;
        int x2;
        int y2;
        int startX = 0;
        int startY = 0;
        int endX = width;
        int endY = height;
        boolean breakFlag = false;
        for (y2 = 0; y2 < height; y2 += 2) {
            for (x2 = 0; x2 < width; x2 += 2) {
                pixel = binaryImage.getRGB(x2, y2);
                if ((pixel & 0xFF) != 0) continue;
                startY = y2;
                breakFlag = true;
                break;
            }
            if (!breakFlag) continue;
            breakFlag = false;
            break;
        }
        for (x = 0; x < width; x += 2) {
            for (y = 0; y < height; y += 2) {
                pixel = binaryImage.getRGB(x, y);
                if ((pixel & 0xFF) != 0) continue;
                startX = x;
                breakFlag = true;
                break;
            }
            if (!breakFlag) continue;
            breakFlag = false;
            break;
        }
        for (x = width - 1; x > 0; x -= 2) {
            for (y = height - 1; y > 0; y -= 2) {
                pixel = binaryImage.getRGB(x, y);
                if ((pixel & 0xFF) != 0) continue;
                endX = x;
                breakFlag = true;
                break;
            }
            if (!breakFlag) continue;
            breakFlag = false;
            break;
        }
        for (y2 = height - 1; y2 > 0; y2 -= 2) {
            for (x2 = width - 1; x2 > 0; x2 -= 2) {
                pixel = binaryImage.getRGB(x2, y2);
                if ((pixel & 0xFF) != 0) continue;
                endY = y2;
                breakFlag = true;
                break;
            }
            if (breakFlag) break;
        }
        if (startX > 9) {
            startX -= 9;
        }
        if (startY > 9) {
            startY -= 9;
        }
        if (endX < width - 9) {
            endX += 9;
        }
        if (endY < height - 9) {
            endY += 9;
        }
        return new int[]{startX, startY, endX, endY};
    }

    private static int colorToRGB(int red, int green, int blue) {
        int thr = 243;
        if (red > thr && green > thr && blue > thr) {
            return -1;
        }
        return -16777216;
    }

    private static void closeStream(Closeable closeable) {
        try {
            if (null != closeable) {
                closeable.close();
            }
        }
        catch (Exception e) {
            logger.error("ReceiptPrintHelper.imageConvertPdf \u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25:" + e.getMessage());
        }
    }

    private static void loadFonts(String fontPath, String fontName) {
        try (InputStream fontResourceStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fontPath);){
            if (fontResourceStream == null) {
                logger.warn("Can not find font resources: " + fontPath);
            } else {
                ReceiptPrintHelper.setFonts(FontFormat.TTF, fontName, fontResourceStream);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static void setFonts(FontFormat fontFormat, String fontName, InputStream fontFileStream) {
        Map<String, FontInfo> fontInfoMap = ReceiptPrintHelper.getFontInfoMap(fontName);
        FontInfo fontInfo = fontInfoMap.get(fontName);
        if (fontInfo != null) {
            return;
        }
        logger.info("pdfFont addFont: {}", (Object)fontName);
        ReceiptPrintHelper.getFontInfoMap(fontName).put(fontName, new PrintFontInfo(fontFileStream, fontFormat, fontName));
    }

    private static Map<String, FontInfo> getFontInfoMap(String fontName) {
        if (fontInfoMap != null && !fontInfoMap.isEmpty() && fontInfoMap.get(fontName) != null) {
            return fontInfoMap;
        }
        FontMapper instance = FontMappers.instance();
        instance.getCIDFont(fontName, null, null);
        Class<?> aClass = instance.getClass();
        try {
            Field field = aClass.getDeclaredField("fontInfoByName");
            if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
                ReflectionUtils.makeAccessible((Field)field);
            }
            fontInfoMap = (Map)field.get(instance);
        }
        catch (Exception e) {
            logger.error("ReceiptPrintHelper.getFontInfoMap font init fail: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return fontInfoMap == null ? new HashMap(64) : fontInfoMap;
    }
}

