/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.BalanceHelper;
import kd.tmc.fbp.common.helper.BeiParameterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SyncAutoBalanceHelper {
    private static final Log logger = LogFactory.getLog(SyncAutoBalanceHelper.class);
    public static final String ORG = "org";
    public static final String ACCOUNTBANK = "accountbank";
    public static final String CURRENCY = "currency";
    public static final String STARTDATE = "startdate";
    public static final String ENDDATE = "enddate";

    public static QFilter getAccountBankQfilter(List<Long> orgIds) {
        QFilter qFilter = new QFilter("issetbankinterface", "=", (Object)"0");
        qFilter.and("isvirtual", "=", (Object)"0");
        qFilter.and("company", "in", orgIds);
        qFilter.and("finorgtype", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        return qFilter;
    }

    public static Boolean isCanAutoBalace(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        qFilter.and("issetbankinterface", "=", (Object)"0");
        qFilter.and("isvirtual", "=", (Object)"0");
        qFilter.and("finorgtype", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"id", (QFilter[])qFilter.toArray());
        return EmptyUtil.isNoEmpty((DynamicObject)account);
    }

    public static void autoCreateBalance(DynamicObject[] transDetails, DistributeSessionlessCache cache) {
        ArrayList<String> messageList = new ArrayList<String>(16);
        Map<String, List<DynamicObject>> transDetailMap = Arrays.stream(transDetails).collect(Collectors.groupingBy(e -> e.get("company") + "#" + e.get(ACCOUNTBANK) + "#" + e.get(CURRENCY) + "#" + DateUtils.formatString((Date)e.getDate("bizdate"), (String)"yyyy-MM-dd")));
        ArrayList<DynamicObject> lastTransDetailIdList = new ArrayList<DynamicObject>(16);
        for (List<DynamicObject> transDetailObj : transDetailMap.values()) {
            List transDetailAllList = transDetailObj.stream().filter(i -> EmptyUtil.isNoEmpty((Object)i.get("biztime")) && EmptyUtil.isNoEmpty((Object)i.get("sortno"))).collect(Collectors.toList());
            if (transDetailAllList.size() > 0) {
                List sortedList = transDetailAllList.stream().sorted(Comparator.comparing(i -> ((DynamicObject)i).getDate("biztime"), Comparator.reverseOrder()).thenComparing(i -> ((DynamicObject)i).getString("sortno"), Comparator.reverseOrder())).collect(Collectors.toList());
                DynamicObject transDetail = (DynamicObject)sortedList.get(0);
                lastTransDetailIdList.add(transDetail);
                continue;
            }
            List transDetailDateList = transDetailObj.stream().filter(i -> EmptyUtil.isEmpty((Object)i.get("biztime")) && EmptyUtil.isNoEmpty((Object)i.get("sortno"))).collect(Collectors.toList());
            if (transDetailDateList.size() > 0) {
                List sortedList = transDetailDateList.stream().sorted(Comparator.comparing(i -> ((DynamicObject)i).getDate("bizdate"), Comparator.reverseOrder()).thenComparing(i -> ((DynamicObject)i).getString("sortno"), Comparator.reverseOrder())).collect(Collectors.toList());
                DynamicObject transDetail = (DynamicObject)sortedList.get(0);
                String billno = transDetail.getString("billno");
                logger.info("\u4ea4\u6613\u65f6\u95f4\u4e3a\u7a7a\u7684\u6570\u636e,\u5355\u636e\u7f16\u53f7\uff1a{}\u3002", (Object)billno);
                lastTransDetailIdList.add(transDetail);
                continue;
            }
            List transDetailTimeList = transDetailObj.stream().filter(i -> EmptyUtil.isNoEmpty((Object)i.get("biztime")) && EmptyUtil.isEmpty((Object)i.get("sortno"))).collect(Collectors.toList());
            if (transDetailTimeList.size() <= 0) continue;
            List sortedList = transDetailTimeList.stream().sorted(Comparator.comparing(i -> i.getDate("biztime"), Comparator.reverseOrder())).collect(Collectors.toList());
            DynamicObject transDetail = (DynamicObject)sortedList.get(0);
            lastTransDetailIdList.add(transDetail);
        }
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<DynamicObject[]> accountBankIds = new HashSet<DynamicObject[]>(16);
        HashSet<Long> currencyIds = new HashSet<Long>(16);
        HashSet<Date> bizDates = new HashSet<Date>(16);
        HashMap genMap = new HashMap(16);
        ArrayList<String> deleteList = new ArrayList<String>(16);
        for (DynamicObject transDetail : lastTransDetailIdList) {
            Long orgId = transDetail.getDynamicObject("company").getLong("id");
            orgIds.add(orgId);
            DynamicObject accountBank = transDetail.getDynamicObject(ACCOUNTBANK);
            DynamicObject[] accountBankId = Long.valueOf(accountBank.getLong("id"));
            accountBankIds.add(accountBankId);
            Long bankId = accountBank.getDynamicObject("bank").getLong("id");
            DynamicObject currency = transDetail.getDynamicObject(CURRENCY);
            Long currencyId = currency.getLong("id");
            currencyIds.add(currencyId);
            Date bizDate = transDetail.getDate("bizdate");
            bizDates.add(bizDate);
            BigDecimal amount = transDetail.getBigDecimal("transbalance");
            String bizDateStr = DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd");
            if (amount == null) {
                String billno = transDetail.getString("billno");
                logger.info("\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a{}, \u4ea4\u6613\u65e5\u671f\uff1a{},\u65e0\u4f59\u989d\u4fe1\u606f\u3002", (Object)billno, (Object)bizDateStr);
                messageList.add(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff08%1$s\uff09\uff0c\u5e01\u79cd\uff08%2$s\uff09\uff0c\u4ea4\u6613\u65e5\u671f\uff08%3$s\uff09\u65e0\u6cd5\u6b63\u5e38\u751f\u6210\u4f59\u989d\uff0c\u539f\u56e0\uff1a\u5f53\u65e5\u6700\u540e\u4ea4\u6613\u65f6\u95f4\u7684\u4ea4\u6613\u660e\u7ec6\uff08\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%4$s\uff09\u65e0\u4f59\u989d\u4fe1\u606f\u3002", (String)"SyncAutoBalanceHelper_1", (String)"tmc-bei-common", (Object[])new Object[0]), accountBank.getString("bankaccountnumber"), currency.getString("name"), bizDateStr, billno));
                deleteList.add(orgId + "_" + accountBankId + "_" + currencyId + "_" + bizDateStr);
                continue;
            }
            ArrayList<String> key = new ArrayList<String>(4);
            key.add(String.valueOf(orgId));
            key.add(String.valueOf(accountBankId));
            key.add(String.valueOf(currencyId));
            key.add(bizDateStr);
            ArrayList<Object> value = new ArrayList<Object>(6);
            value.add(orgId);
            value.add(accountBankId);
            value.add(bankId);
            value.add(currencyId);
            value.add(amount);
            value.add(bizDate);
            genMap.put(key, value);
        }
        QFilter qFilters = new QFilter("company", "in", orgIds);
        qFilters.and(ACCOUNTBANK, "in", accountBankIds);
        qFilters.and(CURRENCY, "in", currencyIds);
        QFilter bizdateQFilter = null;
        for (Date bizDate : bizDates) {
            if (bizdateQFilter == null) {
                bizdateQFilter = new QFilter("bizdate", "=", (Object)bizDate);
                continue;
            }
            bizdateQFilter.or(new QFilter("bizdate", "=", (Object)bizDate));
        }
        qFilters.and(bizdateQFilter);
        DynamicObject[] balances = TmcDataServiceHelper.load((String)"bei_bankbalance", (String)"id,company,accountbank,currency,bizdate,amount,valibalance,modifytime,modifier", (QFilter[])qFilters.toArray());
        ArrayList<Object> updateBalances = new ArrayList<Object>(balances.length);
        for (DynamicObject balance2 : balances) {
            ArrayList<String> key = new ArrayList<String>(4);
            key.add(balance2.getDynamicObject("company").getPkValue().toString());
            key.add(balance2.getDynamicObject(ACCOUNTBANK).getPkValue().toString());
            key.add(balance2.getDynamicObject(CURRENCY).getPkValue().toString());
            key.add(DateUtils.formatString((Date)balance2.getDate("bizdate"), (String)"yyyy-MM-dd"));
            List value = (List)genMap.remove(key);
            if (EmptyUtil.isEmpty((Collection)value)) continue;
            balance2.set("amount", value.get(4));
            balance2.set("valibalance", value.get(4));
            balance2.set("modifytime", (Object)DateUtils.getCurrentTime());
            balance2.set("modifier", (Object)RequestContext.get().getCurrUserId());
            updateBalances.add(balance2);
        }
        if (updateBalances.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateBalances.toArray(new DynamicObject[0]));
        }
        ArrayList<DynamicObject> newBalances = new ArrayList<DynamicObject>(genMap.size());
        ArrayList updateDateBalances = new ArrayList(10);
        Map<String, List> groupedAndSorted = genMap.values().stream().collect(Collectors.groupingBy(balance -> balance.get(1) + "#" + balance.get(3), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(t -> (Date)t.get(5))).collect(Collectors.toList()))));
        for (List values : groupedAndSorted.values()) {
            List bizDatesParam = values.stream().map(s -> (Date)s.get(5)).collect(Collectors.toList());
            for (int i2 = 0; i2 < values.size(); ++i2) {
                List objects = (List)values.get(i2);
                DynamicObject balance3 = TmcDataServiceHelper.newDynamicObject((String)"bei_bankbalance");
                balance3.set("id", (Object)DBServiceHelper.genGlobalLongId());
                balance3.set("company", objects.get(0));
                Object accountBankId = objects.get(1);
                balance3.set(ACCOUNTBANK, accountBankId);
                balance3.set("bank", objects.get(2));
                Object currencyId = objects.get(3);
                balance3.set(CURRENCY, currencyId);
                balance3.set("amount", objects.get(4));
                balance3.set("valibalance", objects.get(4));
                Date bizDate = (Date)objects.get(5);
                balance3.set("bizdate", (Object)bizDate);
                Date endDate = BalanceHelper.dealEndDate((int)i2, bizDatesParam, (Date)bizDate, accountBankId, currencyId, updateDateBalances);
                balance3.set(ENDDATE, (Object)endDate);
                balance3.set("createtime", (Object)DateUtils.getCurrentTime());
                balance3.set("modifytime", (Object)DateUtils.getCurrentTime());
                balance3.set("datasource", (Object)DataSourceEnum.FROMAUTO.getValue());
                balance3.set("creator", (Object)RequestContext.get().getCurrUserId());
                balance3.set("modifier", (Object)RequestContext.get().getCurrUserId());
                newBalances.add(balance3);
            }
        }
        if (newBalances.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newBalances.toArray(new DynamicObject[0]));
        }
        if (updateDateBalances.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateDateBalances.toArray(new DynamicObject[0]));
        }
        SyncAutoBalanceHelper.deleteBalanceInfo(deleteList);
        if (cache != null) {
            String traceId = RequestContext.get().getTraceId();
            String serialize = SerializationUtils.serializeToBase64(messageList);
            cache.put("auto_balance_cache_message_list_" + traceId, (Object)serialize, 3600000);
        }
    }

    public static void deleteBalanceInfo(List<String> deleteList) {
        if (EmptyUtil.isNoEmpty(deleteList)) {
            QFilter delFilter = null;
            for (String deleteInfo : deleteList) {
                String[] split = deleteInfo.split("_");
                QFilter filter = new QFilter("company", "=", (Object)Long.parseLong(split[0]));
                filter.and(ACCOUNTBANK, "=", (Object)Long.parseLong(split[1]));
                filter.and(CURRENCY, "=", (Object)Long.parseLong(split[2]));
                filter.and("bizdate", "=", (Object)DateUtils.stringToDate((String)split[3], (String)"yyyy-MM-dd"));
                filter.and("datasource", "=", (Object)DataSourceEnum.FROMAUTO.getValue());
                if (delFilter == null) {
                    delFilter = filter;
                    continue;
                }
                delFilter.or(filter);
            }
            if (delFilter != null) {
                DynamicObject[] deleteBalance = TmcDataServiceHelper.load((String)"bei_bankbalance", (String)"id,accountbank,currency,bizdate,enddate", (QFilter[])delFilter.toArray());
                ArrayList updateBalanceList = new ArrayList(10);
                BalanceHelper.deleteBalance(Arrays.stream(deleteBalance).collect(Collectors.toList()), updateBalanceList);
                if (updateBalanceList.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])updateBalanceList.toArray(new DynamicObject[0]));
                }
                Object[] ids = Arrays.stream(deleteBalance).map(t -> t.getLong("id")).toArray();
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bei_bankbalance"), (Object[])ids);
            }
        }
    }

    public static void checkAndAutoBalance(DynamicObject[] details, boolean isRemove, List<String> autoBalanceList) {
        QFilter idFilter = null;
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> accountBankIds = new HashSet<Long>(16);
        HashSet<Long> currencyIds = new HashSet<Long>(16);
        HashSet<Date> bizDates = new HashSet<Date>(16);
        String[] dataSourceArr = new String[]{DataSourceEnum.IMPORT.getValue(), DataSourceEnum.RECEIPTGEN.getValue(), DataSourceEnum.FROMIMG.getValue()};
        Map<String, List<DynamicObject>> transDetailMap = Arrays.stream(details).filter(o -> Arrays.asList(dataSourceArr).contains(o.getString("datasource"))).collect(Collectors.groupingBy(o -> o.getDynamicObject("company").getLong("id") + "#" + o.getDynamicObject(ACCOUNTBANK).getLong("id")));
        HashMap<Long, Boolean> checkOrgMap = new HashMap<Long, Boolean>(16);
        HashMap<Long, Boolean> checkAccMap = new HashMap<Long, Boolean>(16);
        for (Map.Entry<String, List<DynamicObject>> next : transDetailMap.entrySet()) {
            Long accountId;
            Boolean isCheckAcc;
            boolean isPass = false;
            String[] split = next.getKey().split("#");
            Long companyId = Long.parseLong(split[0]);
            Boolean isCheckOrg = checkOrgMap.getOrDefault(companyId, false);
            if (!isCheckOrg.booleanValue()) {
                checkOrgMap.put(companyId, Boolean.TRUE);
                boolean isAutoBalance = BeiParameterHelper.getAppBoolParameter((long)companyId, (String)"bei007");
                String genBanlanceWay = (String)TmcParameterHelper.getAppParameter((String)TmcAppEnum.BEI.getId(), (Long)companyId, (String)"bei010");
                if (!isAutoBalance || !"0".equals(genBanlanceWay)) continue;
                orgIds.add(companyId);
                isPass = true;
            }
            if (!(isCheckAcc = checkAccMap.getOrDefault(accountId = Long.valueOf(Long.parseLong(split[1])), false)).booleanValue()) {
                Boolean isCan = SyncAutoBalanceHelper.isCanAutoBalace(accountId);
                if (isCan.booleanValue()) {
                    accountBankIds.add(accountId);
                    isPass = true;
                }
                checkAccMap.put(accountId, Boolean.TRUE);
            }
            if (!isPass) continue;
            List<DynamicObject> detailList = next.getValue();
            if (isRemove) {
                List idList = detailList.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
                idFilter = new QFilter("id", "not in", idList);
            }
            for (DynamicObject detail : detailList) {
                DynamicObject currency = detail.getDynamicObject(CURRENCY);
                Long currencyId = currency.getLong("id");
                currencyIds.add(currencyId);
                Date bizDate = detail.getDate("bizdate");
                bizDates.add(bizDate);
            }
        }
        if (EmptyUtil.isNoEmpty(orgIds) && EmptyUtil.isNoEmpty(accountBankIds)) {
            QFilter qFilters = new QFilter("datasource", "in", (Object)new String[]{DataSourceEnum.IMPORT.getValue(), DataSourceEnum.RECEIPTGEN.getValue(), DataSourceEnum.FROMIMG.getValue()});
            if (idFilter != null) {
                qFilters.and(idFilter);
            }
            qFilters.and("company", "in", orgIds);
            qFilters.and(ACCOUNTBANK, "in", accountBankIds);
            qFilters.and(CURRENCY, "in", currencyIds);
            QFilter bizdateQFilter = null;
            for (Date bizDate : bizDates) {
                if (bizdateQFilter == null) {
                    bizdateQFilter = new QFilter("bizdate", "=", (Object)bizDate);
                    continue;
                }
                bizdateQFilter.or(new QFilter("bizdate", "=", (Object)bizDate));
            }
            qFilters.and(bizdateQFilter);
            String detailSelectField = "id,datasource,billno,company,currency,accountbank,bizdate,transbalance,biztime,sortno";
            Object[] autoDetail = TmcDataServiceHelper.load((String)"bei_transdetail", (String)detailSelectField, (QFilter[])qFilters.toArray());
            logger.info("\u53ef\u4ee5\u81ea\u52a8\u751f\u6210\u4f59\u989d\u6761\u6570\uff1a{}\u3002", (Object)autoDetail.length);
            if (EmptyUtil.isNoEmpty((Object[])autoDetail)) {
                logger.info("\u5f00\u59cb\u81ea\u52a8\u751f\u6210\u4f59\u989d");
                SyncAutoBalanceHelper.autoCreateBalance((DynamicObject[])autoDetail, null);
                logger.info("\u7ed3\u675f\u81ea\u52a8\u751f\u6210\u4f59\u989d");
                if (isRemove) {
                    List deleteBalanceList = Arrays.stream(autoDetail).map(s -> s.getDynamicObject("company").getLong("id") + "_" + s.getDynamicObject(ACCOUNTBANK).getLong("id") + "_" + s.getDynamicObject(CURRENCY).getLong("id") + "_" + DateUtils.formatString((Date)s.getDate("bizdate"), (String)"yyyy-MM-dd")).collect(Collectors.toList());
                    autoBalanceList.removeAll(deleteBalanceList);
                }
            }
            if (isRemove) {
                SyncAutoBalanceHelper.deleteBalanceInfo(autoBalanceList);
            }
        }
    }
}

