/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.tmc.bei.common.helper.OperateServiceHelper;
import kd.tmc.fbp.common.util.StopWatchWithSummary;

public class ThreadPushHelper {
    private static final Log LOGGER = LogFactory.getLog(ThreadPushHelper.class);
    private static int CORE_THREAD = 8;
    private static int MAX_THREAD = 16;
    private static ExecutorService service = ThreadPools.newCachedExecutorService((String)"ThreadPushHelper", (int)CORE_THREAD, (int)MAX_THREAD);

    public static OperateErrorInfo getOperateErrorInfo(Object pk, String meg) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(pk);
        operateErrorInfo.setMessage(meg);
        return operateErrorInfo;
    }

    public static List<OperationResult> doPushAndSaveOp(List<String> ids, String entity, OperateOption operateOption, String key) {
        ArrayList<OperationResult> returnRes = new ArrayList<OperationResult>();
        if (ids.size() != 0) {
            List<List<String>> taskList = ThreadPushHelper.split(ids, ids.size() > CORE_THREAD ? CORE_THREAD : ids.size());
            CountDownLatch countDownLatch = new CountDownLatch(taskList.size());
            ArrayList<Future<List>> futures = new ArrayList<Future<List>>(0);
            for (int i = 0; i < taskList.size(); ++i) {
                List<String> list = taskList.get(i);
                Integer index = i;
                Future<List> pushFuture = service.submit(() -> ThreadPushHelper.getOperationResults(countDownLatch, task, index, entity, operateOption, key));
                futures.add(pushFuture);
            }
            try {
                countDownLatch.await();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Future future : futures) {
                try {
                    returnRes.addAll((Collection)future.get());
                }
                catch (Exception exception) {}
            }
        }
        return returnRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<OperationResult> getOperationResults(CountDownLatch countDownLatch, List<String> task, int i, String entity, OperateOption option, String key) {
        StopWatchWithSummary stopWatchWithSummary = StopWatchWithSummary.createStarted();
        stopWatchWithSummary.start("getOperationResults ");
        stopWatchWithSummary.nextStep("getOperationResults ");
        ArrayList<OperationResult> results = new ArrayList<OperationResult>();
        for (String id : task) {
            OperationResult operationResult = null;
            try {
                operationResult = OperateServiceHelper.execOperate(key, entity, new Object[]{Long.valueOf(id)}, option);
                results.add(operationResult);
            }
            catch (Exception e) {
                operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.addErrorInfo(ThreadPushHelper.getOperateErrorInfo(id, e.getMessage()));
                results.add(operationResult);
            }
        }
        countDownLatch.countDown();
        stopWatchWithSummary.stop();
        stopWatchWithSummary.printSummary();
        return results;
    }

    public static boolean pusAndSave(Object[] selectedPks, String entity, OperationResult result, OperateOption option, String key) {
        StopWatchWithSummary stopWatchWithSummary = StopWatchWithSummary.createStarted();
        stopWatchWithSummary.start("pusAndSave ");
        stopWatchWithSummary.nextStep("pusAndSave ");
        boolean errorFlag = false;
        ArrayList succIdList = new ArrayList(10);
        List<OperationResult> billDealRes = ThreadPushHelper.doPushAndSaveOp(Arrays.stream(selectedPks).map(String::valueOf).collect(Collectors.toList()), entity, option, key);
        for (OperationResult operationResult : billDealRes) {
            if (operationResult.isSuccess()) {
                succIdList.addAll(operationResult.getSuccessPkIds());
                continue;
            }
            result.setAllErrorInfo(operationResult.getAllErrorInfo());
            errorFlag = true;
        }
        result.setSuccessPkIds(succIdList);
        stopWatchWithSummary.stop();
        stopWatchWithSummary.printSummary();
        return errorFlag;
    }

    public static List<List<String>> split(List<String> list, int input) {
        int limit = (list.size() + input - 1) / input;
        List<List<String>> splitList = Stream.iterate(0, n -> n + 1).limit(limit).map(a -> list.stream().skip(a * input).limit(input).collect(Collectors.toList())).collect(Collectors.toList());
        if (input < limit) {
            splitList = Stream.iterate(0, n -> n + 1).limit(input).map(a -> list.stream().skip(a * limit).limit(limit).collect(Collectors.toList())).collect(Collectors.toList());
        }
        return splitList;
    }
}

