/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.init;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SynTransDetailDataHelper {
    private static final Log LOGGER = LogFactory.getLog(SynTransDetailDataHelper.class);

    public static void synBillnoData() {
        try (TXHandle h = TX.requiresNew((String)"SynTransDetailDataHelper");){
            try {
                DataSet detailUpdateLog = DB.queryDataSet((String)"detailUpdateLog", (DBRoute)DBRouteConst.TMC, (String)"SELECT COUNT(0) count FROM T_BEI_DETAIL_UPDATE_LOG");
                int hasUpdateLog = ((Row)detailUpdateLog.iterator().next()).getInteger("count");
                if (hasUpdateLog == 0) {
                    long beforeTime = System.currentTimeMillis();
                    String noUpdateSql = "UPDATE t_bei_transdetail_e t1 SET FBUSINESSBILLNUM = (select  FBILLNO  from T_BEI_TRANSDETAIL t2 where t1.fid=t2.fid)  where fid in(select  fid from  T_BEI_TRANSDETAIL where fbillno !=' ')";
                    DB.execute((DBRoute)DBRouteConst.TMC, (String)noUpdateSql);
                    DataSet synCount = DB.queryDataSet((String)"synCount", (DBRoute)DBRouteConst.TMC, (String)"SELECT COUNT(0) count FROM T_BEI_TRANSDETAIL");
                    int count = ((Row)synCount.iterator().next()).getInteger("count");
                    int page = 0;
                    if (count > 50000) {
                        page = count / 50000;
                    }
                    for (int j = 0; j < page + 1; ++j) {
                        int startsize = j * 50000;
                        int endsize = (j + 1) * 50000;
                        String synSelectStr = "SELECT  fid,fbizdate FROM T_BEI_TRANSDETAIL ";
                        DataSet ds = DB.queryDataSet((String)"synQuery", (DBRoute)DBRouteConst.TMC, (String)synSelectStr).limit(startsize, endsize);
                        ArrayList<Object[]> batchParam = new ArrayList<Object[]>(10);
                        while (ds.hasNext()) {
                            Row row = ds.next();
                            Long id = row.getLong("fid");
                            Date bizdate = row.getDate("fbizdate");
                            String bizdateStr = DateUtils.formatString((Date)(EmptyUtil.isEmpty((Object)bizdate) ? DateUtils.getCurrentDate() : bizdate), (String)"yyyyMMdd");
                            String paramBillno = bizdateStr + "-" + id.toString().substring(8, 18);
                            batchParam.add(new Object[]{paramBillno, id});
                        }
                        String sql = "UPDATE  T_BEI_TRANSDETAIL  SET fbillno = ? where  Fid = ?";
                        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, batchParam);
                    }
                    String insertSql = "INSERT INTO T_BEI_DETAIL_UPDATE_LOG(FID, FISUPATE) VALUES (?,?);";
                    Object[] paramIns = new Object[]{System.nanoTime() + "", "1"};
                    DB.execute((DBRoute)DBRouteConst.TMC, (String)insertSql, (Object[])paramIns);
                    LOGGER.info("\u5171" + count + "\u6761\u6570\u636e\u5347\u7ea7\u8017\u65f6:" + (System.currentTimeMillis() - beforeTime) / 1000L + "\u79d2");
                }
            }
            catch (Exception ee) {
                LOGGER.error((Throwable)ee);
                h.markRollback();
            }
        }
    }

    public static void returnBillnoData() {
        try (TXHandle h = TX.requiresNew((String)"returnBillnoData");){
            try {
                DataSet detailUpdateLog = DB.queryDataSet((String)"detailUpdateLog", (DBRoute)DBRouteConst.TMC, (String)"SELECT COUNT(0) count FROM T_BEI_DETAIL_UPDATE_LOG");
                int hasUpdateLog = ((Row)detailUpdateLog.iterator().next()).getInteger("count");
                if (hasUpdateLog == 1) {
                    String deleteSql = "delete from  T_BEI_DETAIL_UPDATE_LOG;";
                    DB.execute((DBRoute)DBRouteConst.TMC, (String)deleteSql);
                    String selectNumSql = "UPDATE t_bei_transdetail t1 SET FBILLNO =( select  FBUSINESSBILLNUM  from T_BEI_TRANSDETAIL_E t2 where t1.fid=t2.fid)";
                    DB.execute((DBRoute)DBRouteConst.TMC, (String)selectNumSql);
                    String updateSql = "update  t_bei_transdetail_e set  FBUSINESSBILLNUM=' ' where FBUSINESSBILLNUM !=' ';";
                    DB.execute((DBRoute)DBRouteConst.TMC, (String)updateSql);
                }
            }
            catch (Exception ee) {
                LOGGER.error((Throwable)ee);
                h.markRollback();
            }
        }
    }
}

