/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PayBillTracker {
    private final String targetBillType;
    private final IFormView view;

    public PayBillTracker(IFormView view, String targetBillType) {
        this.view = view;
        this.targetBillType = targetBillType;
    }

    public void traceUp(Collection<Long> billIds) {
        if (billIds == null || billIds.size() == 0) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PayBillTracker_0", (String)"tmc-bei-common", (Object[])new Object[0]));
        } else if (billIds.size() == 1) {
            DynamicObject targetBill;
            QFilter qFilter = new QFilter("id", "=", (Object)billIds.iterator().next());
            String sel = "id,sourcebillid";
            if ("bei_bankpaybill".equals(this.targetBillType)) {
                sel = "id,sourcebillid,srcbilltype";
            }
            if ((targetBill = QueryServiceHelper.queryOne((String)this.targetBillType, (String)sel, (QFilter[])qFilter.toArray())) == null) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u5355\u636e\u4e0a\u6ca1\u6709\u8bb0\u5f55\u6e90\u5355\u3002", (String)"PayBillTracker_1", (String)"tmc-bei-common", (Object[])new Object[0]));
                return;
            }
            String sourceEntity = "bei_bankpaybill".equals(this.targetBillType) ? targetBill.getString("srcbilltype") : "cas_agentpaybill";
            this.showOneDataParameter(sourceEntity, targetBill);
        } else {
            DynamicObjectCollection targetBill;
            QFilter qFilter = new QFilter("id", "in", billIds);
            String sel = "id,sourcebillid";
            if ("bei_bankpaybill".equals(this.targetBillType)) {
                sel = "id,sourcebillid,srcbilltype";
            }
            if ((targetBill = QueryServiceHelper.query((String)this.targetBillType, (String)sel, (QFilter[])qFilter.toArray())) == null || targetBill.size() == 0) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"PayBillTracker_3", (String)"tmc-bei-common", (Object[])new Object[0]));
                return;
            }
            if ("bei_bankpaybill".equals(this.targetBillType)) {
                Map<String, List<DynamicObject>> srcBillTypeMap = targetBill.stream().collect(Collectors.groupingBy(e -> e.getString("srcbilltype")));
                for (Map.Entry<String, List<DynamicObject>> map : srcBillTypeMap.entrySet()) {
                    String sourceEntity = map.getKey();
                    List<DynamicObject> targetBillList = map.getValue();
                    Set<Object> sourceBillIds = targetBillList.stream().map(s -> s.get("sourcebillid")).collect(Collectors.toSet());
                    if (sourceBillIds.size() == 1) {
                        this.showOneDataParameter(sourceEntity, targetBillList.get(0));
                        continue;
                    }
                    this.showBatchDataParameter(sourceEntity, sourceBillIds);
                }
            } else {
                String sourceEntity = "cas_agentpaybill";
                Set<Object> sourceBillIds = targetBill.stream().map(s -> s.get("sourcebillid")).collect(Collectors.toSet());
                this.showBatchDataParameter(sourceEntity, sourceBillIds);
            }
        }
    }

    private void showBatchDataParameter(String sourceEntity, Set<Object> sourceBillIds) {
        DynamicObjectCollection sourceBill = QueryServiceHelper.query((String)sourceEntity, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIds)});
        if (sourceBill == null || sourceBill.size() == 0) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u67e5\u627e\u7684\u4e0a\u6e38\u5355\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"PayBillTracker_2", (String)"tmc-bei-common", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setHasRight(true);
        showParameter.setIsolationOrg(false);
        showParameter.setBillFormId(sourceEntity);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", sourceBillIds));
        showParameter.getListFilterParameter().setQFilters(qFilters);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
        showParameter.setCustomParam("istmctracebillop", (Object)"yes");
        this.view.showForm((FormShowParameter)showParameter);
    }

    private void showOneDataParameter(String sourceEntity, DynamicObject targetBill) {
        DynamicObject sourceBill = QueryServiceHelper.queryOne((String)sourceEntity, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", targetBill.get("sourcebillid"))});
        if (sourceBill == null) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u67e5\u627e\u7684\u4e0a\u6e38\u5355\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"PayBillTracker_2", (String)"tmc-bei-common", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setHasRight(true);
        showParameter.setPkId(sourceBill.get("id"));
        showParameter.setFormId(sourceEntity);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
        this.view.showForm((FormShowParameter)showParameter);
    }
}

