/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.util.Sumable;

public class AutoSumableDataProvider {
    private String[] groupBys;
    private String[] sumFields;
    private Collection<String> selectors = new HashSet<String>();
    private Collection<QFilter> filters = new ArrayList<QFilter>();
    private Collection<Row> dsRows = new LinkedList<Row>();
    private String entityKey;

    public AutoSumableDataProvider(String entityKey) {
        this.entityKey = entityKey;
    }

    public AutoSumableDataProvider filter(QFilter ... filters) {
        this.filters.addAll(Arrays.asList(filters));
        return this;
    }

    public AutoSumableDataProvider groupBy(String ... groupBys) {
        this.selectors.addAll(Arrays.asList(groupBys));
        this.groupBys = new String[groupBys.length];
        for (int i = 0; i < groupBys.length; ++i) {
            this.groupBys[i] = this.getAsField(groupBys[i]);
        }
        return this;
    }

    public AutoSumableDataProvider sum(String ... sumFields) {
        this.selectors.addAll(Arrays.asList(sumFields));
        this.sumFields = new String[sumFields.length];
        for (int i = 0; i < sumFields.length; ++i) {
            this.sumFields[i] = this.getAsField(sumFields[i]);
        }
        return this;
    }

    private String getAsField(String originalField) {
        String[] split = originalField.split(" ");
        return split[split.length - 1];
    }

    public AutoSumableDataProvider query() {
        try (DataSet rawDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityKey, (String)String.join((CharSequence)",", this.selectors), (QFilter[])this.filters.toArray(new QFilter[0]), null);){
            GroupbyDataSet groupBy = rawDataSet.groupBy(this.groupBys);
            for (String sum : this.sumFields) {
                groupBy = groupBy.sum(sum);
            }
            try (DataSet groupByDataSet = groupBy.finish();){
                groupByDataSet.forEach(row -> this.dsRows.add((Row)row));
            }
        }
        return this;
    }

    public <K, V extends Sumable> Map<K, V> compute(Function<Row, K> keyFunc, Function<Row, V> vFunc) {
        HashMap map = new HashMap();
        this.dsRows.forEach(row -> {
            Object key = keyFunc.apply((Row)row);
            if (key != null) {
                Sumable value = (Sumable)vFunc.apply((Row)row);
                map.computeIfPresent(key, (k, v) -> v.sum(value));
                map.computeIfAbsent(key, k -> value);
            }
        });
        return map;
    }

    public <K, V extends Sumable> Map<K, V> computeMutiKey(Function<Row, Iterable<K>> keyFunc, BiFunction<Row, K, V> vFunc) {
        HashMap map = new HashMap();
        this.dsRows.forEach(row -> {
            Iterable key = (Iterable)keyFunc.apply((Row)row);
            if (key != null) {
                for (Object k : key) {
                    Sumable value = (Sumable)vFunc.apply((Row)row, (Object)k);
                    map.computeIfPresent(k, (k0, v) -> v.sum(value));
                    map.computeIfAbsent(k, k0 -> value);
                }
            }
        });
        return map;
    }

    public <K, V extends Sumable> Map<K, V> compute(Function<Row, K> keyFunc, BiFunction<Row, K, V> vFunc) {
        HashMap map = new HashMap();
        this.dsRows.forEach(row -> {
            Object key = keyFunc.apply((Row)row);
            if (key != null) {
                Sumable value = (Sumable)vFunc.apply((Row)row, (Object)key);
                map.computeIfPresent(key, (k, v) -> v.sum(value));
                map.computeIfAbsent(key, k -> value);
            }
        });
        return map;
    }

    public <V extends Sumable> V compute(Function<Row, V> vFunc) {
        Sumable temValue = null;
        for (Row row : this.dsRows) {
            Sumable value = (Sumable)vFunc.apply(row);
            if (value == null) continue;
            if (temValue == null) {
                temValue = value;
                continue;
            }
            temValue = temValue.sum(value);
        }
        return (V)temValue;
    }

    public Iterator<Row> getDsRowIterator() {
        return this.dsRows.iterator();
    }

    public static AutoSumableDataProvider merge(AutoSumableDataProvider d1, AutoSumableDataProvider d2) {
        AutoSumableDataProvider mergedDataProvider = new AutoSumableDataProvider(d1.entityKey);
        mergedDataProvider.dsRows.addAll(d1.dsRows);
        mergedDataProvider.dsRows.addAll(d2.dsRows);
        return mergedDataProvider;
    }
}

