/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.common.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.common.constants.ReceiptRecongnizeDetail;
import kd.tmc.bei.common.enums.LendingDirectionEnum;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FileContentUtils {
    private static final Log logger = LogFactory.getLog(FileContentUtils.class);

    public ReceiptRecongnizeDetail parseReceiptOFDStructuredData(String filePath) throws IOException {
        ReceiptRecongnizeDetail ofdParseResult = new ReceiptRecongnizeDetail();
        ZipFile zipFile = new ZipFile(filePath);
        logger.info("\u5f00\u59cb\u89e3\u6790OFD\u6587\u4ef6\uff1a{}", (Object)filePath);
        Enumeration entries = zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            if (entry.isDirectory() || entry.getName().endsWith("Attachments.xml") || !entry.getName().startsWith("Doc_0/Attachs/")) continue;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", null);
            try {
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                Document document = factory.newDocumentBuilder().parse(zipFile.getInputStream(entry));
                Element root = document.getDocumentElement();
                String tradeDate = this.getIsCanNullData(root, "bker:DateOfBookkeeping");
                String payeeName = this.getIsCanNullData(root, "bker:AccountNameOfPayee");
                String payerName = this.getIsCanNullData(root, "bker:AccountNameOfPayer");
                String payeeAccount = this.getIsCanNullData(root, "bker:AccountNumberOfPayee");
                String payerAccount = this.getIsCanNullData(root, "bker:AccountNumberOfPayer");
                String payeeBank = this.getIsCanNullData(root, "bker:OpeningBankOfPayee");
                String payerBank = this.getIsCanNullData(root, "bker:OpeningBankOfPayer");
                String amount = this.getIsCanNullData(root, "bker:TransactionAmountInFigures");
                String currency = this.getIsCanNullData(root, "bker:Currency");
                String tradeType = this.getIsCanNullData(root, "bker:IdentificationOfCreditOrDebit");
                String tradeId = this.getIsCanNullData(root, "bker:JournalAccountOfBookkeeping");
                String tradeNumber = this.getIsCanNullData(root, "bker:NumberOfBankElectronicReceipt");
                String description = this.getIsCanNullData(root, "bker:Usage");
                ofdParseResult.setFtradeDate(tradeDate);
                ofdParseResult.setFpayeeName(payeeName);
                ofdParseResult.setFpaymentName(payerName);
                ofdParseResult.setFpayeeAccount(payeeAccount);
                ofdParseResult.setFpaymentAccount(payerAccount);
                ofdParseResult.setFpayeeBank(payeeBank);
                ofdParseResult.setFpaymentBank(payerBank);
                ofdParseResult.setFamount(amount);
                ofdParseResult.setFcurrency(currency);
                ofdParseResult.setFtradeType("1".equals(tradeType) ? LendingDirectionEnum.IN.getDirect() : LendingDirectionEnum.OUT.getDirect());
                ofdParseResult.setFtradeId(tradeId);
                ofdParseResult.setFtradeNumber(tradeNumber);
                ofdParseResult.setFabstract(description);
            }
            catch (Exception e) {
                logger.info("ReceiptOfdParseException:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw new KDBizException("ReceiptOfdParseException:" + e.getMessage());
            }
        }
        return ofdParseResult;
    }

    private String getIsCanNullData(Element root, String tagName) {
        Node item = root.getElementsByTagName(tagName).item(0);
        if (item == null) {
            return "";
        }
        return item.getTextContent();
    }

    public static String parse(String filename) {
        String field;
        String result = null;
        int indexOf = filename.lastIndexOf(46);
        switch (field = filename.substring(indexOf + 1).toLowerCase(Locale.ENGLISH)) {
            case "pdf": {
                result = "application/pdf";
                break;
            }
            case "jpg": {
                result = "image/jpeg";
                break;
            }
            case "png": {
                result = "image/png";
                break;
            }
        }
        return result;
    }
}

