/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.enums;

import java.util.HashMap;
import java.util.Map;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;
import org.apache.commons.lang3.StringUtils;

public enum ElcTicketStatusToTradeTypeEnum {
    REGISTED("registed", new MultiLangEnumBridge("\u51fa\u7968\u5df2\u767b\u8bb0", "ElcTicketStatusToTradeTypeEnum_0", "tmc-cdm-common"), "remitregister,remitrevocation,remitaccept,ticketguarantee"),
    DESTROY("destroy", new MultiLangEnumBridge("\u7968\u636e\u5df2\u4f5c\u5e9f", "ElcTicketStatusToTradeTypeEnum_1", "tmc-cdm-common"), "remitrevocation"),
    ACCEPTANCE("acceptance", new MultiLangEnumBridge("\u63d0\u793a\u627f\u5151\u5f85\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_2", "tmc-cdm-common"), "remitaccept"),
    ACCEPTANCESIGNED("acceptancesigned", new MultiLangEnumBridge("\u63d0\u793a\u627f\u5151\u5df2\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_3", "tmc-cdm-common"), "remitrevocation,remitaccept,ticketguarantee,remitreceive"),
    INVOICE("invoice", new MultiLangEnumBridge("\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_4", "tmc-cdm-common"), "ticketguarantee,notesignin,notesigninreject,remitreceive"),
    INVOICESIGNED("invoicesigned", new MultiLangEnumBridge("\u63d0\u793a\u6536\u7968\u5df2\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_5", "tmc-cdm-common"), "noteendorse,notesignin,notediscount,presentpayment,pledgenote,removepledge,notecancle,remitreceive"),
    RECITE("recite", new MultiLangEnumBridge("\u80cc\u4e66\u5f85\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_6", "tmc-cdm-common"), "noteendorse,notesignin,notesigninreject"),
    RECITESIGNED("recitesigned", new MultiLangEnumBridge("\u80cc\u4e66\u5df2\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_7", "tmc-cdm-common"), "noteendorse,notesignin,notediscount,presentpayment,pledgenote,removepledge,notecancle"),
    RELEASEOFPLEDGE("releaseofpledge", new MultiLangEnumBridge("\u8d28\u62bc\u89e3\u9664\u5f85\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_8", "tmc-cdm-common"), "notesignin,notesigninreject,removepledge"),
    RELEASEOFEDGSIGNED("releaseofedgsigned", new MultiLangEnumBridge("\u8d28\u62bc\u89e3\u9664\u5df2\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_9", "tmc-cdm-common"), "noteendorse,notesignin,notediscount,presentpayment,pledgenote,removepledge,notecancle"),
    NOTEDISCOUNT("notediscount", new MultiLangEnumBridge("\u4e70\u65ad\u5f0f\u8d34\u73b0\u5f85\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_10", "tmc-cdm-common"), "notediscount"),
    NOTEDISCOUNTSIGNED("notediscountsigned", new MultiLangEnumBridge("\u4e70\u65ad\u5f0f\u8d34\u73b0\u5df2\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_11", "tmc-cdm-common"), "notediscount"),
    PAYMENT("payment", new MultiLangEnumBridge("\u63d0\u793a\u4ed8\u6b3e\u5f85\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_12", "tmc-cdm-common"), "presentpayment"),
    PAYMENTSIGNED("paymentsigned", new MultiLangEnumBridge("\u63d0\u793a\u4ed8\u6b3e\u5df2\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_13", "tmc-cdm-common"), "presentpayment"),
    PAYMENTREFUSED("paymentrefused", new MultiLangEnumBridge("\u63d0\u793a\u4ed8\u6b3e\u5df2\u62d2\u6536", "ElcTicketStatusToTradeTypeEnum_14", "tmc-cdm-common"), "presentpayment"),
    CLOSEDACCOUNT("closedaccount", new MultiLangEnumBridge("\u7968\u636e\u5df2\u7ed3\u6e05", "ElcTicketStatusToTradeTypeEnum_15", "tmc-cdm-common"), "presentpayment"),
    PLEDGE("pledge", new MultiLangEnumBridge("\u8d28\u62bc\u5f85\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_16", "tmc-cdm-common"), "pledgenote"),
    PLEDGESIGNED("pledgesigned", new MultiLangEnumBridge("\u8d28\u62bc\u5df2\u7b7e\u6536", "ElcTicketStatusToTradeTypeEnum_17", "tmc-cdm-common"), "pledgenote,removepledge");

    private final String ticketStatus;
    private final MultiLangEnumBridge name;
    private final String tradeType;

    private ElcTicketStatusToTradeTypeEnum(String ticketStatus, MultiLangEnumBridge name, String tradeType) {
        this.name = name;
        this.ticketStatus = ticketStatus;
        this.tradeType = tradeType;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public static String getName(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        String name = null;
        for (ElcTicketStatusToTradeTypeEnum status : ElcTicketStatusToTradeTypeEnum.values()) {
            if (!status.getTicketStatus().equals(value)) continue;
            name = status.getName();
            return name;
        }
        return value;
    }

    public String getTicketStatus() {
        return this.ticketStatus;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public static Map<String, String> getTicketStatusByTradeType(String tradeType) {
        HashMap<String, String> result = new HashMap<String, String>(4);
        for (ElcTicketStatusToTradeTypeEnum status : ElcTicketStatusToTradeTypeEnum.values()) {
            if (!status.getTradeType().contains(tradeType)) continue;
            result.put(status.getTicketStatus(), status.getName());
        }
        return result;
    }
}

