/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class BankCateHelper {
    private static final Log logger = LogFactory.getLog(BankCateHelper.class);

    public static Long getBankCateId(DynamicObject bankAcct) {
        long bankCateId = 0L;
        if (Objects.isNull(bankAcct)) {
            return bankCateId;
        }
        DynamicObject bank = bankAcct.getDynamicObject("bank");
        if (Objects.nonNull(bank)) {
            bank = BusinessDataServiceHelper.loadSingle((Object)bank.getPkValue(), (String)bank.getDynamicObjectType().getName(), (String)"bank_cate");
            bankCateId = bank.getDynamicObject("bank_cate").getLong("id");
        }
        logger.info("\u6839\u636e\u94f6\u884c\u8d26\u53f7\u83b7\u53d6\u94f6\u884c\u7c7b\u522b\u7684bankCateId:" + bankCateId);
        return bankCateId;
    }

    public static Long getBankCateId(String bankAcctNumber) {
        long bankCateId = 0L;
        if (StringUtils.isNull((String)bankAcctNumber)) {
            return bankCateId;
        }
        if (StringUtils.isNotEmpty((String)bankAcctNumber)) {
            QFilter qFilter = new QFilter("bankaccountnumber", "=", (Object)bankAcctNumber);
            DynamicObject bankAcc = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"bank", (QFilter[])new QFilter[]{qFilter});
            if (Objects.nonNull(bankAcc)) {
                bankCateId = bankAcc.getDynamicObject("bank").getDynamicObject("bank_cate").getLong("id");
            }
        }
        logger.info("\u6839\u636e\u94f6\u884c\u8d26\u53f7\u83b7\u53d6\u94f6\u884c\u7c7b\u522b\u7684bankCateId:" + bankCateId);
        return bankCateId;
    }

    public static String isNewECDs(String bankAcctNumber) {
        if (StringUtils.isNotEmpty((String)bankAcctNumber)) {
            QFilter qFilter = new QFilter("defaultaccount.bankaccountnumber", "=", (Object)bankAcctNumber);
            DynamicObject eleDirConSet = BusinessDataServiceHelper.loadSingle((String)"cdm_electicdirconset", (String)"isnewgenerbill", (QFilter[])new QFilter[]{qFilter});
            return eleDirConSet == null ? "1" : (eleDirConSet.getBoolean("isnewgenerbill") ? "0" : "1");
        }
        return "1";
    }

    public static String isNewECDs(Long accountId) {
        if (accountId > 0L) {
            QFilter qFilter = new QFilter("defaultaccount.id", "=", (Object)accountId);
            DynamicObject eleDirConSet = BusinessDataServiceHelper.loadSingle((String)"cdm_electicdirconset", (String)"isnewgenerbill", (QFilter[])new QFilter[]{qFilter});
            return eleDirConSet == null ? "1" : (eleDirConSet.getBoolean("isnewgenerbill") ? "0" : "1");
        }
        return "1";
    }
}

