/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.cdm.common.enums.AsstActTypeEnum;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.cdm.common.helper.SCAccountInfo;
import kd.tmc.cdm.common.helper.SystemParameterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class BaseDataHelper {
    public static final String CS126 = "cs126";

    public static DynamicObject getInternalOrg(DynamicObject basedata) {
        if (basedata == null) {
            return null;
        }
        String entity = basedata.getDataEntityType().getName();
        return (basedata = BusinessDataServiceHelper.loadSingleFromCache((Object)basedata.getPkValue(), (String)entity, (String)"internal_company")) == null ? null : basedata.getDynamicObject("internal_company");
    }

    public static boolean isInternalOrg(DynamicObject org) {
        Set<String> cs126;
        return org != null && (cs126 = SystemParameterHelper.getParameterComboxs(org.getLong("id"), CS126)).contains("2");
    }

    public static SCAccountInfo loadBankInfo(String sctype, Long entryPk) {
        DynamicObject row;
        SCAccountInfo scAccountInfo = new SCAccountInfo();
        DynamicObject customerOrSupplier = BusinessDataServiceHelper.loadSingle((String)sctype, (String)"bankaccount,accountname,bank,currency,isdefault_bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", (Object)entryPk)});
        if (customerOrSupplier == null) {
            return scAccountInfo;
        }
        DynamicObjectCollection entryBanks = customerOrSupplier.getDynamicObjectCollection("entry_bank");
        Iterator var5 = entryBanks.iterator();
        do {
            if (var5.hasNext()) continue;
            return scAccountInfo;
        } while (!(row = (DynamicObject)var5.next()).getPkValue().equals(entryPk));
        scAccountInfo.setAccount(row.getString("bankaccount"));
        scAccountInfo.setAccountName(row.getString("accountname"));
        scAccountInfo.setCurrency(row.getDynamicObject("currency"));
        scAccountInfo.setDefault(row.getBoolean("isdefault_bank"));
        scAccountInfo.setBeBank(row.getDynamicObject("bank"));
        return scAccountInfo;
    }

    public static DynamicObject getBillType(String formid, String billTypeNumer) {
        QFilter numberFilter = new QFilter("number", "=", (Object)billTypeNumer);
        numberFilter.and("billformid", "=", (Object)formid);
        DynamicObject billType = TmcDataServiceHelper.loadSingle((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{numberFilter});
        return billType;
    }

    public static Boolean isExistInternalBusinessUnit(DynamicObject baseData) {
        String entityName = baseData.getDataEntityType().getName();
        if (AsstActTypeEnum.EMPLOYEE.getValue().equals(entityName) || AsstActTypeEnum.COMPANY.getValue().equals(entityName) || AsstActTypeEnum.OTHER.getValue().equals(entityName)) {
            return Boolean.FALSE;
        }
        if (CasHelper.isNotEmpty(baseData.get("internal_company"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void checkCustomerOrSupplyAuth(String businessType, String baseDataType, Long baseDataId, Long isNeedCheckOrgId) {
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)baseDataType, (Long)isNeedCheckOrgId);
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)baseDataType, (String)"id", (QFilter[])new QFilter[]{qFilter});
        Set resultIds = queryResult.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        if (!resultIds.contains(baseDataId)) {
            String warnMessage = BaseDataHelper.dealWarnMessage(businessType);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5ba2\u5546\u57fa\u7840\u8d44\u6599\u65e0\u6cd5\u5339\u914d\u5230\u53ef\u7528\u7684\u3010%s\u3011\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BaseDataHelper", (String)"tmc-cdm-common", (Object[])new Object[0]), warnMessage));
        }
    }

    private static String dealWarnMessage(String businessType) {
        switch (businessType) {
            case "PayableBill": {
                return ResManager.loadKDString((String)"\u6536\u7968\u4eba", (String)"BaseDataHelper_1", (String)"tmc-cdm-common", (Object[])new Object[0]);
            }
            case "ReceivableBill": {
                return ResManager.loadKDString((String)"\u4ea4\u7968\u4eba", (String)"BaseDataHelper_2", (String)"tmc-cdm-common", (Object[])new Object[0]);
            }
            case "Endorse": {
                return ResManager.loadKDString((String)"\u88ab\u80cc\u4e66\u4eba", (String)"BaseDataHelper_3", (String)"tmc-cdm-common", (Object[])new Object[0]);
            }
            case "Pledge": {
                return ResManager.loadKDString((String)"\u8d28\u6743\u4eba", (String)"BaseDataHelper_4", (String)"tmc-cdm-common", (Object[])new Object[0]);
            }
            case "PayableApply": {
                return ResManager.loadKDString((String)"\u6536\u6b3e\u4eba", (String)"BaseDataHelper_5", (String)"tmc-cdm-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static boolean isNeedCheckProperty(String entityName, String baseDataName) {
        return !(!baseDataName.equals("deliver") && !baseDataName.equals("receiver") || !entityName.equals("bd_supplier") && !entityName.equals("bd_customer"));
    }
}

