/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.compare.CompareException;

public class BatchQueryHelper {
    private static ExecutorService service = ThreadPools.newCachedExecutorService((String)BatchQueryHelper.class.getName(), (int)3, (int)3);

    public static List<DynamicObject> batchQuery(List<Object> tdIdList, String entityName, String pkName, String selectFields, QFilter filter) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        int perSize = 900;
        int totalSize = tdIdList.size();
        int count = totalSize / perSize;
        if (totalSize % perSize > 0) {
            ++count;
        }
        int startIndex = 0;
        ArrayList<Future<List>> futureList = new ArrayList<Future<List>>(count);
        for (int i = 0; i < count; ++i) {
            int n = startIndex + perSize > totalSize ? totalSize : startIndex + perSize;
            List<Object> currList = tdIdList.subList(startIndex, n);
            RequestContext context = RequestContext.get();
            Future<List> future = service.submit(() -> {
                RequestContext.copyAndSet((RequestContext)context);
                QFilter pkFilter = new QFilter(pkName, "in", (Object)currList);
                return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{pkFilter, filter});
            });
            futureList.add(future);
            startIndex = n;
        }
        try {
            for (Future future : futureList) {
                List results = (List)future.get();
                if (results == null) continue;
                resultList.addAll(results);
            }
            return resultList;
        }
        catch (Exception e) {
            throw new CompareException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static List<DynamicObject> batchLoad(List<Object> tdIdList, String entityName, String pkName, String selectFields, QFilter filter) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        int perSize = 900;
        int totalSize = tdIdList.size();
        int count = totalSize / perSize;
        if (totalSize % perSize > 0) {
            ++count;
        }
        int startIndex = 0;
        ArrayList<Future<DynamicObject[]>> futureList = new ArrayList<Future<DynamicObject[]>>(count);
        for (int i = 0; i < count; ++i) {
            int n = startIndex + perSize > totalSize ? totalSize : startIndex + perSize;
            List<Object> currList = tdIdList.subList(startIndex, n);
            RequestContext context = RequestContext.get();
            Future<DynamicObject[]> future = service.submit(() -> {
                RequestContext.copyAndSet((RequestContext)context);
                QFilter pkFilter = new QFilter(pkName, "in", (Object)currList);
                return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{pkFilter, filter});
            });
            futureList.add(future);
            startIndex = n;
        }
        try {
            for (Future future : futureList) {
                DynamicObject[] results = (DynamicObject[])future.get();
                if (results == null) continue;
                resultList.addAll(Arrays.asList(results));
            }
            return resultList;
        }
        catch (Exception e) {
            throw new CompareException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }
}

