/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BeiHelper {
    public static boolean isEmpty(Object o) {
        if (o instanceof String) {
            return o == null || o.toString().trim().length() == 0;
        }
        if (o instanceof Long) {
            return o == null || (Long)o == 0L;
        }
        if (o instanceof BigDecimal) {
            return o == null || ((BigDecimal)o).compareTo(BigDecimal.ZERO) == 0;
        }
        return o == null;
    }

    public static boolean isNotEmpty(Object o) {
        return !BeiHelper.isEmpty(o);
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(BeiHelper.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String toPattern(int scale) {
        StringBuilder s = new StringBuilder(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append('0');
        }
        return s.toString();
    }

    public static String idListToInClause(List<Long> idList) {
        StringBuilder sb = new StringBuilder();
        if (idList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        if (idList.size() == 1) {
            sb.append(idList.get(0));
        } else {
            Iterator<Long> it = idList.iterator();
            int n = idList.size();
            for (int i = 0; i < n - 1; ++i) {
                sb.append(it.next()).append(", ");
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static String idsToInClause(List<String> idList) {
        StringBuilder sb = new StringBuilder();
        if (idList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        if (idList.size() == 1) {
            sb.append('\'');
            sb.append(idList.get(0));
            sb.append('\'');
        } else {
            Iterator<String> it = idList.iterator();
            int n = idList.size();
            for (int i = 0; i < n - 1; ++i) {
                sb.append('\'');
                sb.append(it.next());
                sb.append('\'');
                sb.append(", \n");
            }
            sb.append('\'');
            sb.append(it.next());
            sb.append('\'');
        }
        return sb.toString();
    }

    public static List<String> getIdList(DynamicObject[] infos) {
        ArrayList<String> idList = new ArrayList<String>(infos.length);
        for (DynamicObject info : infos) {
            idList.add(info.getPkValue().toString());
        }
        return idList;
    }

    public static DynamicObject loadSingleFromCache(Object pk, String entityName) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
    }

    public static String getStackTraceMessage(Exception e) {
        StringWriter sw = new StringWriter();
        try {
            PrintWriter writer = new PrintWriter(sw);
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sw.toString();
    }

    public static boolean isEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            if (obj2 == null && obj1 instanceof String) {
                return StringUtils.isBlank((Object)obj1);
            }
            if (obj1 == null && obj2 instanceof String) {
                return StringUtils.isBlank((Object)obj2);
            }
            return false;
        }
        if (obj1.getClass().equals(obj2.getClass())) {
            if (obj1 instanceof BigDecimal) {
                return ((BigDecimal)obj1).compareTo((BigDecimal)obj2) == 0;
            }
            if (obj1 instanceof DynamicObject) {
                return ((DynamicObject)obj1).getPkValue().equals(((DynamicObject)obj2).getPkValue());
            }
            return obj1.equals(obj2);
        }
        return false;
    }

    public static String removeFieldPrefix(String field) {
        int index = field.indexOf(46);
        index = index > 0 ? ++index : 0;
        return field.substring(index);
    }

    public static <T> T[] mergeArrays(T[] t1, T[] t2) {
        T[] copyOf = Arrays.copyOf(t1, t1.length + t2.length);
        for (int i = 0; i < t2.length; ++i) {
            copyOf[i + t1.length] = t2[i];
        }
        return copyOf;
    }

    public static <T> T[] mergeArrays(T[] t1, T t2) {
        T[] copyOf = Arrays.copyOf(t1, t1.length + 1);
        copyOf[t1.length] = t2;
        return copyOf;
    }

    public static Long getCurrentUser() {
        return Long.valueOf(RequestContext.get().getUserId());
    }

    public static int getSelectedRowSize(ListSelectedRowCollection selectedRows) {
        HashSet pkIds = new HashSet();
        selectedRows.forEach(row -> pkIds.add((Long)row.getPrimaryKeyValue()));
        return pkIds.size();
    }

    public static boolean isEmpty(DynamicObject[] objs) {
        return objs == null || objs.length == 0;
    }

    public static OperateErrorInfo getOperateErrorInfo(Object pk, String meg, String title) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setTitle(title);
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(pk);
        operateErrorInfo.setMessage(meg);
        return operateErrorInfo;
    }

    public static void showOperationResultMulti(OperationResult operationResult, String operateName, IFormView view) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        HashMap pkNumbers = new HashMap();
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty() && !operationResult.getBillNos().isEmpty()) {
            pkNumbers.putAll(operationResult.getBillNos());
        }
        parameters.setCustomParam("pkNumbers", pkNumbers);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        int errorCount = operationResult.getAllErrorInfo().size();
        String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c%2$s\u6210\u529f%3$s\u5f20\uff0c\u5931\u8d25%4$s\u5f20", (String)"BeiHelper_0", (String)"tmc-cdm-common", (Object[])new Object[0]), operationResult.getBillCount(), StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, operationResult.getBillCount() - errorCount, errorCount);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        view.showForm(parameters);
    }

    public static boolean isNum(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

