/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.property.ChequeProp;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ChequeHelper {
    private static final Log log = LogFactory.getLog(ChequeHelper.class);
    public static final String CHEQUESTATUS_EMPTY = "0";
    public static final String CHEQUESTATUS_USED = "1";
    public static final String CHEQUESTATUS_FILL = "2";
    public static final String CHEQUESTATUS_INVALID = "3";
    public static final Map<String, String> chequeStatusMap = new HashMap<String, String>();

    public static String createBatchNo() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static Object getMinChequeNoBy(String billTypeId, long accoutId, long currencyId) {
        if (accoutId < 1L) {
            return null;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("billtype", "=", (Object)Long.valueOf(billTypeId)));
        filters.add(new QFilter("accountbank", "=", (Object)accoutId));
        filters.add(new QFilter("chequestatus", "=", (Object)CHEQUESTATUS_EMPTY));
        filters.add(new QFilter("currency", "=", (Object)currencyId));
        String orderBys = "purchdate asc,createtime asc,billno asc";
        DynamicObjectCollection cheques = QueryServiceHelper.query((String)"cdm_cheque_purch", (String)"id,billno", (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys, (int)1);
        if (cheques != null && !cheques.isEmpty()) {
            return ((DynamicObject)cheques.get(0)).getLong("id");
        }
        return null;
    }

    public static synchronized Map<Long, String> updateCheques4Fill(List<Long> ids, Long billId, String billType, String number, BigDecimal amount) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        ChequeHelper.checkCheque(ids, billId);
        HashMap<Long, String> result = new HashMap<Long, String>();
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] cheques = BusinessDataServiceHelper.load((String)"cdm_cheque_purch", (String)ChequeProp.getSelectField(), (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        for (DynamicObject cheque : cheques) {
            if (!cheque.getString("relatebillid").equals(String.valueOf(billId)) && !CHEQUESTATUS_EMPTY.equals(cheque.getString("chequestatus"))) {
                result.put(cheque.getLong("id"), chequeStatusMap.get(cheque.get("chequestatus")));
                continue;
            }
            cheque.set("chequestatus", (Object)CHEQUESTATUS_FILL);
            cheque.set("filldate", (Object)new Date());
            cheque.set("filluser", (Object)RequestContext.get().getUserId());
            cheque.set("relatebillid", (Object)billId);
            cheque.set("relatebillnumber", (Object)number);
            cheque.set("relatebilltype", (Object)billType);
            cheque.set("relateamount", (Object)amount);
            updateList.add(cheque);
        }
        if (updateList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        return result;
    }

    public static void checkCheque(List<Long> ids, Long billId) {
        QFilter oldFilter = new QFilter("relatebillid", "=", (Object)billId);
        DynamicObject[] oldCheques = BusinessDataServiceHelper.load((String)"cdm_cheque_purch", (String)ChequeProp.getSelectField(), (QFilter[])new QFilter[]{oldFilter});
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        for (int i = 0; i < oldCheques.length; ++i) {
            DynamicObject oldChe = oldCheques[i];
            if (ids.contains(oldChe.getLong("id"))) continue;
            oldChe.set("chequestatus", (Object)CHEQUESTATUS_EMPTY);
            oldChe.set("filldate", null);
            oldChe.set("filluser", null);
            oldChe.set("relatebillid", null);
            oldChe.set("relatebillnumber", null);
            oldChe.set("relatebilltype", null);
            oldChe.set("relateamount", (Object)0);
            updateList.add(oldChe);
        }
        if (updateList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
    }

    public static synchronized Map<Long, String> updateCheques4Invalid(List<Long> ids, Long relatebillId) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        HashMap<Long, String> result = new HashMap<Long, String>();
        QFilter filter = new QFilter("id", "in", ids);
        QFilter billIdfilter = new QFilter("relatebillid", "=", (Object)relatebillId);
        DynamicObject[] cheques = BusinessDataServiceHelper.load((String)"cdm_cheque_purch", (String)ChequeProp.getSelectField(), (QFilter[])new QFilter[]{filter, billIdfilter});
        if (cheques == null) {
            result.put(relatebillId, ResManager.loadKDString((String)"\u627e\u4e0d\u5230billId\u4e3a%s\u7684\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChequeHelper_1", (String)"tmc-cdm-common", (Object[])new Object[]{relatebillId}));
            return result;
        }
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        for (DynamicObject cheque : cheques) {
            if (!CHEQUESTATUS_FILL.equals(cheque.getString("chequestatus"))) {
                result.put(cheque.getLong("id"), chequeStatusMap.get("chequestatus"));
                continue;
            }
            cheque.set("chequestatus", (Object)CHEQUESTATUS_INVALID);
            cheque.set("invaliddate", (Object)new Date());
            cheque.set("invaliduser", (Object)RequestContext.get().getUserId());
            updateList.add(cheque);
        }
        if (updateList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        return result;
    }

    public static boolean checkChequeStatus(Object id, String status) {
        QFilter filter = new QFilter("id", "=", id);
        filter.and(new QFilter("chequestatus", "=", (Object)status));
        return TmcDataServiceHelper.exists((String)"cdm_cheque_purch", (QFilter[])new QFilter[]{filter});
    }

    public static void updateByDel(Object id) {
        if (EmptyUtil.isEmpty((Object)id)) {
            return;
        }
        DynamicObject cheque = TmcDataServiceHelper.loadSingle((Object)id, (String)"cdm_cheque_purch");
        cheque.set("chequestatus", (Object)CHEQUESTATUS_EMPTY);
        cheque.set("filldate", null);
        cheque.set("filluser", null);
        cheque.set("relatebillid", null);
        cheque.set("relatebillnumber", null);
        cheque.set("relatebilltype", null);
        cheque.set("relateamount", (Object)0);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cheque});
    }

    static {
        chequeStatusMap.put(CHEQUESTATUS_EMPTY, ResManager.loadKDString((String)"\u7a7a\u767d", (String)"ChequeStatusEnum_0", (String)"tmc-cdm-common", (Object[])new Object[0]));
        chequeStatusMap.put(CHEQUESTATUS_USED, ResManager.loadKDString((String)"\u5df2\u9886\u7528", (String)"ChequeHelper_0", (String)"tmc-cdm-common", (Object[])new Object[0]));
        chequeStatusMap.put(CHEQUESTATUS_FILL, ResManager.loadKDString((String)"\u5df2\u586b\u5f00", (String)"ChequeStatusEnum_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
        chequeStatusMap.put(CHEQUESTATUS_INVALID, ResManager.loadKDString((String)"\u5df2\u4f5c\u5e9f", (String)"ChequeStatusEnum_2", (String)"tmc-cdm-common", (Object[])new Object[0]));
    }
}

