/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.cdm.common.helper.JournalEntryInfo;
import kd.tmc.cdm.common.helper.JournalInfo;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class DraftTradeBookJournalBuilder {
    public static List<JournalInfo> doJournalInfoList(List<DynamicObject> bills) {
        ArrayList<JournalInfo> DraftSuccInfos = new ArrayList<JournalInfo>(10);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entrys");
            if (entrys == null || entrys.size() == 0) continue;
            DynamicObject entry = (DynamicObject)entrys.get(0);
            JournalInfo journal = new JournalInfo();
            journal.setSourceBillType(bill.getDataEntityType().getName());
            journal.setOrg(bill.getDynamicObject("company"));
            journal.setOrgId((Long)bill.getDynamicObject("company").getPkValue());
            journal.setCurrency(bill.getDynamicObject("currency"));
            journal.setCurrencyId((Long)bill.getDynamicObject("currency").getPkValue());
            journal.setBizDate(bill.getDate("bizdate"));
            DynamicObject draftBill = TmcDataServiceHelper.loadSingle((Object)entry.getDynamicObject("draftbill").getPkValue(), (String)"cdm_payablebill");
            journal.setSettlementNumber(draftBill.getString("draftbillno"));
            DynamicObject acct = draftBill.getDynamicObject("draweraccount");
            if (acct != null) {
                journal.setAccountBank(acct);
                journal.setAccountBankId(acct.getLong("id"));
            }
            journal.setOppAcctNumber(draftBill.getString("receiveraccount"));
            journal.setOppUnit(draftBill.getString("receivername"));
            DynamicObject recBank = draftBill.getDynamicObject("receiverbank");
            if (recBank != null) {
                journal.setOppBank(recBank.getString("name"));
            }
            journal.setCreditAmount(bill.getBigDecimal("amount"));
            journal.setDebitAmount(BigDecimal.ZERO);
            journal.setDirection(2);
            journal.setDescription(bill.getString("description"));
            BigDecimal exchange = bill.getBigDecimal("exchangerate");
            if (exchange.compareTo(BigDecimal.ZERO) == 0) {
                exchange = BigDecimal.ONE;
            }
            journal.setExchangeRate(exchange);
            BigDecimal locamt = bill.getBigDecimal("locamt");
            if (locamt.compareTo(BigDecimal.ZERO) == 0) {
                locamt = journal.getCreditAmount().multiply(exchange);
            }
            journal.setLocalAmount(locamt);
            journal.setSourceBillNumber(bill.getString("billno"));
            journal.setBillno(bill.getString("billno"));
            journal.setSourceBillId((Long)bill.getPkValue());
            String userId = RequestContext.get().getUserId();
            DynamicObject user = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_user"), (Object)userId);
            journal.setCashier(user);
            journal.setCashierId((Long)user.getPkValue());
            journal.setPreparationdate(bill.getDate("createtime"));
            ArrayList<JournalEntryInfo> journalEntryInfos = new ArrayList<JournalEntryInfo>(10);
            journal.setSource(2);
            DynamicObject settleType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"JSFS04")});
            if (settleType != null) {
                journal.setSettlementTypeId(settleType.getLong("id"));
            }
            JournalEntryInfo journalEntry = new JournalEntryInfo();
            journalEntry.setOppUnit(draftBill.getString("receivername"));
            journalEntry.setAmount(bill.getBigDecimal("amount"));
            journalEntry.setLocalAmount(journal.getLocalAmount());
            journalEntryInfos.add(journalEntry);
            journal.setEntry(journalEntryInfos);
            DraftSuccInfos.add(journal);
        }
        return DraftSuccInfos;
    }
}

