/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.GuaranteeTradeTypeEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class GuaranteeHelper {
    public static String validatedGuaranteeTrade(Set<Object> idSet, String rpType, String guaranteeType) {
        boolean isOneDraftType;
        boolean isOneCurrency;
        boolean isOneCompany;
        boolean isGuarantee = StringUtils.equals((CharSequence)guaranteeType, (CharSequence)GuaranteeTradeTypeEnum.GUARANTEE.getValue());
        QFilter qFilter = new QFilter("id", "in", idSet);
        DynamicObject[] selectBill = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,availableamount,billno,guarantflag,draftbillstatus,draftbilltranstatus,currency,draftbilltype,company", (QFilter[])new QFilter[]{qFilter});
        boolean guaranteeFlag = isGuarantee ? Arrays.stream(selectBill).anyMatch(bill -> bill.getBoolean("guarantflag")) : Arrays.stream(selectBill).anyMatch(bill -> !bill.getBoolean("guarantflag"));
        boolean isSuccessTrans = Arrays.stream(selectBill).anyMatch(bill -> !StringUtils.equals((CharSequence)bill.getString("draftbilltranstatus"), (CharSequence)"success"));
        boolean draftBillStatusValidated = StringUtils.equals((CharSequence)rpType, (CharSequence)ReceivePayTypeEnum.RECEIVEBILL.getValue()) ? Arrays.stream(selectBill).anyMatch(bill -> !StringUtils.equals((CharSequence)bill.getString("draftbillstatus"), (CharSequence)DraftBillStatusEnum.ENDORSED.getValue())) : Arrays.stream(selectBill).anyMatch(bill -> !StringUtils.equals((CharSequence)bill.getString("draftbillstatus"), (CharSequence)DraftBillStatusEnum.REGISTERED.getValue()));
        if (guaranteeFlag || isSuccessTrans || draftBillStatusValidated) {
            return isGuarantee ? ResManager.loadKDString((String)"\u672a\u505a\u4fdd\u8d34\u767b\u8bb0\u7684\u4ea4\u6613\u6210\u529f\u4e14\u5df2\u767b\u8bb0\u72b6\u6001\u5e94\u4ed8\u7968\u636e\u53ca\u5df2\u80cc\u4e66\u72b6\u6001\u7684\u5e94\u6536\u7968\u636e\u624d\u80fd\u64cd\u4f5c\u4fdd\u8d34\u767b\u8bb0\u3002", (String)"GuaranteeHelper_0", (String)"tmc-cdm-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u505a\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u7684\u4ea4\u6613\u6210\u529f\u4e14\u5df2\u767b\u8bb0\u72b6\u6001\u5e94\u4ed8\u7968\u636e\u53ca\u5df2\u80cc\u4e66\u72b6\u6001\u7684\u5e94\u6536\u7968\u636e\u624d\u80fd\u64cd\u4f5c\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u3002", (String)"GuaranteeHelper_1", (String)"tmc-cdm-common", (Object[])new Object[0]);
        }
        boolean bl = isOneCompany = Arrays.stream(selectBill).map(bill -> bill.getDynamicObject("company").getPkValue()).distinct().count() == 1L;
        if (!isOneCompany) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u4e00\u81f4\u7684\u7968\u636e\u3002", (String)"GuaranteeHelper_5", (String)"tmc-cdm-common", (Object[])new Object[0]);
        }
        boolean bl2 = isOneCurrency = Arrays.stream(selectBill).map(bill -> bill.getDynamicObject("currency").getPkValue()).distinct().count() == 1L;
        if (!isOneCurrency) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd\u4e00\u81f4\u7684\u7968\u636e\u3002", (String)"GuaranteeHelper_2", (String)"tmc-cdm-common", (Object[])new Object[0]);
        }
        boolean bl3 = isOneDraftType = Arrays.stream(selectBill).map(bill -> bill.getDynamicObject("draftbilltype").getPkValue()).distinct().count() == 1L;
        if (!isOneDraftType) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7968\u636e\u7c7b\u578b\u4e00\u81f4\u7684\u7968\u636e\u3002", (String)"GuaranteeHelper_3", (String)"tmc-cdm-common", (Object[])new Object[0]);
        }
        List noAmountSet = Arrays.stream(selectBill).filter(bill -> BigDecimal.ZERO.compareTo(bill.getBigDecimal("availableamount")) >= 0).map(e -> e.getString("billno")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(noAmountSet)) {
            StringJoiner stringJoiner = new StringJoiner("\r\n");
            for (String noAmountBill : noAmountSet) {
                stringJoiner.add(String.format(ResManager.loadKDString((String)"\u7968\u636e %s \u53ef\u7528\u91d1\u989d\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"GuaranteeHelper_3_1", (String)"tmc-cdm-common", (Object[])new Object[0]), noAmountBill));
            }
            return stringJoiner.toString();
        }
        return null;
    }

    public static String validatedIsReleaseGuaranteeBill(Set<Object> billIdSet, String guaranteeType) {
        boolean isGuarantee = StringUtils.equals((CharSequence)guaranteeType, (CharSequence)GuaranteeTradeTypeEnum.GUARANTEE.getValue());
        QFilter qFilter = new QFilter("billentries.draftbill.id", "in", billIdSet);
        qFilter.and(new QFilter("billstatus", "!=", (Object)"C"));
        qFilter.and(new QFilter("guaranteetype", "=", (Object)guaranteeType));
        boolean exist = TmcDataServiceHelper.exists((String)"cdm_guarantee_discount", (QFilter[])new QFilter[]{qFilter});
        if (exist) {
            return isGuarantee ? ResManager.loadKDString((String)"\u672a\u505a\u4fdd\u8d34\u767b\u8bb0\u7684\u4ea4\u6613\u6210\u529f\u4e14\u5df2\u767b\u8bb0\u72b6\u6001\u5e94\u4ed8\u7968\u636e\u53ca\u5df2\u80cc\u4e66\u72b6\u6001\u7684\u5e94\u6536\u7968\u636e\u624d\u80fd\u64cd\u4f5c\u4fdd\u8d34\u767b\u8bb0\u3002", (String)"GuaranteeHelper_0", (String)"tmc-cdm-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u505a\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u7684\u4ea4\u6613\u6210\u529f\u4e14\u5df2\u767b\u8bb0\u72b6\u6001\u5e94\u4ed8\u7968\u636e\u53ca\u5df2\u80cc\u4e66\u72b6\u6001\u7684\u5e94\u6536\u7968\u636e\u624d\u80fd\u64cd\u4f5c\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u3002", (String)"GuaranteeHelper_1", (String)"tmc-cdm-common", (Object[])new Object[0]);
        }
        return null;
    }
}

