/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DispatchRuleEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RecEleDraftHelper {
    private static final Log LOGGER = LogFactory.getLog(RecEleDraftHelper.class);

    public static boolean isSubmitEleNew(DynamicObject transferBill, List<Long> draftbills) {
        Object incompany = transferBill.getDynamicObject("incompany").getPkValue();
        String dispatchrule = transferBill.getString("dispatchrule");
        Long sourceId = transferBill.getLong("sourcebillid");
        List draftBillList = Arrays.stream(TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,company,billpool,bankaccount", (QFilter[])new QFilter("id", "in", draftbills).and("company.id", "!=", incompany).and("draftbilltype.billmedium", "=", (Object)BillMediumEnum.ELECTRIC.getValue()).toArray())).filter(o -> o.getDynamicObject("company") != null).collect(Collectors.toList());
        if (draftBillList == null || draftBillList.size() < 1) {
            return false;
        }
        Map<Object, Object> billpoolMap = new HashMap(0);
        Object[] billpoolIds = draftBillList.stream().filter(item -> item.getDynamicObject("billpool") != null).map(item -> item.getDynamicObject("billpool").getPkValue()).distinct().toArray();
        if (billpoolIds != null && billpoolIds.length > 0) {
            DynamicObject[] billpools = TmcDataServiceHelper.load((Object[])billpoolIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_billpool"));
            billpoolMap = Arrays.asList(billpools).stream().collect(Collectors.toMap(item -> item.getPkValue(), item -> item));
        }
        Object company = null;
        DynamicObject billpool = null;
        Iterator iterator = draftBillList.iterator();
        if (iterator.hasNext()) {
            DynamicObject draftbill = (DynamicObject)iterator.next();
            company = draftbill.getDynamicObject("company").getPkValue();
            if (RecEleDraftHelper.isElectronicbill(company)) {
                if (RecEleDraftHelper.isElectronicbill(incompany)) {
                    if (EmptyUtil.isEmpty((Long)sourceId)) {
                        if (Objects.equals(dispatchrule, DispatchRuleEnum.DIRECT.getValue())) {
                            return true;
                        }
                        billpool = (DynamicObject)billpoolMap.get(draftbill.getDynamicObject("billpool").getPkValue());
                        if (RecEleDraftHelper.isElectronicbill(billpool.getDynamicObject("company").getPkValue())) {
                            return true;
                        }
                        LOGGER.info("create pool org not start submit ele");
                        return false;
                    }
                    if (Objects.equals(dispatchrule, DispatchRuleEnum.INDIRECT.getValue())) {
                        billpool = (DynamicObject)billpoolMap.get(draftbill.getDynamicObject("billpool").getPkValue());
                        if (RecEleDraftHelper.isElectronicbill(billpool.getDynamicObject("company").getPkValue())) {
                            return true;
                        }
                        LOGGER.info("create pool org not start submit ele");
                        return false;
                    }
                    return true;
                }
                LOGGER.info("in pool org not start submit ele");
                return false;
            }
            LOGGER.info("out pool org not start submit ele");
            return false;
        }
        return true;
    }

    public static boolean isElectronicbill(Object companyId) {
        try {
            if (companyId == null) {
                return false;
            }
            Object value = TmcParameterHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"cdm").getId(), (Long)Long.parseLong(companyId.toString()), (String)"iselectronicbill");
            return value == null ? false : Boolean.parseBoolean(value.toString());
        }
        catch (NumberFormatException e) {
            LOGGER.error("isElectronicbill Exception:", (Throwable)e);
            return false;
        }
    }

    public static boolean judgeOfEleOrPaperBill(DynamicObject transferBill, DynamicObject draftBill) {
        DynamicObject casPayBillDy;
        Long sourceBillId = transferBill.getLong("sourcebillid");
        if (EmptyUtil.isNoEmpty((Long)sourceBillId) && EmptyUtil.isNoEmpty((DynamicObject)(casPayBillDy = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"cas_paybill")))) {
            DynamicObject bankAccountDy = draftBill.getDynamicObject("bankaccount");
            DynamicObject bankAccount = TmcDataServiceHelper.loadSingle((Object)bankAccountDy.getPkValue(), (String)"bd_accountbanks");
            DynamicObject bank_cateDy = bankAccount.getDynamicObject("bank").getDynamicObject("bank_cate");
            return RecEleDraftHelper.setInAccount(casPayBillDy, transferBill, bank_cateDy);
        }
        return true;
    }

    public static boolean setInAccount(DynamicObject paymentBill, DynamicObject transferBill, DynamicObject bank_cateDy) {
        String dispatchrule = transferBill.getString("dispatchrule");
        boolean isDirect = Objects.equals(dispatchrule, DispatchRuleEnum.DIRECT.getValue());
        LOGGER.info("setInAccount isDirect is:" + isDirect);
        DynamicObject payeracctbank = paymentBill.getDynamicObject("payeracctbank");
        if (EmptyUtil.isNoEmpty((DynamicObject)payeracctbank)) {
            QFilter companyIdFilter = new QFilter("company", "=", paymentBill.getDynamicObject("org").getPkValue());
            QFilter defaultaccountIdFilter = new QFilter("defaultaccount", "=", payeracctbank.getPkValue());
            Object[] eleDirectSetList = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id", (QFilter[])new QFilter[]{defaultaccountIdFilter});
            if (EmptyUtil.isNoEmpty((Object[])eleDirectSetList)) {
                if (!isDirect) {
                    return RecEleDraftHelper.checkCreatePoolOrg(transferBill, bank_cateDy);
                }
                return true;
            }
            QFilter bankIdIdFilter = new QFilter("directconnchannel", "=", bank_cateDy.getPkValue());
            QFilter inCompanyIdFilter = new QFilter("company", "=", transferBill.getDynamicObject("incompany").getPkValue());
            Object[] eleDirectSetListByBank = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount", (QFilter[])new QFilter[]{inCompanyIdFilter, bankIdIdFilter});
            if (EmptyUtil.isNoEmpty((Object[])eleDirectSetListByBank)) {
                if (!isDirect) {
                    return RecEleDraftHelper.checkCreatePoolOrg(transferBill, bank_cateDy);
                }
                return true;
            }
            Object[] eleDirectSetListByCompany = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount,istransbank", (QFilter[])new QFilter[]{inCompanyIdFilter});
            if (EmptyUtil.isNoEmpty((Object[])eleDirectSetListByCompany)) {
                if (!isDirect) {
                    return RecEleDraftHelper.checkCreatePoolOrg(transferBill, bank_cateDy);
                }
                return true;
            }
            LOGGER.info("eleDirectSetListByCompany is null");
            return true;
        }
        return true;
    }

    public static boolean checkCreatePoolOrg(DynamicObject transferBill, DynamicObject bank_cateDy) {
        DynamicObject createPoolOrg = transferBill.getDynamicObject("company");
        QFilter billBankIdIdFilter = new QFilter("directconnchannel", "=", bank_cateDy.getPkValue());
        QFilter createOrgIdFilter = new QFilter("company", "=", createPoolOrg.getPkValue());
        Object[] eleDirectSetListByBank = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount", (QFilter[])new QFilter[]{createOrgIdFilter, billBankIdIdFilter});
        if (EmptyUtil.isEmpty((Object[])eleDirectSetListByBank)) {
            Object[] eleDirectSetListByCreateOrg = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount", (QFilter[])new QFilter[]{createOrgIdFilter});
            return EmptyUtil.isNoEmpty((Object[])eleDirectSetListByCreateOrg);
        }
        return true;
    }
}

