/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.constant.CdmBizConstant;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.cdm.common.helper.CodeRuleHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class RlatedPreBillHelper {
    private static final Log logger = LogFactory.getLog(RlatedPreBillHelper.class);

    public static Boolean comfirmBill(DynamicObject[] payBills, DynamicObject[] preBills, IFormView view) {
        logger.info("===========\u786e\u8ba4\u5173\u8054\u5f00\u59cb===============");
        Set<Long> payableBillIds = RlatedPreBillHelper.getBillIdsFomBill(payBills);
        Set<Long> electronicBillIds = RlatedPreBillHelper.getBillIdsFomBill(preBills);
        DynamicObjectCollection payableBills = RlatedPreBillHelper.getDynamicObjectColls("cdm_payablebill", payableBillIds);
        DynamicObjectCollection electronicPayBills = RlatedPreBillHelper.getDynamicObjectColls("cdm_electronic_pay_deal", electronicBillIds);
        String validateMsg = RlatedPreBillHelper.validateBillStatus(payableBills);
        if (EmptyUtil.isNoEmpty((String)validateMsg)) {
            view.showTipNotification(validateMsg);
            return false;
        }
        String prebillvalidateMsg = RlatedPreBillHelper.validatePreBill(electronicPayBills);
        if (EmptyUtil.isNoEmpty((String)prebillvalidateMsg)) {
            view.showTipNotification(prebillvalidateMsg);
            return false;
        }
        String payablebillvalidateMsg = RlatedPreBillHelper.validateBill(payableBills);
        if (EmptyUtil.isNoEmpty((String)payablebillvalidateMsg)) {
            view.showTipNotification(payablebillvalidateMsg);
            return false;
        }
        logger.info("===========\u786e\u8ba4\u5173\u8054\u5f00\u59cb\u5339\u914d===============");
        return RlatedPreBillHelper.comfirmRleated(payableBills, electronicPayBills, view);
    }

    public static Boolean reletedCreate(DynamicObject[] preBills, DynamicObject dratbilltype, IFormView view) {
        logger.info("===========\u5173\u8054\u751f\u6210\u5e94\u4ed8\u7968\u636e\u5f00\u59cb===============");
        Set<Long> electronicBillIds = RlatedPreBillHelper.getBillIdsFomBill(preBills);
        DynamicObjectCollection electronicPayBills = RlatedPreBillHelper.getDynamicObjectColls("cdm_electronic_pay_deal", electronicBillIds);
        List<DynamicObject> results = RlatedPreBillHelper.buildPayableBillsByPre(electronicPayBills, dratbilltype, view);
        if (results != null && results.size() < 1) {
            return false;
        }
        if (results.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>(8);
            ArrayList<Long> invoicesignedIds = new ArrayList<Long>();
            SaveServiceHelper.save((DynamicObject[])results.toArray(new DynamicObject[0]));
            SaveServiceHelper.update((DynamicObject[])((DynamicObject[])electronicPayBills.toArray((Object[])new DynamicObject[0])));
            for (DynamicObject result : results) {
                ids.add(result.getLong("id"));
                String eledraftstatus = result.getString("eledraftstatus");
                String eledraftstatusnew = result.getString("eledraftstatusnew");
                boolean isAudiDrawbill = false;
                String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                DynamicObject drawerCompany = result.getDynamicObject("drawercompany");
                boolean isElectronicBill = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)drawerCompany.getLong("id"), (String)"iselectronicbill");
                String draftBillType = result.getDynamicObject("draftbilltype").getString("billmedium");
                String draftBillTranStatus = result.getString("draftbilltranstatus");
                if (StringUtils.isNotEmpty((CharSequence)draftBillTranStatus) && !DraftTranStatusEnum.FAILING.getValue().equals(draftBillTranStatus) || !isElectronicBill || isElectronicBill && "1".equals(draftBillType)) {
                    isAudiDrawbill = true;
                }
                if (!EleDraftNoteStatusEnum.CS03.getValue().equals(eledraftstatusnew) && !EleDraftBillStatusEnum.INVOICESIGNED.getValue().equals(eledraftstatus) || isAudiDrawbill) continue;
                invoicesignedIds.add(result.getLong("id"));
            }
            OperateOption option = OperateOption.create();
            TmcOperateServiceHelper.execOperate((String)"submit", (String)"cdm_payablebill", (Object[])ids.toArray(new Object[0]), (OperateOption)option);
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"cdm_payablebill", (Object[])ids.toArray(new Object[0]), (OperateOption)option);
            if (invoicesignedIds.size() > 0) {
                TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_payablebill", (Object[])invoicesignedIds.toArray(new Object[0]), (OperateOption)option);
            }
            logger.info("\u5173\u8054\u751f\u6210\u7ed3\u675f\uff0c\u5171\u751f\u6210" + ids.size() + "\u5f20\u5e94\u4ed8\u7968\u636e\uff0c\u5176\u4e2d" + invoicesignedIds.size() + "\u8c03\u7528\u786e\u8ba4\u6536\u7968");
        }
        return true;
    }

    private static List<DynamicObject> buildPayableBillsByPre(DynamicObjectCollection electronicPayBills, DynamicObject dratbilltype, IFormView view) {
        Set<String> issueticketertexts = RlatedPreBillHelper.getElecValueByProp(electronicPayBills, "issueticketertext");
        Map<String, DynamicObject> drawerorgObjects = RlatedPreBillHelper.findOrgByNames(issueticketertexts);
        Set<String> issueticketacctexts = RlatedPreBillHelper.getElecValueByProp(electronicPayBills, "issueticketacctext");
        Map<String, DynamicObject> draweraccounts = RlatedPreBillHelper.findBankByNumbers(issueticketacctexts);
        Set<String> collectionbanktexts = RlatedPreBillHelper.getElecValueByProp(electronicPayBills, "collectionbanktext");
        Map<String, DynamicObject> recBanks = RlatedPreBillHelper.findBeBankByNames(collectionbanktexts);
        Set<String> promisertexts = RlatedPreBillHelper.getElecValueByProp(electronicPayBills, "promisertext");
        Map<String, DynamicObject> promiseBanks = RlatedPreBillHelper.findFinOrgInfos(promisertexts);
        Set<String> issueticketgrades = RlatedPreBillHelper.getElecValueByProp(electronicPayBills, "issueticketgrade");
        Map<String, DynamicObject> issueGrades = RlatedPreBillHelper.findBeBankByNames(issueticketgrades);
        Set<String> promisegrades = RlatedPreBillHelper.getElecValueByProp(electronicPayBills, "promisegrade");
        Map<String, DynamicObject> promiseGrades = RlatedPreBillHelper.findBeBankByNames(promisegrades);
        ArrayList<DynamicObject> resultbills = new ArrayList<DynamicObject>();
        MainEntityType recBillEntityType = EntityMetadataCache.getDataEntityType((String)"cdm_payablebill");
        long[] pkIds = DB.genLongIds((String)recBillEntityType.getAlias(), (int)electronicPayBills.size());
        int i = 0;
        for (DynamicObject eleRecDraftBill : electronicPayBills) {
            logger.info("RlatedPreBillHelper.buildPayableBillsByPre \u5f00\u59cb", eleRecDraftBill.getPkValue());
            DynamicObject result = new DynamicObject((DynamicObjectType)recBillEntityType, (Object)pkIds[i]);
            ++i;
            result.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            result.set("sourcebillid", eleRecDraftBill.get("id"));
            result.set("rptype", (Object)ReceivePayTypeEnum.PAYBILL.getValue());
            result.set("draftbillstatus", (Object)DraftBillStatusEnum.REGISTERED.getValue());
            result.set("bizdate", (Object)new Date());
            result.set("draftbilltype", (Object)dratbilltype);
            String deliverName = eleRecDraftBill.getString("preholdername");
            String ticketStatus = eleRecDraftBill.getString("ticketstatus");
            if (EleDraftBillStatusEnum.INVOICE.getValue().equals(ticketStatus) || EleDraftBillStatusEnum.INVOICESIGNED.getValue().equals(ticketStatus)) {
                deliverName = eleRecDraftBill.getString("issueticketertext");
            }
            result.set("issuedate", eleRecDraftBill.get("issueticketdate"));
            result.set("acceptdate", eleRecDraftBill.get("promisedate"));
            result.set("draftbillexpiredate", eleRecDraftBill.get("exchangebillexpiredate"));
            result.set("istransfer", (Object)(eleRecDraftBill.getBoolean("istransfer") ? "1" : "0"));
            result.set("company", (Object)eleRecDraftBill.getDynamicObject("company"));
            if (null == eleRecDraftBill.get("company")) {
                logger.info("RlatedPreBillHelper.buildReceivableBill bill company is null eleRecId = {}", eleRecDraftBill.getPkValue());
            }
            result.set("source", (Object)SourceEnum.HANDREGISTER.getValue());
            result.set("createtime", (Object)new Date());
            result.set("contractno", (Object)eleRecDraftBill.getString("tradecontractno"));
            result.set("issplit", eleRecDraftBill.get("grdbag"));
            String subRange = eleRecDraftBill.getString("subrange");
            result.set("subbillrange", (Object)subRange);
            if (EmptyUtil.isNoEmpty((String)subRange) && subRange.contains("-")) {
                long subBillStartFlag = Long.parseLong(subRange.split("-")[0]);
                long subBillEndFlag = Long.parseLong(subRange.split("-")[1]);
                result.set("subbillstartflag", (Object)subBillStartFlag);
                result.set("subbillendflag", (Object)subBillEndFlag);
                result.set("subbillquantity", (Object)(subBillEndFlag - subBillStartFlag + 1L));
            }
            DynamicObject drawerorgObject = drawerorgObjects.get(eleRecDraftBill.getString("issueticketertext"));
            result.set("drawercompany", (Object)drawerorgObject);
            result.set("drawername", (Object)(StringUtils.isEmpty((CharSequence)eleRecDraftBill.getString("issueticketertext")) ? " " : eleRecDraftBill.getString("issueticketertext")));
            DynamicObject draweraccount = draweraccounts.get(eleRecDraftBill.getString("issueticketacctext"));
            result.set("draweraccount", (Object)draweraccount);
            String issueticketbanktext = eleRecDraftBill.getString("issueticketbanktext");
            String issueticketbankno = eleRecDraftBill.getString("issueticketbankno");
            if (EmptyUtil.isEmpty((String)issueticketbanktext) && EmptyUtil.isNoEmpty((DynamicObject)draweraccount)) {
                if (draweraccount.getDynamicObject("bank") != null) {
                    result.set("drawerbankname", (Object)draweraccount.getDynamicObject("bank").getString("name"));
                }
            } else {
                result.set("drawerbankname", (Object)issueticketbanktext);
            }
            if (EmptyUtil.isEmpty((String)issueticketbankno) && EmptyUtil.isNoEmpty((DynamicObject)draweraccount)) {
                if (draweraccount.getDynamicObject("bank") != null) {
                    DynamicObject finOrgInfoDO = TmcDataServiceHelper.loadSingle((Object)draweraccount.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo");
                    if (finOrgInfoDO.getDynamicObject("bebank") == null) {
                        result.set("drawerbankno", (Object)finOrgInfoDO.getString("union_number"));
                    } else {
                        DynamicObject beBank = TmcDataServiceHelper.loadSingle((Object)finOrgInfoDO.getDynamicObject("bebank").getPkValue(), (String)"bd_bebank");
                        result.set("drawerbankno", (Object)beBank.getString("number"));
                    }
                }
            } else {
                result.set("drawerbankno", (Object)issueticketbankno);
            }
            Pair<String, Object> receiverBD = RlatedPreBillHelper.findComparableBD(eleRecDraftBill.getString("collectionertext"));
            result.set("receivertype", receiverBD.getLeft());
            result.set("payeetype", receiverBD.getLeft());
            result.set("receiver", receiverBD.getRight());
            result.set("receivername", eleRecDraftBill.get("collectionertext"));
            result.set("receiveraccount", eleRecDraftBill.get("collectionacctext"));
            String collectionbanktext = eleRecDraftBill.getString("collectionbanktext");
            if (EmptyUtil.isEmpty((String)collectionbanktext) && eleRecDraftBill.get("collectionacctext") != null) {
                RlatedPreBillHelper.fillUserData(result);
            } else {
                DynamicObject recBank = recBanks.get(collectionbanktext);
                if (recBank != null) {
                    result.set("receiverbank", (Object)recBank);
                }
                result.set("receiverbankno", recBank == null ? eleRecDraftBill.get("collectionbankno") : recBank.getString("union_number"));
            }
            result.set("acceptername", eleRecDraftBill.get("promisertext"));
            DynamicObject promiseBank = promiseBanks.get(eleRecDraftBill.getString("promisertext"));
            result.set("accepterfinorg", (Object)(promiseBank == null ? Integer.valueOf(0) : promiseBank));
            result.set("acceptername", promiseBank == null ? null : promiseBank.get("name"));
            String promiseracctext = eleRecDraftBill.getString("promiseracctext");
            if (EmptyUtil.isEmpty((String)promiseracctext)) {
                result.set("accepteraccount", (Object)"0");
            } else {
                result.set("accepteraccount", eleRecDraftBill.get("promiseracctext"));
            }
            String promiserbankno = eleRecDraftBill.getString("promiserbankno");
            if (EmptyUtil.isEmpty((String)promiserbankno) && null != promiseBank) {
                result.set("accepterbankno", promiseBank.get("union_number"));
            } else {
                result.set("accepterbankno", (Object)promiserbankno);
            }
            String promiserbanktext = eleRecDraftBill.getString("promiserbanktext");
            if (EmptyUtil.isEmpty((String)promiserbanktext) && null != promiseBank) {
                result.set("accepterbankname", promiseBank.get("name"));
            } else {
                result.set("accepterbankname", (Object)promiserbanktext);
            }
            DynamicObject currencyObj = eleRecDraftBill.getDynamicObject("currency");
            if (currencyObj != null) {
                result.set("currency", (Object)currencyObj);
            }
            result.set("amount", eleRecDraftBill.get("amount"));
            result.set("availableamount", eleRecDraftBill.get("amount"));
            result.set("supperbillamount", eleRecDraftBill.get("amount"));
            result.set("standardbillamount", (Object)0.01);
            result.set("paybilltype", (Object)"other");
            result.set("description", eleRecDraftBill.get("explain"));
            DynamicObject issueGrade = issueGrades.get(eleRecDraftBill.getString("issueticketgrade"));
            if (issueGrade != null) {
                result.set("issueticketgrade", (Object)issueGrade);
            }
            result.set("issueticketcreditlevel", eleRecDraftBill.get("issueticketcreditlevel"));
            result.set("issueticketexpiredate", eleRecDraftBill.get("issueticketexpiredate"));
            DynamicObject promiseGrade = promiseGrades.get(eleRecDraftBill.getString("promisegrade"));
            if (promiseGrade != null) {
                result.set("promisegrade", (Object)promiseGrade);
            }
            result.set("promisecreditlevel", eleRecDraftBill.get("promisecreditlevel"));
            result.set("promiseexpiredate", eleRecDraftBill.get("promiseexpiredate"));
            RlatedPreBillHelper.setBillType(result);
            DynamicObject company = result.getDynamicObject("company");
            DynamicObject draftbilltype = result.getDynamicObject("draftbilltype");
            String settlementtype = draftbilltype.getString("settlementtype");
            boolean needApply = DraftHelper.isNeedContorlApply(company.getLong("id"), settlementtype);
            if (needApply) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u5f00\u7968\u7533\u8bf7\u3002", (String)"RecSupContractPlugin_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
                return resultbills;
            }
            result.set("modifytime", (Object)new Date());
            result.set("eledraftstatus", eleRecDraftBill.get("ticketstatus"));
            result.set("draftbillno", eleRecDraftBill.get("billno"));
            result.set("relatedelcbillid", (Object)eleRecDraftBill.getLong("id"));
            result.set("isrelatedprebill", (Object)true);
            result.set("electag", (Object)true);
            String eledraftstatus = eleRecDraftBill.getString("ticketstatus");
            String eledraftstatusnew = eleRecDraftBill.getString("notestatus");
            if (!EleDraftBillStatusEnum.INVOICESIGNED.getValue().equals(eledraftstatus) && !EleDraftNoteStatusEnum.CS03.getValue().equals(eledraftstatusnew)) {
                result.set("draftbilltranstatus", (Object)DraftTranStatusEnum.HANDLEING.getValue());
            }
            String generateNumber = CodeRuleHelper.generateNumber("cdm_payablebill", result, null, null);
            result.set("billno", (Object)generateNumber);
            result.set("eledraftstatusnew", eleRecDraftBill.get("notestatus"));
            result.set("elccirculatestatus", (Object)eleRecDraftBill.getString("cirstatus"));
            resultbills.add(result);
            eleRecDraftBill.set("sourcenumber", (Object)result.getString("billno"));
            eleRecDraftBill.set("sourceid", (Object)result.getString("id"));
            eleRecDraftBill.set("rptype", (Object)"paybill");
        }
        logger.info("\u5173\u8054\u751f\u6210" + resultbills.size() + "\u5f20\u5e94\u4ed8\u7968\u636e");
        return resultbills;
    }

    private static Set<String> getElecValueByProp(DynamicObjectCollection elecbills, String propname) {
        HashSet<String> values = new HashSet<String>();
        if (EmptyUtil.isEmpty((DynamicObjectCollection)elecbills) || elecbills.size() < 1) {
            return values;
        }
        for (DynamicObject elecbill : elecbills) {
            values.add(elecbill.getString(propname));
        }
        return values;
    }

    private static void fillUserData(DynamicObject paybill) {
        String receiveraccount = paybill.getString("receiveraccount");
        DynamicObject receiver = paybill.getDynamicObject("receiver");
        String entityName = receiver.getDataEntityType().getName();
        DynamicObject innerOrg = null;
        boolean isInternalOrg = false;
        if ("bd_supplier".equals(entityName) || "bd_customer".equals(entityName)) {
            innerOrg = BaseDataHelper.getInternalOrg(receiver);
            isInternalOrg = BaseDataHelper.isInternalOrg(paybill.getDynamicObject("company"));
        }
        if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg == null) {
            RlatedPreBillHelper.dealSupplierOrCustomer(paybill, receiveraccount, receiver);
        } else if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg != null && isInternalOrg) {
            RlatedPreBillHelper.dealSupplierOrCustomer(paybill, receiveraccount, receiver);
        } else if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bos_user")) {
            RlatedPreBillHelper.dealUserdata(paybill, receiveraccount);
        } else {
            RlatedPreBillHelper.fillOther(paybill, receiveraccount);
        }
    }

    private static void dealSupplierOrCustomer(DynamicObject paybill, String receiveraccount, DynamicObject receiver) {
        DynamicObjectCollection entryBank;
        DynamicObject bank = TmcDataServiceHelper.loadSingle((String)receiver.getDataEntityType().getName(), (String)"bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.bankaccount", "=", (Object)receiveraccount)});
        if (!EmptyUtil.isEmpty((DynamicObject)bank) && !EmptyUtil.isEmpty((DynamicObjectCollection)(entryBank = bank.getDynamicObjectCollection("entry_bank")))) {
            for (DynamicObject entry : entryBank) {
                if (!entry.getString("bankaccount").equals(receiveraccount)) continue;
                RlatedPreBillHelper.fillSupplierOrCustomer(paybill, entry);
                break;
            }
        }
    }

    private static void fillSupplierOrCustomer(DynamicObject paybill, DynamicObject entry) {
        paybill.set("receiverbank", (Object)entry.getDynamicObject("bank"));
        if (EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("bank"))) {
            DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)entry.getDynamicObject("bank").getPkValue(), (String)entry.getDynamicObject("bank").getDataEntityType().getName());
            paybill.set("receiverbankno", (Object)bdBebankDO.getString("union_number"));
        }
    }

    private static void dealUserdata(DynamicObject paybill, String receiveraccount) {
        QFilter filter = new QFilter("payeraccount", "=", (Object)receiveraccount);
        Object[] payeerDO = TmcDataServiceHelper.load((String)"er_payeer", (String)"id,payerbank", (QFilter[])new QFilter[]{filter});
        if (EmptyUtil.isNoEmpty((Object[])payeerDO)) {
            DynamicObject payerbankDO = payeerDO[0].getDynamicObject("payerbank");
            paybill.set("receiverbank", (Object)payerbankDO);
            DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)payerbankDO.getPkValue(), (String)payerbankDO.getDataEntityType().getName());
            paybill.set("receiverbankno", (Object)bdBebankDO.getString("union_number"));
        }
    }

    private static void fillOther(DynamicObject paybill, String receiveraccount) {
        DynamicObject bankDO;
        QFilter filter = new QFilter("bankaccountnumber", "=", (Object)receiveraccount);
        Object[] accountbanksDO = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"bank,bebank", (QFilter[])new QFilter[]{filter});
        if (!EmptyUtil.isEmpty((Object[])accountbanksDO) && !EmptyUtil.isEmpty((DynamicObject)(bankDO = accountbanksDO[0].getDynamicObject("bank")))) {
            paybill.set("receiverbankno", (Object)bankDO.getString("union_number"));
            DynamicObject bebankDO = bankDO.getDynamicObject("bebank");
            if (!EmptyUtil.isEmpty((DynamicObject)bebankDO)) {
                paybill.set("receiverbank", bebankDO.getPkValue());
            } else {
                paybill.set("receiverbank", null);
            }
        }
    }

    private static Pair<String, Object> findComparableBD(String value) {
        QFilter nameQFilter = new QFilter("name", "=", (Object)value);
        DynamicObject[] orgArr = TmcDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{nameQFilter});
        if (orgArr.length > 0) {
            DynamicObject bosOrg = TmcDataServiceHelper.loadSingle((Object)orgArr[0].getPkValue(), (String)"bos_org");
            return Pair.of((Object)"bos_org", (Object)bosOrg);
        }
        DynamicObject[] supplierArr = TmcDataServiceHelper.load((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{nameQFilter});
        if (supplierArr.length > 0) {
            DynamicObject bdSupplier = TmcDataServiceHelper.loadSingle((Object)supplierArr[0].getPkValue(), (String)"bd_supplier");
            return Pair.of((Object)"bd_supplier", (Object)bdSupplier);
        }
        DynamicObject[] customerArr = TmcDataServiceHelper.load((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{nameQFilter});
        if (customerArr.length > 0) {
            DynamicObject bdCustomer = TmcDataServiceHelper.loadSingle((Object)customerArr[0].getPkValue(), (String)"bd_customer");
            return Pair.of((Object)"bd_customer", (Object)bdCustomer);
        }
        DynamicObject[] userArr = TmcDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{nameQFilter});
        if (userArr.length > 0) {
            DynamicObject bosUser = TmcDataServiceHelper.loadSingle((Object)userArr[0].getPkValue(), (String)"bos_user");
            return Pair.of((Object)"bos_user", (Object)bosUser);
        }
        return Pair.of((Object)"other", (Object)value);
    }

    private static Map<String, DynamicObject> findBeBankByNames(Set<String> bankNames) {
        HashMap<String, DynamicObject> banks = new HashMap<String, DynamicObject>();
        QFilter nameQFilter = new QFilter("name", "in", (Object)bankNames.toArray());
        Object[] loads = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,union_number", (QFilter[])new QFilter[]{nameQFilter});
        if (EmptyUtil.isNoEmpty((Object[])loads) && loads.length > 0) {
            for (Object load : loads) {
                banks.put(load.getString("name"), (DynamicObject)load);
            }
        }
        return banks;
    }

    private static Map<String, DynamicObject> findOrgByNames(Set<String> issueticketertexts) {
        HashMap<String, DynamicObject> orgs = new HashMap<String, DynamicObject>();
        QFilter nameQFilter = new QFilter("name", "in", (Object)issueticketertexts.toArray());
        Object[] loads = TmcDataServiceHelper.load((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{nameQFilter});
        if (EmptyUtil.isNoEmpty((Object[])loads) && loads.length > 0) {
            for (Object load : loads) {
                orgs.put(load.getString("name"), (DynamicObject)load);
            }
        }
        return orgs;
    }

    private static Map<String, DynamicObject> findFinOrgInfos(Set<String> promisertexts) {
        HashMap<String, DynamicObject> orgInfos = new HashMap<String, DynamicObject>();
        QFilter nameQFilter = new QFilter("name", "in", promisertexts);
        Object[] loads = TmcDataServiceHelper.load((String)"bd_finorginfo", (String)"id,number,name,union_number", (QFilter[])new QFilter[]{nameQFilter});
        if (EmptyUtil.isNoEmpty((Object[])loads) && loads.length > 0) {
            for (Object load : loads) {
                orgInfos.put(load.getString("name"), (DynamicObject)load);
            }
        }
        return orgInfos;
    }

    private static Map<String, DynamicObject> findBankByNumbers(Set<String> issueticketacctexts) {
        HashMap<String, DynamicObject> bamks = new HashMap<String, DynamicObject>();
        QFilter numberQFilter = new QFilter("number", "in", issueticketacctexts);
        Object[] loads = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"id,number,name,bank.id,bank.name", (QFilter[])new QFilter[]{numberQFilter});
        if (EmptyUtil.isNoEmpty((Object[])loads) && loads.length > 0) {
            for (Object load : loads) {
                bamks.put(load.getString("number"), (DynamicObject)load);
            }
        }
        return bamks;
    }

    private static void setBillType(DynamicObject payablebill) {
        DynamicObject draftbilltype = payablebill.getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltype)) {
            String settlementtype = draftbilltype.getString("settlementtype");
            String billMedium = draftbilltype.getString("billmedium");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                if ("1".equals(billMedium)) {
                    payablebill.set("billtype", (Object)CdmBizConstant.PAYABLEBILL_BANK);
                } else {
                    payablebill.set("billtype", (Object)CdmBizConstant.PAYABLEBILL_BANK_ELECT);
                }
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                if ("1".equals(billMedium)) {
                    payablebill.set("billtype", (Object)CdmBizConstant.PAYABLEBILL_BUSINESS);
                } else {
                    payablebill.set("billtype", (Object)CdmBizConstant.PAYABLEBILL_BUSINESS_ELECT);
                }
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                payablebill.set("billtype", (Object)CdmBizConstant.PAYABLEBILL_CHECK);
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                payablebill.set("billtype", (Object)CdmBizConstant.PAYABLEBILL_PROMISSORY);
            }
        }
    }

    private static boolean comfirmRleated(DynamicObjectCollection payableBills, DynamicObjectCollection electronicPayBills, IFormView view) {
        ArrayList<Object> payableresult = new ArrayList<Object>();
        ArrayList<DynamicObject> electronicresult = new ArrayList<DynamicObject>();
        ArrayList<Long> invoicesignedebill = new ArrayList<Long>();
        block9: for (Object paybill : payableBills) {
            String receivername = paybill.getString("receivername");
            BigDecimal amount = paybill.getBigDecimal("amount");
            for (DynamicObject electronicPayBill : electronicPayBills) {
                String collectionertext = electronicPayBill.getString("collectionertext");
                BigDecimal preamount = electronicPayBill.getBigDecimal("amount");
                if (!receivername.equals(collectionertext) || amount.compareTo(preamount) != 0) continue;
                paybill.set("relatedelcbillid", (Object)electronicPayBill.getLong("id"));
                paybill.set("draftbillno", (Object)electronicPayBill.getString("billno"));
                paybill.set("eledraftstatusnew", (Object)electronicPayBill.getString("notestatus"));
                paybill.set("eledraftstatus", (Object)electronicPayBill.getString("ticketstatus"));
                paybill.set("elccirculatestatus", (Object)electronicPayBill.getString("cirstatus"));
                paybill.set("electag", (Object)true);
                paybill.set("isrelatedprebill", (Object)true);
                paybill.set("contractno", (Object)electronicPayBill.getString("tradecontractno"));
                paybill.set("issplit", electronicPayBill.get("grdbag"));
                String subRange = electronicPayBill.getString("subrange");
                paybill.set("subbillrange", (Object)subRange);
                if (EmptyUtil.isNoEmpty((String)subRange) && subRange.contains("-")) {
                    long subBillStartFlag = Long.parseLong(subRange.split("-")[0]);
                    long subBillEndFlag = Long.parseLong(subRange.split("-")[1]);
                    paybill.set("subbillstartflag", (Object)subBillStartFlag);
                    paybill.set("subbillendflag", (Object)subBillEndFlag);
                    paybill.set("subbillquantity", (Object)(subBillEndFlag - subBillStartFlag + 1L));
                }
                DraftHelper.setBillCodeinfo((DynamicObject)paybill);
                String eledraftstatus = paybill.getString("eledraftstatus");
                String eledraftstatusnew = paybill.getString("eledraftstatusnew");
                String draftbilltranstatus = paybill.getString("draftbilltranstatus");
                if (!EleDraftBillStatusEnum.INVOICESIGNED.getValue().equals(eledraftstatus) && !EleDraftNoteStatusEnum.CS03.getValue().equals(eledraftstatusnew) && !DraftTranStatusEnum.SUCCESS.getValue().equals(draftbilltranstatus) || (EleDraftBillStatusEnum.INVOICESIGNED.getValue().equals(eledraftstatus) || EleDraftNoteStatusEnum.CS03.getValue().equals(eledraftstatusnew)) && EmptyUtil.isNoEmpty((String)draftbilltranstatus) && !DraftTranStatusEnum.SUCCESS.getValue().equals(draftbilltranstatus) && DraftTranStatusEnum.FAILING.getValue().equals(draftbilltranstatus)) {
                    paybill.set("draftbilltranstatus", (Object)DraftTranStatusEnum.HANDLEING.getValue());
                }
                electronicPayBill.set("rptype", (Object)"paybill");
                electronicPayBill.set("sourcenumber", (Object)paybill.getString("billno"));
                electronicPayBill.set("sourceid", (Object)paybill.getString("id"));
                boolean isAudiDrawbill = false;
                String draftBillTranStatus = paybill.getString("draftbilltranstatus");
                if (StringUtils.isNotEmpty((CharSequence)draftBillTranStatus) && !DraftTranStatusEnum.FAILING.getValue().equals(draftBillTranStatus)) {
                    isAudiDrawbill = true;
                }
                if ((EleDraftNoteStatusEnum.CS03.getValue().equals(eledraftstatusnew) || EleDraftBillStatusEnum.INVOICESIGNED.getValue().equals(eledraftstatus)) && !isAudiDrawbill) {
                    invoicesignedebill.add(paybill.getLong("id"));
                }
                payableresult.add(paybill);
                electronicresult.add(electronicPayBill);
                electronicPayBills.remove((Object)electronicPayBill);
                continue block9;
            }
        }
        if (payableresult.size() != payableBills.size()) {
            StringBuilder builder = new StringBuilder();
            for (DynamicObject paybill : payableBills) {
                boolean isrelatedprebill = paybill.getBoolean("isrelatedprebill");
                if (isrelatedprebill) continue;
                builder.append(paybill.getString("billno"));
                builder.append(";");
            }
            if (builder != null && builder.length() > 0) {
                String billno = builder.substring(0, builder.length() - 1);
                String errMesg = String.format(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u201c%s\u201d\u672a\u5339\u914d\u4e0a\u5bf9\u5e94\u7684\u9884\u5f00\u7968\u7968\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RlatedPreBillHelper_5", (String)"tmc-cdm-common", (Object[])new Object[0]), billno);
                view.showTipNotification(errMesg);
                return false;
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            if (payableresult.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])payableresult.toArray(new DynamicObject[0]));
            }
            if (electronicresult.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])electronicresult.toArray(new DynamicObject[0]));
            }
            if (invoicesignedebill.size() > 0) {
                OperateOption option = OperateOption.create();
                TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_payablebill", (Object[])invoicesignedebill.toArray(new Object[0]), (OperateOption)option);
            }
        }
        logger.info("\u786e\u8ba4\u5173\u8054\uff0c\u66f4\u65b0\u5e94\u4ed8\u7968\u636e\uff1a" + payableresult.size() + "\u5f20;\u66f4\u65b0\u7535\u7968" + electronicresult.size() + "\u5f20;\u5305\u542b" + invoicesignedebill.size() + "\u5f20\u7535\u7968\u72b6\u6001=\u5df2\u6536\u7968\uff0c\u8c03\u7528\u786e\u8ba4\u6536\u7968");
        return true;
    }

    private static String validateBill(DynamicObjectCollection payableBills) {
        boolean isAllPre = true;
        String errorMesge = "";
        for (DynamicObject payableBill : payableBills) {
            Boolean isrelatedprebill = payableBill.getBoolean("isrelatedprebill");
            if (isrelatedprebill.booleanValue()) continue;
            isAllPre = false;
            break;
        }
        if (isAllPre) {
            errorMesge = ResManager.loadKDString((String)"\u6240\u6709\u5e94\u4ed8\u7968\u636e\u90fd\u5df2\u7ecf\u5173\u8054\u9884\u51fa\u7968\u7968\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c!", (String)"RlatedPreBillHelper_0", (String)"tmc-cdm-common", (Object[])new Object[0]);
        }
        return errorMesge;
    }

    private static String validatePreBill(DynamicObjectCollection electronicPayBills) {
        boolean isallRlated = true;
        String errorMeg = "";
        for (DynamicObject electronicPayBill : electronicPayBills) {
            Long sourceid = electronicPayBill.getLong("sourceid");
            if (sourceid != 0L) continue;
            isallRlated = false;
            break;
        }
        if (isallRlated) {
            errorMeg = ResManager.loadKDString((String)"\u5df2\u5173\u8054\u5e94\u4ed8\u7968\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u5173\u8054\u3002", (String)"RlatedPreBillHelper_1", (String)"tmc-cdm-common", (Object[])new Object[0]);
        }
        return errorMeg;
    }

    private static String validateBillStatus(DynamicObjectCollection payableBills) {
        String errorMesge = "";
        for (DynamicObject payableBill : payableBills) {
            String status = payableBill.getString("billstatus");
            if ("C".equals(status)) continue;
            errorMesge = ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u7684\u5e94\u4ed8\u7968\u636e\u786e\u8ba4\u5173\u8054\u3002", (String)"RlatedPreBillHelper_2", (String)"tmc-cdm-common", (Object[])new Object[0]);
            break;
        }
        return errorMesge;
    }

    private static DynamicObjectCollection getDynamicObjectColls(String entityName, Set<Long> billIds) {
        DynamicObject[] bills;
        DynamicObjectCollection result = new DynamicObjectCollection();
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))) {
            result.add((Object)bill);
        }
        return result;
    }

    private static Set<Long> getBillIdsFomBill(DynamicObject[] bills) {
        HashSet<Long> billIds = new HashSet<Long>();
        if (bills != null && bills.length > 0) {
            for (DynamicObject bill : bills) {
                Long stateBillId = bill.getLong("id");
                billIds.add(stateBillId);
            }
        }
        return billIds;
    }
}

