/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.StringUtils;

public class TradeBillChangeHelper {
    private static final String SQL_UDPATE_DRAFTBILL_ENTRY_ISCHANGE = "update t_cdm_drafttrdbill_entry set fisinchange = ? where fisinchange = ? and fentryid in ";

    public static int changBillUpdateIsChangeFlag(Set<Long> entryIds, Object[] params) {
        return DB.update((DBRoute)DBRouteConst.TMC, (String)(SQL_UDPATE_DRAFTBILL_ENTRY_ISCHANGE + StringUtils.setToString(entryIds)), (Object[])params);
    }

    public static boolean notSubmitEleBill(DynamicObject entry) {
        return entry.getBoolean("entryisrejectrefund") || entry.getBoolean("entryisrepay") || TradeBillChangeHelper.notSubmitEleBill(entry.getString("transtatus"));
    }

    public static boolean notSubmitEleBill(String tranStatus) {
        return DraftTranStatusEnum.SUCCESS.getValue().equals(tranStatus) || DraftTranStatusEnum.HANDLEING.getValue().equals(tranStatus);
    }

    public static boolean haveBillIsChange(DynamicObject data, DynamicObject tradeBillDB) {
        DynamicObjectCollection entriesDB = tradeBillDB.getDynamicObjectCollection("entrys");
        Map<Long, DynamicObject> isChangeBillIdToBillMapDB = entriesDB.stream().filter(entry -> entry.getBoolean("changeflag")).collect(Collectors.toMap(e -> e.getDynamicObject("draftbill").getLong("id"), x -> x));
        if (EmptyUtil.isEmpty(isChangeBillIdToBillMapDB) || isChangeBillIdToBillMapDB.size() == 0) {
            return false;
        }
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
        Map<Long, DynamicObject> isChangeBillIdToBillMap = entries.stream().filter(entry -> entry.getBoolean("changeflag")).collect(Collectors.toMap(e -> e.getDynamicObject("draftbill").getLong("id"), x -> x));
        if (EmptyUtil.isEmpty(isChangeBillIdToBillMap) || isChangeBillIdToBillMap.size() == 0) {
            return true;
        }
        for (Long billId : isChangeBillIdToBillMap.keySet()) {
            if (isChangeBillIdToBillMapDB.containsKey(billId)) continue;
            return true;
        }
        return isChangeBillIdToBillMapDB.size() != isChangeBillIdToBillMap.size();
    }
}

