/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.common.helper;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillWorkcalendarHelper {
    public static Integer getDiscountDayScountentryOff(IDataModel model, Object returnData) {
        HashSet<Date> dateSet = new HashSet<Date>(4);
        DynamicObject draftBizBill = model.getDataEntity(true);
        DynamicObject company = draftBizBill.getDynamicObject("company");
        if (returnData != null) {
            ListSelectedRowCollection data = (ListSelectedRowCollection)returnData;
            Object[] pkValue = data.getPrimaryKeyValues();
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)pkValue)};
            DynamicObjectCollection entrysExist = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,draftbillexpiredate", (QFilter[])qFilters);
            dateSet.addAll(entrysExist.stream().filter(s -> s.get("draftbillexpiredate") != null).map(e -> (Date)e.get("draftbillexpiredate")).collect(Collectors.toSet()));
        }
        DynamicObjectCollection entrys = model.getEntryEntity("entrys");
        for (DynamicObject entry : entrys) {
            DynamicObject entryDraft = entry.getDynamicObject("draftbill");
            Date expireDate = entryDraft.getDate("draftbillexpiredate");
            dateSet.add(expireDate);
        }
        Date maxDate = dateSet.stream().max(Date::compareTo).orElse(null);
        return TradeBillWorkcalendarHelper.getDiffDayForWorkcalendar(maxDate, company);
    }

    public static Integer buildDraftBillDyForDisDays(DynamicObject draftBillDy) {
        Date billexpiredate = draftBillDy.getDate("draftbillexpiredate");
        DynamicObject company = draftBillDy.getDynamicObject("company");
        return TradeBillWorkcalendarHelper.getDiffDayForWorkcalendar(billexpiredate, company);
    }

    public static Integer getDiffDayForWorkcalendar(Date billexpiredate, DynamicObject company) {
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        DynamicObject workcalendar = (DynamicObject)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)((Long)company.getPkValue()), (String)"workcalendar");
        if (EmptyUtil.isNoEmpty((DynamicObject)workcalendar) && billexpiredate != null) {
            DynamicObjectCollection workcalendarCollection = new DynamicObjectCollection();
            workcalendarCollection.add((Object)workcalendar);
            Date expireDate = TradeBillWorkcalendarHelper.callBasicSettleDelayDate(workcalendarCollection, billexpiredate, 1);
            long diffDays = (expireDate.getTime() - billexpiredate.getTime()) / 86400000L;
            if (diffDays > 0L) {
                return (int)diffDays;
            }
        }
        return 0;
    }

    public static Date callBasicSettleDelayDate(DynamicObjectCollection workCalendars, Date date, int settleDelay) {
        Date settleDate = date;
        int internal = 1;
        if (settleDelay < 0) {
            internal = -1;
            settleDelay = -settleDelay;
        }
        Set<Long> wcIds = workCalendars.stream().distinct().map(o -> o.getLong("id")).collect(Collectors.toSet());
        for (int index = 0; index < settleDelay; ++index) {
            while (!WorkCalendarHelper.isWorkDay((Long[])wcIds.toArray(new Long[0]), (Date)settleDate)) {
                settleDate = DateUtils.getNextDay((Date)DateUtils.truncateDate((Date)settleDate), (int)internal);
            }
        }
        return settleDate;
    }
}

