/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.webapi.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.webapi.bizdto.BillBackInfoDto;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class BillBackInfoPlugin
implements IBillWebApiPlugin {
    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        try {
            DynamicObject[] receiveIds = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("draftbillno", "=", params.get("draftBillNo"))});
            if (receiveIds == null || receiveIds.length <= 0) {
                result.setErrorCode("2001");
                result.setMessage(ResManager.loadKDString((String)"\u8be5\u7968\u636e\u80cc\u4e66\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"BillBackInfoPlugin_0", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
                return result;
            }
            Object[] pkValueArray = Arrays.stream(receiveIds).map(o -> o.getLong("id")).toArray();
            DynamicObject[] receiveDys = TmcDataServiceHelper.load((Object[])pkValueArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
            ArrayList<BillBackInfoDto> resultList = new ArrayList<BillBackInfoDto>(10);
            for (DynamicObject receiveDy : receiveDys) {
                DynamicObjectCollection entryBackInfos = receiveDy.getDynamicObjectCollection("endorseentry");
                if (entryBackInfos.isEmpty()) continue;
                for (DynamicObject entryBackInfo : entryBackInfos) {
                    BillBackInfoDto BillBackInfo = new BillBackInfoDto();
                    BillBackInfo.setBillNo(receiveDy.getString("billno"));
                    BillBackInfo.setDraftBillNo(receiveDy.getString("draftbillno"));
                    BillBackInfo.setEndorseType(entryBackInfo.getString("endorsetype"));
                    BillBackInfo.setInitiatorName(entryBackInfo.getString("initiatorname"));
                    BillBackInfo.setOpponentName(entryBackInfo.getString("opponentname"));
                    BillBackInfo.setSignDate(entryBackInfo.getDate("signdate") == null ? "" : DateUtils.formatString((Date)entryBackInfo.getDate("signdate"), (String)"yyyyMMdd"));
                    BillBackInfo.setPledgeReleaseDate(entryBackInfo.getDate("pledgereleasedate") == null ? "" : DateUtils.formatString((Date)entryBackInfo.getDate("pledgereleasedate"), (String)"yyyyMMdd"));
                    BillBackInfo.setEndorseIsTransfer(entryBackInfo.getString("endorseistransfer"));
                    resultList.add(BillBackInfo);
                }
            }
            if (resultList.isEmpty()) {
                result.setErrorCode("2001");
                result.setMessage(ResManager.loadKDString((String)"\u8be5\u7968\u636e\u80cc\u4e66\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"BillBackInfoPlugin_0", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
                return result;
            }
            result.setData(resultList);
        }
        catch (Exception e) {
            result.setErrorCode("2000");
            result.setMessage(ResManager.loadKDString((String)("BillBackInfoPlugin has err:" + e.getMessage()), (String)"BillBackInfoPlugin_1", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
        }
        return result;
    }
}

