/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.webapi.api;

import java.util.Date;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.webapi.bizdto.BillPositiveDto;
import kd.tmc.fbp.common.util.DateUtils;

public class BillPositiveInfoPlugin
implements IBillWebApiPlugin {
    private static String selectReceiveSelectors = "company,bankaccount,bizdate,draftbilltype,draftbillno,issuedate,draftbillexpiredate,istransfer,issplit,ispayinterest,returnnotetag,acceptno,payeetype,delivername,deliveraccounttext,deliveropenbank,deliveropenbanknum,drawername,draweraccountname,drawerbank,drawerbankno,receivername,receiveraccount,receiverbank,receiverbankno,acceptername,accepteraccount,accepterbank,accepterbankno,currency,amount,supperbillamount,subbillstartflag,subbillendflag,draftbillstatus,eledraftstatus,billpool,lockbilluser,source,modifytime,rptype";
    private static String selectPaySelectors = "company,bizdate,draftbilltype,draftbillno,issuedate,draftbillexpiredate,istransfer,issplit,ispayinterest,acceptno,payeetype,drawername,draweraccountname,drawerbankname,drawerbankno,receivername,receiveraccount,receiverbank,receiverbankno,acceptername,accepterbankname,accepteraccount,accepterbankno,currency,amount,supperbillamount,subbillstartflag,subbillendflag,draftbillstatus,eledraftstatus,source,modifytime,rptype";

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        try {
            QFilter qFilter = new QFilter("draftbillno", "=", params.get("draftBillNo"));
            QFilter recQFilter = new QFilter("rptype", "=", (Object)"receivebill");
            DynamicObject[] receiveDynamicObjects = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)selectReceiveSelectors, (QFilter[])new QFilter[]{qFilter, recQFilter}, (String)"modifytime desc");
            QFilter payQFilter = new QFilter("rptype", "=", (Object)"paybill");
            DynamicObject[] payDynamicObjects = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)selectPaySelectors, (QFilter[])new QFilter[]{qFilter}, (String)"modifytime desc");
            if (receiveDynamicObjects.length <= 0 && payDynamicObjects.length <= 0) {
                result.setErrorCode("2001");
                result.setMessage(ResManager.loadKDString((String)"data\u89e3\u6790\u5931\u8d25,\u6570\u636e\u4e0d\u5b58\u5728", (String)"BillPositiveInfoPlugin_0", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
            } else if (receiveDynamicObjects.length > 0) {
                result.setData((Object)this.resultBuild(receiveDynamicObjects[0]));
            } else {
                result.setData((Object)this.resultBuild(payDynamicObjects[0]));
            }
        }
        catch (Exception e) {
            result.setErrorCode("2000");
            result.setMessage(ResManager.loadKDString((String)("BillPositiveInfoPlugin has err:" + e.getMessage()), (String)"BillPositiveInfoPlugin_1", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
        }
        return result;
    }

    private BillPositiveDto resultBuild(DynamicObject dy) {
        if (dy == null) {
            return null;
        }
        BillPositiveDto positiveInfo = new BillPositiveDto();
        if ("receivebill".equals(dy.getString("rptype"))) {
            positiveInfo.setCompany(dy.getDynamicObject("company") == null ? "" : dy.getDynamicObject("company").getString("name"));
            positiveInfo.setBankAccount(dy.getDynamicObject("bankaccount") == null ? "" : dy.getDynamicObject("bankaccount").getString("number"));
            positiveInfo.setBizDate(dy.getDate("bizdate") == null ? "" : DateUtils.formatString((Date)dy.getDate("bizdate"), (String)"yyyyMMdd"));
            positiveInfo.setDraftBillType(dy.getDynamicObject("draftbilltype") == null ? "" : dy.getDynamicObject("draftbilltype").getString("name"));
            positiveInfo.setDraftBillNo(dy.getString("draftbillno"));
            positiveInfo.setIssueDate(dy.getDate("issuedate") == null ? "" : DateUtils.formatString((Date)dy.getDate("issuedate"), (String)"yyyyMMdd"));
            positiveInfo.setDraftBillExpireDate(dy.getDate("draftbillexpiredate") == null ? "" : DateUtils.formatString((Date)dy.getDate("draftbillexpiredate"), (String)"yyyyMMdd"));
            positiveInfo.setIsTransfer(dy.getString("istransfer"));
            positiveInfo.setIsSplit(dy.getString("issplit"));
            positiveInfo.setIsPayInterest(dy.getString("ispayinterest"));
            positiveInfo.setReturnNoteTag(dy.getString("returnnotetag"));
            positiveInfo.setAcceptNo(dy.getString("acceptno"));
            positiveInfo.setPayeeType(dy.getString("payeetype"));
            positiveInfo.setDeliverName(dy.getString("delivername"));
            positiveInfo.setDeliverAccountText(dy.getString("deliveraccounttext"));
            positiveInfo.setDeliverOpenBank(dy.getDynamicObject("deliveropenbank") == null ? "" : dy.getDynamicObject("deliveropenbank").getString("name"));
            positiveInfo.setDeliverOpenBankNum(dy.getString("deliveropenbanknum"));
            positiveInfo.setDrawerName(dy.getString("drawername"));
            positiveInfo.setDrawerAccountName(dy.getString("draweraccountname"));
            positiveInfo.setDrawerBank(dy.getDynamicObject("drawerbank") == null ? "" : dy.getDynamicObject("drawerbank").getString("name"));
            positiveInfo.setDrawerBankNo(dy.getString("drawerbankno"));
            positiveInfo.setReceiverName(dy.getString("receivername"));
            positiveInfo.setReceiverAccount(dy.getString("receiveraccount"));
            positiveInfo.setReceiverBank(dy.getDynamicObject("receiverbank") == null ? "" : dy.getDynamicObject("receiverbank").getString("name"));
            positiveInfo.setReceiverBankNo(dy.getString("receiverbankno"));
            positiveInfo.setAccepterName(dy.getString("acceptername"));
            positiveInfo.setAccepterAccount(dy.getString("accepteraccount"));
            positiveInfo.setAccepterBank(dy.getDynamicObject("accepterbank") == null ? "" : dy.getDynamicObject("accepterbank").getString("name"));
            positiveInfo.setAccepterBankNo(dy.getString("accepterbankno"));
            positiveInfo.setCurrency(dy.getDynamicObject("currency") == null ? "" : dy.getDynamicObject("currency").getString("name"));
            positiveInfo.setAmount(String.valueOf(dy.getLong("amount")));
            positiveInfo.setSupperBillAmount(String.valueOf(dy.getLong("supperbillamount")));
            positiveInfo.setSubBillStartFlag(dy.getString("subbillstartflag"));
            positiveInfo.setSubBillEndFlag(dy.getString("subbillendflag"));
            positiveInfo.setDraftBillStatus(dy.getString("draftbillstatus"));
            positiveInfo.setEleDraftStatus(dy.getString("eledraftstatus"));
            positiveInfo.setBillPool(dy.getDynamicObject("billpool") == null ? "" : dy.getDynamicObject("billpool").getString("name"));
            positiveInfo.setLockBillUser(dy.getDynamicObject("lockbilluser") == null ? "" : dy.getDynamicObject("lockbilluser").getString("name"));
            positiveInfo.setSource(dy.getString("source"));
        } else {
            positiveInfo.setCompany(dy.getDynamicObject("company") == null ? "" : dy.getDynamicObject("company").getString("name"));
            positiveInfo.setBankAccount("");
            positiveInfo.setBizDate(dy.getDate("bizdate") == null ? "" : DateUtils.formatString((Date)dy.getDate("bizdate"), (String)"yyyyMMdd"));
            positiveInfo.setDraftBillType(dy.getDynamicObject("draftbilltype") == null ? "" : dy.getDynamicObject("draftbilltype").getString("name"));
            positiveInfo.setDraftBillNo(dy.getString("draftbillno"));
            positiveInfo.setIssueDate(dy.getDate("issuedate") == null ? "" : DateUtils.formatString((Date)dy.getDate("issuedate"), (String)"yyyyMMdd"));
            positiveInfo.setDraftBillExpireDate(dy.getDate("draftbillexpiredate") == null ? "" : DateUtils.formatString((Date)dy.getDate("draftbillexpiredate"), (String)"yyyyMMdd"));
            positiveInfo.setIsTransfer(dy.getString("istransfer"));
            positiveInfo.setIsSplit(dy.getString("issplit"));
            positiveInfo.setIsPayInterest(dy.getString("ispayinterest"));
            positiveInfo.setReturnNoteTag("");
            positiveInfo.setAcceptNo(dy.getString("acceptno"));
            positiveInfo.setPayeeType(dy.getString("payeetype"));
            positiveInfo.setDeliverName("");
            positiveInfo.setDeliverAccountText("");
            positiveInfo.setDeliverOpenBank("");
            positiveInfo.setDeliverOpenBankNum("");
            positiveInfo.setDrawerName(dy.getString("drawername"));
            positiveInfo.setDrawerAccountName(dy.getString("draweraccountname"));
            positiveInfo.setDrawerBank(dy.getString("drawerbankname"));
            positiveInfo.setDrawerBankNo(dy.getString("drawerbankno"));
            positiveInfo.setReceiverName(dy.getString("receivername"));
            positiveInfo.setReceiverAccount(dy.getString("receiveraccount"));
            positiveInfo.setReceiverBank(dy.getDynamicObject("receiverbank") == null ? "" : dy.getDynamicObject("receiverbank").getString("name"));
            positiveInfo.setReceiverBankNo(dy.getString("receiverbankno"));
            positiveInfo.setAccepterName(dy.getString("acceptername"));
            positiveInfo.setAccepterAccount(dy.getString("accepteraccount"));
            positiveInfo.setAccepterBank(dy.getString("accepterbankname"));
            positiveInfo.setAccepterBankNo(dy.getString("accepterbankno"));
            positiveInfo.setCurrency(dy.getDynamicObject("currency") == null ? "" : dy.getDynamicObject("currency").getString("name"));
            positiveInfo.setAmount(String.valueOf(dy.getLong("amount")));
            positiveInfo.setSupperBillAmount(String.valueOf(dy.getLong("supperbillamount")));
            positiveInfo.setSubBillStartFlag(dy.getString("subbillstartflag"));
            positiveInfo.setSubBillEndFlag(dy.getString("subbillendflag"));
            positiveInfo.setDraftBillStatus(dy.getString("draftbillstatus"));
            positiveInfo.setEleDraftStatus(dy.getString("eledraftstatus"));
            positiveInfo.setBillPool("");
            positiveInfo.setLockBillUser("");
            positiveInfo.setSource(dy.getString("source"));
        }
        return positiveInfo;
    }
}

