/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.webapi.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.webapi.bizdto.BillRecordDto;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class BillRecordListPlugin
implements IBillWebApiPlugin {
    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        try {
            String paySelectors = "billno,draftbillno,bizdate,company,modifytime,rptype,eledraftstatus,draftbilltranstatus,draftbillstatus,istransfer,drawername,receivername,issuedate";
            String receiveSelectors = "billno,draftbillno,bizdate,company,bankaccount,modifytime,rptype,eledraftstatus,draftbilltranstatus,draftbillstatus,istransfer,delivername";
            String bizSelectors = "billno,bizdate,company,tradetype,bankaccount,modifytime,draftbilltranstatus,tradetype,beendorsortext,pledgeetext,recbodyname";
            String draftBillNo = (String)params.get("draftBillNo");
            QFilter qFilter = new QFilter("draftbillno", "=", (Object)draftBillNo);
            QFilter payQFilter = new QFilter("rptype", "=", (Object)"paybill");
            DynamicObject[] payDynamicObjects = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)paySelectors, (QFilter[])new QFilter[]{qFilter, payQFilter});
            QFilter recQFilter = new QFilter("rptype", "=", (Object)"receivebill");
            DynamicObject[] receiveDynamicObjects = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)receiveSelectors, (QFilter[])new QFilter[]{qFilter, recQFilter});
            DynamicObject[] recDyObj = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("draftbillno", "=", (Object)draftBillNo)});
            List recIds = Arrays.stream(recDyObj).map(o -> o.getLong("id")).collect(Collectors.toList());
            QFilter qBizFilter = new QFilter("entrys.draftbill", "in", recIds);
            DynamicObject[] bizDynamicObjects = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)bizSelectors, (QFilter[])new QFilter[]{qBizFilter});
            ArrayList dataListResult = new ArrayList();
            if (payDynamicObjects.length == 0 && receiveDynamicObjects.length == 0 && bizDynamicObjects.length == 0) {
                result.setErrorCode("2001");
                result.setMessage(String.format(ResManager.loadKDString((String)"\u7968\u636e\u53f7\u7801[%s]\u4e0d\u5b58\u5728\u6d41\u8f6c\u8bb0\u5f55", (String)"BillRecordListPlugin_20", (String)"tmc-cdm-webapi", (Object[])new Object[0]), draftBillNo));
                return result;
            }
            Arrays.stream(payDynamicObjects).forEach(pay -> {
                BillRecordDto entity = new BillRecordDto();
                entity.setBillNo(pay.getString("billno"));
                entity.setDraftBillNo(pay.getString("draftbillno"));
                entity.setBizDate(DateUtils.formatString((Date)pay.getDate("bizdate"), (String)"yyyyMMdd"));
                entity.setCompany(pay.getDynamicObject("company") == null ? "" : pay.getDynamicObject("company").getString("name"));
                entity.setBankAccount(pay.getDynamicObject("bankaccount") == null ? "" : pay.getDynamicObject("bankaccount").getString("number"));
                entity.setModifyTime(DateUtils.formatString((Date)pay.getDate("modifytime"), (String)"yyyy-MM-dd HH:mm:ss"));
                entity.setEleDraftStatus(pay.getString("eledraftstatus"));
                entity.setDraftBillTranStatus(pay.getString("draftbilltranstatus"));
                entity.setDraftBillStatus(pay.getString("draftbillstatus"));
                entity.setIsTransfer(pay.getString("istransfer"));
                entity.setEndorseeDate(DateUtils.formatString((Date)pay.getDate("issuedate"), (String)"yyyyMMdd"));
                entity.setEndorsor(pay.getString("drawername"));
                entity.setEndorsee(pay.getString("receivername"));
                entity.setBizType(pay.getString("rptype"));
                dataListResult.add(entity);
            });
            Arrays.stream(receiveDynamicObjects).forEach(receive -> {
                BillRecordDto entity = new BillRecordDto();
                entity.setBillNo(receive.getString("billno"));
                entity.setDraftBillNo(receive.getString("draftbillno"));
                entity.setBizDate(DateUtils.formatString((Date)receive.getDate("bizdate"), (String)"yyyyMMdd"));
                entity.setCompany(receive.getDynamicObject("company") == null ? "" : receive.getDynamicObject("company").getString("name"));
                entity.setBankAccount(receive.getDynamicObject("bankaccount") == null ? "" : receive.getDynamicObject("bankaccount").getString("number"));
                entity.setModifyTime(DateUtils.formatString((Date)receive.getDate("modifytime"), (String)"yyyy-MM-dd HH:mm:ss"));
                entity.setEleDraftStatus(receive.getString("eledraftstatus"));
                entity.setDraftBillTranStatus(receive.getString("draftbilltranstatus"));
                entity.setDraftBillStatus(receive.getString("draftbillstatus"));
                entity.setIsTransfer(receive.getString("istransfer"));
                entity.setEndorseeDate(DateUtils.formatString((Date)receive.getDate("bizdate"), (String)"yyyyMMdd"));
                entity.setEndorsor(receive.getString("delivername"));
                entity.setEndorsee(receive.getDynamicObject("company") == null ? "" : receive.getDynamicObject("company").getString("name"));
                entity.setBizType(receive.getString("rptype"));
                dataListResult.add(entity);
            });
            Arrays.stream(bizDynamicObjects).forEach(biz -> {
                if (StringUtils.isEmpty((Object)biz)) {
                    return;
                }
                BillRecordDto entity = new BillRecordDto();
                entity.setBillNo(biz.getString("billno"));
                entity.setDraftBillNo(draftBillNo);
                entity.setBizDate(DateUtils.formatString((Date)biz.getDate("bizdate"), (String)"yyyyMMdd"));
                entity.setCompany(biz.getDynamicObject("company") == null ? "" : biz.getDynamicObject("company").getString("name"));
                entity.setBankAccount(biz.getDynamicObject("bankaccount") == null ? "" : biz.getDynamicObject("bankaccount").getString("number"));
                entity.setModifyTime(DateUtils.formatString((Date)biz.getDate("modifytime"), (String)"yyyy-MM-dd HH:mm:ss"));
                entity.setDraftBillTranStatus(biz.getString("draftbilltranstatus"));
                entity.setEndorseeDate(DateUtils.formatString((Date)biz.getDate("bizdate"), (String)"yyyyMMdd"));
                entity.setEndorsor(biz.getDynamicObject("company") == null ? "" : biz.getDynamicObject("company").getString("name"));
                if (DraftTradeTypeEnum.ENDORSE.getValue().equals(biz.getString("tradetype"))) {
                    entity.setEndorsee(biz.getString("beendorsortext"));
                } else if (DraftTradeTypeEnum.PLEDGE.getValue().equals(biz.getString("tradetype"))) {
                    entity.setEndorsee(biz.getString("pledgeetext"));
                } else if (DraftTradeTypeEnum.DISCOUNT.getValue().equals(biz.getString("tradetype")) || DraftTradeTypeEnum.COLLECT.getValue().equals(biz.getString("tradetype"))) {
                    entity.setEndorsee(biz.getString("recbodyname"));
                }
                entity.setBizType("tradebill");
                dataListResult.add(entity);
            });
            List dataSortListResult = dataListResult.stream().sorted(Comparator.comparing(BillRecordDto::getBizDate).thenComparing(BillRecordDto::getModifyTime)).collect(Collectors.toList());
            result.setData(dataSortListResult);
        }
        catch (Exception e) {
            result.setErrorCode("2000");
            result.setMessage(String.format(ResManager.loadKDString((String)"\u7968\u636e\u8bb0\u5f55\u63a5\u53e3\u67e5\u8be2\u5f02\u5e38:%s", (String)"BillRecordListPlugin_1", (String)"tmc-cdm-webapi", (Object[])new Object[0]), e.getMessage()));
        }
        return result;
    }
}

