/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.EntityFieldTreeOption;
import kd.tmc.fbp.common.util.EntityFieldTreeResult;
import kd.tmc.fbp.common.util.EntityTreeUtil;
import kd.tmc.fbp.common.util.ExpressionType;

public class EleNoticeRuleEdit
extends AbstractBasePlugIn
implements ClickListener {
    private static final String NON_FIELDS = "non_fields";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"e_datafilterdesc"});
        this.addClickListeners(new String[]{"e_notifische"});
        this.fillOrgF7();
        this.authorizedCompany();
    }

    private void fillOrgF7() {
        BasedataEdit uOrgF7 = (BasedataEdit)this.getControl("u_org");
        uOrgF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            DynamicObjectCollection orgDOC = TmcOrgDataHelper.getAuthorizedBankOrg((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cdm_ele_notice_rule", (String)"47156aff000000ac");
            List orgList = TmcOrgDataHelper.getIdList((DynamicObjectCollection)orgDOC);
            showParameter.setCustomParam("range", (Object)orgList);
            DynamicObjectCollection uEntryDOC = this.getModel().getEntryEntity("org_entry");
            int row = evt.getRow();
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)uEntryDOC)) {
                ArrayList<Long> yetChooseIdList = new ArrayList<Long>(10);
                for (int i = 0; i < uEntryDOC.size(); ++i) {
                    DynamicObject uEntryDO = (DynamicObject)uEntryDOC.get(i);
                    if (i == row || !EmptyUtil.isNoEmpty((DynamicObject)uEntryDO) || !EmptyUtil.isNoEmpty((DynamicObject)uEntryDO.getDynamicObject("u_org"))) continue;
                    yetChooseIdList.add((Long)uEntryDO.getDynamicObject("u_org").getPkValue());
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList).and(new QFilter("id", "not in", yetChooseIdList)));
            } else {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
            }
        });
    }

    private void authorizedCompany() {
        BasedataEdit company = (BasedataEdit)this.getControl("company");
        company.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            DynamicObjectCollection orgDOC = TmcOrgDataHelper.getAuthorizedBankOrg((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cdm_ele_notice_rule", (String)"47156aff000000ac");
            List orgList = TmcOrgDataHelper.getIdList((DynamicObjectCollection)orgDOC);
            showParameter.setCustomParam("range", (Object)orgList);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("e_datafilterdesc".equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex("rule_entity");
            this.fillFields("e_datafilter");
            this.showConditionForm(index, "e_datafilter", this.getPageCache().get("e_datafilter"));
        } else if ("e_notifische".equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex("rule_entity");
            String saveNotice = this.getModel().getValue("e_savenotifi_TAG", index).toString();
            this.showNoticeScheme(index, saveNotice);
        }
    }

    private void fillFields(String key) {
        MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal");
        if (srcMainET == null) {
            this.getPageCache().put(key, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)srcMainET);
            option.setReadEntryEntity(false);
            option.setExprType(ExpressionType.Condition);
            option.setFieldType(null);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put(key, toJson);
            String nonFdStr = this.getPageCache().get(NON_FIELDS);
            if (nonFdStr != null) {
                Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
                nonSet.addAll(result.getNonFields());
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)nonSet));
            } else {
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
            }
        }
    }

    private void showConditionForm(int rowIndex, String sourceCtrlKey, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cdm_apply_condition");
        String conditionJson = (String)this.getModel().getValue(sourceCtrlKey + "_TAG", rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        String entity = "cdm_electronic_sign_deal";
        showParameter.getCustomParams().put("entitynumber", entity);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("e_datafilter".equals(e.getActionId())) {
            this.receiveExpressionSet(e, "rule_entity", "e_datafilter", "e_datafilter");
        } else if ("notifischeme".equals(e.getActionId())) {
            String res;
            Map returnData = (Map)e.getReturnData();
            if (returnData == null) {
                return;
            }
            List usernames = (List)returnData.get("usergroupnames");
            List orgnames = (List)returnData.get("orgnames");
            List rolenames = (List)returnData.get("rolenames");
            List users = (List)returnData.get("usernames");
            int index = Integer.parseInt(this.getPageCache().get("index"));
            if (usernames != null && usernames.size() > 0) {
                res = org.apache.commons.lang3.StringUtils.join((Iterable)usernames, (String)",");
                this.getModel().setValue("e_notifische", (Object)res, index);
            } else if (orgnames != null && orgnames.size() > 0 || rolenames != null && rolenames.size() > 0) {
                res = orgnames != null ? org.apache.commons.lang3.StringUtils.join((Iterable)orgnames, (String)",") + (rolenames != null ? "," + org.apache.commons.lang3.StringUtils.join((Iterable)rolenames, (String)",") : "") : org.apache.commons.lang3.StringUtils.join((Iterable)rolenames, (String)",");
                this.getModel().setValue("e_notifische", (Object)res, index);
            } else if (users != null && users.size() > 0) {
                res = org.apache.commons.lang3.StringUtils.join((Iterable)users, (String)",");
                this.getModel().setValue("e_notifische", (Object)res, index);
            }
            String jsonString = SerializationUtils.toJsonString((Object)returnData);
            this.getModel().setValue("e_savenotifi_TAG", (Object)jsonString, Integer.parseInt(this.getPageCache().get("index")));
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent, String entityKey, String expressionFldKey, String descFldKey) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(descFldKey, (Object)"", row);
            } else {
                CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)str, CRCondition.class);
                this.getModel().setValue(expressionFldKey + "_TAG", (Object)str, row);
                String desp = "";
                if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                    desp = filterObj.getExprTran();
                }
                if (desp.length() > 1024) {
                    desp = desp.substring(0, 1024);
                }
                this.getModel().setValue("e_datafilterdesc", (Object)desp, row);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ("e_datafilterdesc".equals(propName) && StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue("e_datafilter", (Object)"", rowIndex);
            this.getModel().setValue("e_datafilter_TAG", (Object)"", rowIndex);
        }
    }

    private void showNoticeScheme(int index, String e_savenotifi) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cdm_notice_scheme");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "notifischeme"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObjectCollection org_entry = this.getModel().getEntryEntity("org_entry");
        if (org_entry.size() > 0) {
            List collect = org_entry.stream().filter(dy -> EmptyUtil.isNoEmpty((DynamicObject)dy) && EmptyUtil.isNoEmpty((DynamicObject)dy.getDynamicObject("u_org"))).map(or -> or.getDynamicObject("u_org").getPkValue()).collect(Collectors.toList());
            showParameter.setCustomParam("orgId", collect);
        } else {
            showParameter.setCustomParam("orgId", new ArrayList());
        }
        showParameter.setCustomParam("e_handlescheme", this.getModel().getValue("e_handlescheme"));
        showParameter.setCustomParam("e_savenotifi", (Object)e_savenotifi);
        this.getView().showForm(showParameter);
        this.getPageCache().put("index", String.valueOf(index));
    }
}

