/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.enums.AcceptPromiseTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.EntityFieldTreeOption;
import kd.tmc.fbp.common.util.EntityFieldTreeResult;
import kd.tmc.fbp.common.util.EntityTreeUtil;
import kd.tmc.fbp.common.util.ExpressionType;

public class RecBillNoticeRuleEdit
extends AbstractFormPlugin {
    private static final String NON_FIELDS = "non_fields";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"e_receivingtypestr"});
        this.addClickListeners(new String[]{"e_payertypestr"});
        this.addClickListeners(new String[]{"e_payer"});
        this.addClickListeners(new String[]{"e_fundflowitemstr"});
        this.addClickListeners(new String[]{"e_explain"});
        this.addClickListeners(new String[]{"e_notifische"});
        this.addClickListeners(new String[]{"e_datafilterdesc"});
        this.addClickListeners(new String[]{"e_settletypestr"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.fillOrgF7();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("e_receivingtypestr".equals(key) || "e_payertypestr".equals(key) || "e_payer".equals(key) || "e_fundflowitemstr".equals(key) || "e_explain".equals(key) || "e_settletypestr".equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex("rule_entity");
            this.showRecInfo(index);
        } else if ("e_datafilterdesc".equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex("rule_entity");
            this.fillFields("e_datafilter");
            this.showConditionForm(index, "e_datafilter", this.getPageCache().get("e_datafilter"));
        } else if ("e_notifische".equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex("rule_entity");
            String saveNotice = this.getModel().getValue("e_savenotifi_TAG", index).toString();
            this.showNoticeScheme(index, saveNotice);
        }
    }

    private void fillFields(String key) {
        MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill");
        if (srcMainET == null) {
            this.getPageCache().put(key, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)srcMainET);
            option.setReadEntryEntity(false);
            option.setExprType(ExpressionType.Condition);
            option.setFieldType(null);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put(key, toJson);
            String nonFdStr = this.getPageCache().get(NON_FIELDS);
            if (nonFdStr != null) {
                Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
                nonSet.addAll(result.getNonFields());
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)nonSet));
            } else {
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
            }
        }
    }

    private void showConditionForm(int rowIndex, String sourceCtrlKey, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cdm_apply_condition");
        String conditionJson = (String)this.getModel().getValue(sourceCtrlKey + "_TAG", rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        String entity = "cdm_receivablebill";
        showParameter.getCustomParams().put("entitynumber", entity);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showNoticeScheme(int index, String e_savenotifi) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cdm_notice_scheme");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "notifischeme"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObjectCollection org_entry = this.getModel().getEntryEntity("org_entry");
        if (org_entry.size() > 0) {
            List collect = org_entry.stream().filter(dy -> EmptyUtil.isNoEmpty((DynamicObject)dy) && EmptyUtil.isNoEmpty((DynamicObject)dy.getDynamicObject("u_org"))).map(or -> or.getDynamicObject("u_org").getPkValue()).collect(Collectors.toList());
            showParameter.setCustomParam("orgId", collect);
        } else {
            showParameter.setCustomParam("orgId", new ArrayList());
        }
        showParameter.setCustomParam("e_handlescheme", this.getModel().getValue("e_handlescheme"));
        showParameter.setCustomParam("e_savenotifi", (Object)e_savenotifi);
        String noticeGroup = (String)this.getModel().getValue("e_noticegroup", index);
        showParameter.setCustomParam("e_noticegroup", (Object)noticeGroup);
        this.getView().showForm(showParameter);
        this.getPageCache().put("index", String.valueOf(index));
    }

    private void showRecInfo(int index) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cdm_recinfo");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "recinfo"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("e_receivingtype", !ObjectUtils.isEmpty((Object)this.getModel().getValue("e_receivingtype")) ? ((DynamicObject)this.getModel().getValue("e_receivingtype")).getPkValue() : null);
        showParameter.setCustomParam("e_payertype", this.getModel().getValue("e_payertype"));
        showParameter.setCustomParam("e_payerbasetype", this.getModel().getValue("e_payerbasetype"));
        showParameter.setCustomParam("e_payer", this.getModel().getValue("e_payer"));
        showParameter.setCustomParam("e_payerid", !ObjectUtils.isEmpty((Object)this.getModel().getValue("e_payerid")) ? ((DynamicObject)this.getModel().getValue("e_payerid")).getPkValue() : null);
        showParameter.setCustomParam("e_fundflowitem", !ObjectUtils.isEmpty((Object)this.getModel().getValue("e_fundflowitem")) ? ((DynamicObject)this.getModel().getValue("e_fundflowitem")).getPkValue() : null);
        showParameter.setCustomParam("e_explain", this.getModel().getValue("e_explain"));
        showParameter.setCustomParam("e_settletype", !ObjectUtils.isEmpty((Object)this.getModel().getValue("e_settletype")) ? ((DynamicObject)this.getModel().getValue("e_settletype")).getPkValue() : null);
        this.getView().showForm(showParameter);
        this.getPageCache().put("recindex", String.valueOf(index));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("recinfo".equals(e.getActionId())) {
            Map returnData = (Map)e.getReturnData();
            if (returnData == null) {
                return;
            }
            int index = Integer.parseInt(this.getPageCache().get("recindex"));
            Object eReceivingType = returnData.get("e_receivingtype");
            if (!ObjectUtils.isEmpty(eReceivingType)) {
                this.getModel().setValue("e_receivingtype", ((DynamicObject)eReceivingType).getPkValue(), index);
                this.getModel().setValue("e_receivingtypestr", ((DynamicObject)eReceivingType).get("name"), index);
            } else {
                this.getModel().setValue("e_receivingtype", (Object)"", index);
                this.getModel().setValue("e_receivingtypestr", (Object)"", index);
            }
            Object ePayerType = returnData.get("e_payertype");
            this.getModel().setValue("e_payertypestr", ObjectUtils.isEmpty(ePayerType) ? "" : this.getType(ePayerType.toString()), index);
            this.getModel().setValue("e_payertype", ePayerType, index);
            if (!ObjectUtils.isEmpty(ePayerType) && AcceptPromiseTypeEnum.OTHER.getValue().equals(ePayerType)) {
                Object ePayer = returnData.get("e_payer");
                this.getModel().setValue("e_payer", ePayer, index);
            } else if (!ObjectUtils.isEmpty(ePayerType) && !AcceptPromiseTypeEnum.OTHER.getValue().equals(ePayerType)) {
                DynamicObject ePayerId = (DynamicObject)returnData.get("e_payerid");
                Object ePayerBaseType = returnData.get("e_payerbasetype");
                this.getModel().setValue("e_payer", ePayerId.get("name"), index);
                this.getModel().setValue("e_payerbasetype", ePayerBaseType, index);
                this.getModel().setValue("e_payerid", ePayerId.getPkValue(), index);
            } else {
                this.getModel().setValue("e_payertypestr", (Object)"", index);
                this.getModel().setValue("e_payer", (Object)"", index);
            }
            Object eFundFlowItem = returnData.get("e_fundflowitem");
            Object eExplain = returnData.get("e_explain");
            if (!ObjectUtils.isEmpty(eFundFlowItem)) {
                this.getModel().setValue("e_fundflowitem", ((DynamicObject)eFundFlowItem).getPkValue(), index);
                this.getModel().setValue("e_fundflowitemstr", ((DynamicObject)eFundFlowItem).get("name"), index);
            } else {
                this.getModel().setValue("e_fundflowitem", (Object)"", index);
                this.getModel().setValue("e_fundflowitemstr", (Object)"", index);
            }
            if (!ObjectUtils.isEmpty(eExplain)) {
                this.getModel().setValue("e_explain", eExplain, index);
            } else {
                this.getModel().setValue("e_explain", (Object)"", index);
            }
            Object eSettleType = returnData.get("e_settletype");
            if (!ObjectUtils.isEmpty(eSettleType)) {
                this.getModel().setValue("e_settletype", ((DynamicObject)eSettleType).getPkValue(), index);
                this.getModel().setValue("e_settletypestr", ((DynamicObject)eSettleType).get("name"), index);
            } else {
                this.getModel().setValue("e_settletype", (Object)"", index);
                this.getModel().setValue("e_settletypestr", (Object)"", index);
            }
        } else if ("e_datafilter".equals(e.getActionId())) {
            this.receiveExpressionSet(e, "rule_entity", "e_datafilter", "e_datafilter");
        } else if ("notifischeme".equals(e.getActionId())) {
            String res;
            Map returnData = (Map)e.getReturnData();
            if (returnData == null) {
                return;
            }
            List usernames = (List)returnData.get("usergroupnames");
            List orgnames = (List)returnData.get("orgnames");
            List rolenames = (List)returnData.get("rolenames");
            List users = (List)returnData.get("usernames");
            String noticeGroup = (String)returnData.get("noticegroup");
            int index = Integer.parseInt(this.getPageCache().get("index"));
            this.getModel().setValue("e_notifische", (Object)"", index);
            if (usernames != null && usernames.size() > 0) {
                res = org.apache.commons.lang3.StringUtils.join((Iterable)usernames, (String)",");
                this.getModel().setValue("e_notifische", (Object)res, index);
            } else if (orgnames != null && orgnames.size() > 0 || rolenames != null && rolenames.size() > 0) {
                res = orgnames != null ? org.apache.commons.lang3.StringUtils.join((Iterable)orgnames, (String)",") + (rolenames != null ? "," + org.apache.commons.lang3.StringUtils.join((Iterable)rolenames, (String)",") : "") : org.apache.commons.lang3.StringUtils.join((Iterable)rolenames, (String)",");
                this.getModel().setValue("e_notifische", (Object)res, index);
            } else if (users != null && users.size() > 0) {
                res = org.apache.commons.lang3.StringUtils.join((Iterable)users, (String)",");
                this.getModel().setValue("e_notifische", (Object)res, index);
            }
            this.getModel().setValue("e_noticegroup", (Object)noticeGroup, index);
            String jsonString = SerializationUtils.toJsonString((Object)returnData);
            this.getModel().setValue("e_savenotifi_TAG", (Object)jsonString, Integer.parseInt(this.getPageCache().get("index")));
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent, String entityKey, String expressionFldKey, String descFldKey) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(descFldKey, (Object)"", row);
            } else {
                CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)str, CRCondition.class);
                this.getModel().setValue(expressionFldKey + "_TAG", (Object)str, row);
                String desp = "";
                if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                    desp = filterObj.getExprTran();
                }
                if (desp.length() > 1024) {
                    desp = desp.substring(0, 1024);
                }
                this.getModel().setValue("e_datafilterdesc", (Object)desp, row);
            }
        }
    }

    private Object getType(String type) {
        String res = "";
        switch (type) {
            case "bos_org": {
                res = AcceptPromiseTypeEnum.BOS_ORG.getName();
                break;
            }
            case "bd_supplier": {
                res = AcceptPromiseTypeEnum.BD_SUPPLIER.getName();
                break;
            }
            case "bd_customer": {
                res = AcceptPromiseTypeEnum.BD_CUSTOMER.getName();
                break;
            }
            case "bos_user": {
                res = AcceptPromiseTypeEnum.BOS_USER.getName();
                break;
            }
            case "other": {
                res = AcceptPromiseTypeEnum.OTHER.getName();
                break;
            }
        }
        return res;
    }

    private void fillOrgF7() {
        BasedataEdit uOrgF7 = (BasedataEdit)this.getControl("u_org");
        uOrgF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            DynamicObjectCollection orgDOC = TmcOrgDataHelper.getAuthorizedBankOrg((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cdm_recbill_noticerule", (String)"47156aff000000ac");
            List orgList = TmcOrgDataHelper.getIdList((DynamicObjectCollection)orgDOC);
            showParameter.setCustomParam("range", (Object)orgList);
            DynamicObjectCollection uEntryDOC = this.getModel().getEntryEntity("org_entry");
            int row = evt.getRow();
            if (!ObjectUtils.isEmpty((Object)uEntryDOC)) {
                ArrayList<Long> yetChooseIdList = new ArrayList<Long>(10);
                for (int i = 0; i < uEntryDOC.size(); ++i) {
                    DynamicObject uEntryDO = (DynamicObject)uEntryDOC.get(i);
                    if (i == row || ObjectUtils.isEmpty((Object)uEntryDO) || ObjectUtils.isEmpty((Object)uEntryDO.getDynamicObject("u_org"))) continue;
                    yetChooseIdList.add((Long)uEntryDO.getDynamicObject("u_org").getPkValue());
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList).and(new QFilter("id", "not in", yetChooseIdList)));
            } else {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
            }
        });
    }
}

