/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billpool;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.enums.BillPoolTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;

public class BillPoolEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setCompanyFilter();
        this.setEntryEntityCompanyFilter();
    }

    private void setEntryEntityCompanyFilter() {
        BasedataEdit companyEdit = (BasedataEdit)this.getControl("e_company");
        companyEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject company = this.getModel().getDataEntity().getDynamicObject("company");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Set entryCompanyIds = entryEntity.stream().map(row -> row.getDynamicObject("e_company")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            if (company != null) {
                entryCompanyIds.add(company.getPkValue());
            }
            QFilter filter = new QFilter("id", "not in", entryCompanyIds);
            parameter.getListFilterParameter().setFilter(filter);
        });
    }

    private void setCompanyFilter() {
        BasedataEdit company = (BasedataEdit)this.getControl("company");
        company.addBeforeF7SelectListener(evt -> {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cdm_billpool", (String)"47150e89000000ac");
            QFilter filter = new QFilter("id", "in", (Object)authOrgIds);
            parameter.getListFilterParameter().setFilter(filter);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newCompany;
        String name = e.getProperty().getName();
        Object value = this.getModel().getValue("type");
        if (Objects.equals(name, "type")) {
            if (Objects.equals(value, BillPoolTypeEnum.BANK.getValue())) {
                FieldEdit fieldEdit = (FieldEdit)this.getControl("bank");
                fieldEdit.setMustInput(true);
            }
        } else if (Objects.equals(name, "company") && (newCompany = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            this.clearEntity(newCompany.getPkValue());
        }
    }

    private void clearEntity(Object newCompanyId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryCompany = ((DynamicObject)entryEntity.get(i)).getDynamicObject("e_company");
            if (entryCompany == null || !Objects.equals(entryCompany.getPkValue(), newCompanyId)) continue;
            this.getModel().deleteEntryRow("entryentity", i);
        }
    }
}

