/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billpoolbiz;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.BizBusinessTypeEnum;

public class BillPoolBizList
extends AbstractListPlugin {
    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"company.")) {
            args.getQFilters().addAll(this.getFilter("company", "company.id"));
        }
    }

    private List<QFilter> getFilter(String selectProperty, String filterProperty) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"cdm_billpoolbiz", (String)selectProperty, (QFilter[])new QFilter(filterProperty, "!=", (Object)0).toArray());
        Set productTermIds = Arrays.stream(load).filter(d -> Objects.nonNull(d.getDynamicObject(selectProperty))).map(d -> (Long)d.getDynamicObject(selectProperty).getPkValue()).collect(Collectors.toSet());
        return Collections.singletonList(new QFilter("id", "in", productTermIds));
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (Objects.equals("join", evt.getOperateKey())) {
            this.showBill(BizBusinessTypeEnum.JOIN, OperationStatus.ADDNEW, null);
        } else if (Objects.equals("out", evt.getOperateKey())) {
            this.showBill(BizBusinessTypeEnum.OUT, OperationStatus.ADDNEW, null);
        }
    }

    private void showBill(BizBusinessTypeEnum bizBusinessTypeEnum, OperationStatus operationStatus, Object pkId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setAppId("cdm");
        parameter.setStatus(operationStatus);
        parameter.setFormId("cdm_billpoolbiz");
        parameter.setCustomParam("businesstype", (Object)bizBusinessTypeEnum.getValue());
        parameter.setCaption(bizBusinessTypeEnum.getName());
        parameter.setPkId(pkId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)this.getControl("billlistap");
        Object primaryKeyValue = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject billPoolBiz = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"cdm_billpoolbiz", (String)"businesstype");
        if (Objects.equals(BizBusinessTypeEnum.JOIN.getValue(), billPoolBiz.getString("businesstype"))) {
            this.showBill(BizBusinessTypeEnum.JOIN, OperationStatus.EDIT, primaryKeyValue);
        } else {
            this.showBill(BizBusinessTypeEnum.OUT, OperationStatus.EDIT, primaryKeyValue);
        }
    }
}

