/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billpoolbiz;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.tmc.cdm.common.enums.BizBusinessTypeEnum;
import kd.tmc.cdm.common.helper.OperateServiceHelper;

public class PoolDraftEdit
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (operateKey.equals("pooldraftlock")) {
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_lock": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("cdm_lockbilluser_select");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cdm_lockbilluser_select"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        OperationResult operationResult = evt.getOperationResult();
        if (operateKey.equals("pooldraftlock")) {
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52a0\u9501\u6210\u529f\u3002", (String)"PoolDraft_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
        } else if (operateKey.equals("pooldraftunlock")) {
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u9501\u6210\u529f\u3002", (String)"PoolDraft_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
        } else if (operateKey.equals("join")) {
            this.showPoolBizBill(BizBusinessTypeEnum.JOIN, OperationStatus.ADDNEW, null);
        } else if (operateKey.equals("out") && operationResult.isSuccess()) {
            List pkValues = operationResult.getSuccessPkIds();
            this.showPoolBizBill(BizBusinessTypeEnum.OUT, OperationStatus.ADDNEW, pkValues.get(0));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("cdm_lockbilluser_select".equals(actionId)) {
            DynamicObject[] dynamicObjects;
            Map returnData = (Map)e.getReturnData();
            if (returnData == null) {
                return;
            }
            DynamicObject lockBillUser = (DynamicObject)returnData.get("lockBillUser");
            if (lockBillUser == null) {
                return;
            }
            DynamicObject DynamicObject2 = this.getModel().getDataEntity();
            for (DynamicObject dyobj : dynamicObjects = new DynamicObject[]{DynamicObject2}) {
                Long userPK = Long.valueOf(RequestContext.get().getUserId());
                dyobj.set("lockbilluser", (Object)userPK);
                dyobj.set("poollockorg", (Object)lockBillUser);
            }
            OperationResult execOperate = OperateServiceHelper.executeOperate((String)"pooldraftlock", (String)"cdm_pooldraftbill", (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
            if (execOperate != null && !execOperate.isSuccess()) {
                this.getView().showOperationResult(execOperate);
                execOperate.setSuccess(true);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u52a0\u9501\u6210\u529f\u3002", (String)"PoolDraft_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void showPoolBizBill(BizBusinessTypeEnum bizBusinessTypeEnum, OperationStatus operationStatus, Object pkValue) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setAppId("cdm");
        parameter.setStatus(operationStatus);
        parameter.setFormId("cdm_billpoolbiz");
        parameter.setCustomParam("businesstype", (Object)bizBusinessTypeEnum.getValue());
        parameter.setCustomParam("poolDraftId", pkValue);
        parameter.setCaption(bizBusinessTypeEnum.getName());
        parameter.setPkId(null);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

