/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billsInventory;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.StringJoiner;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class BankDraftsEdit
extends AbstractTmcBillEdit {
    private boolean skipPropChange;
    private static final BigDecimal STANDARAMOUNT = new BigDecimal("0.01");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.headCurrencyListener();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isAddNew = BillOperationStatus.ADDNEW.equals((Object)((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus());
        if (isAddNew) {
            long standardCurrency;
            DynamicObject orgDy;
            Object dataDate = this.getModel().getValue("datadate");
            if (EmptyUtil.isEmpty((Object)dataDate)) {
                Date yesterday = DateUtils.getLastDay((Date)new Date(), (int)1);
                this.skipPropChange = true;
                Date newDate = DateUtils.stringToDate((String)DateUtils.formatString((Date)yesterday, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                this.getModel().setValue("datadate", (Object)newDate);
            }
            if (null != (orgDy = (DynamicObject)this.getModel().getValue("org")) && 0L != (standardCurrency = DraftHelper.getMainCurrByOrg((DynamicObject)orgDy))) {
                this.getModel().setValue("billcurrency", (Object)standardCurrency);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("locamt".equals(key)) {
            return;
        }
        if (this.skipPropChange) {
            this.skipPropChange = false;
            return;
        }
        ChangeData[] changeData = e.getChangeSet();
        Object propValue = changeData[0].getNewValue();
        Object oldPropValue = changeData[0].getOldValue();
        int rowIndex = changeData[0].getRowIndex();
        switch (key) {
            case "org": {
                long standardCurrency;
                DynamicObject companyDO = this.getModel().getDataEntity().getDynamicObject("org");
                if (!EmptyUtil.isNoEmpty((DynamicObject)companyDO) || 0L == (standardCurrency = DraftHelper.getMainCurrByOrg((DynamicObject)companyDO))) break;
                this.getModel().setValue("billcurrency", (Object)standardCurrency);
                break;
            }
            case "bankaccount": {
                DynamicObjectCollection currencyColl;
                DynamicObject bankAccount = this.getModel().getDataEntity().getDynamicObject("bankaccount");
                if (!EmptyUtil.isNoEmpty((DynamicObject)bankAccount) || !EmptyUtil.isNoEmpty((DynamicObjectCollection)(currencyColl = bankAccount.getDynamicObjectCollection("currency")))) break;
                if (currencyColl.size() == 1) {
                    this.getModel().setValue("billcurrency", ((DynamicObject)currencyColl.get(0)).getDynamicObject("fbasedataid").getPkValue());
                    break;
                }
                DynamicObject defaultcurrency = bankAccount.getDynamicObject("defaultcurrency");
                if (!EmptyUtil.isNoEmpty((DynamicObject)defaultcurrency)) break;
                this.getModel().setValue("billcurrency", defaultcurrency.getPkValue());
                break;
            }
            case "e_draftamount": {
                BigDecimal newDraftAmount = (BigDecimal)propValue;
                if (STANDARAMOUNT.compareTo(newDraftAmount) > 0) {
                    this.skipPropChange = true;
                    this.getModel().setValue("e_draftamount", (Object)STANDARAMOUNT, rowIndex);
                }
                this.reSetAllAmount();
                boolean isSplitDraft = (Boolean)this.getModel().getValue("e_issplit", rowIndex);
                if (!isSplitDraft) break;
                BigDecimal e_draftAmount = (BigDecimal)this.getModel().getValue("e_draftamount", rowIndex);
                long startFlag = (Long)this.getModel().getValue("e_subbillstartflag", rowIndex);
                long newEndFlag = e_draftAmount.multiply(new BigDecimal("100")).longValue() - 1L + startFlag;
                this.skipPropChange = true;
                this.getModel().setValue("e_subbillendflag", (Object)newEndFlag, rowIndex);
                this.getModel().setValue("e_subbillrange", (Object)(startFlag + "-" + newEndFlag), rowIndex);
                break;
            }
            case "e_issplit": {
                boolean isSplit = (Boolean)propValue;
                if (!isSplit) {
                    this.getModel().setValue("e_subbillrange", (Object)"0", rowIndex);
                    this.skipPropChange = true;
                    this.getModel().setValue("e_subbillendflag", (Object)0, rowIndex);
                    this.skipPropChange = true;
                    this.getModel().setValue("e_subbillstartflag", (Object)0, rowIndex);
                    break;
                }
                long startFlag = (Long)this.getModel().getValue("e_subbillstartflag", rowIndex);
                if (0L == startFlag) {
                    startFlag = 1L;
                    this.skipPropChange = true;
                    this.getModel().setValue("e_subbillstartflag", (Object)startFlag, rowIndex);
                }
                BigDecimal e_draftAmount = (BigDecimal)this.getModel().getValue("e_draftamount", rowIndex);
                long endFlag = e_draftAmount.multiply(new BigDecimal("100")).longValue() - 1L + startFlag;
                this.skipPropChange = true;
                this.getModel().setValue("e_subbillendflag", (Object)endFlag, rowIndex);
                this.skipPropChange = true;
                this.getModel().setValue("e_subbillrange", (Object)(startFlag + "-" + endFlag), rowIndex);
                break;
            }
            case "e_subbillendflag": {
                BigDecimal e_draftAmount;
                long startFlag;
                boolean isSplitData = (Boolean)this.getModel().getValue("e_issplit", rowIndex);
                if (!isSplitData) break;
                Object startFlagOb = this.getModel().getValue("e_subbillstartflag", rowIndex);
                Object endFlagOb = this.getModel().getValue("e_subbillendflag", rowIndex);
                long endFlag = (Long)endFlagOb;
                if (endFlag < (startFlag = ((Long)startFlagOb).longValue())) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\uff1a\u5b50\u7968\u5305\u7ed3\u675f\u6807\u8bc6\u4e0d\u80fd\u5c0f\u4e8e\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u3002", (String)"BankDraftsEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), rowIndex + 1), Integer.valueOf(2000));
                    this.skipPropChange = true;
                    this.getModel().setValue("e_subbillendflag", (Object)startFlag, rowIndex);
                    break;
                }
                long subQuantity = endFlag - startFlag + 1L;
                BigDecimal e_draftAmountForCalc = STANDARAMOUNT.multiply(new BigDecimal(subQuantity));
                if (e_draftAmountForCalc.compareTo(e_draftAmount = (BigDecimal)this.getModel().getValue("e_draftamount", rowIndex)) != 0) {
                    this.getModel().setValue("e_draftamount", (Object)e_draftAmountForCalc, rowIndex);
                }
                this.getModel().setValue("e_subbillrange", (Object)(startFlag + "-" + endFlag), rowIndex);
                break;
            }
            case "e_subbillstartflag": {
                BigDecimal e_draftAmount;
                boolean isSplitFlag = (Boolean)this.getModel().getValue("e_issplit", rowIndex);
                if (!isSplitFlag) break;
                Object startFlagCurr = this.getModel().getValue("e_subbillstartflag", rowIndex);
                Object endFlagCurr = this.getModel().getValue("e_subbillendflag", rowIndex);
                long endFlagNum = (Long)endFlagCurr;
                long startFlagNum = (Long)startFlagCurr;
                if (startFlagNum <= 0L || endFlagNum <= 0L) {
                    this.skipPropChange = true;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\uff1a\u5b50\u7968\u5305\u6807\u8bc6\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\u3002", (String)"BankDraftsEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), rowIndex + 1), Integer.valueOf(2000));
                    this.getModel().setValue("e_subbillstartflag", oldPropValue, rowIndex);
                    break;
                }
                if (endFlagNum < startFlagNum) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\uff1a\u5b50\u7968\u5305\u7ed3\u675f\u6807\u8bc6\u4e0d\u80fd\u5c0f\u4e8e\u5b50\u7968\u5305\u5f00\u59cb\u6807\u8bc6\u3002", (String)"BankDraftsEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), rowIndex + 1), Integer.valueOf(2000));
                    this.skipPropChange = true;
                    this.getModel().setValue("e_subbillstartflag", oldPropValue, rowIndex);
                    break;
                }
                long subQuantity = endFlagNum - startFlagNum + 1L;
                BigDecimal e_draftAmountForCalc = STANDARAMOUNT.multiply(new BigDecimal(subQuantity));
                if (e_draftAmountForCalc.compareTo(e_draftAmount = (BigDecimal)this.getModel().getValue("e_draftamount", rowIndex)) != 0) {
                    this.getModel().setValue("e_draftamount", (Object)e_draftAmountForCalc, rowIndex);
                }
                this.getModel().setValue("e_subbillrange", (Object)(startFlagNum + "-" + endFlagNum), rowIndex);
                break;
            }
            case "e_draftbillexpiredate": {
                Date e_draftBillExpireDate = (Date)propValue;
                Date e_issuedate = (Date)this.getModel().getValue("e_issuedate", rowIndex);
                if (null == e_issuedate) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\uff1a\u8bf7\u5148\u9009\u62e9\u51fa\u7968\u65e5\u671f\u3002", (String)"BankDraftsEdit_2_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), rowIndex + 1), Integer.valueOf(2000));
                    this.skipPropChange = true;
                    this.getModel().setValue("e_draftbillexpiredate", oldPropValue, rowIndex);
                    break;
                }
                if (null == e_draftBillExpireDate || !e_draftBillExpireDate.before(e_issuedate)) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\uff1a\u5230\u671f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u51fa\u7968\u65e5\u671f\u3002", (String)"BankDraftsEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), rowIndex + 1), Integer.valueOf(2000));
                this.skipPropChange = true;
                this.getModel().setValue("e_draftbillexpiredate", oldPropValue, rowIndex);
                break;
            }
            case "e_drawerbank": {
                if (EmptyUtil.isNoEmpty((Object)propValue)) {
                    DynamicObject e_drawerBankDy = (DynamicObject)propValue;
                    String union_number = e_drawerBankDy.getString("union_number");
                    this.getModel().setValue("e_drawerbankno", (Object)union_number, rowIndex);
                    break;
                }
                this.getModel().setValue("e_drawerbankno", null, rowIndex);
                break;
            }
            case "e_receiverbank": {
                if (EmptyUtil.isNoEmpty((Object)propValue)) {
                    DynamicObject e_receiverBankDy = (DynamicObject)propValue;
                    String union_number = e_receiverBankDy.getString("union_number");
                    this.getModel().setValue("e_receiverbankno", (Object)union_number, rowIndex);
                    break;
                }
                this.getModel().setValue("e_receiverbankno", null, rowIndex);
                break;
            }
            case "e_accepterbank": {
                if (EmptyUtil.isNoEmpty((Object)propValue)) {
                    DynamicObject e_accpterBankDy = (DynamicObject)propValue;
                    String union_number = e_accpterBankDy.getString("union_number");
                    String name = e_accpterBankDy.getString("name");
                    this.getModel().setValue("e_accepterbankno", (Object)union_number, rowIndex);
                    this.getModel().setValue("e_acceptername", (Object)name, rowIndex);
                    break;
                }
                this.getModel().setValue("e_accepterbankno", null, rowIndex);
                this.getModel().setValue("e_acceptername", null, rowIndex);
                break;
            }
            case "e_drafttype": {
                String draftType = (String)propValue;
                if ("AC01".equals(draftType) || !"AC02".equals(draftType)) break;
                this.getModel().setValue("e_accepterbebank", null, rowIndex);
                this.getModel().setValue("e_accepteraccount", null, rowIndex);
                break;
            }
            case "e_accepterbebank": {
                if (EmptyUtil.isNoEmpty((Object)propValue)) {
                    String draftTypeStr = (String)this.getModel().getValue("e_drafttype", rowIndex);
                    if (!"AC01".equals(draftTypeStr)) break;
                    DynamicObject e_accpterBeBankDy = (DynamicObject)propValue;
                    this.getModel().setValue("e_accepteraccount", null, rowIndex);
                    this.getModel().setValue("e_accepterbank", (Object)e_accpterBeBankDy.getLong("id"), rowIndex);
                    break;
                }
                this.getModel().setValue("e_accepterbank", null, rowIndex);
                break;
            }
            case "e_transferflag": {
                String e_transferflag = (String)propValue;
                if ("EM00".equalsIgnoreCase(e_transferflag)) {
                    this.getModel().setValue("e_cirstatus", (Object)EleDraftCirStatusEnum.TF0301.getValue(), rowIndex);
                    break;
                }
                if (!"EM01".equalsIgnoreCase(e_transferflag)) break;
                this.getModel().setValue("e_cirstatus", (Object)EleDraftCirStatusEnum.TF0303.getValue(), rowIndex);
                break;
            }
            case "datadate": {
                Date dateData = (Date)propValue;
                if (null == dateData) break;
                Date newDate = DateUtils.stringToDate((String)DateUtils.formatString((Date)dateData, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                this.skipPropChange = true;
                this.getModel().setValue("datadate", (Object)newDate);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.reSetAllAmount();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bankdraftentry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
            int size = entryEntity.size();
            this.getModel().setValue("count", (Object)size);
            int index = size - 1;
            long startFlag = (Long)this.getModel().getValue("e_subbillstartflag", index);
            long endFlag = (Long)this.getModel().getValue("e_subbillendflag", index);
            boolean isSplit = (Boolean)this.getModel().getValue("e_issplit", index);
            if (isSplit) {
                this.getModel().setValue("e_subbillrange", (Object)(startFlag + "-" + endFlag), index);
            } else {
                this.getModel().setValue("e_subbillrange", (Object)"0", index);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.reSetAllAmount();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bankdraftentry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
            this.getModel().setValue("count", (Object)entryEntity.size());
        } else {
            this.getModel().setValue("count", (Object)0);
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        super.afterDeleteEntry(e);
        this.getModel().setValue("totalamount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("count", (Object)0);
    }

    private void reSetAllAmount() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("bankdraftentry");
        BigDecimal allAmount = entryEntity.stream().filter(e1 -> EmptyUtil.isNoEmpty((BigDecimal)e1.getBigDecimal("e_draftamount"))).map(o -> o.getBigDecimal("e_draftamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("totalamount", (Object)allAmount);
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        String operateKey = arg.getOperateKey();
        if ("save".equalsIgnoreCase(operateKey)) {
            this.getView().updateView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "newentry": {
                int count = (Integer)this.getModel().getValue("count");
                if (count != 0) {
                    return;
                }
                boolean isOrgEmpty = EmptyUtil.isEmpty((Object)this.getModel().getValue("org"));
                boolean isBankAcc = EmptyUtil.isEmpty((Object)this.getModel().getValue("bankaccount"));
                boolean isDataDate = EmptyUtil.isEmpty((Object)this.getModel().getValue("datadate"));
                boolean isCurrency = EmptyUtil.isEmpty((Object)this.getModel().getValue("billcurrency"));
                boolean isBizType = EmptyUtil.isEmpty((Object)this.getModel().getValue("biztype"));
                StringJoiner stringJoiner = new StringJoiner(",");
                if (isOrgEmpty) {
                    stringJoiner.add(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7", (String)"BankDraftsEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                }
                if (isBankAcc) {
                    stringJoiner.add(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"BankDraftsEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                }
                if (isDataDate) {
                    stringJoiner.add(ResManager.loadKDString((String)"\u6570\u636e\u65e5\u671f", (String)"BankDraftsEdit_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                }
                if (isCurrency) {
                    stringJoiner.add(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BankDraftsEdit_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                }
                if (isBizType) {
                    stringJoiner.add(ResManager.loadKDString((String)"\u7968\u636e\u4e1a\u52a1\u5206\u7c7b", (String)"BankDraftsEdit_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                }
                if (!EmptyUtil.isNoEmpty((Object)stringJoiner) || stringJoiner.length() <= 0) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199 %s\u3002", (String)"BankDraftsEdit_10", (String)"fi-cas-formplugin", (Object[])new Object[0]), stringJoiner));
                args.setCancel(true);
                return;
            }
        }
    }

    private void headCurrencyListener() {
        Object bankAcc = this.getModel().getValue("bankaccount");
        if (null != bankAcc) {
            BasedataEdit headCurr = (BasedataEdit)this.getControl("billcurrency");
            DynamicObjectCollection currencyList = ((DynamicObject)bankAcc).getDynamicObjectCollection("currency");
            if (currencyList.size() > 0) {
                HashSet<Long> itemSet = new HashSet<Long>(16);
                for (DynamicObject currency : currencyList) {
                    if (!EmptyUtil.isNoEmpty((DynamicObject)currency.getDynamicObject("fbasedataid"))) continue;
                    itemSet.add(currency.getDynamicObject("fbasedataid").getLong("id"));
                }
                headCurr.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    parameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)itemSet));
                });
            }
        }
    }
}

