/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billsInventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.property.TmcTreeNodeProp;
import kd.tmc.fbp.common.property.TmcTreeNodeRefProp;
import kd.tmc.fbp.common.property.TmcTreeNodeTypeProp;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.tree.AbstractTmcTreeList;

public class BankDraftsTreeList
extends AbstractTmcTreeList {
    private static final Log logger = LogFactory.getLog(BankDraftsTreeList.class);
    private static final TmcTreeNodeTypeProp NODE_ORG = new TmcTreeNodeTypeProp("org", TmcTreeNodeTypeProp.ROOT, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    private static final TmcTreeNodeTypeProp NODE_ACCOUNT_CURRENCY = new TmcTreeNodeTypeProp("account_currey", NODE_ORG, TmcTreeNodeTypeProp.LeafMode.LEAF);
    protected List<Object> selectedOrgIdList = new ArrayList<Object>();
    protected List<Object> selectedAcctIdList = new ArrayList<Object>();
    protected DynamicObject[] acctsShow;
    private FilterContainerInitArgs initArgs;
    protected boolean isSearchClick;

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter")) {
            Object filterValue;
            String currChangeProp;
            Map currentCommonFilter = args.getCurrentCommonFilter();
            boolean isNeedClearCurr = false;
            if (currentCommonFilter != null && EmptyUtil.isNoEmpty((String)(currChangeProp = ((List)currentCommonFilter.get("FieldName")).get(0).toString())) && (this.isOrgFilterColumn(currChangeProp) || this.isBankAccountFilterColumn(currChangeProp))) {
                isNeedClearCurr = true;
            }
            if (EmptyUtil.isNoEmpty((Object)(filterValue = args.getFilterValue("billcurrency.id"))) && isNeedClearCurr) {
                ((List)args.getFilterValues().get("customfilter")).removeIf(e -> ((List)e.get("FieldName")).get(0).equals("billcurrency.id"));
            }
            this.cacheCommonFilter(this.getPageCache(), args.getSearchClickEvent());
            this.isSearchClick = true;
            this.filterContainerInit(this.initArgs);
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        if (this.getTreeListView() == null) {
            logger.info("this.getTreeListView()==null return filterContainerAfterSearchClick");
            return;
        }
        this.getTreeModel().getRoot().setChildren(null);
        this.getTreeListView().getTreeView().queryTreeNodeChildren("", this.getTreeModel().getRoot().getId());
        this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
    }

    protected List<TmcTreeNodeTypeProp> getTreeNodeTypeList() {
        return Arrays.asList(NODE_ORG, NODE_ACCOUNT_CURRENCY);
    }

    protected List<TmcTreeNodeRefProp> loadTreeNodeList(TmcTreeNodeProp currNode) {
        List<Object> nodeList = new ArrayList();
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        if (nodeType.equals((Object)TmcTreeNodeTypeProp.ROOT)) {
            nodeList = this.loadOrgNodeList();
        } else if (nodeType.equals((Object)NODE_ORG)) {
            nodeList = this.loadAccAndCurrNodeList(currNode);
        }
        return nodeList;
    }

    protected QFilter getBillListFilter(TmcTreeNodeProp currNode) {
        QFilter qfilter = null;
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        if (NODE_ORG.equals((Object)nodeType)) {
            qfilter = new QFilter("org", "in", (Object)Long.valueOf(currNode.getRefEntityPkValue().toString()));
        } else if (NODE_ACCOUNT_CURRENCY.equals((Object)nodeType)) {
            Object orgId = currNode.getParentRefEntityPkValue(NODE_ORG);
            Object accountBankIdStr = currNode.getParentRefEntityPkValue(NODE_ACCOUNT_CURRENCY);
            String[] idArr = accountBankIdStr.toString().split("_", -1);
            if (null != idArr) {
                qfilter = idArr.length > 1 ? new QFilter("org", "=", (Object)Long.valueOf(orgId.toString())).and("bankaccount", "=", (Object)Long.valueOf(idArr[0])).and("billcurrency", "=", (Object)Long.valueOf(idArr[1])) : new QFilter("org", "=", (Object)Long.valueOf(orgId.toString())).and("bankaccount", "=", (Object)Long.valueOf(idArr[0]));
            }
        }
        return qfilter;
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1", "flexpanel_treebtn"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        if (this.getPageCache().get("isPageOpen") == null) {
            logger.info("isPageOpen");
            this.getPageCache().put("isPageOpen", "true");
            this.cacheFirstSelectedOrg(args);
            this.initFilterItems(args);
        } else {
            logger.info("isPageOpen" + this.isSearchClick);
            if (this.isSearchClick) {
                this.initFilterItems(args);
            }
        }
    }

    protected List<Long> getAllOrgIdList(FilterContainerInitArgs args) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            if (!this.isOrgFilterColumn(commonFilterColumn.getFieldName())) continue;
            List orgItems = commonFilterColumn.getComboItems();
            for (int i = 0; i < orgItems.size(); ++i) {
                ComboItem item = (ComboItem)orgItems.get(i);
                if (item.getValue().equals("")) continue;
                orgIdList.add(Long.valueOf(item.getValue()));
            }
        }
        return orgIdList;
    }

    protected boolean isOrgFilterColumn(String filterColumnName) {
        return filterColumnName.startsWith("org.");
    }

    protected void initFilterItems(FilterContainerInitArgs args) {
        if (this.selectedOrgIdList.size() < 1) {
            this.selectedOrgIdList.addAll(this.getAllOrgIdList(args));
        }
        logger.info("selectedOrgIdList size:" + this.selectedOrgIdList.size());
        this.acctsShow = this.getAcctsShowByOrg(this.selectedOrgIdList);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            logger.info("add fieldName: " + fieldName);
            if (this.isOrgFilterColumn(fieldName)) {
                logger.info("add buxian ");
                commonFilterColumn.getComboItems().add(new ComboItem(new LocaleString(""), "0"));
            }
            if (!fieldName.startsWith("billcurrency.")) continue;
            List<ComboItem> currencyItems = this.getCurrencyItems();
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            commonFilterColumn.setComboItems(currencyItems);
            FilterColumn billcurrencyColum = args.getFilterColumn("billcurrency.name");
            billcurrencyColum.setDefaultValue("");
        }
    }

    protected DynamicObject[] getAcctsShowByOrg(List<Object> selectedOrgIdList) {
        DynamicObject[] acctsShow = null;
        List orgPks = selectedOrgIdList.stream().map(orgId -> Long.parseLong(orgId.toString())).collect(Collectors.toList());
        QFilter[] accountFilter = null;
        QFilter accountAuthAssignFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", new ArrayList(orgPks), (boolean)true);
        accountFilter = new QFilter[]{accountAuthAssignFilter};
        ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
        Collections.addAll(qFilterArrayList, accountFilter);
        qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        accountFilter = qFilterArrayList.toArray(new QFilter[qFilterArrayList.size()]);
        acctsShow = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,name,number,ismulcurrency,defaultcurrency.id,defaultcurrency.name,currency.fbasedataid.*", (QFilter[])accountFilter);
        return acctsShow;
    }

    protected List<ComboItem> getCurrencyItems() {
        ArrayList<ComboItem> currencyItems = new ArrayList<ComboItem>();
        DynamicObject[] coll = null;
        coll = this.selectedAcctIdList.isEmpty() ? this.acctsShow : this.getAcctsShow(this.selectedAcctIdList);
        if (coll != null && coll.length > 0) {
            for (int i = 0; i < coll.length; ++i) {
                DynamicObject cashAcct = coll[i];
                if (!cashAcct.getBoolean("ismulcurrency")) {
                    DynamicObject defaultCurrency = cashAcct.getDynamicObject("defaultcurrency");
                    if (defaultCurrency == null) continue;
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(defaultCurrency.getString("name")));
                    item.setValue(defaultCurrency.getString("id"));
                    if (currencyItems.contains(item)) continue;
                    currencyItems.add(item);
                    continue;
                }
                DynamicObjectCollection currencyList = cashAcct.getDynamicObjectCollection("currency");
                if (currencyList.size() <= 0) continue;
                for (DynamicObject currency : currencyList) {
                    ComboItem item = new ComboItem();
                    if (!EmptyUtil.isNoEmpty((DynamicObject)currency.getDynamicObject("fbasedataid"))) continue;
                    item.setCaption(new LocaleString(currency.getDynamicObject("fbasedataid").getString("name")));
                    item.setValue(currency.getDynamicObject("fbasedataid").getString("id"));
                    if (currencyItems.contains(item)) continue;
                    currencyItems.add(item);
                }
            }
        } else {
            currencyItems.add(new ComboItem(new LocaleString(""), "0"));
        }
        return currencyItems;
    }

    private List<TmcTreeNodeRefProp> loadAccAndCurrNodeList(TmcTreeNodeProp currNode) {
        ArrayList<TmcTreeNodeRefProp> modelList = new ArrayList<TmcTreeNodeRefProp>(16);
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        String orgId = (String)currNode.getParentRefEntityPkValue(nodeType);
        if (orgId == null || orgId.equals("null")) {
            return modelList;
        }
        QFilter statusFilter = new QFilter("acctstatus", "!=", (Object)"closed");
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)Long.valueOf(orgId));
        DynamicObject[] bd_accountbanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,company,currency,ismulcurrency,bankaccountnumber,defaultcurrency", (QFilter[])new QFilter[]{qFilter, statusFilter});
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(16);
        for (DynamicObject accounts : bd_accountbanks) {
            String bankAccountNumber = accounts.getString("bankaccountnumber");
            DynamicObjectCollection currencys = accounts.getDynamicObjectCollection("currency");
            for (DynamicObject currency : currencys) {
                TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
                DynamicObject fbasedataid = currency.getDynamicObject("fbasedataid");
                if (!EmptyUtil.isNoEmpty((DynamicObject)fbasedataid)) continue;
                String curreyName = fbasedataid.getString("name");
                node.setNodeName(bankAccountNumber + "_" + curreyName);
                node.setNodeType(NODE_ACCOUNT_CURRENCY);
                String accId = accounts.getString("id");
                String currId = fbasedataid.getString("id");
                node.setRefEntityPkValue((Object)(accId + "_" + currId));
                nodeList.add(node);
            }
        }
        return nodeList;
    }

    private List<TmcTreeNodeRefProp> loadOrgNodeList() {
        String orgIdStr = this.getPageCache().get("org.id");
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        if (EmptyUtil.isNoEmpty((String)orgIdStr)) {
            if (orgIdStr.contains(",")) {
                String[] orgIdStrArr;
                for (String orgId : orgIdStrArr = orgIdStr.split(",", -1)) {
                    if (!EmptyUtil.isNoEmpty((String)orgId)) continue;
                    orgIdSet.add(Long.parseLong(orgId));
                }
            } else {
                orgIdSet.add(Long.parseLong(orgIdStr));
            }
        } else {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cdm_bankdrafts", (String)"47150e89000000ac");
            orgIdSet = new HashSet(authOrgIds);
        }
        DynamicObject[] orgDys = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIdSet)});
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(16);
        for (DynamicObject orgDy : orgDys) {
            TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
            node.setNodeName(orgDy.getString("name"));
            node.setNodeType(NODE_ORG);
            node.setRefEntityPkValue((Object)orgDy.getString("id"));
            nodeList.add(node);
        }
        return nodeList;
    }

    protected boolean isDefaultOpen() {
        ListShowParameter parameters = (ListShowParameter)this.getView().getFormShowParameter();
        return parameters.getCustomParam("setDefaultFilters") == null;
    }

    protected void cacheFirstSelectedOrg(FilterContainerInitArgs args) {
        String firstOrgId = null;
        if (this.isDefaultOpen()) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                List orgItems;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                if (!this.isOrgFilterColumn(commonFilterColumn.getFieldName()) || (orgItems = commonFilterColumn.getComboItems()) == null || orgItems.size() <= 0) continue;
                String loginOrg = String.valueOf(RequestContext.get().getOrgId());
                for (int i = 0; i < orgItems.size(); ++i) {
                    ComboItem item = (ComboItem)orgItems.get(i);
                    if (!item.getValue().equals(loginOrg)) continue;
                    firstOrgId = loginOrg;
                    break;
                }
                if (firstOrgId != null) continue;
                List defaultVals = commonFilterColumn.getDefaultValues();
                if (defaultVals != null && defaultVals.size() > 0) {
                    firstOrgId = (String)defaultVals.get(0);
                    continue;
                }
                firstOrgId = ((ComboItem)orgItems.get(0)).getValue();
            }
        } else {
            firstOrgId = this.getView().getFormShowParameter().getCustomParam("org.id").toString();
        }
        if (firstOrgId != null) {
            this.selectedOrgIdList.add(firstOrgId);
        }
        this.cacheSelectedOrgIdList(this.selectedOrgIdList);
        this.getPageCache().put("org.id", firstOrgId);
    }

    protected void cacheSelectedOrgIdList(List<Object> selectedOrgIdList) {
        if (selectedOrgIdList != null) {
            this.getPageCache().put("selectedOrgIdList", SerializationUtils.toJsonString(selectedOrgIdList));
        } else {
            this.getPageCache().put("selectedOrgIdList", null);
        }
    }

    protected DynamicObject[] getAcctsShow(Collection<Object> acctIds) {
        DynamicObject[] acctsShow = null;
        if (acctIds != null && acctIds.size() > 0) {
            List<Long> acctIdsNew = acctIds.stream().map(o -> Long.parseLong(String.valueOf(o).trim())).collect(Collectors.toList());
            acctsShow = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,name,acctname,number,ismulcurrency,defaultcurrency.id,defaultcurrency.name,currency.fbasedataid.*", (QFilter[])this.getAcctFilter(acctIdsNew));
        }
        return acctsShow;
    }

    protected QFilter[] getAcctFilter(List<Long> acctIds) {
        return new QFilter[]{new QFilter("id", "in", acctIds)};
    }

    private void cacheCommonFilter(IPageCache pageCache, SearchClickEvent searchClickEvent) {
        if (pageCache != null && searchClickEvent.getFilterValues() != null) {
            this.selectedOrgIdList.clear();
            this.selectedAcctIdList.clear();
            pageCache.remove("org.id");
            Map orgFilter = null;
            Map acctFilter = null;
            List customfilter = (List)searchClickEvent.getFilterValues().get("customfilter");
            if (customfilter != null) {
                for (Map filteritem : customfilter) {
                    String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                    List item = (List)filteritem.get("Value");
                    if (this.isOrgFilterColumn(fieldName)) {
                        orgFilter = filteritem;
                        if (item.isEmpty() || "".equals(item.get(0))) continue;
                        String fieldValue = item.get(0).toString();
                        pageCache.put(fieldName, fieldValue);
                        this.selectedOrgIdList = item;
                        continue;
                    }
                    if (!this.isBankAccountFilterColumn(fieldName)) continue;
                    acctFilter = filteritem;
                    if (item.isEmpty() || "".equals(item.get(0))) continue;
                    this.selectedAcctIdList = item;
                }
                if (orgFilter == null) {
                    if (this.getCachedOrgList() != null) {
                        this.orgCommonFilterChange(acctFilter);
                    }
                    this.cacheSelectedOrgIdList(null);
                } else {
                    List values = (List)orgFilter.get("Value");
                    List cacheOrg = CollectionUtils.isEmpty(this.getCachedOrgList()) ? Collections.emptyList() : this.getCachedOrgList().stream().filter(v -> null != v && !v.toString().equals("")).collect(Collectors.toList());
                    List orgs = values.stream().filter(v -> null != v && !v.toString().equals("")).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(cacheOrg) && !cacheOrg.equals(orgs)) {
                        this.orgCommonFilterChange(acctFilter);
                    }
                    this.cacheSelectedOrgIdList(values);
                }
            }
        }
    }

    protected boolean isBankAccountFilterColumn(String filterColumnName) {
        return filterColumnName.startsWith("accountbank.") || filterColumnName.startsWith("bankaccount.");
    }

    protected List<Object> getCachedOrgList() {
        if (this.getPageCache().get("selectedOrgIdList") != null) {
            return (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selectedOrgIdList"), List.class);
        }
        return null;
    }

    protected void orgCommonFilterChange(Map<String, List<Object>> acctFilter) {
        if (acctFilter != null) {
            ArrayList<String> acctList = new ArrayList<String>();
            acctList.add("");
            acctFilter.put("Value", acctList);
            this.selectedAcctIdList.clear();
        }
    }
}

