/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billsInventory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.PayeeTypeEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ChequeFilledAddEdit
extends AbstractFormPlugin
implements ListRowClickListener {
    private static Log logger = LogFactory.getLog(ChequeFilledAddEdit.class);
    private boolean skipPropChange;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.authorizedCompanyListener();
        this.addAccountListener();
        this.receiverRegisterListener();
        this.addCurrencyListener();
    }

    private void addAccountListener() {
        BasedataEdit bankAccount = (BasedataEdit)this.getControl("accountbank");
        if (Objects.nonNull(bankAccount)) {
            bankAccount.addBeforeF7SelectListener(evt -> {
                ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                DynamicObject orgDy = (DynamicObject)this.getModel().getValue("org");
                if (EmptyUtil.isEmpty((DynamicObject)orgDy)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"DraftsInventoryEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    evt.setCancel(true);
                    return;
                }
                ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
                if (!Objects.nonNull(currency)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"DraftsInventoryEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    evt.setCancel(true);
                    return;
                }
                QFilter companyFilter = new QFilter("acctstatus", "!=", (Object)"closed");
                companyFilter.and(new QFilter("currency.fbasedataid", "=", currency.getPkValue()));
                listFilterParameter.getQFilters().add(companyFilter);
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object org = this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((Object)org)) {
            RequestContext requestContext = RequestContext.get();
            long orgId = requestContext.getOrgId();
            MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
            DynamicObject currentOrg = BusinessDataServiceHelper.loadSingle((Object)orgId, (DynamicObjectType)orgType);
            if (currentOrg.getBoolean("fisbankroll")) {
                this.getModel().setValue("org", (Object)orgId);
                long standardCurrency = DraftHelper.getMainCurrByOrg((DynamicObject)currentOrg);
                if (0L != standardCurrency) {
                    this.getModel().setValue("currency", (Object)standardCurrency);
                }
            }
        }
        boolean isInvalid = (Boolean)this.getModel().getValue("isinvalid");
        ((FieldEdit)this.getView().getControl("payamount")).setMustInput(!isInvalid);
        Object payeetype = this.getModel().getValue("payeetype");
        if (EmptyUtil.isEmpty((Object)payeetype)) {
            this.getModel().setValue("payeetype", (Object)"bd_supplier");
            this.getModel().setValue("receivertype", (Object)"bd_supplier");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.skipPropChange) {
            this.skipPropChange = false;
            return;
        }
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object propValue = changeData[0].getNewValue();
        switch (key) {
            case "org": {
                DynamicObject currentOrg;
                long standardCurrency;
                this.getModel().setValue("accountbank", null);
                Object org = this.getModel().getValue("org");
                if (!EmptyUtil.isNoEmpty((Object)org) || 0L == (standardCurrency = DraftHelper.getMainCurrByOrg((DynamicObject)(currentOrg = (DynamicObject)org)))) break;
                this.getModel().setValue("currency", (Object)standardCurrency);
                break;
            }
            case "isinvalid": {
                boolean isInvalid = (Boolean)this.getModel().getValue("isinvalid");
                ((FieldEdit)this.getView().getControl("payamount")).setMustInput(!isInvalid);
                if (!isInvalid) break;
                this.getModel().setValue("payamount", (Object)BigDecimal.ZERO);
                break;
            }
            case "payeetype": {
                if (null == propValue || "other".equals(propValue)) {
                    this.getModel().setValue("receivertype", null);
                } else {
                    this.getModel().setValue("receivertype", propValue);
                }
                this.getModel().setValue("receiver", null);
                this.getModel().setValue("receivername", null);
                break;
            }
            case "currency": {
                this.getModel().setValue("accountbank", null);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("confirm".equals(operateKey)) {
            boolean isinvalid = (Boolean)this.getModel().getValue("isinvalid");
            BigDecimal payAmount = (BigDecimal)this.getModel().getValue("payamount");
            if (!isinvalid && EmptyUtil.isEmpty((BigDecimal)payAmount)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u586b\u5f00\u91d1\u989d\u3002", (String)"ChequeFilledAddEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String isfromChequelist = (String)fsp.getCustomParam("isfromchequelist");
        if (EmptyUtil.isEmpty((String)isfromChequelist)) {
            return;
        }
        if ("confirm".equals(operateKey) && e.getOperationResult().isSuccess()) {
            this.updateDBInfoBy();
        }
    }

    private void updateDBInfoBy() {
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(16);
        DynamicObject formCheque = this.getModel().getDataEntity();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String inventorydateStr = (String)fsp.getCustomParam("inventorydate");
        Date inventoryDate = DateUtils.stringToDate((String)inventorydateStr, (String)"yyyy-MM-dd");
        boolean isinvalid = (Boolean)this.getModel().getValue("isinvalid");
        DynamicObject saveCheque = this.setInfo(formCheque, inventoryDate, isinvalid);
        newList.add(saveCheque);
        if (!newList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])newList.toArray(new DynamicObject[0]));
            String isfromChequelist = (String)fsp.getCustomParam("isfromchequelist");
            if (EmptyUtil.isNoEmpty((String)isfromChequelist)) {
                long cheuqeInventoryId = Long.parseLong(isfromChequelist);
                DynamicObject[] chequeActualDy = BusinessDataServiceHelper.load((String)"cdm_chequeinventory", (String)"id,filledactual_ncd_entry,filledactual_ncd_entry.e_ncd_fiillactual,filledacutaiamount,filledactualcount,filledchequeamount,filledchequecount,filleddiffamount,filledactual_cd_entry,filledactual_cd_entry.e_cd_filledactual", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cheuqeInventoryId)});
                DynamicObject filledCheuqeDy = chequeActualDy[0];
                DynamicObjectCollection blancAcutalNcdEntry = filledCheuqeDy.getDynamicObjectCollection("filledactual_ncd_entry");
                DynamicObjectCollection blancAcutalcdEntry = filledCheuqeDy.getDynamicObjectCollection("filledactual_cd_entry");
                BigDecimal filledacutalAmount = filledCheuqeDy.getBigDecimal("filledacutaiamount");
                for (DynamicObject actualDy : newList) {
                    DynamicObject entry = blancAcutalNcdEntry.addNew();
                    entry.set("e_ncd_fiillactual", (Object)actualDy);
                    filledacutalAmount = filledacutalAmount.add(actualDy.getBigDecimal("payamount"));
                }
                BigDecimal fillcdAmountSum = blancAcutalcdEntry.stream().filter(e -> null != e.getDynamicObject("e_cd_filledactual")).map(e -> e.getDynamicObject("e_cd_filledactual").getBigDecimal("payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal fillActualAmount = filledacutalAmount.add(fillcdAmountSum);
                BigDecimal filledchequeAmount = filledCheuqeDy.getBigDecimal("filledchequeamount");
                int size = blancAcutalNcdEntry.size();
                int cdSize = blancAcutalcdEntry.size();
                int fillActualCount = size + cdSize;
                filledCheuqeDy.set("filledactualcount", (Object)fillActualCount);
                filledCheuqeDy.set("filledacutaiamount", (Object)fillActualAmount);
                filledCheuqeDy.set("filleddiffamount", (Object)fillActualAmount.subtract(filledchequeAmount));
                SaveServiceHelper.save((DynamicObject[])chequeActualDy);
            }
            ParamMap paramMap = new ParamMap();
            this.getView().returnDataToParent((Object)paramMap);
            this.getView().close();
        }
    }

    private DynamicObject setInfo(DynamicObject formCheque, Date inventoryDate, boolean isinvalid) {
        StringJoiner stringJoiner = new StringJoiner(",");
        long pkId = DB.genGlobalLongId();
        stringJoiner.add(String.valueOf(pkId));
        DynamicObject saveCheque = BusinessDataServiceHelper.newDynamicObject((String)"cdm_actualchequef7");
        if (isinvalid) {
            saveCheque.set("chequestatus", (Object)"invalid");
        } else {
            saveCheque.set("chequestatus", (Object)"used");
        }
        saveCheque.set("id", (Object)pkId);
        saveCheque.set("org", (Object)formCheque.getDynamicObject("org"));
        saveCheque.set("purchuser", (Object)formCheque.getDynamicObject("purchase"));
        saveCheque.set("inventorystatus", (Object)"B");
        saveCheque.set("checkstatus", (Object)"A");
        DynamicObject accountBank = formCheque.getDynamicObject("accountbank");
        saveCheque.set("accountbank", (Object)accountBank);
        saveCheque.set("bank", (Object)accountBank.getDynamicObject("bank"));
        saveCheque.set("currency", (Object)formCheque.getDynamicObject("currency"));
        Date payDate = formCheque.getDate("paydate");
        if (null != payDate) {
            Date payDateNew = DateUtils.stringToDate((String)DateUtils.formatString((Date)payDate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            saveCheque.set("paydate", (Object)payDateNew);
        }
        saveCheque.set("payamount", (Object)formCheque.getBigDecimal("payamount"));
        saveCheque.set("datadate", (Object)inventoryDate);
        saveCheque.set("billno", (Object)formCheque.getString("billno"));
        saveCheque.set("payeetype", (Object)formCheque.getString("payeetype"));
        saveCheque.set("receivertype", (Object)formCheque.getString("receivertype"));
        saveCheque.set("receiver", (Object)formCheque.getDynamicObject("receiver"));
        saveCheque.set("receivername", (Object)formCheque.getString("receivername"));
        Date purchDate = formCheque.getDate("purchdate");
        if (null != purchDate) {
            Date purchDateNew = DateUtils.stringToDate((String)DateUtils.formatString((Date)purchDate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            saveCheque.set("purchdate", (Object)purchDateNew);
        }
        return saveCheque;
    }

    private void receiverRegisterListener() {
        if (this.getModel().getProperty("receiver") != null) {
            BasedataEdit receiver = (BasedataEdit)this.getControl("receiver");
            String payeetype = this.getModel().getValue("payeetype") == null ? "" : this.getModel().getValue("payeetype").toString();
            Object receiverTypeStr = this.getModel().getValue("receivertype");
            if (EmptyUtil.isNoEmpty((String)payeetype) && EmptyUtil.isEmpty((Object)receiverTypeStr)) {
                this.getModel().setValue("receivertype", (Object)payeetype);
            }
            if (receiver != null) {
                receiver.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    if (EmptyUtil.isEmpty((String)payeetype)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"ChequeFilledAddEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                        beforeF7SelectEvent.setCancel(true);
                        return;
                    }
                    if (StringUtils.equals((CharSequence)payeetype, (CharSequence)PayeeTypeEnum.BOS_ORG.getValue())) {
                        QFilter filter = new QFilter("fisbankroll", "=", (Object)"1");
                        showParameter.setCustomParam("orgFuncId", (Object)"08");
                        List qfilter = showParameter.getListFilterParameter().getQFilters();
                        qfilter.add(filter);
                    }
                });
            }
        }
    }

    private void authorizedCompanyListener() {
        BasedataEdit company = (BasedataEdit)this.getControl("org");
        company.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            DynamicObjectCollection orgDOC = TmcOrgDataHelper.getAuthorizedBankOrg((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cdm_chequeinventory", (String)"47156aff000000ac");
            List orgList = TmcOrgDataHelper.getIdList((DynamicObjectCollection)orgDOC);
            showParameter.setCustomParam("range", (Object)orgList);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
        });
    }

    private void addCurrencyListener() {
        BasedataEdit bankCurrency = (BasedataEdit)this.getControl("currency");
        if (Objects.nonNull(bankCurrency)) {
            bankCurrency.addBeforeF7SelectListener(evt -> {
                ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
                DynamicObject bankAcc = (DynamicObject)this.getModel().getValue("accountbank");
                DynamicObject orgDy = (DynamicObject)this.getModel().getValue("org");
                if (EmptyUtil.isEmpty((DynamicObject)orgDy)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"DraftsInventoryEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    evt.setCancel(true);
                    return;
                }
                ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
                if (Objects.nonNull(bankAcc)) {
                    Set bankAccCurrIdSet = bankAcc.getDynamicObjectCollection("currency").stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("fbasedataid"))).map(e -> e.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    listFilterParameter.getQFilters().add(new QFilter("id", "in", bankAccCurrIdSet));
                }
            });
        }
    }
}

