/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billsInventory;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.formplugin.billsInventory.BussinessDraftsInventoryList;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class ChequeInventoryList
extends AbstractTmcBillBaseList {
    private static final Log logger = LogFactory.getLog(BussinessDraftsInventoryList.class);
    private static final String ACTIONKEY = "cdm_chequeinventory_back";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        switch (itemKey) {
            case "tblnew": {
                FormShowParameter para = new FormShowParameter();
                para.setCustomParam("isfromchequelist", (Object)"y");
                para.setFormId("cdm_chequeinventoryrange");
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONKEY));
                para.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(para);
                break;
            }
            case "tblsubmit": 
            case "tblunsubmit": {
                boolean amountNotMatch;
                if (!EmptyUtil.isNoEmpty((Object)selectedRows)) break;
                Set dataSet = selectedRows.parallelStream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                if (dataSet.size() > 1) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BussinessDraftsInventoryList_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Set idsSet = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                QFilter qFilter1 = new QFilter("id", "in", idsSet);
                DynamicObjectCollection inventoryBillList = QueryServiceHelper.query((String)"cdm_chequeinventory", (String)"id,billno,blankdifferecount,filleddiffamount", (QFilter[])new QFilter[]{qFilter1});
                HashSet<Long> countCheckSet = new HashSet<Long>(16);
                HashSet<Long> amountCheckSet = new HashSet<Long>(16);
                for (DynamicObject inventoryBillL : inventoryBillList) {
                    boolean isNotNullFilledDiffAmount;
                    int blankDiffCount = inventoryBillL.getInt("blankdifferecount");
                    BigDecimal filleddiffereAmount = inventoryBillL.getBigDecimal("filleddiffamount");
                    long id = inventoryBillL.getLong("id");
                    boolean isNotNullBlankDifCount = blankDiffCount != 0;
                    boolean bl = isNotNullFilledDiffAmount = EmptyUtil.isNoEmpty((BigDecimal)filleddiffereAmount) && BigDecimal.ZERO.compareTo(filleddiffereAmount) != 0;
                    if (isNotNullBlankDifCount) {
                        countCheckSet.add(id);
                    }
                    if (!isNotNullFilledDiffAmount) continue;
                    amountCheckSet.add(id);
                }
                boolean countNotMatch = countCheckSet.size() > 0;
                boolean bl = amountNotMatch = amountCheckSet.size() > 0;
                if (countNotMatch && amountNotMatch) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7a7a\u767d\u7968\u636e\u76d8\u70b9\u4ee5\u53ca\u5df2\u586b\u5f00\u7968\u636e\u76d8\u70b9\u5b58\u5728\u5dee\u5f02\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"ChequeInventoryEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(itemKey, (IFormPlugin)this));
                    break;
                }
                if (countNotMatch && !amountNotMatch) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7a7a\u767d\u7968\u636e\u76d8\u70b9\u5b58\u5728\u5dee\u5f02\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"ChequeInventoryEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(itemKey, (IFormPlugin)this));
                    break;
                }
                if (!countNotMatch && amountNotMatch) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u586b\u5f00\u7968\u636e\u76d8\u70b9\u5b58\u5728\u5dee\u5f02\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"ChequeInventoryEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(itemKey, (IFormPlugin)this));
                    break;
                }
                this.callSubmitOrUnSubmit(itemKey);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String inventoryBillId;
        ParamMap dataMap;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)ACTIONKEY, (CharSequence)actionId) && EmptyUtil.isNoEmpty((Object)(dataMap = (ParamMap)returnData)) && EmptyUtil.isNoEmpty((Object)dataMap.get("inventoryBillId")) && !"0".equals(inventoryBillId = (String)dataMap.get("inventoryBillId"))) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setPkId((Object)inventoryBillId);
            parameter.setFormId("cdm_chequeinventory");
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (e.getResult() == MessageBoxResult.Yes) {
            this.callSubmitOrUnSubmit(callBackId);
        }
    }

    private void callSubmitOrUnSubmit(String callBackId) {
        if ("tblsubmit".equals(callBackId) || "tblunsubmit".equals(callBackId)) {
            OperationResult operationResult;
            OperateOption op;
            if ("tblsubmit".equalsIgnoreCase(callBackId)) {
                op = OperateOption.create();
                operationResult = this.getView().invokeOperation("submit", op);
            }
            if ("tblunsubmit".equalsIgnoreCase(callBackId)) {
                op = OperateOption.create();
                operationResult = this.getView().invokeOperation("unsubmit", op);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("draftinventoryreport".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            Object focusRowPkId = list.getFocusRowPkId();
            DynamicObjectCollection chequeDyColl = QueryServiceHelper.query((String)"cdm_chequeinventory", (String)"id,draftinventoryreportid", (QFilter[])new QFilter[]{new QFilter("id", "=", focusRowPkId)});
            long draftinventoryReportId = ((DynamicObject)chequeDyColl.get(0)).getLong("draftinventoryreportid");
            if (EmptyUtil.isNoEmpty((Long)draftinventoryReportId)) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setFormId("cdm_inventoryresult");
                showParameter.setPkId((Object)draftinventoryReportId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }
}

