/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billtype;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.BillTypeUnitEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;

public class BillTypeEdit
extends AbstractBillPlugIn {
    private boolean isneedcheck = true;

    public void afterCreateNewData(EventObject e) {
        String validitytime = this.getModel().getDataEntity().getString("validitytime");
        String unit = this.getModel().getDataEntity().getString("unit");
        this.getModel().setValue("defaulttime", (Object)validitytime);
        this.getModel().setValue("defaultunit", (Object)unit);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setSelectSettTypeFilter();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valSet = e.getChangeSet();
        Object newValue = valSet[0].getNewValue();
        IDataModel model = this.getModel();
        String defaulttime = model.getDataEntity().getString("defaulttime");
        String validitytime = model.getDataEntity().getString("validitytime");
        String unit = model.getDataEntity().getString("unit");
        String defaultunit = model.getDataEntity().getString("defaultunit");
        switch (propName) {
            case "settlementtype": {
                if (EmptyUtil.isEmpty((Object)newValue)) {
                    this.isneedcheck = false;
                    model.setValue("validitytime", (Object)"");
                    model.setValue("unit", (Object)"");
                    model.setValue("defaulttime", (Object)"");
                    model.setValue("defaultunit", (Object)"");
                    this.isneedcheck = true;
                } else if (StringUtils.equals((String)SettleMentTypeEnum.PROMISSORY.getValue(), (String)newValue.toString())) {
                    this.isneedcheck = false;
                    model.setValue("validitytime", (Object)10);
                    model.setValue("unit", (Object)BillTypeUnitEnum.DAY.getValue());
                    model.setValue("defaulttime", (Object)10);
                    model.setValue("defaultunit", (Object)BillTypeUnitEnum.DAY.getValue());
                    this.isneedcheck = true;
                } else if (StringUtils.equals((String)SettleMentTypeEnum.CHECK.getValue(), (String)newValue.toString())) {
                    this.isneedcheck = false;
                    model.setValue("validitytime", (Object)1);
                    model.setValue("unit", (Object)BillTypeUnitEnum.MONTH.getValue());
                    model.setValue("defaulttime", (Object)1);
                    model.setValue("defaultunit", (Object)BillTypeUnitEnum.MONTH.getValue());
                    this.isneedcheck = true;
                } else if (StringUtils.equals((String)SettleMentTypeEnum.BANK.getValue(), (String)newValue.toString()) && StringUtils.equals((String)model.getValue("billmedium").toString(), (String)BillMediumEnum.ELECTRIC.getValue())) {
                    this.isneedcheck = false;
                    model.setValue("validitytime", (Object)12);
                    model.setValue("unit", (Object)BillTypeUnitEnum.MONTH.getValue());
                    model.setValue("defaulttime", (Object)12);
                    model.setValue("defaultunit", (Object)BillTypeUnitEnum.MONTH.getValue());
                    this.isneedcheck = true;
                } else {
                    this.isneedcheck = false;
                    model.setValue("validitytime", (Object)6);
                    model.setValue("unit", (Object)BillTypeUnitEnum.MONTH.getValue());
                    model.setValue("defaulttime", (Object)6);
                    model.setValue("defaultunit", (Object)BillTypeUnitEnum.MONTH.getValue());
                    this.isneedcheck = true;
                }
                model.setValue("settlementtypebd", null);
                break;
            }
            case "billmedium": {
                if (!StringUtils.equals((String)model.getValue("settlementtype").toString(), (String)SettleMentTypeEnum.BANK.getValue())) break;
                if (StringUtils.equals((String)BillMediumEnum.ELECTRIC.getValue(), (String)newValue.toString())) {
                    this.isneedcheck = false;
                    model.setValue("validitytime", (Object)12);
                    model.setValue("unit", (Object)BillTypeUnitEnum.MONTH.getValue());
                    model.setValue("defaulttime", (Object)12);
                    model.setValue("defaultunit", (Object)BillTypeUnitEnum.MONTH.getValue());
                    this.isneedcheck = true;
                    break;
                }
                this.isneedcheck = false;
                model.setValue("validitytime", (Object)6);
                model.setValue("unit", (Object)BillTypeUnitEnum.MONTH.getValue());
                model.setValue("defaulttime", (Object)6);
                model.setValue("defaultunit", (Object)BillTypeUnitEnum.MONTH.getValue());
                this.isneedcheck = true;
                break;
            }
            case "defaulttime": {
                BigDecimal validitytimeDecimal;
                BigDecimal defaulttimeDecimal;
                if (!this.isneedcheck) {
                    return;
                }
                try {
                    int defaulttimeint = Integer.parseInt(newValue.toString());
                    if (defaulttimeint <= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6709\u6548\u671f\u3001\u6700\u5927\u6709\u6548\u671f\u7684\u8303\u56f4\u5fc5\u987b\u662f\u5927\u4e8e0\u4e14\u5408\u7406\u6574\u6570\u3002", (String)"BillTypeEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                catch (Exception ex) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6709\u6548\u671f\u3001\u6700\u5927\u6709\u6548\u671f\u7684\u8303\u56f4\u5fc5\u987b\u662f\u5927\u4e8e0\u4e14\u5408\u7406\u6574\u6570\u3002", (String)"BillTypeEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!EmptyUtil.isNoEmpty((String)unit) || !EmptyUtil.isNoEmpty((String)defaultunit) || !EmptyUtil.isNoEmpty((String)defaulttime) || !EmptyUtil.isNoEmpty((String)validitytime) || !unit.equals(defaultunit) || (defaulttimeDecimal = new BigDecimal(newValue.toString())).compareTo(validitytimeDecimal = new BigDecimal(validitytime)) <= 0 && defaulttimeDecimal.compareTo(new BigDecimal(0)) != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6709\u6548\u671f\u7684\u8303\u56f4\u5fc5\u987b\u57280\u4e0e\u6700\u5927\u6709\u6548\u671f\u4e4b\u95f4\u3002", (String)"BillTypeEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "defaultunit": {
                model.setValue("unit", (Object)defaultunit);
                break;
            }
            case "validitytime": {
                BigDecimal validitytimeDecimal;
                BigDecimal defaulttimeDecimal;
                if (!this.isneedcheck) {
                    return;
                }
                try {
                    int validitytimeint = Integer.parseInt(newValue.toString());
                    if (validitytimeint <= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6709\u6548\u671f\u3001\u6700\u5927\u6709\u6548\u671f\u7684\u8303\u56f4\u5fc5\u987b\u662f\u5927\u4e8e0\u4e14\u5408\u7406\u6574\u6570\u3002", (String)"BillTypeEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                catch (Exception ex) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6709\u6548\u671f\u3001\u6700\u5927\u6709\u6548\u671f\u7684\u8303\u56f4\u5fc5\u987b\u662f\u5927\u4e8e0\u4e14\u5408\u7406\u6574\u6570\u3002", (String)"BillTypeEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!EmptyUtil.isNoEmpty((String)unit) || !EmptyUtil.isNoEmpty((String)defaultunit) || !EmptyUtil.isNoEmpty((String)defaulttime) || !EmptyUtil.isNoEmpty((String)validitytime) || !unit.equals(defaultunit) || (defaulttimeDecimal = new BigDecimal(defaulttime)).compareTo(validitytimeDecimal = new BigDecimal(newValue.toString())) <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5927\u6709\u6548\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u9ed8\u8ba4\u6709\u6548\u671f\u3002", (String)"BillTypeEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "unit": {
                model.setValue("defaultunit", (Object)unit);
                break;
            }
        }
    }

    private void setSelectSettTypeFilter() {
        BasedataEdit draftBillEdit = (BasedataEdit)this.getControl("settlementtypebd");
        draftBillEdit.addBeforeF7SelectListener(evt -> {
            Object currPk = this.getView().getModel().getDataEntity().getPkValue();
            DynamicObject[] billTypeColl = TmcDataServiceHelper.load((String)"cdm_billtype", (String)"settlementtypebd", (QFilter[])new QFilter[]{new QFilter("id", "!=", currPk)});
            Object o1 = billTypeColl[0].get("settlementtypebd");
            List settTypeIdList = Arrays.stream(billTypeColl).map(e -> e.getDynamicObjectCollection("settlementtypebd")).filter(o -> !CollectionUtils.isEmpty((Collection)o)).flatMap(Collection::stream).map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
            qFilterList.add(new QFilter("settlementtype", "=", this.getModel().getValue("settlementtype")));
            if (!CollectionUtils.isEmpty(settTypeIdList)) {
                qFilterList.add(new QFilter("id", "not in", settTypeIdList));
            }
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            parameter.getListFilterParameter().setQFilters(qFilterList);
        });
    }
}

