/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.cheque;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.SetCellFieldValueArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ChequePurchListPlugin
extends AbstractListPlugin {
    public void beforeItemClick(BeforeItemClickEvent evt) {
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().getOpenStyle().setShowType(ShowType.Modal);
        e.getParameter().setStatus(OperationStatus.EDIT);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!(e.getSource() instanceof BillList)) {
            return;
        }
        BillList billList = (BillList)e.getSource();
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        Map<Object, String> batchMap = this.getCurrentBatchNos(rows);
        if (batchMap == null || batchMap.isEmpty()) {
            return;
        }
        Map<Object, Integer> usedMap = this.getAllUsedAmountBy(batchMap.values());
        if (usedMap == null || usedMap.isEmpty()) {
            return;
        }
        int i = 0;
        for (ListSelectedRow row : rows) {
            String userID = row.getPrimaryKeyValue().toString();
            if (StringUtils.isNotEmpty((CharSequence)userID)) {
                String batchNo = batchMap.get(row.getPrimaryKeyValue());
                if (StringUtils.isEmpty((CharSequence)batchNo)) continue;
                billList.setCellFieldValue("currencylist", i, (Object)usedMap.get(batchNo));
            }
            ++i;
        }
    }

    private Map<Object, String> getCurrentBatchNos(ListSelectedRowCollection rows) {
        if (rows.isEmpty()) {
            return null;
        }
        ArrayList<Object> ids = new ArrayList<Object>(rows.size());
        for (ListSelectedRow row : rows) {
            ids.add(row.getPrimaryKeyValue());
        }
        QFilter idFiter = new QFilter("id", "in", ids);
        DynamicObjectCollection cheuqes = QueryServiceHelper.query((String)"cdm_cheque_purch", (String)"id,batchno", (QFilter[])new QFilter[]{idFiter});
        if (cheuqes == null) {
            return null;
        }
        HashMap<Object, String> map = new HashMap<Object, String>();
        cheuqes.forEach(s -> map.put(s.get("id"), s.getString("batchno")));
        return map;
    }

    private Map<Object, Integer> getAllUsedAmountBy(Collection batchs) {
        QFilter batchFiter = new QFilter("batchno", "in", (Object)batchs);
        QFilter fiter = new QFilter("chequestatus", "!=", (Object)"0");
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        DataSet allDS = QueryServiceHelper.queryDataSet((String)"ChequePurchListPlugin-getAllUsedAmount", (String)"cdm_cheque_purch", (String)"id,billno,batchno,chequestatus", (QFilter[])new QFilter[]{batchFiter, fiter}, null);
        allDS = allDS.select(new String[]{"batchno", "chequestatus"}).groupBy(new String[]{"batchno"}).count("chequestatus").finish();
        for (Row row : allDS) {
            map.put(row.getString("batchno"), row.getInteger("chequestatus"));
        }
        return map;
    }

    public void setCellFieldValue(SetCellFieldValueArgs args) {
        super.setCellFieldValue(args);
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter filter = new QFilter("id", "in", this.getAllFirstNoBills());
        filterList.add(filter);
        e.setCustomQFilters(filterList);
        e.setOrderBy("purchdate desc,bank asc,accountbank asc,coderule asc");
    }

    private List<Object> getAllFirstNoBills() {
        ArrayList<Object> list = new ArrayList<Object>();
        DataSet allDS = QueryServiceHelper.queryDataSet((String)"ChequePurchListPlugin-getAllFirstNoBills", (String)"cdm_cheque_purch", (String)"id,billno,batchno", null, (String)"billno");
        allDS = allDS.select(new String[]{"id", "batchno"}).groupBy(new String[]{"batchno"}).min("id").finish();
        for (Row row : allDS) {
            list.add(row.get("id"));
        }
        return list;
    }
}

