/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.elcDraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.CdmCommonHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class EleDraftPayList
extends AbstractTmcBillBaseList {
    private static Log logger = LogFactory.getLog(EleDraftPayList.class);
    private static final String BAR_PRE_ELECBILL_QUERY = "bar_pre_elecbill_query";
    private static final String DRAFT_TYPE_AC01 = "AC01";
    private static final String PREELECBILL_EBVALUESTATE = "40";

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue()));
        e.getQFilters().add(new QFilter("ticketstatus", "in", Arrays.asList("", " ", EleDraftBillStatusEnum.REGISTED.getValue(), EleDraftBillStatusEnum.INIT.getValue(), EleDraftBillStatusEnum.ACCEPTANCE.getValue(), EleDraftBillStatusEnum.ACCEPTANCESIGNED.getValue(), EleDraftBillStatusEnum.INVOICE.getValue(), EleDraftBillStatusEnum.INVOICESIGNED.getValue(), EleDraftBillStatusEnum.DESTROY.getValue(), EleDraftBillStatusEnum.ENSURE.getValue(), EleDraftBillStatusEnum.PREREGISTER.getValue())));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!"ticketstatus".equals(fieldName)) continue;
            commonFilterColumn.setComboItems(this.buildComboItems());
        }
    }

    private List<ComboItem> buildComboItems() {
        List<String> status = Arrays.asList(EleDraftBillStatusEnum.REGISTED.getValue(), EleDraftBillStatusEnum.INIT.getValue(), EleDraftBillStatusEnum.ACCEPTANCE.getValue(), EleDraftBillStatusEnum.ACCEPTANCESIGNED.getValue(), EleDraftBillStatusEnum.INVOICE.getValue(), EleDraftBillStatusEnum.INVOICESIGNED.getValue(), EleDraftBillStatusEnum.DESTROY.getValue(), EleDraftBillStatusEnum.ENSURE.getValue(), EleDraftBillStatusEnum.PREREGISTER.getValue());
        return status.stream().map(o -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(EleDraftBillStatusEnum.getByValue((String)o).getName()));
            item.setValue(o);
            return item;
        }).collect(Collectors.toList());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "relatepaybill": {
                QFilter idsFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
                DynamicObject[] electronicBills = TmcDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"id,querydrafttype,sourceid,currency,company,tradecontractno", (QFilter[])new QFilter[]{idsFilter});
                HashSet<Long> companySet = new HashSet<Long>(16);
                HashSet<Long> currencySet = new HashSet<Long>(16);
                HashSet<String> tradeContractNoSet = new HashSet<String>(16);
                boolean hasEmptyTradeContractNo = false;
                for (DynamicObject electronicBill : electronicBills) {
                    String tradeContractNo;
                    DynamicObject currency;
                    DynamicObject company = electronicBill.getDynamicObject("company");
                    if (EmptyUtil.isNoEmpty((DynamicObject)company)) {
                        companySet.add(company.getLong("id"));
                    }
                    if (EmptyUtil.isNoEmpty((DynamicObject)(currency = electronicBill.getDynamicObject("currency")))) {
                        currencySet.add(currency.getLong("id"));
                    }
                    if (EmptyUtil.isNoEmpty((String)(tradeContractNo = electronicBill.getString("tradecontractno")))) {
                        tradeContractNoSet.add(tradeContractNo);
                    } else {
                        hasEmptyTradeContractNo = true;
                    }
                    String queryDraftType = electronicBill.getString("querydrafttype");
                    if (EmptyUtil.isNoEmpty((String)queryDraftType) && !queryDraftType.equals(EleDraftExistCatEnum.PREREGISTER.getValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u9884\u51fa\u7968\u7968\u636e\u4e0d\u652f\u6301\u5173\u8054\u5e94\u4ed8\u7968\u636e", (String)"EleDraftPayList_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    Long sourceId = electronicBill.getLong("sourceid");
                    if (sourceId == null || sourceId <= 0L) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u8054\u5e94\u4ed8\u7968\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u5173\u8054\u3002", (String)"EleDraftPayList_2", (String)"tmc-cdm-common", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (currencySet.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7968\u636e\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EleDraftPayList_3", (String)"tmc-cdm-common", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (companySet.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7968\u636e\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EleDraftPayList_4", (String)"tmc-cdm-common", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (hasEmptyTradeContractNo && tradeContractNoSet.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e\u7684\u4ea4\u6613\u5408\u540c\u53f7\uff0c\u5fc5\u987b\u540c\u65f6\u4e3a\u7a7a\u6216\u540c\u65f6\u6709\u503c\u3002", (String)"EleDraftPayList_5", (String)"tmc-cdm-common", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (tradeContractNoSet.size() <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7968\u636e\u4ea4\u6613\u5408\u540c\u53f7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EleDraftPayList_6", (String)"tmc-cdm-common", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        List<Long> pkValues;
        super.afterDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        OperationResult opResult = event.getOperationResult();
        String operateKey = formOperate.getOperateKey();
        if ("modifyebstatus".equals(operateKey) && (pkValues = event.getOperationResult().getSuccessPkIds()).size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            HashMap<String, Object> customParam = new HashMap<String, Object>();
            customParam.put("sourceIdList", pkValues);
            customParam.put("sourcetype", "cdm_electronic_pay_deal");
            param.put("customParam", customParam);
            param.put("formId", "cdm_ebstatuschange");
            param.put("showType", ShowType.MainNewTabPage);
            CdmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
        }
        if ("viewmodifyrecord".equals(operateKey)) {
            if (!event.getOperationResult().isSuccess()) {
                return;
            }
            pkValues = event.getOperationResult().getSuccessPkIds();
            Object pkValue = event.getOperationResult().getSuccessPkIds().get(0);
            QFilter qFilter = new QFilter("entryentity.billsourceid", "=", pkValue);
            boolean isExistChangeBill = QueryServiceHelper.exists((String)"cdm_ebstatuschange", (QFilter[])new QFilter[]{qFilter});
            if (pkValues.size() > 0 && isExistChangeBill) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setFormId("bos_list");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setBillFormId("cdm_ebstatuschange");
                List qFiltersCol = showParameter.getListFilterParameter().getQFilters();
                qFiltersCol.add(qFilter);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4fee\u6539\u8bb0\u5f55", (String)"EleDraftRecList_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
        }
        if ("relationtrackdown".equals(operateKey) && opResult.isSuccess() && opResult.getSuccessPkIds().size() > 0) {
            Object pkValue = event.getOperationResult().getSuccessPkIds().get(0);
            DynamicObject electronicPayDeal = TmcDataServiceHelper.loadSingle(pkValue, (String)"cdm_electronic_pay_deal", (String)"id,sourceid");
            if (!EmptyUtil.isEmpty((DynamicObject)electronicPayDeal) && EmptyUtil.isNoEmpty((Long)electronicPayDeal.getLong("sourceid")) && electronicPayDeal.getLong("sourceid") > 0L) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setAppId("cdm");
                parameter.setFormId("cdm_payablebill");
                parameter.setPkId((Object)electronicPayDeal.getLong("sourceid"));
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8054\u67e5\u6570\u636e\u3002", (String)"CdmBizResource_167", (String)"tmc-cdm-common", (Object[])new Object[0]));
            }
        }
        if ("querypreelecbill".equals(operateKey)) {
            this.showQueryPreElecBillView();
        }
        if ("relatepaybill".equals(operateKey)) {
            pkValues = event.getOperationResult().getSuccessPkIds();
            QFilter idsFilter = new QFilter("id", "in", (Object)pkValues);
            DynamicObject[] electronicBills = TmcDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"id,tradecontractno,company", (QFilter[])new QFilter[]{idsFilter});
            String tradeContractNo = electronicBills[0].getString("tradecontractno");
            Long companyId = electronicBills[0].getDynamicObject("company").getLong("id");
            if (EmptyUtil.isNoEmpty((String)tradeContractNo)) {
                QFilter filter = new QFilter("tradecontractno", "=", (Object)tradeContractNo);
                filter.and(new QFilter("querydrafttype", "=", (Object)EleDraftExistCatEnum.PREREGISTER.getValue()));
                filter.and(new QFilter("sourceid", "=", (Object)0L));
                filter.and(new QFilter("company", "=", (Object)companyId));
                DynamicObject[] elecBills = TmcDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"id", (QFilter[])new QFilter[]{filter});
                pkValues = Stream.of(elecBills).map(o -> o.getLong("id")).collect(Collectors.toList());
            }
            FormShowParameter para = new FormShowParameter();
            para.setFormId("cdm_relatedprebill");
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            para.setCustomParam("srcbilltype", (Object)"cdm_electronic_pay_deal");
            para.setCustomParam("id", (Object)pkValues.toArray(new Long[0]));
            this.getView().showForm(para);
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    private void showQueryPreElecBillView() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cdm_pre_elecbill_query");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, BAR_PRE_ELECBILL_QUERY);
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)BAR_PRE_ELECBILL_QUERY)) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            Long companyId = (Long)returnData.get("company");
            Long connChannelId = (Long)returnData.get("directconnchannel");
            Long accountId = (Long)returnData.get("defaultaccount");
            String interfaceType = (String)returnData.get("interfacetype");
            try {
                this.queryOp(accountId, interfaceType);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u9884\u51fa\u7968\u7968\u636e, \u4ea7\u751f\u5f02\u5e38:", (Throwable)e);
                throw e;
            }
        }
    }

    private void queryOp(Long accountId, String interfaceType) {
        ArrayList<String> draftTypeEnums = new ArrayList<String>(4);
        draftTypeEnums.add(DRAFT_TYPE_AC01);
        ArrayList<String> ticStatusEnums = new ArrayList<String>(4);
        ticStatusEnums.add(PREELECBILL_EBVALUESTATE);
        HashMap<String, ArrayList<String>> interfaceTypeMap = new HashMap<String, ArrayList<String>>(2);
        if (StringUtils.isEmpty((CharSequence)interfaceType)) {
            interfaceTypeMap.put("0", ticStatusEnums);
            interfaceTypeMap.put("1", ticStatusEnums);
        } else {
            interfaceTypeMap.put(interfaceType, ticStatusEnums);
        }
        ArrayList<Long> accountIdSet = new ArrayList<Long>(4);
        accountIdSet.add(accountId);
        IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
        List noteResults = bankService.queryDraftBill(draftTypeEnums, interfaceTypeMap, accountIdSet, null, null, EleDraftExistCatEnum.PREREGISTER.getValue());
        boolean isAllSuccess = true;
        String errorMsg = "";
        for (NoteResult noteResult : noteResults) {
            if (EBResultStatusCode.SUCCESS.equals((Object)noteResult.getStatusCode())) continue;
            logger.error(String.format("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0cerrCode:{%s}\uff0cerrMsg:{%s}\u3002", noteResult.getErrCode(), noteResult.getErrMsg()));
            errorMsg = noteResult.getErrMsg();
            isAllSuccess = false;
        }
        if (isAllSuccess) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"EleDraftBillHandleList_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
        } else {
            StringBuilder failTips = new StringBuilder(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25:", (String)"EleDraftBillHandleList_10", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                failTips.append(errorMsg);
            }
            this.getView().showTipNotification(failTips.toString());
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("existChangeBillConfirm".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            String successString = this.getPageCache().get("successIds");
            BillShowParameter sp = new BillShowParameter();
            sp.setBillTypeId("cdm_ebstatuschange");
            sp.setFormId("cdm_ebstatuschange");
            sp.setPkId((Object)successString);
            sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)sp);
            this.getPageCache().remove("successIds");
            BillList billList = (BillList)this.getControl("billlistap");
            billList.clearSelection();
            billList.refresh();
        }
    }
}

