/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.elcDraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.cdm.common.enums.BankReturnStatusEnum;
import kd.tmc.cdm.common.enums.ElcTicketStatusToTradeTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class EleEbStatusChangeEdit
extends AbstractTmcBillEdit {
    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List idList = (List)customParams.get("sourceIdList");
        Object sourceType = customParams.get("sourcetype");
        if (EmptyUtil.isNoEmpty((Object)idList) && null != sourceType) {
            this.fillBillData(idList, sourceType);
        }
        this.initComboEditControl();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int currentRowIndex = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        switch (key) {
            case "afterebstatus": {
                this.changeBizFinishDate(currentRowIndex);
                this.firstRowChangeToOtherRow(key, currentRowIndex, newValue);
                break;
            }
            case "afterticketstatus": 
            case "afternotestatus": 
            case "aftercirstatus": 
            case "bizfinishdate": 
            case "reason": {
                this.firstRowChangeToOtherRow(key, currentRowIndex, newValue);
            }
        }
    }

    private void firstRowChangeToOtherRow(String key, int currentRowIndex, Object newValue) {
        if (currentRowIndex == 0) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                if (!EmptyUtil.isEmpty((Object)entry.get(key))) continue;
                entry.set(key, newValue);
            }
            this.getView().updateView("entryentity");
        }
    }

    private void changeBizFinishDate(int currentRowIndex) {
        String afterebStatus = (String)this.getModel().getValue("afterebstatus", currentRowIndex);
        if (StringUtils.equals((CharSequence)afterebStatus, (CharSequence)BankReturnStatusEnum.BANK_SUCCESS.getValue())) {
            this.getView().setEnable(Boolean.valueOf(true), currentRowIndex, new String[]{"bizfinishdate"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), currentRowIndex, new String[]{"bizfinishdate"});
        }
    }

    private void fillBillData(List<Object> idList, Object sourceType) {
        DynamicObject[] electBillList = TmcDataServiceHelper.load((Object[])idList.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceType.toString()));
        this.getModel().setValue("sourcetype", sourceType);
        this.getModel().setValue("company", electBillList[0].get("company"));
        Arrays.stream(electBillList).forEach(electBill -> {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("billsourceid", electBill.getPkValue(), rowIndex);
            this.getModel().setValue("draftno", (Object)electBill.getString("billno"), rowIndex);
            String subRange = electBill.getString("subrange");
            this.getModel().setValue("subrange", (Object)(EmptyUtil.isNotEmpty((CharSequence)subRange) ? subRange : "0-0"), rowIndex);
            this.getModel().setValue("rptype", electBill.get("rptype"), rowIndex);
            this.getModel().setValue("bankmsg", electBill.get("bankmsg"), rowIndex);
            this.getModel().setValue("tradetype", electBill.get("tradetype"), rowIndex);
            this.getModel().setValue("ebstatus", electBill.get("ebstatus"), rowIndex);
            this.getModel().setValue("ticketstatus", electBill.get("ticketstatus"), rowIndex);
            this.getModel().setValue("notestatus", electBill.get("notestatus"), rowIndex);
            this.getModel().setValue("cirstatus", electBill.get("cirstatus"), rowIndex);
            this.changeBizFinishDate(rowIndex);
        });
    }

    private void initComboEditControl() {
        ComboEdit afterTicketStatusComboEdit = (ComboEdit)this.getControl("afterticketstatus");
        Map ticketStatusMap = ElcTicketStatusToTradeTypeEnum.getTicketStatusByTradeType((String)this.getModel().getValue("tradetype", 0).toString());
        ArrayList<ComboItem> afterTicketStatusItems = new ArrayList<ComboItem>(ticketStatusMap.size());
        for (Map.Entry entry : ticketStatusMap.entrySet()) {
            ComboItem comboItem = new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey());
            afterTicketStatusItems.add(comboItem);
        }
        afterTicketStatusComboEdit.setComboItems(afterTicketStatusItems);
    }
}

