/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.index;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class ExpiredWarnPlugin
extends AbstractTmcBillEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"freshbutton"});
    }

    public void afterCreateNewData(EventObject e) {
        long curOrgId = RequestContext.get().getOrgId();
        QFilter filter = new QFilter("org", "=", (Object)curOrgId);
        DynamicObject initOrg = QueryServiceHelper.queryOne((String)"cas_cashmgtinit", (String)"id,exratetable,standardcurrency", (QFilter[])filter.toArray());
        if (initOrg != null) {
            this.getModel().setValue("ratetable", initOrg.get("exratetable"));
            this.getModel().setValue("reportcurrency", initOrg.get("standardcurrency"));
        }
        this.setDateBill();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("freshbutton".equals(key)) {
            this.setDateBill();
        }
    }

    private void setDateBill() {
        Object[] payableBills = this.getBillDate();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        DynamicObject rateTable = (DynamicObject)this.getModel().getValue("ratetable");
        DynamicObject reportCurrency = (DynamicObject)this.getModel().getValue("reportcurrency");
        if (rateTable == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpiredWarnPlugin_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (reportCurrency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u544a\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpiredWarnPlugin_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtil.isEmpty((Object[])payableBills)) {
            return;
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List sourceCurrencys = Arrays.asList(payableBills).stream().filter(v -> v.getDynamicObject("currency") != null).map(v -> v.getDynamicObject("currency").getLong("id")).distinct().collect(Collectors.toList());
        HashMap<Long, BigDecimal> sourceCurrencyMap = new HashMap<Long, BigDecimal>(10);
        for (Long sourceCurrency : sourceCurrencys) {
            BigDecimal value = BaseDataServiceHelper.getExchangeRate((Long)rateTable.getLong("id"), (Long)sourceCurrency, (Long)reportCurrency.getLong("id"), (Date)new Date());
            if (value == null) {
                value = BigDecimal.ZERO;
            }
            sourceCurrencyMap.put(sourceCurrency, value);
        }
        vs.addField("org", new Object[0]);
        vs.addField("billtype", new Object[0]);
        vs.addField("type", new Object[0]);
        vs.addField("billstatus", new Object[0]);
        vs.addField("billnumber", new Object[0]);
        vs.addField("createdate", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("amount", new Object[0]);
        vs.addField("expireddate", new Object[0]);
        vs.addField("createname", new Object[0]);
        vs.addField("cangive", new Object[0]);
        vs.addField("promisename", new Object[0]);
        vs.addField("receiver", new Object[0]);
        vs.addField("amountofreportcur", new Object[0]);
        vs.addField("pledgeenddate", new Object[0]);
        for (Object bill : payableBills) {
            vs.addRow(new Object[]{bill.get("company.id"), bill.get("draftbilltype.id"), bill.get("rptype"), bill.get("draftbillstatus"), bill.get("draftbillno"), bill.get("issuedate"), bill.get("currency.id"), bill.get("amount"), bill.get("draftbillexpiredate"), bill.get("drawername"), bill.get("istransfer"), bill.get("acceptername"), bill.get("receivername"), bill.getBigDecimal("amount").multiply(bill.getDynamicObject("currency") != null ? (BigDecimal)sourceCurrencyMap.get(bill.getDynamicObject("currency").getLong("id")) : BigDecimal.ZERO), bill.getDate("pledgeenddate")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private DynamicObject[] getBillDate() {
        int day = (Integer)this.getModel().getValue("day");
        if (day == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5230\u671f\u5929\u6570\u3002", (String)"ExpiredWarnPlugin_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return null;
        }
        String appId = this.getModel().getDataEntityType().getAppId();
        Long userPK = Long.valueOf(RequestContext.get().getUserId());
        HashSet orgs = new HashSet();
        orgs.addAll(TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)"cdm_payablebill", (String)"47150e89000000ac"));
        orgs.addAll(TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)"cdm_receivablebill", (String)"47150e89000000ac"));
        QFilter orgfilter = new QFilter("company", "in", orgs);
        QFilter filters = new QFilter("draftbillexpiredate", "<=", (Object)DateUtils.getNextDay((Date)new Date(), (int)day));
        QFilter filters_pledge = new QFilter("pledgeenddate", "<=", (Object)DateUtils.getNextDay((Date)new Date(), (int)day));
        QFilter statusFilters = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter billFilters = new QFilter("draftbillstatus", "in", (Object)new String[]{DraftBillStatusEnum.REGISTERED.getValue(), DraftBillStatusEnum.COLLOCATED.getValue()});
        QFilter billFiltersOfPledge = new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.PLEDGED.getValue());
        DynamicObject[] bills = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)this.getFields(), (QFilter[])new QFilter[]{filters, statusFilters, orgfilter, billFilters}, (String)"draftbillexpiredate");
        DynamicObject[] billsOfPledge = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)this.getFields(), (QFilter[])new QFilter[]{filters_pledge, statusFilters, orgfilter, billFiltersOfPledge}, (String)"pledgeenddate");
        ArrayList<DynamicObject> allBills = new ArrayList<DynamicObject>();
        allBills.addAll(Arrays.asList(bills));
        allBills.addAll(Arrays.asList(billsOfPledge));
        return allBills.toArray(new DynamicObject[0]);
    }

    private String getFields() {
        return "company,draftbilltype,rptype,draftbillstatus,draftbillno,issuedate,currency,amount,draftbillexpiredate,istransfer,drawername,receiver,receivername,acceptername,pledgeenddate";
    }
}

