/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.payablebill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayApplyToPayableConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(PayApplyToPayableConvertPlugin.class);

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        logger.info("PayApplyToPayableConvertPlugin is start");
        for (ExtendedDataEntity billDataEntity : billDataEntities) {
            boolean hasGua;
            DynamicObject payablebill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_payablebill_ap_manual"));
            DynamicObjectCollection entry_gcontract = payablebill.getDynamicObjectCollection("entry_gcontract");
            String paybilltype = sourceBill.getString("billingtype");
            boolean bl = hasGua = StringUtils.contains((CharSequence)paybilltype, (CharSequence)"guarantee") || StringUtils.contains((CharSequence)paybilltype, (CharSequence)"credit");
            if (hasGua && EmptyUtil.isNoEmpty((DynamicObjectCollection)entry_gcontract) && entry_gcontract.size() > 0) {
                logger.info("is will update gamount");
                BigDecimal amount = payablebill.getBigDecimal("amount");
                for (DynamicObject entry : entry_gcontract) {
                    BigDecimal gratio = entry.getBigDecimal("gratio");
                    if (null == gratio) continue;
                    BigDecimal gamount = amount.multiply(new BigDecimal("0.01")).multiply(gratio);
                    entry.set("gamount", (Object)gamount);
                }
            }
            DraftHelper.setSubBillInfo((DynamicObject)payablebill, (BigDecimal)payablebill.getBigDecimal("amount"));
        }
    }
}

