/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.bean.CreditLimitF7ResBean;
import kd.tmc.cdm.common.bean.CreditLimitUseBean;
import kd.tmc.cdm.common.enums.BillTypeUnitEnum;
import kd.tmc.cdm.common.enums.PayeeTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.cdm.common.helper.ChequeHelper;
import kd.tmc.cdm.common.helper.ListConstructorHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class PayableApplyBillBatchEdit
extends AbstractTmcBillEdit {
    private static final Log logger = LogFactory.getLog(PayableApplyBillBatchEdit.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private boolean skip = false;

    public void afterCreateNewData(EventObject e) {
        Object obj = this.getModel().getContextVariable("IGNORE_RELOADDATAMODEL");
        if (null != obj && ((Boolean)obj).booleanValue()) {
            return;
        }
        this.issuedateChange();
        DynamicObject companyDO = this.getModel().getDataEntity().getDynamicObject("company");
        if (!EmptyUtil.isEmpty((DynamicObject)companyDO)) {
            DynamicObject baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)companyDO.getPkValue()));
            if (EmptyUtil.isNoEmpty((DynamicObject)baseCurrency)) {
                this.getModel().setValue("currency", baseCurrency.getPkValue());
            }
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (int i = 0; i < collection.size(); ++i) {
                this.getModel().setValue("drawername", (Object)companyDO.getString("name"), i);
            }
        }
        this.getDefaultDraftNo();
        ((FieldEdit)this.getView().getControl("receiver")).setMustInput(true);
        DynamicObject draftBillType = (DynamicObject)this.getModel().getValue("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftBillType)) {
            String settlementType = draftBillType.getString("settlementtype");
            if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                Object accepterAcc = this.getModel().getValue("accepteraccount");
                if (EmptyUtil.isEmpty((Object)accepterAcc)) {
                    this.getModel().setValue("accepteraccount", (Object)"0");
                }
            } else if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
                // empty if block
            }
            this.setAcceptDateMust(draftBillType);
        }
    }

    private void setDefaultSuretyMoney() {
        boolean isEditSuretyAmount = (Boolean)this.getModel().getValue("iseditsuretyamount");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (isEditSuretyAmount) {
            for (int i = 0; i < entrys.size(); ++i) {
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"entry_suretyamount"});
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"suretymoney"});
            this.getModel().setValue("suretymoney", null);
        } else {
            for (int i = 0; i < entrys.size(); ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entry_suretyamount"});
            }
            BigDecimal promisRate = (BigDecimal)this.getModel().getValue("promisrate");
            BigDecimal amountTotal = (BigDecimal)this.getModel().getValue("amounttotal");
            BigDecimal suretyMoney = amountTotal.multiply(promisRate.divide(new BigDecimal(100)));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"suretymoney"});
            this.getModel().setValue("suretymoney", (Object)suretyMoney);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setAcceptDate();
        Object draftbilltype = this.getModel().getValue("draftbilltype");
        this.draftbilltypeChangeNew(draftbilltype);
        Object creditlimit = this.getModel().getValue("creditlimit");
        if (EmptyUtil.isNoEmpty((Object)creditlimit)) {
            long billId = this.getModel().getDataEntity().getLong("id");
            this.loadCreditUse(billId);
        }
        if (BillOperationStatus.ADDNEW.equals((Object)((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus())) {
            this.setDefaultSuretyMoney();
        }
        Object billIngType = this.getModel().getValue("billingtype");
        this.setCreditEnableAndValue(billIngType);
    }

    private void loadCreditUse(Long sourceBillId) {
        if (EmptyUtil.isEmpty((Long)sourceBillId)) {
            return;
        }
        QFilter source_qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        QFilter isrele_qFilter = new QFilter("isrelease", "=", (Object)"0");
        Object[] creditUses = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"sourcebillentryid, currency, realamt", (QFilter[])new QFilter[]{source_qFilter, isrele_qFilter});
        if (EmptyUtil.isNoEmpty((Object[])creditUses)) {
            Object creditUs = creditUses[0];
            Long currency = creditUs.getDynamicObject("currency").getLong("id");
            BigDecimal realamt = creditUs.getBigDecimal("realamt");
            this.getModel().setValue("creditcurrency", (Object)currency);
            this.getModel().setValue("amountofcredit", (Object)realamt);
        }
    }

    private void setAcceptDate() {
        DynamicObject draftBillType = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        if (!EmptyUtil.isEmpty((DynamicObject)draftBillType)) {
            String settlementType = draftBillType.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) || StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"acceptdate"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"acceptdate"});
            }
        }
    }

    private void setAcceptDateMust(DynamicObject draftBillType) {
        if (EmptyUtil.isNoEmpty((DynamicObject)draftBillType)) {
            String settlementType = draftBillType.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) || StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"acceptdate"});
                ((DateEdit)this.getView().getControl("acceptdate")).setMustInput(false);
                DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY_ENTITY);
                if (!EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
                    for (int i = 0; i < entrys.size(); ++i) {
                        Date issueDate = (Date)this.getModel().getValue("issuedate", i);
                        this.getModel().setValue("acceptdate", (Object)issueDate, i);
                    }
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"acceptdate"});
                ((DateEdit)this.getView().getControl("acceptdate")).setMustInput(false);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        String billstatus;
        super.beforeBindData(e);
        String string = billstatus = this.getModel().getValue("billstatus") == null ? "" : this.getModel().getValue("billstatus").toString();
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.DISCARD.getValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_del", "bar_save", "bar_submit", "bar_audit", "submitdraft", "bar_track", "bar_print", "bar_refresh"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (operateKey.equals("newentry")) {
            this.issuedateChange();
            DynamicObject companyDO = this.getModel().getDataEntity().getDynamicObject("company");
            if (!EmptyUtil.isEmpty((DynamicObject)companyDO)) {
                this.getModel().setValue("drawername", (Object)companyDO.getString("name"));
            }
            this.getDefaultDraftNo();
            ((FieldEdit)this.getView().getControl("receiver")).setMustInput(true);
            int index = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            Date issueDate = (Date)this.getModel().getValue("issuedate", index);
            this.getModel().setValue("acceptdate", (Object)issueDate, index);
        }
        if (operateKey.equals("invalidnetry") && args.getOperationResult().isSuccess()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            if (selectRows != null && selectRows.length > 0) {
                Long id = (Long)this.getModel().getValue("id");
                QFilter debtBillIdFilter = new QFilter("entry.debtbillid", "=", (Object)id);
                Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"id", (QFilter[])new QFilter[]{debtBillIdFilter});
                if (!EmptyUtil.isEmpty((Object[])suretyBills)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5f00\u7968\u767b\u8bb0\u4e3a\u5426\u4e14\u4f5c\u5e9f\u4e3a\u5426\u4e14\u5b58\u5165\u4fdd\u8bc1\u91d1\u4e3a\u5426\u7684\u5206\u5f55\u64cd\u4f5c\u4f5c\u5e9f", (String)"PayableApplyBillBatchEdit_15", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean hasPayable = false;
                for (int selectRow : selectRows) {
                    boolean bl = hasPayable = ((DynamicObject)entity.get(selectRow)).getBoolean("payable") || ((DynamicObject)entity.get(selectRow)).getBoolean("invalid");
                    if (hasPayable) break;
                }
                if (hasPayable) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u4f5c\u5e9f\u5f00\u7968\u767b\u8bb0\u4e3a\u201c\u5426\u201d\u4e14\u4f5c\u5e9f\u4e3a\u201c\u5426\u201d\u7684\u6570\u636e\u3002", (String)"PayableApplyBillBatchEdit_3_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                } else {
                    for (int selectRow : selectRows) {
                        DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
                        dynamicObject.set("invalid", (Object)Boolean.TRUE);
                    }
                    DynamicObject creditlimit = (DynamicObject)this.getModel().getValue("creditlimit");
                    String billstatus = (String)this.getModel().getValue("billstatus");
                    if (EmptyUtil.isNoEmpty((DynamicObject)creditlimit)) {
                        BigDecimal allAmountofcredit = this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(o -> !o.getBoolean("invalid")).map(v -> v.getBigDecimal("entry_amountofcredit")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        this.getModel().setValue("creditamount", (Object)allAmountofcredit);
                    }
                    BigDecimal amounttotal = this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(o -> !o.getBoolean("invalid")).map(v -> v.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    this.getModel().setValue("amounttotal", (Object)amounttotal);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
                    this.getView().invokeOperation("refresh");
                    if (EmptyUtil.isNoEmpty((DynamicObject)creditlimit) && (BillStatusEnum.SUBMIT.getValue().equals(billstatus) || BillStatusEnum.AUDIT.getValue().equals(billstatus))) {
                        BigDecimal creditamount = (BigDecimal)this.getModel().getValue("creditamount");
                        Long pk = (Long)this.getModel().getValue("id");
                        CreditLimitServiceHelper.updateCreditLimitUse((String)"cdm_payablebill_ap_manual", (Long)pk, (BigDecimal)creditamount, (boolean)true);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u6210\u529f", (String)"PayableApplyBillBatchEdit_3_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4f5c\u5e9f\u7684\u5f00\u7968\u7533\u8bf7\u660e\u7ec6", (String)"PayableApplyBillBatchEdit_3_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
        }
        if ("deleteentry".equals(operateKey)) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY_ENTITY);
            if (entrys == null || entrys.size() < 1) {
                this.getModel().setValue("amounttotal", (Object)BigDecimal.ZERO);
                this.getModel().setValue("creditamount", (Object)BigDecimal.ZERO);
            } else {
                BigDecimal amounttotal = this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(o -> !o.getBoolean("invalid")).map(v -> v.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.getModel().setValue("amounttotal", (Object)amounttotal);
                BigDecimal allAmountofcredit = this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(o -> !o.getBoolean("invalid")).map(v -> v.getBigDecimal("entry_amountofcredit")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.getModel().setValue("creditamount", (Object)allAmountofcredit);
            }
        }
    }

    private void getDefaultDraftNo() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < collection.size(); ++i) {
            this.getModel().setValue("payable", (Object)Character.valueOf('0'), i);
        }
        Object draftType = this.getModel().getValue("draftbilltype");
        DynamicObject dataEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY));
        if (EmptyUtil.isEmpty((DynamicObject)dataEntity)) {
            for (int i = 0; i < collection.size(); ++i) {
                dataEntity = (DynamicObject)collection.get(i);
                DynamicObject acct = dataEntity.getDynamicObject("draweraccount");
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                DynamicObject billType = (DynamicObject)this.getModel().getValue("draftbilltype");
                this.getModel().setValue("basedraftbillno", null, i);
                if (acct == null || currency == null) continue;
                Object id = ChequeHelper.getMinChequeNoBy((String)billType.getString("id"), (long)acct.getLong("id"), (long)currency.getLong("id"));
                this.getModel().setValue("basedraftbillno", id, i);
            }
        } else {
            DynamicObject acct = dataEntity.getDynamicObject("draweraccount");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject billType = (DynamicObject)this.getModel().getValue("draftbilltype");
            this.getModel().setValue("basedraftbillno", null);
            if (acct != null && currency != null) {
                Object id = ChequeHelper.getMinChequeNoBy((String)billType.getString("id"), (long)acct.getLong("id"), (long)currency.getLong("id"));
                this.getModel().setValue("basedraftbillno", id);
            }
        }
    }

    private void issuedateChange() {
        Date draftBillExpireDate = this.getDraftBillDefaultExpireDate();
        int index = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        Date date = ((DynamicObject)entryentity.get(index)).getDate("draftbillexpiredate");
        if (date == null && draftBillExpireDate != null || draftBillExpireDate != null && date != null && date.after(draftBillExpireDate)) {
            this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpireDate);
        }
    }

    private Date getDraftBillExpireDate() {
        DynamicObject draftbilltypeDO = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            Date draftbillexpiredate = null;
            int validitytime = draftbilltypeDO.getInt("validitytime");
            String unit = draftbilltypeDO.getString("unit");
            Date issueDate = (Date)this.getModel().getValue("issuedate");
            if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.MONTH.getValue()) && issueDate != null) {
                draftbillexpiredate = DateUtils.getNextMonth((Date)issueDate, (int)validitytime);
                if (draftbillexpiredate.getDate() != issueDate.getDate()) {
                    draftbillexpiredate = DateUtils.getNextDay((Date)draftbillexpiredate, (int)(-draftbillexpiredate.getDate()));
                }
            } else if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.DAY.getValue()) && issueDate != null) {
                draftbillexpiredate = DateUtils.getNextDay((Date)issueDate, (int)validitytime);
            }
            return draftbillexpiredate;
        }
        return null;
    }

    private Date getDraftBillDefaultExpireDate() {
        DynamicObject draftbilltypeDO = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            Date draftbillexpiredate = null;
            int validitytime = draftbilltypeDO.getInt("defaulttime");
            String unit = draftbilltypeDO.getString("defaultunit");
            Date issuedate = (Date)this.getModel().getValue("issuedate");
            if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.MONTH.getValue()) && issuedate != null) {
                draftbillexpiredate = DateUtils.getNextMonth((Date)issuedate, (int)validitytime);
                if (draftbillexpiredate.getDate() != issuedate.getDate()) {
                    draftbillexpiredate = DateUtils.getNextDay((Date)draftbillexpiredate, (int)(-draftbillexpiredate.getDate()));
                }
            } else if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.DAY.getValue()) && issuedate != null) {
                draftbillexpiredate = DateUtils.getNextDay((Date)issuedate, (int)validitytime);
            }
            return draftbillexpiredate;
        }
        return null;
    }

    private void draftbillexpiredateChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Date newValue = (Date)changeSet[0].getNewValue();
        Date oldValue = (Date)changeSet[0].getOldValue();
        if (oldValue != null && newValue != null) {
            Date draftBillExpiredate = this.getDraftBillExpireDate();
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            Date issuedate = ((DynamicObject)entryentity.get(0)).getDate("issuedate");
            if (draftBillExpiredate != null && newValue.after(draftBillExpiredate)) {
                this.getView().showErrorNotification(new CdmBizResource().getRbDraftBillExpiredateCheck());
                this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpiredate);
            } else if (draftBillExpiredate != null && issuedate != null && !newValue.after(issuedate)) {
                this.getView().showErrorNotification(new CdmBizResource().getRbDraftBillExpiredateCheck2());
                this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpiredate);
            }
        }
    }

    private void draftBillTypeDefault(Object draftBillType) {
        if (EmptyUtil.isNoEmpty((Object)draftBillType)) {
            DynamicObject draftBillTypeDy = (DynamicObject)draftBillType;
            String settlementType = draftBillTypeDy.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                Object accepterAcc = this.getModel().getValue("accepteraccount");
                if (EmptyUtil.isEmpty((Object)accepterAcc)) {
                    this.getModel().setValue("accepteraccount", (Object)"0");
                }
            } else {
                this.getModel().setValue("accepteraccount", (Object)"");
            }
            this.getView().setEnable(Boolean.valueOf(!StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())), new String[]{"accepterbankname", "accepterbankno"});
        }
    }

    private void draftbilltypeChange(Object draftbilltype) {
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            Date draftBillExpireDate = this.getDraftBillDefaultExpireDate();
            if (draftBillExpireDate != null) {
                this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpireDate);
            }
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            String billMedium = draftbilltypeDO.getString("billmedium");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                if ("1".equals(billMedium)) {
                    this.setBankPaperVisibleMustInput();
                } else {
                    this.setBankEleVisibleMustInput();
                }
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                if ("1".equals(billMedium)) {
                    this.setBusinessPaperVisibleMustInput();
                } else {
                    this.setBusinessEleVisibleMustInput();
                }
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                this.setCheckVisibleMustInput();
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                this.setPromissoryVisibleMustInput();
                this.getDefaultDraftNo();
            }
            this.getModel().setValue("draftbilltype", draftbilltypeDO.getPkValue());
            if (!StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                Object value = this.getModel().getValue("company");
                DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(ENTRY_ENTITY);
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryentitys) && entryentitys.size() > 0) {
                    this.getModel().setValue("drawercompany", null);
                    this.getModel().setValue("drawercompany", value);
                }
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"company"});
            this.getPageCache().remove("draftbilltype_confirm");
        }
    }

    private void draftbilltypeChangeNew(Object draftbilltype) {
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            String billMedium = draftbilltypeDO.getString("billmedium");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                if ("1".equals(billMedium)) {
                    this.setBankPaperVisibleMustInput();
                } else {
                    this.setBankEleVisibleMustInput();
                }
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                if ("1".equals(billMedium)) {
                    this.setBusinessPaperVisibleMustInput();
                } else {
                    this.setBusinessEleVisibleMustInput();
                }
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                this.setCheckVisibleMustInput();
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                this.setPromissoryVisibleMustInput();
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"company"});
        }
    }

    private void setBankPaperVisibleMustInput() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"acceptercompany"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"drawerorg"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"drawername"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"draweraccountname"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"company"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepterfinorg"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepteraccount"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepterbankname"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepterbankno"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"drawercompany"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"draweraccount"});
        ((BasedataEdit)this.getControl("drawercompany")).setMustInput(true);
        ((BasedataEdit)this.getControl("receiverbank")).setMustInput(true);
        ((BasedataEdit)this.getControl("draweraccount")).setMustInput(true);
        ((FieldEdit)this.getControl("drawerbankname")).setMustInput(true);
        ((FieldEdit)this.getControl("receiveraccount")).setMustInput(false);
        ((ComboEdit)this.getControl("payeetype")).setMustInput(false);
        ((BasedataEdit)this.getControl("acceptercompany")).setMustInput(false);
        ((BasedataEdit)this.getControl("drawerorg")).setMustInput(false);
    }

    private void setBankEleVisibleMustInput() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"acceptercompany"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"drawerorg"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"drawername"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"draweraccountname"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"company"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepterfinorg"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepteraccount"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepterbankname"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepterbankno"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"drawercompany"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"draweraccount"});
        ((BasedataEdit)this.getControl("drawercompany")).setMustInput(true);
        ((BasedataEdit)this.getControl("draweraccount")).setMustInput(true);
        ((FieldEdit)this.getControl("drawerbankname")).setMustInput(true);
        ((FieldEdit)this.getControl("receiveraccount")).setMustInput(true);
        ((BasedataEdit)this.getControl("receiverbank")).setMustInput(true);
        ((ComboEdit)this.getControl("payeetype")).setMustInput(false);
        ((BasedataEdit)this.getControl("acceptercompany")).setMustInput(false);
        ((BasedataEdit)this.getControl("drawerorg")).setMustInput(false);
    }

    private void setBusinessPaperVisibleMustInput() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"company"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accepterfinorg"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"drawerorg"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"drawername"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"draweraccountname"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"acceptercompany"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepteraccount"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepterbankname"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepterbankno"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"drawercompany"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"draweraccount"});
        ((BasedataEdit)this.getControl("acceptercompany")).setMustInput(true);
        ((BasedataEdit)this.getControl("drawercompany")).setMustInput(true);
        ((BasedataEdit)this.getControl("draweraccount")).setMustInput(true);
        ((FieldEdit)this.getControl("drawerbankname")).setMustInput(true);
        ((ComboEdit)this.getControl("payeetype")).setMustInput(true);
        ((FieldEdit)this.getControl("receiveraccount")).setMustInput(true);
        ((BasedataEdit)this.getControl("receiverbank")).setMustInput(true);
        ((BasedataEdit)this.getControl("drawerorg")).setMustInput(false);
    }

    private void setBusinessEleVisibleMustInput() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"drawerorg"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"drawername"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"draweraccountname"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accepterfinorg"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"acceptercompany"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"company"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepteraccount"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepterbankname"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accepterbankno"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"drawercompany"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"draweraccount"});
        ((BasedataEdit)this.getControl("acceptercompany")).setMustInput(true);
        ((BasedataEdit)this.getControl("drawercompany")).setMustInput(true);
        ((BasedataEdit)this.getControl("draweraccount")).setMustInput(true);
        ((FieldEdit)this.getControl("drawerbankname")).setMustInput(true);
        ((ComboEdit)this.getControl("payeetype")).setMustInput(true);
        ((FieldEdit)this.getControl("receiveraccount")).setMustInput(true);
        ((BasedataEdit)this.getControl("receiverbank")).setMustInput(true);
        ((BasedataEdit)this.getControl("drawerorg")).setMustInput(false);
    }

    private void setCheckVisibleMustInput() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"acceptercompany"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accepterfinorg"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accepteraccount"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accepterbankname"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accepterbankno"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"drawercompany"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"drawername"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"draweraccount"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"company"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"drawerorg"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"draweraccountname"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"drawerbankname"});
        ((BasedataEdit)this.getControl("drawerorg")).setMustInput(true);
        ((ComboEdit)this.getControl("payeetype")).setMustInput(true);
        ((FieldEdit)this.getControl("drawerbankname")).setMustInput(false);
        ((FieldEdit)this.getControl("receiveraccount")).setMustInput(false);
        ((BasedataEdit)this.getControl("receiverbank")).setMustInput(false);
        ((BasedataEdit)this.getControl("acceptercompany")).setMustInput(false);
        ((BasedataEdit)this.getControl("drawercompany")).setMustInput(false);
        ((BasedataEdit)this.getControl("draweraccount")).setMustInput(false);
    }

    private void setPromissoryVisibleMustInput() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"company"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"acceptercompany"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accepterfinorg"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accepteraccount"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accepterbankname"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accepterbankno"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"drawerorg"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"drawername"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"draweraccountname"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"drawercompany"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"draweraccount"});
        ((BasedataEdit)this.getControl("drawercompany")).setMustInput(true);
        ((BasedataEdit)this.getControl("draweraccount")).setMustInput(true);
        ((FieldEdit)this.getControl("drawerbankname")).setMustInput(true);
        ((ComboEdit)this.getControl("payeetype")).setMustInput(true);
        ((BasedataEdit)this.getControl("receiverbank")).setMustInput(false);
        ((FieldEdit)this.getControl("receiveraccount")).setMustInput(false);
        ((BasedataEdit)this.getControl("acceptercompany")).setMustInput(false);
        ((BasedataEdit)this.getControl("drawerorg")).setMustInput(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if ("save".equals(opKey) || "submit".equals(opKey)) {
            DynamicObject draftbilltype = (DynamicObject)this.getModel().getValue("draftbilltype");
            if (EmptyUtil.isEmpty((DynamicObject)draftbilltype)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7968\u636e\u7c7b\u578b", (String)"PayableApplyBillBatchEdit_3_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if ("entryimport".equals(opKey)) {
            this.entryImportStart();
        } else if ("addsuretyentry".equals(opKey) && (EmptyUtil.isEmpty((Object)this.getModel().getValue("currency")) || EmptyUtil.isEmpty((Object)this.getModel().getValue("amount")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e01\u79cd\uff0c\u5f00\u7968\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayableApplyBillBatchEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void click(EventObject evt) {
        String btnKey = ((Control)evt.getSource()).getKey();
        DynamicObject draftBillType = (DynamicObject)this.getModel().getValue("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftBillType)) {
            String settlementType = draftBillType.getString("settlementtype");
            if ("accepteraccount".equals(btnKey) && SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
                BasedataEdit baseData = (BasedataEdit)this.getControl("accepteraccountid");
                baseData.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    Long accepterCompanyId = this.getModel().getValue("acceptercompany") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("acceptercompany")).getLong("id"));
                    QFilter qFilter = new QFilter("company", "=", (Object)accepterCompanyId).and("acctstatus", "=", (Object)"normal");
                    showParameter.getListFilterParameter().setFilter(qFilter);
                });
                baseData.click();
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getDefaultDraftNo();
        this.getModel().setValue("creditlimit", null);
        this.getModel().setValue("innercreditlimit", (Object)true);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (entrys == null || entrys.size() < 1) {
            this.getModel().setValue("amounttotal", (Object)BigDecimal.ZERO);
            this.getModel().setValue("creditamount", (Object)BigDecimal.ZERO);
        } else {
            BigDecimal amounttotal = this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(o -> !o.getBoolean("invalid")).map(v -> v.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.getModel().setValue("amounttotal", (Object)amounttotal);
            BigDecimal allAmountofcredit = this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(o -> !o.getBoolean("invalid")).map(v -> v.getBigDecimal("entry_amountofcredit")).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.getModel().setValue("creditamount", (Object)allAmountofcredit);
            for (int i = 0; i < entrys.size(); ++i) {
                this.getModel().setValue("suretyinput", (Object)false, i);
            }
        }
    }

    private void entryImportStart() {
        this.getPageCache().put("cdm_entryimportCache", "true");
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("cas_entryimport");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        String billFormId = this.getModel().getDataEntityType().getName();
        logger.info("billFormId: " + billFormId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("BillFormId", billFormId);
        params.put("BillEntryId", ENTRY_ENTITY);
        showForm.setCustomParams(params);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cas_entryimport"));
        this.getView().showForm(showForm);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_del": {
                String source = this.getModel().getValue("source").toString();
                if (StringUtils.equals((CharSequence)source, (CharSequence)SourceEnum.HANDREGISTER.getValue())) break;
                String message = String.format(new CdmBizResource().getRbSourceCheck(), SourceEnum.getName((String)source));
                this.getView().showConfirm(message, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("delete", (IFormPlugin)this));
                evt.setCancel(true);
                break;
            }
            case "submitdraft": {
                EntryGrid entryGrid;
                int size;
                boolean incluleGuarantee = false;
                String billingType = this.getModel().getDataEntity().getString("billingtype");
                if (EmptyUtil.isNoEmpty((String)billingType) && StringUtils.contains((CharSequence)billingType, (CharSequence)"guarantee") && (size = (entryGrid = (EntryGrid)this.getView().getControl("entry_surety")).getEntryData().getDataEntitys().length) < 1) {
                    incluleGuarantee = true;
                }
                if (incluleGuarantee) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u6709\u672a\u7f34\u5b58\u7684\u4fdd\u8bc1\u91d1\uff0c\u63d0\u4ea4\u5f00\u7968\u767b\u8bb0\u540e\u53ea\u80fd\u5728\u5f00\u7968\u767b\u8bb0\u5355\u636e\u5185\u64cd\u4f5c\u5b58\u5165\u4fdd\u8bc1\u91d1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayableApplyBillBatchEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirm_close", (IFormPlugin)this));
                    evt.setCancel(true);
                    break;
                }
                this.getView().invokeOperation("afterpush");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("delete");
        } else if (StringUtils.equals((CharSequence)"draftbilltype_confirm", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            this.getPageCache().put("draftbilltype_confirm", String.valueOf(messageBoxClosedEvent.getResult().getValue()));
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                Object draftbilltype = this.getModel().getValue("draftbilltype");
                this.draftbilltypeChange(draftbilltype);
                this.draftBillTypeDefault(draftbilltype);
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                for (int i = 0; i < entryentity.size(); ++i) {
                    this.skip = true;
                    this.getModel().setValue("amount", (Object)BigDecimal.ZERO, i);
                }
                this.getModel().setValue("amounttotal", (Object)BigDecimal.ZERO);
                this.getPageCache().remove("draftbilltype");
            } else {
                String oldDraftBillTypeId = this.getPageCache().get("draftbilltype");
                this.getModel().setValue("draftbilltype", (Object)Long.parseLong(oldDraftBillTypeId));
            }
        } else if (StringUtils.equals((CharSequence)"confirm_close", (CharSequence)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation("afterpush");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object draftbilltype = this.getModel().getValue("draftbilltype");
        ChangeData[] changeData = e.getChangeSet();
        Object propValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int rowIndex = changeData[0].getRowIndex();
        if (this.skip && (key.equals("payeetype") || key.equals("receiver") || key.equals("amount") || key.equals("amounttotal") || key.equals("entry_suretyamount"))) {
            this.skip = false;
            return;
        }
        switch (key) {
            case "issuedate": {
                this.issuedateChange();
                break;
            }
            case "draftbillexpiredate": {
                this.draftbillexpiredateChange(e);
                break;
            }
            case "draftbilltype": {
                String result = this.getPageCache().get("draftbilltype_confirm");
                if ("6".equals(result)) {
                    this.draftbilltypeChange(draftbilltype);
                    this.draftBillTypeDefault(draftbilltype);
                } else if (EmptyUtil.isEmpty((String)result)) {
                    DynamicObject oldDraftBillType = (DynamicObject)e.getChangeSet()[0].getOldValue();
                    String oldDraftBillTypeId = EmptyUtil.isEmpty((DynamicObject)oldDraftBillType) ? "" : String.valueOf(oldDraftBillType.getPkValue());
                    this.getPageCache().put("draftbilltype", oldDraftBillTypeId);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u7968\u636e\u7c7b\u578b\u4f1a\u6062\u590d\u9ed8\u8ba4\u7684\u5f00\u7968\u91d1\u989d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayableApplyBillBatchEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("draftbilltype_confirm", (IFormPlugin)this));
                } else {
                    this.getPageCache().remove("draftbilltype_confirm");
                }
                this.setAcceptDateMust((DynamicObject)draftbilltype);
                break;
            }
            case "drawercompany": {
                this.companyChange(draftbilltype);
                this.getDefaultDraftNo();
                DynamicObject newValue = (DynamicObject)changeData[0].getNewValue();
                if (newValue == null) break;
                this.getModel().setValue("drawercompany", newValue.getPkValue());
                this.getModel().setValue("drawername", newValue.get("name"));
                break;
            }
            case "draweraccount": {
                this.draweraccountChange(draftbilltype);
                this.getDefaultDraftNo();
                break;
            }
            case "drawerbankname": {
                break;
            }
            case "receiver": {
                this.receiverChange();
                break;
            }
            case "drawerorg": {
                this.drawerorgChange();
                break;
            }
            case "payeetype": {
                this.getModel().setValue("receiver", null);
                this.getModel().setValue("receivername", null);
                this.getModel().setValue("receiveraccount", null);
                this.getModel().setValue("receiverbank", null);
                this.getModel().setValue("receiverbankno", null);
                this.getView().updateView(ENTRY_ENTITY, this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY));
                if ("other".equals(propValue)) {
                    ((TextEdit)this.getControl("receivername")).setMustInput(true);
                    ((BasedataEdit)this.getControl("receiver")).setMustInput(false);
                    break;
                }
                ((TextEdit)this.getControl("receivername")).setMustInput(false);
                ((BasedataEdit)this.getControl("receiver")).setMustInput(true);
                break;
            }
            case "amount": {
                BigDecimal amounttotal = this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(o -> !o.getBoolean("invalid")).map(v -> v.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.getModel().setValue("amounttotal", (Object)amounttotal);
                if (null == propValue || BigDecimal.ZERO.compareTo((BigDecimal)propValue) == 0) {
                    this.skip = true;
                    this.getModel().setValue("amount", oldValue, rowIndex);
                    return;
                }
                this.getModel().setValue("creditlimit", null);
                this.fillEntryAmountofcreditByAmount(rowIndex);
                this.setSuretyAmount(rowIndex);
                break;
            }
            case "entry_suretyamount": {
                BigDecimal suretyAmount = (BigDecimal)this.getModel().getValue("entry_suretyamount", rowIndex);
                BigDecimal entryAmount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                if (entryAmount.compareTo(BigDecimal.ZERO) == 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7b2c%1s\u884c\u5206\u5f55\u5f00\u7968\u91d1\u989d", (String)"CdmBizResource_181", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), rowIndex + 1), Integer.valueOf(2000));
                    this.skip = true;
                    this.getModel().setValue("entry_suretyamount", oldValue, rowIndex);
                } else if (suretyAmount.compareTo(BigDecimal.ZERO) < 0 || suretyAmount.compareTo(entryAmount) > 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u5206\u5f55\u4fdd\u8bc1\u91d1\u503c\u8303\u56f4\u4e3a\u30100\uff0c%2s\u3011", (String)"CdmBizResource_179", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), rowIndex + 1, entryAmount), Integer.valueOf(2000));
                    this.skip = true;
                    this.getModel().setValue("entry_suretyamount", oldValue, rowIndex);
                }
                this.setCreditAmount(rowIndex);
                break;
            }
            case "acceptercompany": {
                DynamicObject acceptercompanyDO = this.getModel().getDataEntity().getDynamicObject("acceptercompany");
                if (EmptyUtil.isNoEmpty((DynamicObject)acceptercompanyDO)) {
                    this.getModel().setValue("acceptername", (Object)acceptercompanyDO.getString("name"));
                }
                this.getModel().setValue("creditlimitcompany", (Object)acceptercompanyDO);
                break;
            }
            case "currency": {
                this.getDefaultDraftNo();
                break;
            }
            case "receiverbank": {
                DynamicObject dataEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY));
                DynamicObject receiverbankDO = dataEntity.getDynamicObject("receiverbank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)receiverbankDO)) break;
                DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)receiverbankDO.getPkValue(), (String)"bd_bebank");
                this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
                break;
            }
            case "accepterfinorg": {
                DynamicObject accepterFinOrg = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (accepterFinOrg != null) {
                    this.getModel().setValue("acceptername", accepterFinOrg.get("name"));
                    this.getModel().setValue("accepterbankname", accepterFinOrg.get("name"));
                    this.getModel().setValue("accepterbankno", (Object)accepterFinOrg.getString("union_number"));
                } else {
                    this.getModel().setValue("acceptername", null);
                    this.getModel().setValue("accepterbankname", null);
                    this.getModel().setValue("accepterbankno", null);
                }
                this.getModel().setValue("creditlimitorg", (Object)accepterFinOrg);
                break;
            }
            case "accepteraccountid": {
                DynamicObject bankAccount = (DynamicObject)this.getModel().getValue("accepteraccountid");
                if (!EmptyUtil.isNoEmpty((DynamicObject)bankAccount)) break;
                this.getModel().setValue("accepteraccount", (Object)bankAccount.getString("number"));
                this.getModel().setValue("accepterbankname", (Object)bankAccount.getDynamicObject("bank").getString("name"));
                if (bankAccount.getDynamicObject("bank") == null) break;
                DynamicObject finOrgInfo = TmcDataServiceHelper.loadSingle((Object)bankAccount.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo");
                if (finOrgInfo.getDynamicObject("bebank") == null) {
                    this.getModel().setValue("accepterbankno", (Object)finOrgInfo.getString("union_number"));
                    break;
                }
                DynamicObject beBank = TmcDataServiceHelper.loadSingle((Object)finOrgInfo.getDynamicObject("bebank").getPkValue(), (String)"bd_bebank");
                String union_number = beBank.getString("union_number");
                if (StringUtils.isEmpty((CharSequence)union_number)) {
                    this.getModel().setValue("accepterbankno", (Object)beBank.getString("number"));
                    break;
                }
                this.getModel().setValue("accepterbankno", (Object)union_number);
                break;
            }
            case "creditlimit": {
                if (propValue != null) break;
                this.getModel().setValue("creditcurrency", null);
                this.getModel().setValue("amountofcredit", null);
                break;
            }
            case "billingtype": {
                this.fillEntryAmountofcredit();
                if (EmptyUtil.equals((CharSequence)key, (CharSequence)"promisrate")) {
                    this.setSuretyMoney();
                }
                this.setCreditEnableAndValue(propValue);
                break;
            }
            case "promisrate": {
                this.fillEntryAmountofcredit();
                if (!EmptyUtil.equals((CharSequence)key, (CharSequence)"promisrate")) break;
                this.setSuretyMoney();
                break;
            }
            case "amounttotal": {
                this.setSuretyMoney();
                break;
            }
            case "iseditsuretyamount": {
                boolean iseditsuretyamount = (Boolean)this.getModel().getValue("iseditsuretyamount");
                DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY_ENTITY);
                if (iseditsuretyamount) {
                    for (int i = 0; i < entrys.size(); ++i) {
                        this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"entry_suretyamount"});
                    }
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"suretymoney"});
                    this.getModel().setValue("suretymoney", null);
                    break;
                }
                for (int i = 0; i < entrys.size(); ++i) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entry_suretyamount"});
                }
                BigDecimal promisRate = (BigDecimal)this.getModel().getValue("promisrate");
                BigDecimal amountTotal = (BigDecimal)this.getModel().getValue("amounttotal");
                BigDecimal suretyMoney = amountTotal.multiply(promisRate.divide(new BigDecimal(100)));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"suretymoney"});
                this.getModel().setValue("suretymoney", (Object)suretyMoney);
                break;
            }
            case "entry_amountofcredit": {
                BigDecimal entry_amountofcredit = (BigDecimal)propValue;
                DynamicObject entity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
                BigDecimal amount = entity.getBigDecimal("amount");
                if (entry_amountofcredit.compareTo(amount) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5360\u7528\u6388\u4fe1\u989d\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5f00\u7968\u91d1\u989d\u3002", (String)"PayableApplyBillBatchEdit_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    this.skip = true;
                    this.getModel().setValue("entry_amountofcredit", oldValue, rowIndex);
                }
                BigDecimal allAmountofcredit = this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(o -> !o.getBoolean("invalid")).map(v -> v.getBigDecimal("entry_amountofcredit")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.getModel().setValue("creditamount", (Object)allAmountofcredit);
                this.setSuretyAmount(rowIndex);
                break;
            }
            case "creditamount": {
                BigDecimal creditamount = (BigDecimal)propValue;
                BigDecimal totalamount = (BigDecimal)this.getModel().getValue("amounttotal");
                if (creditamount.compareTo(totalamount) <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u5360\u7528\u6388\u4fe1\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u7968\u636e\u91d1\u989d\u5408\u8ba1\u3002", (String)"PayableApplyBillBatchEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("creditamount", (Object)BigDecimal.ZERO);
                break;
            }
            case "creditlimitorg": 
            case "creditlimitcompany": {
                this.getModel().setValue("creditlimit", null);
                break;
            }
            case "accepteraccount": {
                Object accepterAcc = this.getModel().getValue("accepteraccount");
                if (!EmptyUtil.isEmpty((Object)accepterAcc)) break;
                this.skip = true;
                this.getModel().setValue("accepteraccountid", null);
                break;
            }
        }
    }

    private void setSuretyMoney() {
        BigDecimal promisRate = (BigDecimal)this.getModel().getValue("promisrate");
        BigDecimal amountTotal = (BigDecimal)this.getModel().getValue("amounttotal");
        BigDecimal suretyMoney = amountTotal.multiply(promisRate.divide(new BigDecimal(100)));
        this.getModel().setValue("suretymoney", (Object)suretyMoney);
    }

    private void fillEntryAmountofcredit() {
        block5: {
            String settlementtype;
            String billingType = this.getModel().getDataEntity().getString("billingtype");
            if (EmptyUtil.isEmpty((String)billingType)) {
                return;
            }
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            DynamicObject draftbilltype = (DynamicObject)this.getModel().getValue("draftbilltype");
            if (draftbilltype == null || !StringUtils.equals((CharSequence)(settlementtype = draftbilltype.getString("settlementtype")), (CharSequence)SettleMentTypeEnum.BANK.getValue()) && !StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) break block5;
            if (StringUtils.contains((CharSequence)billingType, (CharSequence)"guarantee")) {
                BigDecimal promisrate = (BigDecimal)this.getModel().getValue("promisrate");
                for (int i = 0; i < entryentity.size(); ++i) {
                    BigDecimal amount = ((DynamicObject)entryentity.get(i)).getBigDecimal("amount");
                    BigDecimal entry_amountofcredit = amount.multiply(new BigDecimal(1).subtract(promisrate.multiply(new BigDecimal("0.01"))));
                    this.getModel().setValue("entry_amountofcredit", (Object)entry_amountofcredit, i);
                }
            } else {
                for (int i = 0; i < entryentity.size(); ++i) {
                    BigDecimal amount = ((DynamicObject)entryentity.get(i)).getBigDecimal("amount");
                    this.getModel().setValue("entry_amountofcredit", (Object)amount, i);
                }
            }
        }
    }

    private void setSuretyAmount(int rowIndex) {
        String billingType = this.getModel().getDataEntity().getString("billingtype");
        if (EmptyUtil.isEmpty((String)billingType) || !StringUtils.contains((CharSequence)billingType, (CharSequence)"guarantee")) {
            return;
        }
        BigDecimal promisrate = (BigDecimal)this.getModel().getValue("promisrate");
        BigDecimal amountOfCredit = (BigDecimal)this.getModel().getValue("entry_amountofcredit", rowIndex);
        BigDecimal entryAmount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
        if (EmptyUtil.isEmpty((BigDecimal)amountOfCredit) || BigDecimal.ZERO.compareTo(amountOfCredit) == 0) {
            amountOfCredit = entryAmount.multiply(new BigDecimal(1).subtract(promisrate.multiply(new BigDecimal("0.01"))));
        }
        BigDecimal suretyAmount = entryAmount.subtract(amountOfCredit);
        this.skip = true;
        this.getModel().setValue("entry_suretyamount", (Object)suretyAmount, rowIndex);
    }

    private void setCreditAmount(int rowIndex) {
        String billingType = this.getModel().getDataEntity().getString("billingtype");
        if (EmptyUtil.isEmpty((String)billingType) || !StringUtils.contains((CharSequence)billingType, (CharSequence)"credit")) {
            return;
        }
        BigDecimal entry_suretyamount = (BigDecimal)this.getModel().getValue("entry_suretyamount", rowIndex);
        BigDecimal entryAmount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
        BigDecimal amountOfCredit = entryAmount.subtract(entry_suretyamount);
        this.skip = true;
        this.getModel().setValue("entry_amountofcredit", (Object)amountOfCredit, rowIndex);
        BigDecimal allAmountofcredit = this.getModel().getEntryEntity(ENTRY_ENTITY).stream().filter(o -> !o.getBoolean("invalid")).map(v -> v.getBigDecimal("entry_amountofcredit")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("creditamount", (Object)allAmountofcredit);
    }

    private void fillEntryAmountofcreditByAmount(int rowindex) {
        String settlementtype;
        String billingType = this.getModel().getDataEntity().getString("billingtype");
        if (EmptyUtil.isEmpty((String)billingType)) {
            return;
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        DynamicObject draftbilltype = (DynamicObject)this.getModel().getValue("draftbilltype");
        if (draftbilltype != null && (StringUtils.equals((CharSequence)(settlementtype = draftbilltype.getString("settlementtype")), (CharSequence)SettleMentTypeEnum.BANK.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()))) {
            if (StringUtils.contains((CharSequence)billingType, (CharSequence)"guarantee")) {
                BigDecimal promisrate = (BigDecimal)this.getModel().getValue("promisrate");
                BigDecimal amount = ((DynamicObject)entryentity.get(rowindex)).getBigDecimal("amount");
                BigDecimal entry_amountofcredit = amount.multiply(new BigDecimal(1).subtract(promisrate.multiply(new BigDecimal("0.01"))));
                this.getModel().setValue("entry_amountofcredit", (Object)entry_amountofcredit, rowindex);
            } else {
                BigDecimal amount = ((DynamicObject)entryentity.get(rowindex)).getBigDecimal("amount");
                this.getModel().setValue("entry_amountofcredit", (Object)amount, rowindex);
            }
        }
    }

    private void drawerorgChange() {
        DynamicObject drawerorgDO = (DynamicObject)this.getModel().getValue("drawerorg");
        if (null != drawerorgDO) {
            this.getModel().setValue("drawerbankname", (Object)drawerorgDO.getString("name"));
            this.getModel().setValue("drawerbankno", (Object)drawerorgDO.getString("union_number"));
        } else {
            this.getModel().setValue("drawerbankname", null);
            this.getModel().setValue("drawerbankno", null);
        }
    }

    private void receiverChange() {
        this.getModel().setValue("receiveraccount", null);
        this.getModel().setValue("receiverbank", null);
        this.getModel().setValue("receiverbankno", null);
        DynamicObject dataEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY));
        DynamicObject receiverDO = dataEntity.getDynamicObject("receiver");
        if (EmptyUtil.isNoEmpty((DynamicObject)receiverDO)) {
            DynamicObject payeerDO;
            this.getModel().setValue("receivername", (Object)receiverDO.getString("name"));
            String entityName = receiverDO.getDataEntityType().getName();
            DynamicObject innerOrg = null;
            if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) {
                innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)receiverDO);
                if (innerOrg == null) {
                    DynamicObject bank = TmcDataServiceHelper.loadSingle((String)entityName, (String)"entry_bank.isdefault_bank,entry_bank.bankaccount,entry_bank.bank,entry_bank.bank.union_number", (QFilter[])new QFilter[]{new QFilter("id", "=", receiverDO.getPkValue())});
                    DynamicObjectCollection entryBanks = bank.getDynamicObjectCollection("entry_bank");
                    for (DynamicObject entryBank : entryBanks) {
                        Boolean isdefaultBank = entryBank.getBoolean("isdefault_bank");
                        if (!isdefaultBank.booleanValue()) continue;
                        String bankaccount = entryBank.getString("bankaccount");
                        DynamicObject bankDO = entryBank.getDynamicObject("bank");
                        this.getModel().setValue("receiveraccount", (Object)bankaccount);
                        if (EmptyUtil.isEmpty((DynamicObject)bankDO)) continue;
                        this.getModel().setValue("receiverbank", bankDO.getPkValue());
                        DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)bankDO.getPkValue(), (String)bankDO.getDataEntityType().getName());
                        if (EmptyUtil.isEmpty((DynamicObject)bdBebankDO)) continue;
                        this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
                    }
                }
            } else if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bos_user") && EmptyUtil.isNoEmpty((DynamicObject)(payeerDO = TmcDataServiceHelper.loadSingle((String)"er_payeer", (String)"payerbank,payeraccount", (QFilter[])new QFilter[]{new QFilter("payer.id", "=", receiverDO.getPkValue()), new QFilter("isdefault", "=", (Object)"1")})))) {
                this.getModel().setValue("receiveraccount", (Object)payeerDO.getString("payeraccount"));
                DynamicObject payerbankDO = payeerDO.getDynamicObject("payerbank");
                this.getModel().setValue("receiverbank", payerbankDO.getPkValue());
                DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)payerbankDO.getPkValue(), (String)payerbankDO.getDataEntityType().getName());
                this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
            }
        }
    }

    private void draweraccountChange(Object draftbilltype) {
        this.getModel().setValue("drawerbankname", null);
        this.getModel().setValue("drawerbankno", null);
        DynamicObject dataEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY));
        DynamicObject drawerAccount = dataEntity.getDynamicObject("draweraccount");
        if (EmptyUtil.isNoEmpty((DynamicObject)drawerAccount)) {
            this.getModel().setValue("draweraccountname", (Object)drawerAccount.getString("name"));
            if (EmptyUtil.isEmpty((Object)draftbilltype)) {
                return;
            }
            QFilter accountNumberFilter = new QFilter("account.bankaccountnumber", "=", (Object)drawerAccount.getString("bankaccountnumber"));
            Object[] accountmaintenances = TmcDataServiceHelper.load((String)"am_accountmaintenance", (String)"id,bank,billbank,billbankname", (QFilter[])new QFilter[]{accountNumberFilter});
            if (!EmptyUtil.isEmpty((Object[])accountmaintenances)) {
                DynamicObject finOrgInfoDO = accountmaintenances[0].getDynamicObject("billbank");
                if (!EmptyUtil.isEmpty((DynamicObject)accountmaintenances[0].getDynamicObject("billbank"))) {
                    this.getModel().setValue("drawerbankname", (Object)accountmaintenances[0].getDynamicObject("billbank").getString("name"));
                }
                this.getModel().setValue("drawerbankno", (Object)accountmaintenances[0].getString("billbankname"));
                logger.info("PayableApplyBillBatchEdit accountmaintenances not empty,billbank is \uff1a" + accountmaintenances[0].getDynamicObject("billbank") + ",billbankname is :" + accountmaintenances[0].getString("billbankname"));
            } else {
                if (EmptyUtil.isEmpty((DynamicObject)drawerAccount.getDynamicObject("bank"))) {
                    return;
                }
                DynamicObject finOrgInfoDO = TmcDataServiceHelper.loadSingle((Object)drawerAccount.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo");
                this.getModel().setValue("drawerbankname", (Object)drawerAccount.getDynamicObject("bank").getString("name"));
                if (finOrgInfoDO.getDynamicObject("bebank") == null) {
                    this.getModel().setValue("drawerbankno", (Object)finOrgInfoDO.getString("union_number"));
                } else {
                    DynamicObject beBank = TmcDataServiceHelper.loadSingle((Object)finOrgInfoDO.getDynamicObject("bebank").getPkValue(), (String)"bd_bebank");
                    String union_number = beBank.getString("union_number");
                    if (StringUtils.isEmpty((CharSequence)union_number)) {
                        this.getModel().setValue("drawerbankno", (Object)beBank.getString("number"));
                    } else {
                        this.getModel().setValue("drawerbankno", (Object)union_number);
                    }
                }
                logger.info("PayableApplyBillBatchEdit accountmaintenances is empty");
            }
        }
    }

    private void companyChange(Object draftbilltype) {
        this.getModel().setValue("drawername", null);
        this.getModel().setValue("draweraccount", null);
        this.getModel().setValue("draweraccountname", null);
        this.getModel().setValue("drawerbankname", null);
        this.getModel().setValue("drawerbankno", null);
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            DynamicObject payableApplyBill = this.getModel().getDataEntity();
            DynamicObjectCollection entryentity = payableApplyBill.getDynamicObjectCollection(ENTRY_ENTITY);
            for (DynamicObject entity : entryentity) {
                DynamicObject baseCurrency;
                DynamicObject companyDO = entity.getDynamicObject("drawercompany");
                if (!EmptyUtil.isNoEmpty((DynamicObject)companyDO)) continue;
                this.getModel().setValue("drawername", (Object)companyDO.getString("name"));
                if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                    this.getModel().setValue("acceptercompany", (Object)companyDO);
                    this.getModel().setValue("acceptername", (Object)companyDO.getString("name"));
                }
                if (EmptyUtil.isEmpty((DynamicObject)(baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)companyDO.getPkValue()))))) continue;
                this.getModel().setValue("currency", baseCurrency.getPkValue());
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.companyRegisterListener();
        this.drawerRegisterListener();
        this.draweraccountRegisterListener();
        this.receiveraccountRegisterListener();
        this.receiverbankRegisterListener();
        this.receiverRegisterListener();
        this.accepterFinOrgRegisterListener();
        this.creditlimitClick();
        this.addClickListeners(new String[]{"accepteraccount"});
    }

    private void creditlimitClick() {
        logger.info("creditlimitClick is start that");
        BasedataEdit creditLimitEdit = (BasedataEdit)this.getControl("creditlimit");
        if (EmptyUtil.isNoEmpty((Object)creditLimitEdit)) {
            creditLimitEdit.addBeforeF7SelectListener(this::beforeF7Select);
        }
    }

    private String creditLimitValidator() {
        StringBuilder message = new StringBuilder();
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryentitys)) {
            for (int i = 0; i < entryentitys.size(); ++i) {
                DynamicObject entryentity = (DynamicObject)entryentitys.get(i);
                if (!EmptyUtil.isEmpty((Object)entryentity.getDate("draftbillexpiredate"))) continue;
                message.append(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7b2c %s \u884c\u5206\u5f55\u7684\u7968\u636e\u5230\u671f\u65e5\u3002", (String)"PayableApplyBillBatchEdit_11_2", (String)"tmc-cdm-formplugin", (Object[])new Object[]{i + 1}));
            }
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("creditamount")) || ((BigDecimal)this.getModel().getValue("creditamount")).compareTo(BigDecimal.ZERO) == 0) {
            message.append(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5206\u5f55\u7684\u5360\u7528\u6388\u4fe1\u989d\u5ea6\uff01", (String)"PayableApplyBillBatchEdit_11", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
        }
        if (this.getModel().getValue("currency") == null) {
            message.append(new CdmBizResource().getPbCurrencyChecknull());
        }
        return message.toString();
    }

    private void accepterFinOrgRegisterListener() {
        BasedataEdit accepterFinOrg = (BasedataEdit)this.getControl("accepterfinorg");
        accepterFinOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "accepterfinorg")));
    }

    private void receiverRegisterListener() {
        if (this.getModel().getProperty("receiver") != null) {
            String payeetype;
            BasedataEdit receiver = (BasedataEdit)this.getControl("receiver");
            String string = payeetype = this.getModel().getValue("payeetype") == null ? "" : this.getModel().getValue("payeetype").toString();
            if (receiver != null) {
                receiver.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    if (StringUtils.equals((CharSequence)payeetype, (CharSequence)PayeeTypeEnum.BOS_ORG.getValue())) {
                        QFilter filter = new QFilter("fisbankroll", "=", (Object)"1");
                        showParameter.setCustomParam("orgFuncId", (Object)"08");
                        List qfilter = showParameter.getListFilterParameter().getQFilters();
                        qfilter.add(filter);
                    }
                });
            }
        }
    }

    private void receiverbankRegisterListener() {
        BasedataEdit receiverbank;
        if (this.getModel().getProperty("receiverbank") != null && (receiverbank = (BasedataEdit)this.getControl("receiverbank")) != null) {
            receiverbank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "receiverbank");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void receiveraccountRegisterListener() {
        TextEdit receiveraccount = (TextEdit)this.getControl("receiveraccount");
        receiveraccount.addButtonClickListener(new ClickListener(){

            public void click(EventObject evt) {
                PayableApplyBillBatchEdit.this.showBankInfo();
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.equals((CharSequence)"creditlimit", (CharSequence)actionId)) {
            if (returnData instanceof String) {
                CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)((String)returnData), CreditLimitF7ResBean.class);
                Long creditLimitId = res.getCreditLimitId();
                this.getModel().setValue("creditlimit", (Object)creditLimitId);
                this.getModel().setValue("creditamount", (Object)res.getRealBizAmt());
                this.getModel().setValue("creditcurrency", (Object)res.getTargetCurrencyId());
                this.getModel().setValue("amountofcredit", (Object)res.getExchangeAmt());
            }
        } else if (StringUtils.equals((CharSequence)"basedraftbillno", (CharSequence)actionId) && null != returnData) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            this.getModel().setValue("basedraftbillno", rows.get(0).getPrimaryKeyValue());
        } else if (StringUtils.equals((CharSequence)"cas_entryimport", (CharSequence)actionId) && null != returnData) {
            logger.info("EntryImport >> Data>> " + SerializationUtils.toJsonString((Object)returnData));
            this.entryImportDataHandler((Map)returnData);
            this.getPageCache().remove("cdm_entryimportCache");
        } else {
            ListSelectedRow row;
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            if (rows != null && EmptyUtil.isNoEmpty((Object)(row = rows.get(0)))) {
                switch (actionId) {
                    case "drawercompany": {
                        this.drawercompanyCloseCallback(row);
                        break;
                    }
                    case "draweraccount": {
                        this.draweraccountCloseCallback(row);
                        break;
                    }
                    case "receiveraccount": {
                        this.receiveraccountCloseCallback(row, "receiver", "receiveraccount");
                        break;
                    }
                    case "receiverbank": {
                        this.receiverbankCloseCallback(row);
                        break;
                    }
                    case "company": {
                        this.companyCloseCallBack(row);
                        break;
                    }
                    case "accepterfinorg": {
                        this.getModel().setValue("accepterfinorg", row.getPrimaryKeyValue());
                    }
                }
            }
        }
    }

    private void companyCloseCallBack(ListSelectedRow row) {
        this.getModel().setValue("company", row.getPrimaryKeyValue());
        DynamicObject baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)row.getPrimaryKeyValue()));
        if (!EmptyUtil.isEmpty((DynamicObject)baseCurrency)) {
            this.getModel().setValue("currency", baseCurrency.getPkValue());
        }
    }

    private void receiverbankCloseCallback(ListSelectedRow row) {
        this.getModel().setValue("receiverbank", row.getPrimaryKeyValue());
        DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"bd_bebank");
        if (EmptyUtil.isNoEmpty((DynamicObject)bdBebankDO)) {
            this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
        }
    }

    private void drawercompanyCloseCallback(ListSelectedRow row) {
        this.getModel().setValue("drawercompany", row.getPrimaryKeyValue());
        this.getModel().setValue("drawername", (Object)row.getName());
    }

    private void draweraccountCloseCallback(ListSelectedRow row) {
        this.getModel().setValue("draweraccountname", (Object)row.getNumber());
        this.getModel().setValue("draweraccount", row.getPrimaryKeyValue());
    }

    private void receiveraccountCloseCallback(ListSelectedRow row, String user, String account) {
        Object entryKey = row.getEntryPrimaryKeyValue();
        DynamicObject dataEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY));
        DynamicObject receiver = dataEntity.getDynamicObject(user);
        String entityName = receiver.getDataEntityType().getName();
        DynamicObject innerOrg = null;
        boolean isInternalOrg = false;
        if ("bd_supplier".equals(entityName) || "bd_customer".equals(entityName)) {
            innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)receiver);
            IDataModel model = this.getModel();
            DynamicObject draftTradeBill = model.getDataEntity();
            if (user.equalsIgnoreCase("receiver")) {
                isInternalOrg = BaseDataHelper.isInternalOrg((DynamicObject)draftTradeBill.getDynamicObject("company"));
            }
        }
        if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg == null) {
            this.dealSupplierOrCustomer(user, account, entryKey, receiver);
        } else if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg != null && isInternalOrg) {
            this.dealSupplierOrCustomer(user, account, entryKey, receiver);
        } else if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bos_user")) {
            this.getModel().setValue(account, (Object)row.getNumber());
            if (user.equalsIgnoreCase("receiver")) {
                this.fillUserData(row);
            }
        } else {
            this.getModel().setValue(account, (Object)row.getNumber());
            if (user.equalsIgnoreCase("receiver")) {
                this.fillOther(row);
            }
        }
    }

    private void fillOther(ListSelectedRow row) {
        DynamicObject bankDO;
        DynamicObject accountbanksDO = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"bd_accountbanks");
        if (!EmptyUtil.isEmpty((DynamicObject)accountbanksDO) && !EmptyUtil.isEmpty((DynamicObject)(bankDO = accountbanksDO.getDynamicObject("bank")))) {
            this.getModel().setValue("receiverbankno", (Object)bankDO.getString("union_number"));
            DynamicObject bebankDO = bankDO.getDynamicObject("bebank");
            if (!EmptyUtil.isEmpty((DynamicObject)bebankDO)) {
                this.getModel().setValue("receiverbank", bebankDO.getPkValue());
            } else {
                this.getModel().setValue("receiverbank", null);
            }
        }
    }

    private void fillUserData(ListSelectedRow row) {
        DynamicObject payeerDO = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"er_payeer");
        if (EmptyUtil.isNoEmpty((DynamicObject)payeerDO)) {
            DynamicObject payerbankDO = payeerDO.getDynamicObject("payerbank");
            this.getModel().setValue("receiverbank", (Object)payerbankDO);
            DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)payerbankDO.getPkValue(), (String)payerbankDO.getDataEntityType().getName());
            this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
        }
    }

    private void fillSupplierOrCustomer(DynamicObject entry) {
        this.getModel().setValue("receiverbank", (Object)entry.getDynamicObject("bank"));
        if (EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("bank"))) {
            DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)entry.getDynamicObject("bank").getPkValue(), (String)entry.getDynamicObject("bank").getDataEntityType().getName());
            this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
        }
    }

    private void companyRegisterListener() {
        BasedataEdit company;
        if (this.getModel().getProperty("company") != null && (company = (BasedataEdit)this.getControl("company")) != null) {
            company.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "company");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void drawerRegisterListener() {
        BasedataEdit company;
        if (this.getModel().getProperty("drawercompany") != null && (company = (BasedataEdit)this.getControl("drawercompany")) != null) {
            company.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                Long userPK = RequestContext.get().getCurrUserId();
                String appId = this.getView().getFormShowParameter().getAppId();
                String dataEntityName = this.getModel().getDataEntityType().getName();
                List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)dataEntityName, (String)"47150e89000000ac");
                showParameter.setCustomParam("range", (Object)orgIdSet);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "drawercompany");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void draweraccountRegisterListener() {
        BasedataEdit draweraccount;
        if (this.getModel().getProperty("draweraccount") != null && (draweraccount = (BasedataEdit)this.getControl("draweraccount")) != null) {
            draweraccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                DynamicObject companyDO = this.getModel().getDataEntity().getDynamicObject("company");
                DynamicObject dataEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY));
                DynamicObject drawercompanyDO = dataEntity.getDynamicObject("drawercompany");
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                if (EmptyUtil.isNoEmpty((DynamicObject)drawercompanyDO)) {
                    long orgID = drawercompanyDO.getPkValue() == null ? Long.parseLong(companyDO.getPkValue().toString()) : Long.parseLong(drawercompanyDO.getPkValue().toString());
                    QFilter filter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgID);
                    QFilter filter1 = new QFilter("acctstatus", "=", (Object)"normal");
                    List qfilter = showParameter.getListFilterParameter().getQFilters();
                    qfilter.clear();
                    qfilter.add(filter);
                    qfilter.add(filter1);
                }
                showParameter.getListFilterParameter().getQFilters().add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "draweraccount");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void showBankInfo() {
        DynamicObject draftTradeBill = this.getModel().getEntryRowEntity(ENTRY_ENTITY, this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY));
        DynamicObject receiver = draftTradeBill.getDynamicObject("receiver");
        if (EmptyUtil.isNoEmpty((DynamicObject)receiver)) {
            String receiverEntityType = receiver.getDataEntityType().getName();
            Object receiverId = receiver.getPkValue();
            Object innerOrgId = null;
            if (StringUtils.equals((CharSequence)receiverEntityType, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)receiverEntityType, (CharSequence)"bd_customer")) {
                DynamicObject innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)receiver);
                if (innerOrg == null) {
                    QFilter qFilter = new QFilter("id", "=", receiverId);
                    String entryBankDO = TmcDataServiceHelper.loadSingle((String)receiverEntityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                    if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                        this.getView().showTipNotification(new CdmBizResource().getTipCsNull());
                        return;
                    }
                } else {
                    innerOrgId = innerOrg.getPkValue();
                }
            }
            ListShowParameter lsp = new ListShowParameter();
            boolean isInternalOrg = BaseDataHelper.isInternalOrg((DynamicObject)this.getModel().getDataEntity().getDynamicObject("company"));
            switch (receiverEntityType) {
                case "bd_supplier": {
                    if (innerOrgId != null) {
                        if (isInternalOrg) {
                            lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)receiverId);
                            break;
                        }
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)receiverId);
                    break;
                }
                case "bd_customer": {
                    if (innerOrgId != null) {
                        if (isInternalOrg) {
                            lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)receiverId);
                            break;
                        }
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)receiverId);
                    break;
                }
                case "bos_org": {
                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)receiverId);
                    break;
                }
                case "bos_user": {
                    lsp = ListConstructorHelper.getPayeerInfoShowParameter((Object)receiverId);
                    break;
                }
            }
            if (lsp != null) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "receiveraccount");
                lsp.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)lsp);
            }
        } else {
            String payeetypeObj = draftTradeBill.getString("payeetype");
            if (null != payeetypeObj) {
                String payeetype = payeetypeObj.toString();
                if (!StringUtils.equals((CharSequence)payeetype, (CharSequence)PayeeTypeEnum.OTHER.getValue())) {
                    this.switchPromiser("receiver");
                }
            } else {
                this.switchPromiser("receiver");
            }
        }
    }

    private void switchPromiser(String accountName) {
        switch (accountName) {
            case "receiver": {
                this.getView().showTipNotification(new CdmBizResource().getTipReceiverShort());
                return;
            }
        }
    }

    private void entryImportDataHandler(Map<String, Object> returnData) {
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<Integer> deleteList = new ArrayList<Integer>(10);
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject entrydy = (DynamicObject)entryEntitys.get(i);
            if (!EmptyUtil.isEmpty((BigDecimal)entrydy.getBigDecimal("amount"))) continue;
            deleteList.add(i);
        }
        int[] deleteNum1 = new int[deleteList.size()];
        for (int k = 0; k < deleteList.size(); ++k) {
            deleteNum1[k] = (Integer)deleteList.get(k);
        }
        this.getModel().deleteEntryRows(ENTRY_ENTITY, deleteNum1);
        this.getView().updateView(ENTRY_ENTITY);
        deleteList.clear();
        List rowDatas = (List)returnData.get("rowDatas");
        StringBuilder errorInfo = new StringBuilder();
        boolean isdelete = false;
        int dealRow = 4;
        for (int rowNum = 0; rowNum < rowDatas.size(); ++rowNum) {
            Map row = (Map)rowDatas.get(rowNum);
            this.getView().invokeOperation("newentry");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            ++dealRow;
            try {
                block32: for (Map.Entry entry : row.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (value == null || CasHelper.isEmpty((Object)value)) {
                        if ("entryentity_id".equals(key)) continue;
                        if ("drawercompany.number".equals(key) || "drawercompany.name".equals(key)) {
                            String drawercompanyNumber = (String)row.get("drawercompany.number");
                            String drawercompanyName = (String)row.get("drawercompany.name");
                            if (EmptyUtil.isEmpty((String)drawercompanyNumber) && EmptyUtil.isEmpty((String)drawercompanyName)) {
                                Object company;
                                DynamicObject draftTypeDy = (DynamicObject)this.getModel().getValue("draftbilltype");
                                String settlementtype = draftTypeDy.getString("settlementtype");
                                if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue()) || null == (company = this.getModel().getValue("company"))) continue;
                                DynamicObject companyDy = (DynamicObject)company;
                                this.getModel().setValue("drawercompany", (Object)companyDy.getLong("id"), rowIndex);
                                this.getModel().setValue("drawername", (Object)companyDy.getString("name"), rowIndex);
                                continue;
                            }
                        }
                    }
                    switch (key) {
                        case "draweraccount.bankaccountnumber": {
                            QFilter qFilter = new QFilter("bankaccountnumber", "=", (Object)value);
                            DynamicObject drawerAccount = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,name,bank,bankaccountnumber", (QFilter[])new QFilter[]{qFilter});
                            this.getModel().setValue("draweraccount", (Object)drawerAccount, rowIndex);
                            break;
                        }
                        case "draweraccount.number": {
                            QFilter qFilterNumber = new QFilter("number", "=", (Object)value);
                            DynamicObject drawerAccountByNum = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,name,bank,bankaccountnumber", (QFilter[])new QFilter[]{qFilterNumber});
                            this.getModel().setValue("draweraccount", (Object)drawerAccountByNum, rowIndex);
                            break;
                        }
                        case "payeetype": {
                            String payType = (String)row.get("payeetype");
                            String payeetype = this.getPayRecType(payType);
                            this.skip = true;
                            this.getModel().setValue(key, (Object)payeetype, rowIndex);
                            break;
                        }
                        case "receivertype": {
                            String recTypeStr = (String)row.get("payeetype");
                            String recTypeEm = this.getPayRecType(recTypeStr);
                            this.getModel().setValue(key, (Object)recTypeEm, rowIndex);
                            break;
                        }
                        case "receivername": 
                        case "receiver.name": {
                            Object draftbilltype;
                            DynamicObject draftbilltypeDO;
                            String settlementtype;
                            String recType = (String)row.get("payeetype");
                            String payeetypeStr = this.getPayRecType(recType);
                            String errorMessage = "";
                            if (EmptyUtil.isEmpty((String)payeetypeStr) || "other".equals(payeetypeStr)) continue block32;
                            if (EmptyUtil.isEmpty((String)value)) break;
                            QFilter qFilter = new QFilter("name", "=", (Object)value);
                            DynamicObject receiver = TmcDataServiceHelper.loadSingle((String)payeetypeStr, (String)"id,name,number", (QFilter[])new QFilter[]{qFilter});
                            if (EmptyUtil.isEmpty((DynamicObject)receiver)) break;
                            DynamicObject companyDO = this.getModel().getDataEntity().getDynamicObject("company");
                            if (companyDO != null && !StringUtils.equals((CharSequence)(settlementtype = (draftbilltypeDO = (DynamicObject)(draftbilltype = this.getModel().getValue("draftbilltype"))).getString("settlementtype")), (CharSequence)SettleMentTypeEnum.CHECK.getValue()) && (payeetypeStr.equals("bd_supplier") || payeetypeStr.equals("bd_customer"))) {
                                long checkId = 0L;
                                DynamicObject drawerCompany = null;
                                if (row.containsKey("drawercompany.number") && null != row.get("drawercompany.number") && !"".equals(row.get("drawercompany.number"))) {
                                    String drawerCompanyNum = (String)row.get("drawercompany.number");
                                    drawerCompany = TmcDataServiceHelper.loadSingle((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)drawerCompanyNum)});
                                    checkId = drawerCompany.getLong("id");
                                } else if (row.containsKey("drawercompany.name") && null != row.get("drawercompany.name") && !"".equals(row.get("drawercompany.name"))) {
                                    String drawerCompanyName = (String)row.get("drawercompany.name");
                                    drawerCompany = TmcDataServiceHelper.loadSingle((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)drawerCompanyName)});
                                    checkId = drawerCompany.getLong("id");
                                } else {
                                    checkId = companyDO.getLong("id");
                                }
                                BaseDataHelper.checkCustomerOrSupplyAuth((String)"PayableApply", (String)payeetypeStr, (Long)receiver.getLong("id"), (Long)checkId);
                            }
                            this.getModel().setValue("receivertype", (Object)payeetypeStr, rowIndex);
                            this.skip = true;
                            this.getModel().setValue("receiver", receiver.getPkValue(), rowIndex);
                            this.skip = true;
                            this.getModel().setValue("receivername", receiver.get("name"), rowIndex);
                            break;
                        }
                        case "receiver.number": {
                            String recTypeNum = (String)row.get("payeetype");
                            String rectypeStr = this.getPayRecType(recTypeNum);
                            if (EmptyUtil.isEmpty((String)rectypeStr) || "other".equals(rectypeStr)) continue block32;
                            if (EmptyUtil.isEmpty((String)value)) break;
                            QFilter qFilterRecNum = new QFilter("number", "=", (Object)value);
                            DynamicObject recOrg = TmcDataServiceHelper.loadSingle((String)rectypeStr, (String)"id,name", (QFilter[])new QFilter[]{qFilterRecNum});
                            if (EmptyUtil.isEmpty((DynamicObject)recOrg)) break;
                            this.getModel().setValue("receivertype", (Object)rectypeStr, rowIndex);
                            this.skip = true;
                            this.getModel().setValue("receiver", recOrg.getPkValue(), rowIndex);
                            this.skip = true;
                            this.getModel().setValue("receivername", recOrg.get("name"), rowIndex);
                            break;
                        }
                        case "receiverbank": 
                        case "receiverbank.number": {
                            QFilter qFilterRecBankNum = new QFilter("number", "=", (Object)value);
                            DynamicObject revBank = TmcDataServiceHelper.loadSingle((String)"bd_bebank", (String)"id,name", (QFilter[])new QFilter[]{qFilterRecBankNum});
                            if (EmptyUtil.isEmpty((DynamicObject)revBank)) break;
                            this.getModel().setValue("receiverbank", revBank.getPkValue(), rowIndex);
                            break;
                        }
                        case "drawerorg.number": {
                            QFilter qFilterDrawerOrgNum = new QFilter("number", "=", (Object)value);
                            DynamicObject drawerOrg = TmcDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id,name", (QFilter[])new QFilter[]{qFilterDrawerOrgNum});
                            if (EmptyUtil.isEmpty((DynamicObject)drawerOrg)) break;
                            this.getModel().setValue("drawerorg", drawerOrg.getPkValue(), rowIndex);
                            break;
                        }
                        case "drawerbankno": {
                            break;
                        }
                        case "drawercompany.number": 
                        case "drawercompany.name": {
                            QFilter qFilterDrawerCompanyNum = key.equals("drawercompany.number") ? new QFilter("number", "=", (Object)value) : new QFilter("name", "=", (Object)value);
                            DynamicObject drawerCompany = TmcDataServiceHelper.loadSingle((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{qFilterDrawerCompanyNum});
                            if (EmptyUtil.isEmpty((DynamicObject)drawerCompany)) break;
                            this.getModel().setValue("drawercompany", drawerCompany.getPkValue(), rowIndex);
                            this.getModel().setValue("drawername", (Object)drawerCompany.getString("name"), rowIndex);
                            break;
                        }
                        default: {
                            String entrityName;
                            IDataEntityProperty property = this.getModel().getProperty(key);
                            if (property == null || !ENTRY_ENTITY.equals(entrityName = property.getParent().getName())) continue block32;
                            this.getModel().setValue(key, (Object)value, rowIndex);
                        }
                    }
                }
                if (!isdelete) continue;
                throw new KDBizException(errorInfo.toString());
            }
            catch (KDBizException bizExp) {
                logger.info("EntryImport >> data >> " + (Object)((Object)bizExp));
                errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"PayableApplyBillBatchEdit_17", (String)"tmc-cdm-formplugin", (Object[])new Object[0])).append(dealRow).append(ResManager.loadKDString((String)"\u884c\uff1a", (String)"PayableApplyBillBatchEdit_18", (String)"tmc-cdm-formplugin", (Object[])new Object[0])).append(bizExp.getMessage()).append("\r\n");
                deleteList.add(rowIndex);
            }
        }
        if (!CasHelper.isEmpty((Object)errorInfo.toString())) {
            int[] deleteNum2 = new int[deleteList.size()];
            for (int k = 0; k < deleteList.size(); ++k) {
                deleteNum2[k] = (Integer)deleteList.get(k);
            }
            this.getModel().deleteEntryRows(ENTRY_ENTITY, deleteNum2);
            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u5f02\u5e38, \u63d0\u793a\u4fe1\u606f\u5982\u4e0b!", (String)"PayableApplyBillBatchEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), errorInfo.toString(), MessageTypes.Default);
        }
    }

    private String getPayRecType(String value) {
        String payeetype = ResManager.loadKDString((String)"\u516c\u53f8", (String)"PayableApplyBillBatchEdit_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]).equals(value) ? "bos_org" : (ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"PayableApplyBillBatchEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]).equals(value) ? "bd_supplier" : (ResManager.loadKDString((String)"\u5ba2\u6237", (String)"PayableApplyBillBatchEdit_10", (String)"tmc-cdm-formplugin", (Object[])new Object[0]).equals(value) ? "bd_customer" : (ResManager.loadKDString((String)"\u804c\u5458", (String)"PayableApplyBillBatchEdit_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]).equals(value) ? "bos_user" : (ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"PayableApplyBillBatchEdit_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]).equals(value) ? "bos_org" : "other"))));
        return payeetype;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.updateCountBalanceAmt();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.updateCountBalanceAmt();
    }

    private void updateCountBalanceAmt() {
        this.getModel().updateCache();
        this.getModel().setValue("count", (Object)this.getModel().getEntryRowCount(ENTRY_ENTITY));
    }

    private void dealSupplierOrCustomer(String user, String account, Object entryKey, DynamicObject receiver) {
        DynamicObjectCollection entryBank;
        DynamicObject bank = TmcDataServiceHelper.loadSingle((String)receiver.getDataEntityType().getName(), (String)"bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", entryKey)});
        if (!EmptyUtil.isEmpty((DynamicObject)bank) && !EmptyUtil.isEmpty((DynamicObjectCollection)(entryBank = bank.getDynamicObjectCollection("entry_bank")))) {
            for (DynamicObject entry : entryBank) {
                if (!entry.getPkValue().equals(entryKey)) continue;
                this.getModel().setValue(account, (Object)entry.getString("bankaccount"));
                if (!user.equalsIgnoreCase("receiver")) break;
                this.fillSupplierOrCustomer(entry);
                break;
            }
        }
    }

    private void beforeF7Select(BeforeF7SelectEvent evt) {
        String message = this.creditLimitValidator();
        if (EmptyUtil.isNoEmpty((String)message)) {
            this.getView().showErrorNotification(message);
            evt.setCancel(true);
            return;
        }
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id.equals(0L)) {
            id = DB.genLongId((String)this.getModel().getDataEntityType().getAlias());
            this.getModel().setValue("id", (Object)id);
        }
        useBean.setPkId(id);
        useBean.setBillNo((String)this.getModel().getValue("billno"));
        useBean.setEntityName("cdm_payablebill_ap_manual");
        useBean.setOrgId((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue());
        useBean.setCurrencyId((Long)((DynamicObject)this.getModel().getValue("currency")).getPkValue());
        DynamicObject draftbilltype = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltype)) {
            String settlementType = draftbilltype.getString("settlementtype");
            if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                DynamicObject creditlimitorg = this.getModel().getDataEntity().getDynamicObject("creditlimitorg");
                if (EmptyUtil.isEmpty((DynamicObject)creditlimitorg)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u627f\u5151\u4eba\u5168\u79f0\u3002", (String)"PayableApplyBillBatchEdit_12", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                useBean.setFinOrgId(Long.valueOf(creditlimitorg.getLong("id")));
                useBean.setCreditFinType("bd_finorginfo");
            } else if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
                boolean innerCreditLimit = (Boolean)this.getModel().getValue("innercreditlimit");
                if (innerCreditLimit) {
                    DynamicObject creditlimitcompany = this.getModel().getDataEntity().getDynamicObject("creditlimitcompany");
                    if (EmptyUtil.isEmpty((DynamicObject)creditlimitcompany)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u627f\u5151\u4eba\u5168\u79f0\u3002", (String)"PayableApplyBillBatchEdit_12", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    useBean.setFinOrgId(Long.valueOf(creditlimitcompany.getLong("id")));
                    useBean.setCreditFinType("bos_org");
                } else {
                    DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(ENTRY_ENTITY);
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryentitys)) {
                        HashSet<String> drawerBankNameSet = new HashSet<String>(8);
                        for (DynamicObject entryentity : entryentitys) {
                            String drawerBankName = entryentity.getString("drawerbankname");
                            if (EmptyUtil.isEmpty((String)drawerBankName)) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u51fa\u7968\u4eba\u5f00\u6237\u94f6\u884c\u3002", (String)"PayableApplyBillBatchEdit_13", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                                evt.setCancel(true);
                                return;
                            }
                            drawerBankNameSet.add(drawerBankName);
                        }
                        if (EmptyUtil.isNoEmpty(drawerBankNameSet) && drawerBankNameSet.size() != 1) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u7684\u51fa\u7968\u4eba\u5f00\u6237\u94f6\u884c\u4e0d\u4e00\u81f4\u3002", (String)"PayableApplyBillBatchEdit_14", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                            evt.setCancel(true);
                            return;
                        }
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u51fa\u7968\u4eba\u5f00\u6237\u94f6\u884c\u3002", (String)"PayableApplyBillBatchEdit_13", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    DynamicObject drawerAccount = ((DynamicObject)entryentitys.get(0)).getDynamicObject("draweraccount");
                    if (EmptyUtil.isNoEmpty((DynamicObject)drawerAccount)) {
                        DynamicObject bank = drawerAccount.getDynamicObject("bank");
                        useBean.setFinOrgId(Long.valueOf(bank.getLong("id")));
                        useBean.setCreditFinType("bd_finorginfo");
                    }
                }
            }
            DynamicObject credittypeDO = draftbilltype.getDynamicObject("credittype");
            if (EmptyUtil.isNoEmpty((DynamicObject)credittypeDO)) {
                useBean.setCreditTypeId((Long)credittypeDO.getPkValue());
            } else {
                DynamicObject creditType = TmcDataServiceHelper.loadSingle((String)"cfm_credittype", (String)"iscomprehensive", (QFilter[])new QFilter[]{new QFilter("iscomprehensive", "=", (Object)"1")});
                useBean.setCreditTypeId((Long)creditType.getPkValue());
            }
        }
        useBean.setCreditVariety(draftbilltype.getString("name"));
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        useBean.setBizAmt((BigDecimal)this.getModel().getValue("creditamount"));
        useBean.setMaxAmt((BigDecimal)this.getModel().getValue("amounttotal"));
        useBean.setStartDate(bizdate);
        DynamicObjectCollection entitys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        Date draftbillexpiredate = null;
        if (entitys.size() == 1) {
            boolean invalid = ((DynamicObject)entitys.get(0)).getBoolean("invalid");
            if (!invalid) {
                draftbillexpiredate = ((DynamicObject)entitys.get(0)).getDate("draftbillexpiredate");
            }
        } else {
            Optional<DynamicObject> entryMaxDate = entitys.stream().filter(x -> !x.getBoolean("invalid")).max(Comparator.comparing(e -> e.getDate("draftbillexpiredate")));
            if (entryMaxDate.isPresent()) {
                draftbillexpiredate = entryMaxDate.get().getDate("draftbillexpiredate");
            }
        }
        if (EmptyUtil.isEmpty(draftbillexpiredate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u660e\u7ec6\u5df2\u5168\u90e8\u4f5c\u5e9f\u3002", (String)"PayableApplyBillBatchEdit_16", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        useBean.setEndDate(draftbillexpiredate);
        FormShowParameter sp = evt.getFormShowParameter();
        sp.setCustomParam("KEY_F7PARAM", (Object)useBean);
        sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "creditlimit"));
    }

    private void setCreditEnableAndValue(Object billingType) {
        if (billingType == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"advconap_surety"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"advconap_gcuse"});
        } else {
            String billingTypeStr = billingType.toString();
            this.getView().setEnable(Boolean.valueOf(billingTypeStr.contains("guarantee")), new String[]{"advconap_surety"});
            this.getView().setEnable(Boolean.valueOf(billingTypeStr.contains("assure") || billingTypeStr.contains("pledge") || billingTypeStr.contains("mortgage")), new String[]{"advconap_gcuse"});
            StringBuilder guarantee = new StringBuilder(",");
            for (String billingTypes : billingTypeStr.split(",")) {
                if ("assure".equals(billingTypes)) {
                    guarantee.append("2").append(",");
                    continue;
                }
                if ("pledge".equals(billingTypes)) {
                    guarantee.append("4").append(",");
                    continue;
                }
                if (!"mortgage".equals(billingTypes)) continue;
                guarantee.append("5").append(",");
            }
            this.getModel().setValue("guarantee", (Object)guarantee.toString());
        }
    }
}

