/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class PayableApplyBillBatchList
extends AbstractTmcBillBaseList {
    private static final Log logger = LogFactory.getLog(PayableApplyBillBatchList.class);
    private static final String SURETYREMAINAMOUNT = "entryentity.entry_suretyremainamount";
    private static final String AMOUNTOFCREDIT = "entryentity.entry_creditamount";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        String itemKey = evt.getItemKey();
        Set<Long> idsSet = selectedRows.stream().map(e -> (Long)e.getPrimaryKeyValue()).collect(Collectors.toSet());
        if ("submitdraft".equals(itemKey)) {
            boolean incluleGuarantee = false;
            Map<Long, Long> entrySurety = this.getEntrySurety(idsSet);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryData", (String)"cdm_payablebill_ap_manual", (String)"id,billingtype", (QFilter[])new QFilter[]{new QFilter("id", "in", idsSet)}, null);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    String billingType = row.getString("billingtype");
                    if (!StringUtils.contains((CharSequence)billingType, (CharSequence)"guarantee") || entrySurety.get(row.getLong("id")) != null) continue;
                    incluleGuarantee = true;
                }
            }
            if (incluleGuarantee) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u6709\u672a\u7f34\u5b58\u7684\u4fdd\u8bc1\u91d1\uff0c\u63d0\u4ea4\u5f00\u7968\u767b\u8bb0\u540e\u53ea\u80fd\u5728\u5f00\u7968\u767b\u8bb0\u5355\u636e\u5185\u64cd\u4f5c\u5b58\u5165\u4fdd\u8bc1\u91d1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayableApplyBillBatchList_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirm_close", (IFormPlugin)this));
                evt.setCancel(true);
            } else {
                this.getView().invokeOperation("afterpush");
            }
        } else if ("tblsuretybill".equals(itemKey)) {
            if (selectedRows.size() <= 0) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e!", (String)"AbstractTmcListPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] payBillApList = TmcDataServiceHelper.load((String)"cdm_payablebill_ap_manual", (String)"id,billingtype,entry_surety.suretybill,entryentity.entry_suretyamount", (QFilter[])new QFilter[]{new QFilter("id", "in", idsSet)});
            boolean isSuretyIng = false;
            for (DynamicObject payBillAp : payBillApList) {
                DynamicObjectCollection entryEntity;
                BigDecimal suretyMoney;
                String billingType = payBillAp.getString("billingtype");
                if (!StringUtils.contains((CharSequence)billingType, (CharSequence)"guarantee")) continue;
                DynamicObjectCollection suretyBills = payBillAp.getDynamicObjectCollection("entry_surety");
                for (DynamicObject suretyBill : suretyBills) {
                    DynamicObject suretyBillBo = suretyBill.getDynamicObject("suretybill");
                    if ("surety_ing".equals(suretyBillBo.getString("bizstatus"))) continue;
                    isSuretyIng = true;
                    break;
                }
                if (BigDecimal.ZERO.compareTo(suretyMoney = (entryEntity = payBillAp.getDynamicObjectCollection("entryentity")).stream().map(o -> o.getBigDecimal("entry_suretyamount")).reduce(BigDecimal.ZERO, BigDecimal::add)) < 0) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u4fdd\u8bc1\u91d1\u91d1\u989d\u540e\u518d\u5b58\u5165\u4fdd\u8bc1\u91d1\u3002", (String)"PayableBillList_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (isSuretyIng) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u4fdd\u8bc1\u91d1\u5b58\u5165\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\u5b58\u5165\u4fdd\u8bc1\u91d1\uff1f", (String)"PayableApplyBillBatchList_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("surety_in", (IFormPlugin)this));
                evt.setCancel(true);
            } else {
                this.getView().invokeOperation("suretyconfigm");
            }
        }
    }

    private Map<Long, Long> getEntrySurety(Set<Long> idsSet) {
        HashMap<Long, Long> entryids = new HashMap<Long, Long>(16);
        if (EmptyUtil.isEmpty(idsSet)) {
            return entryids;
        }
        QFilter[] filters = new QFilter[]{new QFilter("entry.debtbillid", "in", idsSet)};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"querySuretyBill", (String)"fbd_suretybill", (String)"id, entry.debtbillid", (QFilter[])filters, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                entryids.put(row.getLong("entry.debtbillid"), row.getLong("id"));
            }
        }
        return entryids;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirm_close".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getView().invokeOperation("afterpush");
            }
        } else if ("surety_in".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation("suretyconfigm");
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new GetListDataProvider());
    }

    static class GetListDataProvider
    extends ListDataProvider {
        GetListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            boolean isNeedCalSurety;
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            ArrayList ids = new ArrayList(rows.size());
            boolean isContainSurety = false;
            boolean isContainCredit = false;
            DataEntityPropertyCollection properties = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties();
            if (properties.containsKey((Object)PayableApplyBillBatchList.SURETYREMAINAMOUNT)) {
                isContainSurety = true;
            }
            if (properties.containsKey((Object)PayableApplyBillBatchList.AMOUNTOFCREDIT)) {
                isContainCredit = true;
            }
            logger.info("isContainCredit is:" + isContainCredit + ",isContainSurety:" + isContainSurety);
            if (!isContainCredit && !isContainSurety) {
                return rows;
            }
            rows.forEach(row -> ids.add(row.getLong("id")));
            if (ids.size() == 0) {
                return rows;
            }
            Map<Object, Object> draftIdAndCreditMap = new HashMap(8);
            Map<Object, Object> draftIdAndSuretyMap = new HashMap(8);
            if (isContainCredit || isContainSurety) {
                DynamicObjectCollection suretybills;
                Set hasSuretyPayDraftIdSet;
                QFilter status_qFilter;
                QFilter isrele_qFilter;
                QFilter source_qFilter;
                DynamicObjectCollection creditUses;
                Set hasCreditPayDraftIdSet;
                DynamicObjectCollection payDraftList = QueryServiceHelper.query((String)"cdm_payablebill_ap_manual", (String)"id,creditlimit,billingtype", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                if (isContainCredit && EmptyUtil.isNoEmpty(hasCreditPayDraftIdSet = payDraftList.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getLong("creditlimit"))).map(x -> x.getLong("id")).collect(Collectors.toSet())) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(creditUses = QueryServiceHelper.query((String)"cfm_credituse", (String)"sourcebillentryid,sourcebillid, realamt", (QFilter[])new QFilter[]{source_qFilter = new QFilter("sourcebillid", "in", hasCreditPayDraftIdSet), isrele_qFilter = new QFilter("isrelease", "=", (Object)"0"), status_qFilter = new QFilter("billstatus", "=", (Object)"C")})))) {
                    draftIdAndCreditMap = creditUses.stream().collect(Collectors.groupingBy(e -> e.getLong("sourcebillid")));
                }
                if (isContainSurety && EmptyUtil.isNoEmpty(hasSuretyPayDraftIdSet = payDraftList.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getString("billingtype")) && e.getString("billingtype").contains("guarantee")).map(x -> x.getLong("id")).collect(Collectors.toSet())) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(suretybills = QueryServiceHelper.query((String)"fbd_suretybill", (String)"entry.debtbillid,surplusamount,id", (QFilter[])new QFilter[]{source_qFilter = new QFilter("entry.debtbillid", "in", hasSuretyPayDraftIdSet)})))) {
                    draftIdAndSuretyMap = suretybills.stream().collect(Collectors.groupingBy(e -> e.getLong("entry.debtbillid")));
                }
            }
            boolean isNeedCalCredit = isContainCredit && EmptyUtil.isNoEmpty(draftIdAndCreditMap) && draftIdAndCreditMap.size() > 0;
            boolean bl = isNeedCalSurety = isContainSurety && EmptyUtil.isNoEmpty(draftIdAndSuretyMap) && draftIdAndSuretyMap.size() > 0;
            if (isNeedCalCredit || isNeedCalSurety) {
                for (DynamicObject row2 : rows) {
                    List suretyDyList;
                    long draftBillId;
                    List creditDyList;
                    if (isNeedCalCredit && EmptyUtil.isNoEmpty((Object)(creditDyList = (List)draftIdAndCreditMap.get(draftBillId = row2.getLong("id"))))) {
                        DynamicObject creditDy = (DynamicObject)creditDyList.get(0);
                        BigDecimal realamt = creditDy.getBigDecimal("realamt");
                        row2.set(PayableApplyBillBatchList.AMOUNTOFCREDIT, (Object)realamt);
                    }
                    if (!isNeedCalSurety || !EmptyUtil.isNoEmpty((Object)(suretyDyList = (List)draftIdAndSuretyMap.get(draftBillId = row2.getLong("id"))))) continue;
                    DynamicObject suretyDy = (DynamicObject)suretyDyList.get(0);
                    BigDecimal surplusamount = suretyDy.getBigDecimal("surplusamount");
                    row2.set(PayableApplyBillBatchList.SURETYREMAINAMOUNT, (Object)surplusamount);
                }
            }
            return rows;
        }
    }
}

