/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.payablebill;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.bean.CreditLimitF7ResBean;
import kd.tmc.cdm.common.constant.CdmBizConstant;
import kd.tmc.cdm.common.enums.BillTypeUnitEnum;
import kd.tmc.cdm.common.enums.PayeeTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.cdm.common.helper.ChequeHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.ListConstructorHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class PayableApplyBillEdit
extends AbstractTmcBillEdit {
    public void afterCreateNewData(EventObject e) {
        this.issuedateChange();
        DynamicObject companyDO = this.getModel().getDataEntity().getDynamicObject("company");
        if (!EmptyUtil.isEmpty((DynamicObject)companyDO)) {
            DynamicObject baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)companyDO.getPkValue()));
            if (EmptyUtil.isNoEmpty((DynamicObject)baseCurrency)) {
                this.getModel().setValue("currency", baseCurrency.getPkValue());
            }
            this.getModel().setValue("drawername", (Object)companyDO.getString("name"));
        }
        this.getDefaultDraftNo();
        ((FieldEdit)this.getView().getControl("receiver")).setMustInput(true);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.companyRegisterListener();
        this.drawerRegisterListener();
        this.draweraccountRegisterListener();
        this.receiveraccountRegisterListener();
        this.receiverbankRegisterListener();
        this.receiverRegisterListener();
        this.accepterFinOrgRegisterListener();
        this.issuePromiserAccountRegisterListener();
        this.acceptPromiserAccountRegisterListener();
    }

    private void acceptPromiserAccountRegisterListener() {
        TextEdit receiveraccount = (TextEdit)this.getControl("acceptpromiseraccount");
        receiveraccount.addButtonClickListener(new ClickListener(){

            public void click(EventObject evt) {
                PayableApplyBillEdit.this.showBankInfo("acceptpromiser", "acceptpromisertype", "acceptpromiseraccount");
            }
        });
    }

    private void issuePromiserAccountRegisterListener() {
        TextEdit receiveraccount = (TextEdit)this.getControl("issuepromiseraccount");
        receiveraccount.addButtonClickListener(new ClickListener(){

            public void click(EventObject evt) {
                PayableApplyBillEdit.this.showBankInfo("issuepromiser", "issuepromisertype", "issuepromiseraccount");
            }
        });
    }

    private void showBankInfo(String accountName, String accountType, String account) {
        IDataModel model = this.getModel();
        DynamicObject draftTradeBill = model.getDataEntity();
        DynamicObject receiver = draftTradeBill.getDynamicObject(accountName);
        if (EmptyUtil.isNoEmpty((DynamicObject)receiver)) {
            String receiverEntityType = receiver.getDataEntityType().getName();
            Object receiverId = receiver.getPkValue();
            Object innerOrgId = null;
            if (StringUtils.equals((CharSequence)receiverEntityType, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)receiverEntityType, (CharSequence)"bd_customer")) {
                DynamicObject innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)receiver);
                if (innerOrg == null) {
                    String qFilter = new QFilter("id", "=", receiverId);
                    DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)receiverEntityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                    if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                        this.getView().showTipNotification(new CdmBizResource().getTipCsNull());
                        return;
                    }
                } else {
                    innerOrgId = innerOrg.getPkValue();
                }
            }
            ListShowParameter lsp = new ListShowParameter();
            switch (receiverEntityType) {
                case "bd_supplier": {
                    if (innerOrgId != null) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)receiverId);
                    break;
                }
                case "bd_customer": {
                    if (innerOrgId != null) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)receiverId);
                    break;
                }
                case "bos_org": {
                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)receiverId);
                    break;
                }
                case "bos_user": {
                    lsp = ListConstructorHelper.getPayeerInfoShowParameter((Object)receiverId);
                    break;
                }
            }
            if (lsp != null) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, account);
                lsp.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)lsp);
            }
        } else {
            Object payeetypeObj = this.getModel().getValue(accountType);
            if (null != payeetypeObj) {
                String payeetype = payeetypeObj.toString();
                if (!StringUtils.equals((CharSequence)payeetype, (CharSequence)PayeeTypeEnum.OTHER.getValue())) {
                    this.switchPromiser(accountName);
                }
            } else {
                this.switchPromiser(accountName);
            }
        }
    }

    private void switchPromiser(String accountName) {
        switch (accountName) {
            case "issuepromiser": {
                this.getView().showTipNotification(new CdmBizResource().getIssuePromiserMsg());
                return;
            }
            case "acceptpromiser": {
                this.getView().showTipNotification(new CdmBizResource().getAcceptPromiserMsg());
                return;
            }
            case "receiver": {
                this.getView().showTipNotification(new CdmBizResource().getTipReceiverShort());
                return;
            }
        }
    }

    private void accepterFinOrgRegisterListener() {
        BasedataEdit accepterFinOrg = (BasedataEdit)this.getControl("accepterfinorg");
        accepterFinOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "accepterfinorg")));
    }

    private void receiverRegisterListener() {
        if (this.getModel().getProperty("receiver") != null) {
            String payeetype;
            BasedataEdit receiver = (BasedataEdit)this.getControl("receiver");
            String string = payeetype = this.getModel().getValue("payeetype") == null ? "" : this.getModel().getValue("payeetype").toString();
            if (receiver != null) {
                receiver.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    if (StringUtils.equals((CharSequence)payeetype, (CharSequence)PayeeTypeEnum.BOS_ORG.getValue())) {
                        QFilter filter = new QFilter("fisbankroll", "=", (Object)"1");
                        showParameter.setCustomParam("orgFuncId", (Object)"08");
                        List qfilter = showParameter.getListFilterParameter().getQFilters();
                        qfilter.add(filter);
                    }
                });
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getDefaultDraftNo();
    }

    private void getDefaultDraftNo() {
        Object draftType = this.getModel().getValue("draftbilltype");
        this.getModel().setValue("payable", (Object)Character.valueOf('0'));
        if (!DraftHelper.isPromissory((Object)draftType)) {
            return;
        }
        DynamicObject acct = (DynamicObject)this.getModel().getValue("draweraccount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject billType = (DynamicObject)this.getModel().getValue("draftbilltype");
        this.getModel().setValue("basedraftbillno", null);
        if (acct != null && currency != null) {
            Object id = ChequeHelper.getMinChequeNoBy((String)billType.getString("id"), (long)acct.getLong("id"), (long)currency.getLong("id"));
            this.getModel().setValue("basedraftbillno", id);
        }
    }

    private void receiverbankRegisterListener() {
        BasedataEdit receiverbank;
        if (this.getModel().getProperty("receiverbank") != null && (receiverbank = (BasedataEdit)this.getControl("receiverbank")) != null) {
            receiverbank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "receiverbank");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.equals((CharSequence)"creditlimit", (CharSequence)actionId)) {
            if (returnData instanceof String) {
                CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)((String)returnData), CreditLimitF7ResBean.class);
                Long creditLimitId = res.getCreditLimitId();
                this.getModel().setValue("creditlimit", (Object)creditLimitId);
                this.getModel().setValue("creditamount", (Object)res.getRealBizAmt());
            }
        } else if (StringUtils.equals((CharSequence)"basedraftbillno", (CharSequence)actionId) && null != returnData) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            this.getModel().setValue("basedraftbillno", rows.get(0).getPrimaryKeyValue());
        } else {
            ListSelectedRow row;
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            if (rows != null && EmptyUtil.isNoEmpty((Object)(row = rows.get(0)))) {
                switch (actionId) {
                    case "drawercompany": {
                        this.drawercompanyCloseCallback(row);
                        break;
                    }
                    case "draweraccount": {
                        this.draweraccountCloseCallback(row);
                        break;
                    }
                    case "receiveraccount": {
                        this.receiveraccountCloseCallback(row, "receiver", "receiveraccount");
                        break;
                    }
                    case "receiverbank": {
                        this.receiverbankCloseCallback(row);
                        break;
                    }
                    case "company": {
                        this.companyCloseCallBack(row);
                        break;
                    }
                    case "accepterfinorg": {
                        this.getModel().setValue("accepterfinorg", row.getPrimaryKeyValue());
                        break;
                    }
                    case "issuepromiseraccount": {
                        this.receiveraccountCloseCallback(row, "issuepromiser", "issuepromiseraccount");
                        break;
                    }
                    case "acceptpromiseraccount": {
                        this.receiveraccountCloseCallback(row, "acceptpromiser", "acceptpromiseraccount");
                    }
                }
            }
        }
    }

    private void companyCloseCallBack(ListSelectedRow row) {
        this.getModel().setValue("company", row.getPrimaryKeyValue());
        DynamicObject baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)row.getPrimaryKeyValue()));
        if (!EmptyUtil.isEmpty((DynamicObject)baseCurrency)) {
            this.getModel().setValue("currency", baseCurrency.getPkValue());
        }
    }

    private void receiverbankCloseCallback(ListSelectedRow row) {
        this.getModel().setValue("receiverbank", row.getPrimaryKeyValue());
        DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"bd_bebank");
        if (EmptyUtil.isNoEmpty((DynamicObject)bdBebankDO)) {
            this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_del": {
                String source = this.getModel().getValue("source").toString();
                if (StringUtils.equals((CharSequence)source, (CharSequence)SourceEnum.HANDREGISTER.getValue())) break;
                String message = String.format(new CdmBizResource().getRbSourceCheck(), source);
                this.getView().showConfirm(message, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("delete", (IFormPlugin)this));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject draftbilltype;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (("save".equals(opKey) || "submit".equals(opKey)) && EmptyUtil.isEmpty((DynamicObject)(draftbilltype = (DynamicObject)this.getModel().getValue("draftbilltype")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7968\u636e\u7c7b\u578b", (String)"PayableApplyBillBatchEdit_3_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("delete");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object draftbilltype = this.getModel().getValue("draftbilltype");
        ChangeData[] changeData = e.getChangeSet();
        switch (key) {
            case "issuedate": {
                this.issuedateChange();
                break;
            }
            case "draftbillexpiredate": {
                this.draftbillexpiredateChange(e);
                break;
            }
            case "draftbilltype": {
                this.draftbilltypeChange(e, draftbilltype);
                break;
            }
            case "drawercompany": {
                this.companyChange(draftbilltype);
                this.getDefaultDraftNo();
                DynamicObject newValue = (DynamicObject)changeData[0].getNewValue();
                if (newValue == null) break;
                this.getModel().setValue("company", newValue.getPkValue());
                this.getModel().setValue("drawercompany", newValue.getPkValue());
                this.getModel().setValue("drawername", newValue.get("name"));
                break;
            }
            case "draweraccount": {
                this.draweraccountChange(draftbilltype);
                this.getDefaultDraftNo();
                break;
            }
            case "drawerbankname": {
                this.drawerbanknameChange((DynamicObject)draftbilltype);
                break;
            }
            case "receiver": {
                this.receiverChange();
                break;
            }
            case "drawerorg": {
                this.drawerorgChange();
                break;
            }
            case "payeetype": {
                this.getModel().setValue("receiver", null);
                this.getModel().setValue("receivername", null);
                this.getModel().setValue("receiveraccount", null);
                this.getModel().setValue("receiverbank", null);
                this.getModel().setValue("receiverbankno", null);
                this.getView().updateView();
                break;
            }
            case "amount": {
                this.getModel().setValue("creditamount", this.getModel().getValue("amount"));
                this.getModel().setValue("creditlimit", null);
                break;
            }
            case "acceptercompany": {
                DynamicObject acceptercompanyDO = this.getModel().getDataEntity().getDynamicObject("acceptercompany");
                if (!EmptyUtil.isNoEmpty((DynamicObject)acceptercompanyDO)) break;
                this.getModel().setValue("acceptername", (Object)acceptercompanyDO.getString("name"));
                break;
            }
            case "currency": {
                this.getDefaultDraftNo();
                break;
            }
            case "receiverbank": {
                DynamicObject receiverbankDO = this.getModel().getDataEntity().getDynamicObject("receiverbank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)receiverbankDO)) break;
                DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)receiverbankDO.getPkValue(), (String)"bd_bebank");
                this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
                break;
            }
            case "accepterfinorg": {
                DynamicObject accepterFinOrg = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (accepterFinOrg != null) {
                    this.getModel().setValue("acceptername", accepterFinOrg.get("name"));
                    this.getModel().setValue("accepterbankname", accepterFinOrg.get("name"));
                    this.getModel().setValue("accepterbankno", (Object)accepterFinOrg.getString("union_number"));
                    break;
                }
                this.getModel().setValue("acceptername", null);
                this.getModel().setValue("accepterbankname", null);
                this.getModel().setValue("accepterbankno", null);
                break;
            }
            case "issuepromisertype": {
                this.getModel().setValue("issuepromiser", null);
                this.getModel().setValue("issuepromiseraccount", null);
                this.getModel().setValue("issuepromiseraddr", null);
                this.getModel().setValue("issuepromiserdate", null);
                this.getModel().setValue("issuepromisername", null);
                this.getView().updateView();
                break;
            }
            case "issuepromiser": {
                this.getModel().setValue("issuepromiseraccount", null);
                this.getModel().setValue("issuepromiseraddr", null);
                this.getModel().setValue("issuepromiserdate", null);
                this.getModel().setValue("issuepromisername", null);
                this.getView().updateView();
                break;
            }
            case "acceptpromisertype": {
                this.getModel().setValue("acceptpromiser", null);
                this.getModel().setValue("acceptpromiseraccount", null);
                this.getModel().setValue("acceptpromiseraddr", null);
                this.getModel().setValue("acceptpromiserdate", null);
                this.getModel().setValue("acceptpromisername", null);
                this.getView().updateView();
                break;
            }
            case "acceptpromiser": {
                this.getModel().setValue("acceptpromiseraccount", null);
                this.getModel().setValue("acceptpromiseraddr", null);
                this.getModel().setValue("acceptpromiserdate", null);
                this.getModel().setValue("acceptpromisername", null);
                this.getView().updateView();
            }
        }
    }

    private void receiveraccountRegisterListener() {
        TextEdit receiveraccount = (TextEdit)this.getControl("receiveraccount");
        receiveraccount.addButtonClickListener(new ClickListener(){

            public void click(EventObject evt) {
                PayableApplyBillEdit.this.showBankInfo();
            }
        });
    }

    private void draweraccountRegisterListener() {
        BasedataEdit draweraccount;
        if (this.getModel().getProperty("draweraccount") != null && (draweraccount = (BasedataEdit)this.getControl("draweraccount")) != null) {
            draweraccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject drawercompanyDO = this.getModel().getDataEntity().getDynamicObject("drawercompany");
                if (EmptyUtil.isNoEmpty((DynamicObject)drawercompanyDO)) {
                    long orgId = drawercompanyDO.getPkValue() == null ? 0L : Long.parseLong(drawercompanyDO.getPkValue().toString());
                    QFilter filter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId);
                    QFilter filter1 = new QFilter("acctstatus", "=", (Object)"normal");
                    List qfilter = showParameter.getListFilterParameter().getQFilters();
                    qfilter.add(filter);
                    qfilter.add(filter1);
                }
                showParameter.getListFilterParameter().getQFilters().add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "draweraccount");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void drawerRegisterListener() {
        BasedataEdit company;
        if (this.getModel().getProperty("drawercompany") != null && (company = (BasedataEdit)this.getControl("drawercompany")) != null) {
            company.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                Long userPk = Long.valueOf(RequestContext.get().getUserId());
                String appId = this.getView().getFormShowParameter().getAppId();
                String dataEntityName = this.getModel().getDataEntityType().getName();
                List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPk, (String)appId, (String)dataEntityName, (String)"4715a0df000000ac");
                showParameter.setCustomParam("range", (Object)orgIdSet);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "drawercompany");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void companyRegisterListener() {
        BasedataEdit company;
        if (this.getModel().getProperty("company") != null && (company = (BasedataEdit)this.getControl("company")) != null) {
            company.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "company");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void draftbillexpiredateChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Date newValue = (Date)changeSet[0].getNewValue();
        Date oldValue = (Date)changeSet[0].getOldValue();
        if (oldValue != null && newValue != null) {
            Date draftBillExpiredate = this.getDraftBillExpireDate();
            Date issuedate = this.getModel().getDataEntity().getDate("issuedate");
            if (draftBillExpiredate != null && newValue.after(draftBillExpiredate)) {
                this.getView().showErrorNotification(new CdmBizResource().getRbDraftBillExpiredateCheck());
                this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpiredate);
            } else if (draftBillExpiredate != null && issuedate != null && !newValue.after(issuedate)) {
                this.getView().showErrorNotification(new CdmBizResource().getRbDraftBillExpiredateCheck2());
                this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpiredate);
            }
        }
    }

    private void receiveraccountCloseCallback(ListSelectedRow row, String user, String account) {
        Object entryKey = row.getEntryPrimaryKeyValue();
        DynamicObject receiver = this.getModel().getDataEntity().getDynamicObject(user);
        String entityName = receiver.getDataEntityType().getName();
        DynamicObject innerOrg = null;
        if ("bd_supplier".equals(entityName) || "bd_customer".equals(entityName)) {
            innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)receiver);
        }
        if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg == null) {
            DynamicObjectCollection entryBank;
            DynamicObject bank = TmcDataServiceHelper.loadSingle((String)receiver.getDataEntityType().getName(), (String)"bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", entryKey)});
            if (!EmptyUtil.isEmpty((DynamicObject)bank) && !EmptyUtil.isEmpty((DynamicObjectCollection)(entryBank = bank.getDynamicObjectCollection("entry_bank")))) {
                for (DynamicObject entry : entryBank) {
                    if (!entry.getPkValue().equals(entryKey)) continue;
                    this.getModel().setValue(account, (Object)entry.getString("bankaccount"));
                    if (user.equalsIgnoreCase("receiver")) {
                        this.fillSupplierOrCustomer(entry);
                    }
                    break;
                }
            }
        } else if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bos_user")) {
            this.getModel().setValue(account, (Object)row.getNumber());
            if (user.equalsIgnoreCase("receiver")) {
                this.fillUserData(row);
            }
        } else {
            this.getModel().setValue(account, (Object)row.getNumber());
            if (user.equalsIgnoreCase("receiver")) {
                this.fillOther(row);
            }
        }
    }

    private void fillOther(ListSelectedRow row) {
        DynamicObject bankDO;
        DynamicObject accountbanksDO = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"bd_accountbanks");
        if (!EmptyUtil.isEmpty((DynamicObject)accountbanksDO) && !EmptyUtil.isEmpty((DynamicObject)(bankDO = accountbanksDO.getDynamicObject("bank")))) {
            this.getModel().setValue("receiverbankno", (Object)bankDO.getString("union_number"));
            DynamicObject bebankDO = bankDO.getDynamicObject("bebank");
            if (!EmptyUtil.isEmpty((DynamicObject)bebankDO)) {
                this.getModel().setValue("receiverbank", bebankDO.getPkValue());
            } else {
                this.getModel().setValue("receiverbank", null);
            }
        }
    }

    private void fillUserData(ListSelectedRow row) {
        DynamicObject payeerDO = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"er_payeer");
        if (EmptyUtil.isNoEmpty((DynamicObject)payeerDO)) {
            DynamicObject payerbankDO = payeerDO.getDynamicObject("payerbank");
            this.getModel().setValue("receiverbank", (Object)payerbankDO);
            DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)payerbankDO.getPkValue(), (String)payerbankDO.getDataEntityType().getName());
            this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
        }
    }

    private void fillSupplierOrCustomer(DynamicObject entry) {
        this.getModel().setValue("receiverbank", (Object)entry.getDynamicObject("bank"));
        if (EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("bank"))) {
            DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)entry.getDynamicObject("bank").getPkValue(), (String)entry.getDynamicObject("bank").getDataEntityType().getName());
            this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
        }
    }

    private void draweraccountCloseCallback(ListSelectedRow row) {
        this.getModel().setValue("draweraccountname", (Object)row.getNumber());
        this.getModel().setValue("draweraccount", row.getPrimaryKeyValue());
    }

    private void drawercompanyCloseCallback(ListSelectedRow row) {
        this.getModel().setValue("company", row.getPrimaryKeyValue());
        this.getModel().setValue("drawercompany", row.getPrimaryKeyValue());
        this.getModel().setValue("drawername", (Object)row.getName());
    }

    private void drawerorgChange() {
        DynamicObject drawerorgDO = (DynamicObject)this.getModel().getValue("drawerorg");
        this.getModel().setValue("drawerbankname", (Object)drawerorgDO.getString("name"));
        this.getModel().setValue("drawerbankno", (Object)drawerorgDO.getString("union_number"));
    }

    private void receiverChange() {
        this.getModel().setValue("receiveraccount", null);
        this.getModel().setValue("receiverbank", null);
        this.getModel().setValue("receiverbankno", null);
        DynamicObject receiverDO = this.getModel().getDataEntity().getDynamicObject("receiver");
        if (EmptyUtil.isNoEmpty((DynamicObject)receiverDO)) {
            DynamicObject payeerDO;
            this.getModel().setValue("receivername", (Object)receiverDO.getString("name"));
            String entityName = receiverDO.getDataEntityType().getName();
            DynamicObject innerOrg = null;
            if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) {
                innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)receiverDO);
                if (innerOrg == null) {
                    DynamicObject bank = TmcDataServiceHelper.loadSingle((String)entityName, (String)"entry_bank.isdefault_bank,entry_bank.bankaccount,entry_bank.bank,entry_bank.bank.union_number", (QFilter[])new QFilter[]{new QFilter("id", "=", receiverDO.getPkValue())});
                    DynamicObjectCollection entryBanks = bank.getDynamicObjectCollection("entry_bank");
                    for (DynamicObject entryBank : entryBanks) {
                        Boolean isdefaultBank = entryBank.getBoolean("isdefault_bank");
                        if (!isdefaultBank.booleanValue()) continue;
                        String bankaccount = entryBank.getString("bankaccount");
                        DynamicObject bankDO = entryBank.getDynamicObject("bank");
                        this.getModel().setValue("receiveraccount", (Object)bankaccount);
                        if (EmptyUtil.isEmpty((DynamicObject)bankDO)) continue;
                        this.getModel().setValue("receiverbank", bankDO.getPkValue());
                        DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)bankDO.getPkValue(), (String)bankDO.getDataEntityType().getName());
                        if (EmptyUtil.isEmpty((DynamicObject)bdBebankDO)) continue;
                        this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
                    }
                }
            } else if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bos_user") && EmptyUtil.isNoEmpty((DynamicObject)(payeerDO = TmcDataServiceHelper.loadSingle((String)"er_payeer", (String)"payerbank,payeraccount", (QFilter[])new QFilter[]{new QFilter("payer.id", "=", receiverDO.getPkValue()), new QFilter("isdefault", "=", (Object)"1")})))) {
                this.getModel().setValue("receiveraccount", (Object)payeerDO.getString("payeraccount"));
                DynamicObject payerbankDO = payeerDO.getDynamicObject("payerbank");
                this.getModel().setValue("receiverbank", payerbankDO.getPkValue());
                DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)payerbankDO.getPkValue(), (String)payerbankDO.getDataEntityType().getName());
                this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
            }
        }
    }

    private void companyChange(Object draftbilltype) {
        this.getModel().setValue("drawername", null);
        this.getModel().setValue("draweraccount", null);
        this.getModel().setValue("draweraccountname", null);
        this.getModel().setValue("drawerbankname", null);
        this.getModel().setValue("drawerbankno", null);
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            DynamicObject companyDO = this.getModel().getDataEntity().getDynamicObject("drawercompany");
            if (EmptyUtil.isNoEmpty((DynamicObject)companyDO)) {
                DynamicObject baseCurrency;
                this.getModel().setValue("drawername", (Object)companyDO.getString("name"));
                if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                    this.getModel().setValue("acceptercompany", (Object)companyDO);
                    this.getModel().setValue("acceptername", (Object)companyDO.getString("name"));
                }
                if (!EmptyUtil.isEmpty((DynamicObject)(baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)companyDO.getPkValue()))))) {
                    this.getModel().setValue("currency", baseCurrency.getPkValue());
                }
            }
        }
    }

    private void drawerbanknameChange(DynamicObject draftbilltype) {
        DynamicObject draftbilltypeDO = draftbilltype;
        String settlementtype = draftbilltypeDO.getString("settlementtype");
        if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
            String drawerbankname = this.getModel().getValue("drawerbankname").toString();
            this.getModel().setValue("acceptername", (Object)drawerbankname);
            DynamicObject drawerAccount = this.getModel().getDataEntity().getDynamicObject("draweraccount");
            this.getModel().setValue("accepterfinorg", drawerAccount == null ? null : drawerAccount.getDynamicObject("bank"));
            this.getModel().setValue("accepterbankname", (Object)drawerbankname);
            DynamicObject draweraccountDO = this.getModel().getDataEntity().getDynamicObject("draweraccount");
            if (EmptyUtil.isNoEmpty((DynamicObject)draweraccountDO)) {
                if (StringUtils.equals((CharSequence)drawerbankname, (CharSequence)draweraccountDO.getString("bank.name"))) {
                    DynamicObject finorginfoDO = TmcDataServiceHelper.loadSingle((Object)draweraccountDO.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo");
                    this.getModel().setValue("accepterbankno", (Object)finorginfoDO.getString("union_number"));
                } else {
                    this.getModel().setValue("accepterbankno", null);
                }
            }
        }
    }

    private void draweraccountChange(Object draftbilltype) {
        this.getModel().setValue("drawerbankname", null);
        this.getModel().setValue("drawerbankno", null);
        DynamicObject draweraccountDO = this.getModel().getDataEntity().getDynamicObject("draweraccount");
        if (EmptyUtil.isNoEmpty((DynamicObject)draweraccountDO)) {
            this.getModel().setValue("draweraccountname", (Object)draweraccountDO.getString("number"));
            DynamicObject[] finorginfoDO = TmcDataServiceHelper.load((String)"bd_finorginfo", (String)"id,union_number", (QFilter[])new QFilter[]{new QFilter("id", "=", ObjectUtils.isEmpty((Object)draweraccountDO.getDynamicObject("bank")) ? Integer.valueOf(0) : draweraccountDO.getDynamicObject("bank").getPkValue())});
            if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
                this.getModel().setValue("drawerbankname", (Object)(ObjectUtils.isEmpty((Object)draweraccountDO.getDynamicObject("bank")) ? "" : draweraccountDO.getDynamicObject("bank").getString("name")));
                this.getModel().setValue("drawerbankno", (Object)(finorginfoDO.length > 0 ? finorginfoDO[0].getString("union_number") : ""));
            }
        }
    }

    private void draftbilltypeChange(PropertyChangedArgs e, Object draftbilltype) {
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            String settlementtype;
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            Date draftBillExpireDate = this.getDraftBillDefaultExpireDate();
            if (draftBillExpireDate != null) {
                this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpireDate);
            }
            if (StringUtils.equals((CharSequence)(settlementtype = draftbilltypeDO.getString("settlementtype")), (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                this.getModel().setValue("billtype", (Object)CdmBizConstant.PAYABLE_APPLY_BANK);
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                this.getModel().setValue("billtype", (Object)CdmBizConstant.PAYABLEBILL_BUSINESS);
                this.getModel().setValue("istransfer", (Object)"0");
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                this.getModel().setValue("billtype", (Object)CdmBizConstant.PAYABLEBILL_CHECK);
                this.getModel().setValue("company", (Object)RequestContext.get().getOrgId());
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                this.getModel().setValue("billtype", (Object)CdmBizConstant.PAYABLEBILL_PROMISSORY);
                this.getDefaultDraftNo();
            }
            this.getModel().setValue("draftbilltype", (Object)((DynamicObject)e.getChangeSet()[0].getNewValue()));
            if (!StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                Object value = this.getModel().getValue("company");
                this.getModel().setValue("drawercompany", null);
                this.getModel().setValue("drawercompany", value);
            }
        }
    }

    private void issuedateChange() {
        Date draftBillExpireDate = this.getDraftBillDefaultExpireDate();
        Date date = this.getModel().getDataEntity().getDate("draftbillexpiredate");
        if (date == null && draftBillExpireDate != null || draftBillExpireDate != null && date != null && date.after(draftBillExpireDate)) {
            this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpireDate);
        }
    }

    private Date getDraftBillExpireDate() {
        DynamicObject draftbilltypeDO = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            Date draftbillexpiredate = null;
            int validitytime = draftbilltypeDO.getInt("validitytime");
            String unit = draftbilltypeDO.getString("unit");
            Date issueDate = (Date)this.getModel().getValue("issuedate");
            if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.MONTH.getValue()) && issueDate != null) {
                draftbillexpiredate = DateUtils.getNextMonth((Date)issueDate, (int)validitytime);
            } else if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.DAY.getValue()) && issueDate != null) {
                draftbillexpiredate = DateUtils.getNextDay((Date)issueDate, (int)validitytime);
            }
            return draftbillexpiredate;
        }
        return null;
    }

    private Date getDraftBillDefaultExpireDate() {
        DynamicObject draftbilltypeDO = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            Date draftbillexpiredate = null;
            int validitytime = draftbilltypeDO.getInt("defaulttime");
            String unit = draftbilltypeDO.getString("defaultunit");
            Date issuedate = (Date)this.getModel().getValue("issuedate");
            if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.MONTH.getValue()) && issuedate != null) {
                draftbillexpiredate = DateUtils.getNextMonth((Date)issuedate, (int)validitytime);
            } else if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.DAY.getValue()) && issuedate != null) {
                draftbillexpiredate = DateUtils.getNextDay((Date)issuedate, (int)validitytime);
            }
            return draftbillexpiredate;
        }
        return null;
    }

    private void showBankInfo() {
        IDataModel model = this.getModel();
        DynamicObject draftTradeBill = model.getDataEntity();
        DynamicObject receiver = draftTradeBill.getDynamicObject("receiver");
        if (EmptyUtil.isNoEmpty((DynamicObject)receiver)) {
            String receiverEntityType = receiver.getDataEntityType().getName();
            Object receiverId = receiver.getPkValue();
            Object innerOrgId = null;
            if (StringUtils.equals((CharSequence)receiverEntityType, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)receiverEntityType, (CharSequence)"bd_customer")) {
                DynamicObject innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)receiver);
                if (innerOrg == null) {
                    String qFilter = new QFilter("id", "=", receiverId);
                    DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)receiverEntityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                    if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                        this.getView().showTipNotification(new CdmBizResource().getTipCsNull());
                        return;
                    }
                } else {
                    innerOrgId = innerOrg.getPkValue();
                }
            }
            ListShowParameter lsp = new ListShowParameter();
            switch (receiverEntityType) {
                case "bd_supplier": {
                    if (innerOrgId != null) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)receiverId);
                    break;
                }
                case "bd_customer": {
                    if (innerOrgId != null) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)receiverId);
                    break;
                }
                case "bos_org": {
                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)receiverId);
                    break;
                }
                case "bos_user": {
                    lsp = ListConstructorHelper.getPayeerInfoShowParameter((Object)receiverId);
                    break;
                }
            }
            if (lsp != null) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "receiveraccount");
                lsp.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)lsp);
            }
        } else {
            String payeetype = this.getModel().getValue("payeetype").toString();
            if (!StringUtils.equals((CharSequence)payeetype, (CharSequence)PayeeTypeEnum.OTHER.getValue())) {
                this.getView().showTipNotification(new CdmBizResource().getTipReceiverShort());
                return;
            }
        }
    }
}

