/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.payablebill;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.constant.CdmBizConstant;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.PayableBillHelp;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Map variables = this.getOption().getVariables();
        String draftbillnobydraw = (String)variables.get("draftbillnobydraw");
        for (ExtendedDataEntity entity : billDataEntities) {
            String drawerbankname;
            DynamicObject[] beBanks;
            String receiverAccount;
            DynamicObject[] accountBanks;
            DynamicObject payBill = entity.getDataEntity();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)payBill.getLong("sourcebillid"), (String)"cdm_payablebill");
            Object companyId = PayableBillHelp.getCompanyIdByRec((DynamicObject)obj);
            if (EmptyUtil.isEmpty((Object)companyId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4e0d\u5b58\u5728", (String)"TradeBillTplEdit_22_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
            String payBillDraftbillno = obj.getString("draftbillno");
            String recBillDraftbillno = payBill.getString("draftbillno");
            if (EmptyUtil.isNoEmpty((String)draftbillnobydraw) && !recBillDraftbillno.equalsIgnoreCase(draftbillnobydraw)) {
                payBill.set("draftbillno", (Object)draftbillnobydraw);
            } else {
                payBill.set("draftbillno", (Object)payBillDraftbillno);
            }
            DynamicObject companyObj = TmcDataServiceHelper.loadSingle((Object)companyId, (String)"bos_org");
            payBill.set("company", (Object)companyObj);
            payBill.set("issplit", (Object)obj.getBoolean("issplit"));
            payBill.set("supperbillamount", (Object)obj.getBigDecimal("supperbillamount"));
            String drawerBankNo = payBill.getString("drawerbankno");
            QFilter filter = new QFilter("union_number", "=", (Object)drawerBankNo);
            DynamicObject[] drawerBeBanks = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id", (QFilter[])new QFilter[]{filter});
            if (drawerBeBanks.length > 0) {
                payBill.set("drawerbank", (Object)drawerBeBanks[0]);
            }
            if ((accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)(receiverAccount = payBill.getString("receiveraccount")))})).length > 0) {
                payBill.set("bankaccount", (Object)accountBanks[0]);
            }
            DynamicObject draftBillType = payBill.getDynamicObject("draftbilltype");
            Long billTypeId = 0L;
            String settlementType = draftBillType.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                DynamicObject bebankDny;
                billTypeId = CdmBizConstant.RECEIVABLEBILL_BANK;
                DynamicObject accepterfinorgDyn = obj.getDynamicObject("accepterfinorg");
                if (EmptyUtil.isNoEmpty((DynamicObject)accepterfinorgDyn) && EmptyUtil.isNoEmpty((DynamicObject)(bebankDny = accepterfinorgDyn.getDynamicObject("bebank")))) {
                    payBill.set("accepterbebank", (Object)bebankDny);
                }
            } else if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                billTypeId = CdmBizConstant.RECEIVABLEBILL_BUSINESS;
            } else if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                billTypeId = CdmBizConstant.RECEIVABLEBILL_CHECK;
            } else if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                billTypeId = CdmBizConstant.RECEIVABLEBILL_PROMISSORY;
            }
            DynamicObject billTypeObj = TmcDataServiceHelper.loadSingle((Object)billTypeId, (String)"bos_billtype");
            payBill.set("billtype", (Object)billTypeObj);
            Object accepterName = payBill.get("acceptername");
            if (EmptyUtil.isEmpty((Object)accepterName)) {
                DynamicObject accepterCompany;
                DynamicObject accepterFinOrg = obj.getDynamicObject("accepterfinorg");
                if (EmptyUtil.isNoEmpty((DynamicObject)accepterFinOrg)) {
                    payBill.set("acceptername", accepterFinOrg.get("name"));
                }
                if (EmptyUtil.isEmpty((Object)payBill.get("acceptername")) && EmptyUtil.isNoEmpty((DynamicObject)(accepterCompany = obj.getDynamicObject("acceptercompany")))) {
                    payBill.set("acceptername", accepterCompany.get("name"));
                }
            }
            DynamicObject draweraccount = obj.getDynamicObject("draweraccount");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                DynamicObject bebank;
                String draweraccountname = obj.getString("draweraccountname");
                payBill.set("deliveraccounttext", (Object)draweraccountname);
                payBill.set("deliveraccountbase", (Object)draweraccountname);
                DynamicObject drawerorg = obj.getDynamicObject("drawerorg");
                if (EmptyUtil.isNoEmpty((DynamicObject)drawerorg) && EmptyUtil.isNoEmpty((DynamicObject)(bebank = drawerorg.getDynamicObject("bebank")))) {
                    payBill.set("drawer", (Object)bebank);
                    payBill.set("drawername", (Object)bebank.getString("name"));
                }
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)draweraccount)) {
                payBill.set("deliveraccounttext", (Object)draweraccount.getString("bankaccountnumber"));
                payBill.set("deliveraccountbase", (Object)draweraccount.getString("bankaccountnumber"));
            }
            if ((beBanks = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)(drawerbankname = obj.getString("drawerbankname")))})).length > 0) {
                payBill.set("deliveropenbank", (Object)beBanks[0]);
            }
            payBill.set("eledraftstatusnew", (Object)EleDraftNoteStatusEnum.CS03.getValue());
        }
    }
}

