/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.payablebill;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.bean.CreditLimitF7ResBean;
import kd.tmc.cdm.common.bean.CreditLimitUseBean;
import kd.tmc.cdm.common.constant.CdmBizConstant;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.BillTypeUnitEnum;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.PayeeTypeEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.cdm.common.helper.CdmCommonHelper;
import kd.tmc.cdm.common.helper.ChequeHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.GuaranteeHelper;
import kd.tmc.cdm.common.helper.ListConstructorHelper;
import kd.tmc.cdm.common.helper.PayableBillHelp;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class PayableBillEdit
extends AbstractTmcBillEdit {
    private static final Log logger = LogFactory.getLog(PayableBillEdit.class);
    private boolean skip = false;
    private static final String BALEAC_ACTIONID = "baleac";

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter;
        super.afterBindData(e);
        this.fillBillAmount();
        if (SourceEnum.CAS.getValue().equals(this.getModel().getValue("source")) && (BillOperationStatus.ADDNEW.equals((Object)((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()) || BillOperationStatus.EDIT.equals((Object)((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()))) {
            Object casAmount = this.getModel().getValue("casamount");
            if (EmptyUtil.isEmpty((Object)casAmount)) {
                this.getModel().setValue("casamount", (Object)"amount");
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"amount"});
        }
        if ((SourceEnum.CAS.getValue().equals(this.getModel().getValue("source")) || SourceEnum.IFM.getValue().equals(this.getModel().getValue("source"))) && BillOperationStatus.ADDNEW.equals((Object)((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus())) {
            boolean isSplit;
            this.getDefaultDraftNo();
            Object value = this.getModel().getValue("draftbillexpiredate");
            if (EmptyUtil.isEmpty((Object)value)) {
                this.issuedateChange();
            }
            if (isSplit = ((Boolean)this.getModel().getValue("issplit")).booleanValue()) {
                BigDecimal subAmount = (BigDecimal)this.getModel().getValue("amount");
                long subStartFlage = (Long)this.getModel().getValue("subbillstartflag");
                long subEndFlage = (Long)this.getModel().getValue("subbillendflag");
                if (EmptyUtil.isEmpty((Long)subStartFlage) || EmptyUtil.isEmpty((Long)subEndFlage)) {
                    this.getModel().setValue("subbillstartflag", (Object)1L);
                    long endFlag = subAmount.multiply(new BigDecimal("100")).longValue();
                    this.getModel().setValue("subbillendflag", (Object)endFlag);
                    String subRange = "1-" + endFlag;
                    this.getModel().setValue("subbillrange", (Object)subRange);
                }
            }
        }
        this.setAcceptDate();
        Object creditlimit = this.getModel().getValue("creditlimit");
        if (EmptyUtil.isNoEmpty((Object)creditlimit)) {
            long billId = this.getModel().getDataEntity().getLong("id");
            this.loadCreditUse(billId);
        }
        if (this.getView().getFormShowParameter().getCustomParam("modifydata") != null) {
            this.setBillStatus();
        }
        if ((formShowParameter = this.getView().getFormShowParameter()).getCustomParam("modifydata") != null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"creditlimitorg", "creditlimitcompany"});
        }
        this.setEleStatus();
        if (DraftHelper.needToHideToolForRecAndPayBill((String)((String)this.getView().getFormShowParameter().getCustomParam("sourceBill")))) {
            this.setToolBarVisible();
        }
        this.setAcpFlgVisible();
        if (SourceEnum.APPLY.getValue().equals(this.getModel().getValue("source"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"suretymoney"});
        }
        Object billIngType = this.getModel().getValue("paybilltype");
        this.setCreditEnableAndValue(billIngType);
    }

    private void setToolBarVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_del", "bar_submit", "bar_unsubmit", "bar_invalid", "bar_audit", "bar_unaudit", "generatevoucher", "bar_drawbill", "submiteledraft", "relatedprebill", "bar_remit", "bar_payinterest", "bar_track", "bar_print", "bar_refresh"});
    }

    private void fillBillAmount() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("supperbillamount"))) {
            boolean isNotCheckOrPromissoryBillType = !PayableBillHelp.isCheckOrPromissoryBillType((DynamicObject)((DynamicObject)this.getModel().getValue("draftbilltype")));
            this.getModel().setValue("supperbillamount", isNotCheckOrPromissoryBillType ? this.getModel().getValue("amount") : BigDecimal.ZERO);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.issuedateChange();
        DynamicObject companyDO = this.getModel().getDataEntity().getDynamicObject("company");
        if (!EmptyUtil.isEmpty((DynamicObject)companyDO)) {
            DynamicObject baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)companyDO.getPkValue()));
            if (EmptyUtil.isNoEmpty((DynamicObject)baseCurrency)) {
                this.getModel().setValue("currency", baseCurrency.getPkValue());
            }
            this.getModel().setValue("drawername", (Object)companyDO.getString("name"));
        }
        this.getDefaultDraftNo();
        ((FieldEdit)this.getView().getControl("receiver")).setMustInput(true);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"acpflg", "acpfer", "baltyp", BALEAC_ACTIONID});
        this.initializeSubBillInfo();
        DynamicObject draftBillType = (DynamicObject)this.getModel().getValue("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftBillType)) {
            String settlementType = draftBillType.getString("settlementtype");
            this.setEleStatus();
            if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                Object accepterAcc = this.getModel().getValue("accepteraccount");
                if (EmptyUtil.isEmpty((Object)accepterAcc)) {
                    this.getModel().setValue("accepteraccount", (Object)"0");
                }
            } else if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
                // empty if block
            }
            this.setBankNoMust(draftBillType);
            this.setAcceptDateMust(draftBillType);
            this.setAcpFlgVisible();
        }
    }

    private void setAcpFlgVisible() {
        DynamicObject draftBillType = (DynamicObject)this.getModel().getValue("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftBillType)) {
            Object[] bankCgSettings;
            DynamicObject bankCate;
            String settlementType = draftBillType.getString("settlementtype");
            String billMedium = draftBillType.getString("billmedium");
            String typeCode = "";
            DynamicObject accepterFinOrg = (DynamicObject)this.getModel().getValue("accepterfinorg");
            if (EmptyUtil.isNoEmpty((DynamicObject)accepterFinOrg) && EmptyUtil.isNoEmpty((DynamicObject)(bankCate = accepterFinOrg.getDynamicObject("bank_cate"))) && EmptyUtil.isNoEmpty((Object[])(bankCgSettings = TmcDataServiceHelper.load((Object[])new Object[]{bankCate.getLong("id")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_bankcgsetting"))))) {
                typeCode = bankCgSettings[0].getString("type_code");
            }
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue()) && StringUtils.equals((CharSequence)billMedium, (CharSequence)BillMediumEnum.ELECTRIC.getValue()) && StringUtils.equals((CharSequence)typeCode, (CharSequence)"308")) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"acpflg", "acpfer", "baltyp", BALEAC_ACTIONID});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"acpflg", "acpfer", "baltyp", BALEAC_ACTIONID});
            }
        }
    }

    private void setEleStatus() {
        DynamicObject draftBillType = (DynamicObject)this.getModel().getValue("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftBillType)) {
            String billMedium = draftBillType.getString("billmedium");
            if (BillMediumEnum.ELECTRIC.getValue().equals(billMedium)) {
                Object eledraftstatusnew;
                boolean issplit = (Boolean)this.getModel().getValue("issplit");
                if (issplit && EmptyUtil.isEmpty((Object)(eledraftstatusnew = this.getModel().getValue("eledraftstatusnew")))) {
                    this.getModel().setValue("eledraftstatusnew", (Object)"registering");
                }
            } else {
                this.getModel().setValue("eledraftstatusnew", null);
            }
        }
    }

    private void setAcceptDateMust(DynamicObject draftBillType) {
        String settlementType = draftBillType.getString("settlementtype");
        String billMedium = draftBillType.getString("billmedium");
        Date issueDate = (Date)this.getModel().getValue("issuedate");
        if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) || StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"acceptdate"});
            this.getModel().setValue("acceptdate", (Object)issueDate);
            if (BillMediumEnum.ELECTRIC.getValue().equals(billMedium)) {
                ((DateEdit)this.getView().getControl("acceptdate")).setMustInput(false);
            } else {
                ((DateEdit)this.getView().getControl("acceptdate")).setMustInput(true);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"acceptdate"});
            ((DateEdit)this.getView().getControl("acceptdate")).setMustInput(false);
        }
    }

    private void setAcceptDate() {
        DynamicObject draftBillType = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        long sourceBillId = (Long)this.getModel().getValue("sourcebillid");
        if (!EmptyUtil.isEmpty((DynamicObject)draftBillType)) {
            if (!EmptyUtil.isEmpty((Long)sourceBillId) && sourceBillId > 0L && EmptyUtil.isEmpty((Object)this.getModel().getValue("acceptdate"))) {
                this.setAcceptDateMust(draftBillType);
            }
            String settlementType = draftBillType.getString("settlementtype");
            String billMedium = draftBillType.getString("billmedium");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) || StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"acceptdate"});
                if (BillMediumEnum.ELECTRIC.getValue().equals(billMedium)) {
                    ((DateEdit)this.getView().getControl("acceptdate")).setMustInput(false);
                } else {
                    ((DateEdit)this.getView().getControl("acceptdate")).setMustInput(true);
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"acceptdate"});
                ((DateEdit)this.getView().getControl("acceptdate")).setMustInput(false);
            }
        }
    }

    private void setBankNoMust(DynamicObject draftBillType) {
        String settlementType = draftBillType.getString("settlementtype");
        if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) || StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
            ((FieldEdit)this.getView().getControl("drawerbankno")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("receiverbankno")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("accepterbankno")).setMustInput(true);
            String billMedium = draftBillType.getString("billmedium");
            if (BillMediumEnum.ELECTRIC.getValue().equals(billMedium)) {
                ((FieldEdit)this.getView().getControl("accepteraccount")).setMustInput(true);
            } else {
                ((FieldEdit)this.getView().getControl("accepteraccount")).setMustInput(false);
            }
        } else {
            ((FieldEdit)this.getView().getControl("drawerbankno")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("receiverbankno")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("accepterbankno")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("accepteraccount")).setMustInput(false);
        }
    }

    public void beforeBindData(EventObject e) {
        String billstatus;
        String draftbillstatus;
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String string = draftbillstatus = this.getModel().getValue("draftbillstatus") == null ? "" : this.getModel().getValue("draftbillstatus").toString();
        if (StringUtils.equals((CharSequence)draftbillstatus, (CharSequence)DraftBillStatusEnum.PAYOFFED.getValue()) || formShowParameter.getCustomParam("modifydata") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_remit"});
        }
        String string2 = billstatus = this.getModel().getValue("billstatus") == null ? "" : this.getModel().getValue("billstatus").toString();
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.DISCARD.getValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_del", "bar_save", "bar_submit", "bar_invalid", "bar_print", "bar_refresh"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.companyRegisterListener();
        this.drawerRegisterListener();
        this.draweraccountRegisterListener();
        this.receiveraccountRegisterListener();
        this.issuePromiserAccountRegisterListener();
        this.acceptPromiserAccountRegisterListener();
        this.receiverbankRegisterListener();
        this.creditlimitClick();
        this.baseDraftBillnoRegListener();
        this.receiverRegisterListener();
        this.accepterFinOrgRegisterListener();
        DynamicObject draftbilltypeDO = (DynamicObject)this.getModel().getValue("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                this.getModel().setValue("issplit", (Object)Character.valueOf('0'));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"issplit"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"issplit"});
            }
            this.setBankNoMust(draftbilltypeDO);
        }
        this.fillBillAmount();
        this.addClickListeners(new String[]{"accepteraccount", BALEAC_ACTIONID});
    }

    private void accepterFinOrgRegisterListener() {
        BasedataEdit accepterFinOrg = (BasedataEdit)this.getControl("accepterfinorg");
        accepterFinOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "accepterfinorg")));
    }

    private void receiverRegisterListener() {
        BasedataEdit receiver;
        if (this.getModel().getProperty("receiver") != null && (receiver = (BasedataEdit)this.getControl("receiver")) != null) {
            receiver.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                String payeetype;
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                String string = payeetype = this.getModel().getValue("payeetype") == null ? "" : this.getModel().getValue("payeetype").toString();
                if (StringUtils.equals((CharSequence)payeetype, (CharSequence)PayeeTypeEnum.BOS_ORG.getValue())) {
                    QFilter filter = new QFilter("fisbankroll", "=", (Object)"1");
                    showParameter.setCustomParam("orgFuncId", (Object)"08");
                    List qfilter = showParameter.getListFilterParameter().getQFilters();
                    qfilter.add(filter);
                }
            });
        }
    }

    public void click(EventObject evt) {
        String btnKey = ((Control)evt.getSource()).getKey();
        DynamicObject draftBillType = (DynamicObject)this.getModel().getValue("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftBillType)) {
            String settlementType = draftBillType.getString("settlementtype");
            if ("accepteraccount".equals(btnKey) && SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
                BasedataEdit baseData = (BasedataEdit)this.getControl("accepteraccountid");
                baseData.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    Long accepterCompanyId = this.getModel().getValue("acceptercompany") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("acceptercompany")).getLong("id"));
                    QFilter qFilter = TmcAccountHelper.getAccountBankFilterByOrg(accepterCompanyId);
                    QFilter filter1 = new QFilter("acctstatus", "=", (Object)"normal");
                    QFilter qFilter2 = qFilter.and(filter1);
                    showParameter.getListFilterParameter().setFilter(qFilter2);
                    showParameter.getListFilterParameter().getQFilters().add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                });
                baseData.click();
            } else if (BALEAC_ACTIONID.equals(btnKey) && SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                this.showBdAccountBanksInfo();
            }
        }
    }

    private void showBdAccountBanksInfo() {
        String msg = "";
        ListShowParameter lsp = new ListShowParameter();
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        long orgID = company == null ? 0L : company.getLong("id");
        QFilter filter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgID);
        boolean isExists = TmcDataServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{filter});
        if (isExists) {
            DynamicObject drawerCompany = (DynamicObject)this.getModel().getValue("drawercompany");
            long drawercompanyId = drawerCompany == null ? 0L : drawerCompany.getLong("id");
            filter.and(new QFilter("company", "=", (Object)drawercompanyId));
            filter.and(new QFilter("acctstatus", "!=", (Object)"closed"));
            DynamicObject accepterfinorg = (DynamicObject)this.getModel().getValue("accepterfinorg");
            long accepterfinorgId = accepterfinorg == null ? 0L : accepterfinorg.getLong("id");
            Object[] finorginfos = TmcDataServiceHelper.load((Object[])new Object[]{accepterfinorgId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_finorginfo"));
            if (EmptyUtil.isNoEmpty((Object[])finorginfos)) {
                DynamicObject finorgType = finorginfos[0].getDynamicObject("finorgtype");
                filter.and(new QFilter("bank.finorgtype", "=", (Object)finorgType.getLong("id")));
            }
            lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((QFilter)filter);
        } else {
            msg = ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u94f6\u884c\u4fe1\u606f", (String)"TradeBillTplEdit_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
        }
        if (!EmptyUtil.isEmpty((String)msg)) {
            this.getView().showTipNotification(msg, Integer.valueOf(2000));
        } else {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BALEAC_ACTIONID);
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getDefaultDraftNo();
        this.clearListInfo();
        this.getModel().setValue("batchno", null);
        this.getModel().setValue("elccirculatestatus", null);
        this.getModel().setValue("isrelatedprebill", (Object)false);
        this.getModel().setValue("relatedelcbillid", (Object)0L);
        this.getModel().setValue("innercreditlimit", (Object)true);
        this.getModel().setValue("electag", (Object)false);
        this.getModel().setValue("ispayinterest", (Object)0);
        this.getModel().setValue("contractno", null);
        this.getModel().setValue("guarantee", null);
        this.getModel().setValue("billidentitycode", null);
        this.getModel().setValue("isfromequalspilt", (Object)false);
        this.getModel().setValue("isequalbill", (Object)false);
        this.getModel().setValue("equaltradebilltype", null);
        this.getModel().setValue("equaltradebillid", (Object)0L);
        this.getModel().setValue("lockedamount", null);
        this.getModel().setValue("usedamount", null);
        this.fillAmountofcredit();
        this.getModel().setValue("originalsubbillamount", null);
        this.getModel().setValue("originalsubbillrang", null);
        this.getModel().setValue("supperbillamount", null);
        this.getModel().setValue("suretyinput", (Object)false);
        DraftHelper.resetGuaranteeInfo((IDataModel)this.getModel());
        this.getModel().deleteEntryData("releatedcasbillentrys");
    }

    private void clearListInfo() {
        this.getModel().setValue("whitelist", (Object)false);
        this.getModel().setValue("blacklist", (Object)false);
        this.getModel().setValue("listinformation", null);
    }

    private void getDefaultDraftNo() {
        Object draftType = this.getModel().getValue("draftbilltype");
        if (!DraftHelper.isPromissory((Object)draftType)) {
            return;
        }
        DynamicObject acct = (DynamicObject)this.getModel().getValue("draweraccount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject billType = (DynamicObject)this.getModel().getValue("draftbilltype");
        this.getModel().setValue("basedraftbillno", null);
        if (acct != null && currency != null) {
            Object id = ChequeHelper.getMinChequeNoBy((String)billType.getString("id"), (long)acct.getLong("id"), (long)currency.getLong("id"));
            this.getModel().setValue("basedraftbillno", id);
            DynamicObject baseDraftBillno = this.getModel().getDataEntity().getDynamicObject("basedraftbillno");
            if (EmptyUtil.isNoEmpty((DynamicObject)baseDraftBillno)) {
                this.getModel().setValue("draftbillno", (Object)baseDraftBillno.getString("billno"));
            }
        }
    }

    private void initializeSubBillInfo() {
        Boolean isSplit = (Boolean)this.getModel().getValue("issplit");
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        Object source = this.getModel().getValue("source");
        boolean isNotCheckOrPromissoryBillType = !PayableBillHelp.isCheckOrPromissoryBillType((DynamicObject)((DynamicObject)this.getModel().getValue("draftbilltype")));
        this.getModel().setValue("supperbillamount", (Object)(isNotCheckOrPromissoryBillType ? amount : BigDecimal.ZERO));
        if (!isSplit.booleanValue()) {
            if (EmptyUtil.isNoEmpty((Object)source) && "cas".equalsIgnoreCase(source.toString())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"supperbillamount"});
            }
            this.getModel().setValue("subbillrange", (Object)0);
            this.getModel().setValue("subbillquantity", (Object)0L);
            this.getModel().setValue("subbillstartflag", (Object)0L);
            this.getModel().setValue("subbillendflag", (Object)0L);
        } else {
            if (EmptyUtil.isNoEmpty((Object)source) && "cas".equalsIgnoreCase(source.toString())) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"supperbillamount"});
            }
            this.getModel().setValue("subbillrange", (Object)0);
            this.getModel().setValue("subbillquantity", (Object)0);
            long subBillStartFlag = 1L;
            this.getModel().setValue("subbillstartflag", (Object)subBillStartFlag);
            BigDecimal standardBillAmount = (BigDecimal)this.getModel().getValue("standardbillamount");
            long amountInt = amount.divide(standardBillAmount).longValue();
            this.getModel().setValue("subbillendflag", (Object)(amountInt - subBillStartFlag + 1L));
        }
    }

    private void setSubBillInfoByAmount() {
        Boolean isSplit = (Boolean)this.getModel().getValue("issplit");
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        boolean isNotCheckOrPromissoryBillType = !PayableBillHelp.isCheckOrPromissoryBillType((DynamicObject)((DynamicObject)this.getModel().getValue("draftbilltype")));
        this.getModel().setValue("supperbillamount", (Object)(isNotCheckOrPromissoryBillType ? amount : BigDecimal.ZERO));
        if (isSplit.booleanValue()) {
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue("amount", (Object)0);
                this.getModel().setValue("subbillrange", (Object)0);
                this.getModel().setValue("subbillquantity", (Object)0);
                this.getModel().setValue("subbillstartflag", (Object)1L);
                this.getModel().setValue("subbillendflag", (Object)0L);
                return;
            }
            this.getModel().setValue("subbillstartflag", (Object)1L);
            BigDecimal standardBillAmount = (BigDecimal)this.getModel().getValue("standardbillamount");
            this.getModel().setValue("subbillendflag", (Object)amount.divide(standardBillAmount).longValue());
        }
    }

    private void calculateSubBill() {
        Boolean isSplit = (Boolean)this.getModel().getValue("issplit");
        if (!isSplit.booleanValue()) {
            this.getModel().setValue("supperbillamount", this.getModel().getValue("amount"));
            this.getModel().setValue("subbillrange", (Object)0);
            this.getModel().setValue("subbillquantity", (Object)0L);
            this.getModel().setValue("subbillstartflag", (Object)0L);
            this.getModel().setValue("subbillendflag", (Object)0L);
            this.setOriginalInfo();
            return;
        }
        long subBillStartFlag = (Long)this.getModel().getValue("subbillstartflag");
        long subBillEndFlag = (Long)this.getModel().getValue("subbillendflag");
        if (subBillStartFlag > 0L && subBillEndFlag > 0L && subBillStartFlag <= subBillEndFlag) {
            long quantityNew = subBillEndFlag - subBillStartFlag + 1L;
            BigDecimal quantity = new BigDecimal(quantityNew);
            this.getModel().setValue("subbillrange", (Object)(subBillStartFlag + "-" + subBillEndFlag));
            this.getModel().setValue("subbillquantity", (Object)quantityNew);
            BigDecimal subBillAmount = ((BigDecimal)this.getModel().getValue("standardbillamount")).multiply(quantity);
            this.skip = true;
            this.getModel().setValue("amount", (Object)subBillAmount);
            this.getModel().setValue("supperbillamount", (Object)subBillAmount);
            String paybillType = this.getModel().getDataEntity().getString("paybilltype");
            if (EmptyUtil.isNoEmpty((String)paybillType)) {
                if (StringUtils.contains((CharSequence)paybillType, (CharSequence)"guarantee")) {
                    BigDecimal promisrate = (BigDecimal)this.getModel().getValue("promisrate");
                    BigDecimal creditAmount = subBillAmount.multiply(new BigDecimal(1).subtract(promisrate.multiply(new BigDecimal("0.01"))));
                    this.getModel().setValue("creditamount", (Object)creditAmount);
                } else {
                    this.getModel().setValue("creditamount", (Object)subBillAmount);
                }
            }
            this.setOriginalInfo();
        }
    }

    private void setOriginalInfo() {
        Object source = this.getModel().getValue("source");
        BigDecimal subBillAmount = (BigDecimal)this.getModel().getValue("amount");
        Object subbillrange = this.getModel().getValue("subbillrange");
        Object draftbillno = this.getModel().getValue("draftbillno");
        boolean issplit = (Boolean)this.getModel().getValue("issplit");
        long billId = this.getModel().getDataEntity().getLong("id");
        if (0L == billId) {
            this.getModel().setValue("originalsubbillrang", subbillrange);
            this.getModel().setValue("originalsubbillamount", (Object)subBillAmount);
            this.getModel().setValue("availableamount", (Object)subBillAmount);
            if (issplit) {
                this.getModel().setValue("billidentitycode", (Object)(EmptyUtil.isNoEmpty((Object)draftbillno) ? draftbillno + "-" + subbillrange : ""));
            } else {
                this.getModel().setValue("billidentitycode", EmptyUtil.isNoEmpty((Object)draftbillno) ? draftbillno : "");
            }
        } else if (EmptyUtil.isNoEmpty((Object)source) && SourceEnum.HANDREGISTER.getValue().equals(source)) {
            this.getModel().setValue("originalsubbillrang", subbillrange);
            this.getModel().setValue("originalsubbillamount", (Object)subBillAmount);
            this.getModel().setValue("availableamount", (Object)subBillAmount);
            if (issplit) {
                this.getModel().setValue("billidentitycode", (Object)(EmptyUtil.isNoEmpty((Object)draftbillno) ? draftbillno + "-" + subbillrange : ""));
            } else {
                this.getModel().setValue("billidentitycode", EmptyUtil.isNoEmpty((Object)draftbillno) ? draftbillno : "");
            }
        }
    }

    private void baseDraftBillnoRegListener() {
        BasedataEdit receiverbank = (BasedataEdit)this.getControl("basedraftbillno");
        if (receiverbank != null) {
            receiverbank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                Object accout = this.getModel().getValue("draweraccount");
                Object currency = this.getModel().getValue("currency");
                if (accout == null) {
                    this.getView().showTipNotification(new CdmBizResource().getTipAccountCheck());
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (currency == null) {
                    this.getView().showTipNotification(new CdmBizResource().getTipCurrCheck());
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("accountbank", "=", ((DynamicObject)accout).getPkValue());
                DynamicObject billType = (DynamicObject)this.getModel().getValue("draftbilltype");
                filter.and(new QFilter("billtype", "=", billType.getPkValue()));
                filter.and(new QFilter("chequestatus", "=", (Object)"0"));
                Object pk = this.getModel().getDataEntity().getPkValue();
                if ((Long)pk != 0L) {
                    filter.or(new QFilter("relatebillid", "=", pk));
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "basedraftbillno");
                showParameter.setCloseCallBack(closeCallBack);
                showParameter.setCaption(new CdmBizResource().getTitlePromissory());
                showParameter.getListFilterParameter().setFilter(filter);
            });
        }
    }

    private void receiverbankRegisterListener() {
        BasedataEdit receiverbank;
        if (this.getModel().getProperty("receiverbank") != null && (receiverbank = (BasedataEdit)this.getControl("receiverbank")) != null) {
            receiverbank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "receiverbank");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.getModel().getDataEntity(true);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if ("save".equals(opKey) && Objects.isNull(formShowParameter.getCustomParam("modifydata")) || "submit".equals(opKey)) {
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            String source = this.getModel().getValue("source").toString();
            DynamicObject draftbilltype = (DynamicObject)this.getModel().getValue("draftbilltype");
            if (EmptyUtil.isEmpty((DynamicObject)draftbilltype)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7968\u636e\u7c7b\u578b", (String)"PayableApplyBillBatchEdit_3_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String settlementtype = draftbilltype.getString("settlementtype");
            boolean needApply = DraftHelper.isNeedContorlApply((Long)company.getLong("id"), (String)settlementtype);
            boolean isManualAdd = StringUtils.equals((CharSequence)source, (CharSequence)SourceEnum.HANDREGISTER.getValue());
            if (isManualAdd && needApply) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u5f00\u7968\u7533\u8bf7\u3002", (String)"RecSupContractPlugin_1", (String)"tmc-cdm-common", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else {
            Object modifytag = this.getModel().getValue("modifytag");
            Object billStatus = this.getModel().getValue("billstatus");
            if ("done".equals(modifytag) && Objects.nonNull(formShowParameter.getCustomParam("modifydata")) && "save".equals(opKey) && "C".equals(billStatus)) {
                AbstractOperate op = (AbstractOperate)args.getSource();
                op.getOption().setVariableValue("modifysave", "true");
            }
        }
        switch (opKey) {
            case "guarantee": 
            case "unguarantee": {
                DynamicObject bill = this.getModel().getDataEntity(true);
                Object id = bill.getPkValue();
                HashSet<Object> idSet = new HashSet<Object>(8);
                idSet.add(id);
                String result = GuaranteeHelper.validatedGuaranteeTrade(idSet, (String)ReceivePayTypeEnum.PAYBILL.getValue(), (String)opKey);
                if (EmptyUtil.isNoEmpty((String)result)) {
                    this.getView().showTipNotification(result);
                    args.setCancel(true);
                    break;
                }
                result = GuaranteeHelper.validatedIsReleaseGuaranteeBill(idSet, (String)opKey);
                if (!EmptyUtil.isNoEmpty((String)result)) break;
                this.getView().showTipNotification(result);
                args.setCancel(true);
                break;
            }
            case "canceldrawbill": {
                logger.info("canceldrawbill will refresh");
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.equals((CharSequence)"creditlimit", (CharSequence)actionId)) {
            if (returnData instanceof String) {
                CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)((String)returnData), CreditLimitF7ResBean.class);
                Long creditLimitId = res.getCreditLimitId();
                DynamicObject creditLimitDy = this.getModel().getDataEntity().getDynamicObject("creditlimit");
                if (EmptyUtil.isNoEmpty((DynamicObject)creditLimitDy)) {
                    boolean isChange;
                    long creditLimitOldId = creditLimitDy.getLong("id");
                    boolean bl = isChange = EmptyUtil.isNoEmpty((Long)creditLimitOldId) && creditLimitId.compareTo(creditLimitOldId) == 0;
                    if (isChange) {
                        this.getModel().setValue("creditlimit", null);
                    }
                }
                this.getModel().setValue("creditlimit", (Object)creditLimitId);
                this.getModel().setValue("creditamount", (Object)res.getRealBizAmt());
                this.getModel().setValue("creditcurrency", (Object)res.getTargetCurrencyId());
                this.getModel().setValue("amountofcredit", (Object)res.getExchangeAmt());
            }
        } else if (StringUtils.equals((CharSequence)"basedraftbillno", (CharSequence)actionId) && null != returnData) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            this.getModel().setValue("basedraftbillno", rows.get(0).getPrimaryKeyValue());
        } else {
            ListSelectedRow row;
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            if (rows != null && EmptyUtil.isNoEmpty((Object)(row = rows.get(0)))) {
                switch (actionId) {
                    case "drawercompany": {
                        this.drawercompanyCloseCallback(row);
                        break;
                    }
                    case "draweraccount": {
                        this.draweraccountCloseCallback(row);
                        break;
                    }
                    case "receiveraccount": {
                        this.receiveraccountCloseCallback(row, "receiver", "receiveraccount");
                        break;
                    }
                    case "receiverbank": {
                        this.receiverbankCloseCallback(row);
                        break;
                    }
                    case "company": {
                        this.companyCloseCallBack(row);
                        break;
                    }
                    case "accepterfinorg": {
                        this.getModel().setValue("accepterfinorg", row.getPrimaryKeyValue());
                        break;
                    }
                    case "issuepromiseraccount": {
                        this.receiveraccountCloseCallback(row, "issuepromiser", "issuepromiseraccount");
                        break;
                    }
                    case "acceptpromiseraccount": {
                        this.receiveraccountCloseCallback(row, "acceptpromiser", "acceptpromiseraccount");
                        break;
                    }
                    case "baleac": {
                        this.baleacCloseCallBack(row);
                    }
                }
            }
        }
    }

    private void baleacCloseCallBack(ListSelectedRow row) {
        DynamicObject bdAccountbank = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"bd_accountbanks");
        if (EmptyUtil.isNoEmpty((DynamicObject)bdAccountbank)) {
            this.getModel().setValue(BALEAC_ACTIONID, (Object)bdAccountbank.getString("bankaccountnumber"));
        }
    }

    private void companyCloseCallBack(ListSelectedRow row) {
        this.getModel().setValue("company", row.getPrimaryKeyValue());
        DynamicObject baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)row.getPrimaryKeyValue()));
        if (!EmptyUtil.isEmpty((DynamicObject)baseCurrency)) {
            this.getModel().setValue("currency", baseCurrency.getPkValue());
        }
    }

    private void receiverbankCloseCallback(ListSelectedRow row) {
        this.getModel().setValue("receiverbank", row.getPrimaryKeyValue());
        DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"bd_bebank");
        if (EmptyUtil.isNoEmpty((DynamicObject)bdBebankDO)) {
            this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_invalid": {
                if (SourceEnum.CAS.getValue().equals(this.getModel().getValue("source"))) {
                    this.getView().showConfirm(new CdmBizResource().getTipInvalidCom(), MessageBoxOptions.YesNo, new ConfirmCallBackListener("INVALID_CONFIRM", (IFormPlugin)this));
                    break;
                }
                this.getView().invokeOperation("invalid");
                break;
            }
            case "delvoucher": 
            case "previewvoucher": {
                Boolean isVoucher = (Boolean)this.getModel().getValue("isvoucher");
                logger.info("isVoucher is:" + isVoucher);
                if (isVoucher.booleanValue()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u672a\u751f\u6210\uff01", (String)"PayableBillEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "bar_unaudit": {
                Boolean isVoucherGen = (Boolean)this.getModel().getValue("isvoucher");
                logger.info("isVoucher is:" + isVoucherGen);
                if (!isVoucherGen.booleanValue()) break;
                String billnoStr = this.getModel().getValue("billno").toString();
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1 ,\u662f\u5426\u7ee7\u7eed\u53cd\u5ba1\u6838\uff1f", (String)"PayableBillEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billnoStr), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_UNAUDITBILL_CALLBACK", (IFormPlugin)this));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "trackcaspayview": {
                ListShowParameter parameter;
                long draftBillId = this.getModel().getDataEntity(true).getLong("id");
                if (!EmptyUtil.isNoEmpty((Long)draftBillId)) break;
                Object[] cdmPayBillIdArr = new Long[]{draftBillId};
                Set casPayBillIdSetAll = DraftHelper.getCasBillId((Object[])cdmPayBillIdArr, (String)"paybill", (String)"cas_paybill", (ListShowParameter)(parameter = new ListShowParameter()));
                if (EmptyUtil.isEmpty((Collection)casPayBillIdSetAll)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u4e0d\u5b58\u5728\u51fa\u7eb3\u5355\u636e\u3002", (String)"PayableApplyBillBatchList_3_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("delete");
        } else if ("INVALID_CONFIRM".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getView().invokeOperation("invalid");
            }
        } else if ("CONFIRM_UNAUDITBILL_CALLBACK".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().invokeOperation("unaudit");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object draftbilltype = this.getModel().getValue("draftbilltype");
        if ("locamt".equals(key)) {
            return;
        }
        boolean isModifyData = false;
        if (this.getView().getFormShowParameter().getCustomParam("modifydata") != null) {
            isModifyData = true;
        }
        if (this.skip) {
            this.skip = false;
            return;
        }
        ChangeData[] changeData = e.getChangeSet();
        Object propValue = changeData[0].getNewValue();
        Object oldPropValue = changeData[0].getOldValue();
        switch (key) {
            case "issuedate": {
                this.issuedateChange();
                break;
            }
            case "draftbillexpiredate": {
                this.draftbillexpiredateChange(e);
                break;
            }
            case "draftbilltype": {
                this.draftbilltypeChange(e, draftbilltype);
                this.draftBillTypeDefault(e, draftbilltype);
                if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
                    DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
                    this.setEleStatus();
                    this.setBankNoMust(draftbilltypeDO);
                    this.setAcceptDateMust(draftbilltypeDO);
                    this.setAcpFlgVisible();
                }
                this.fillAmountofcredit();
                break;
            }
            case "drawercompany": {
                this.companyChange(draftbilltype);
                this.getDefaultDraftNo();
                DynamicObject newValue = (DynamicObject)changeData[0].getNewValue();
                if (newValue == null) break;
                this.getModel().setValue("company", newValue.getPkValue());
                this.getModel().setValue("drawercompany", newValue.getPkValue());
                this.getModel().setValue("drawername", newValue.get("name"));
                break;
            }
            case "draweraccount": {
                this.drawerAccountChange(draftbilltype);
                this.getDefaultDraftNo();
                break;
            }
            case "drawerbankname": {
                this.drawerbanknameChange((DynamicObject)draftbilltype);
                break;
            }
            case "receiver": {
                this.receiverChange();
                break;
            }
            case "drawerorg": {
                this.drawerorgChange();
                break;
            }
            case "payeetype": {
                this.getModel().setValue("receiver", null);
                this.getModel().setValue("receivername", null);
                this.getModel().setValue("receiveraccount", null);
                this.getModel().setValue("receiverbank", null);
                this.getModel().setValue("receiverbankno", null);
                this.getView().updateView();
                break;
            }
            case "amount": {
                this.getModel().setValue("creditlimit", null);
                this.setSubBillInfoByAmount();
                this.fillAmountofcredit();
                this.setOriginalInfo();
                this.setSuretyAmount();
                break;
            }
            case "suretymoney": {
                BigDecimal suretyMoney = (BigDecimal)this.getModel().getValue("suretymoney");
                BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
                if (suretyMoney.compareTo(BigDecimal.ZERO) < 0 || suretyMoney.compareTo(amount) > 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u503c\u8303\u56f4\u4e3a\u30100\uff0c%s\u3011", (String)"CdmBizResource_180", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), amount), Integer.valueOf(2000));
                    this.getModel().setValue("suretymoney", oldPropValue);
                    break;
                }
                this.setCreditAmount();
                break;
            }
            case "acceptercompany": {
                DynamicObject acceptercompanyDO = this.getModel().getDataEntity().getDynamicObject("acceptercompany");
                if (EmptyUtil.isNoEmpty((DynamicObject)acceptercompanyDO)) {
                    this.getModel().setValue("acceptername", (Object)acceptercompanyDO.getString("name"));
                }
                this.getModel().setValue("creditlimitcompany", (Object)acceptercompanyDO);
                break;
            }
            case "currency": {
                this.getDefaultDraftNo();
                break;
            }
            case "receiverbank": {
                DynamicObject receiverbankDO = this.getModel().getDataEntity().getDynamicObject("receiverbank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)receiverbankDO)) break;
                DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)receiverbankDO.getPkValue(), (String)"bd_bebank");
                this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
                break;
            }
            case "accepterfinorg": {
                DynamicObject accepterFinOrg = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (accepterFinOrg != null) {
                    this.getModel().setValue("acceptername", accepterFinOrg.get("name"));
                    this.getModel().setValue("accepterbankname", accepterFinOrg.get("name"));
                    this.getModel().setValue("accepterbankno", (Object)accepterFinOrg.getString("union_number"));
                } else {
                    this.getModel().setValue("acceptername", null);
                    this.getModel().setValue("accepterbankname", null);
                    this.getModel().setValue("accepterbankno", null);
                }
                this.getModel().setValue("creditlimitorg", (Object)accepterFinOrg);
                this.setAcpFlgVisible();
                break;
            }
            case "issuepromisertype": {
                this.getModel().setValue("issuepromiser", null);
                this.getModel().setValue("issuepromiseraccount", null);
                this.getModel().setValue("issuepromiseraddr", null);
                this.getModel().setValue("issuepromiserdate", null);
                this.getModel().setValue("issuepromisername", null);
                this.getView().updateView();
                break;
            }
            case "acceptpromisertype": {
                this.getModel().setValue("acceptpromiser", null);
                this.getModel().setValue("acceptpromiseraccount", null);
                this.getModel().setValue("acceptpromiseraddr", null);
                this.getModel().setValue("acceptpromiserdate", null);
                this.getModel().setValue("acceptpromisername", null);
                this.getView().updateView();
                break;
            }
            case "basedraftbillno": {
                DynamicObject basedraftbillno = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (basedraftbillno == null) break;
                this.getModel().setValue("draftbillno", (Object)basedraftbillno.getString("billno"));
                break;
            }
            case "subbillstartflag": 
            case "subbillendflag": {
                if (isModifyData) {
                    long subbillstartflag = (Long)this.getModel().getValue("subbillstartflag");
                    long subbillEndflag = (Long)this.getModel().getValue("subbillendflag");
                    this.getModel().setValue("subbillrange", (Object)(subbillstartflag + "-" + subbillEndflag));
                    this.getModel().setValue("subbillquantity", (Object)(subbillEndflag - subbillstartflag + 1L));
                    break;
                }
                this.calculateSubBill();
                break;
            }
            case "issplit": {
                this.initializeSubBillInfo();
                this.setEleStatus();
                break;
            }
            case "backgroundinfo": {
                this.getModel().setValue("backgroundinfodate", null);
                this.getModel().setValue("backgroundinfotransferee", null);
                this.getModel().setValue("backgroundinfocontent", null);
                break;
            }
            case "accepteraccountid": {
                DynamicObject bankAccount = (DynamicObject)this.getModel().getValue("accepteraccountid");
                if (!EmptyUtil.isNoEmpty((DynamicObject)bankAccount)) break;
                this.getModel().setValue("accepteraccount", (Object)bankAccount.getString("number"));
                this.getModel().setValue("accepterbankname", (Object)bankAccount.getDynamicObject("bank").getString("name"));
                if (bankAccount.getDynamicObject("bank") == null) break;
                DynamicObject finOrgInfo = TmcDataServiceHelper.loadSingle((Object)bankAccount.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo");
                if (finOrgInfo.getDynamicObject("bebank") == null) {
                    this.getModel().setValue("accepterbankno", (Object)finOrgInfo.getString("union_number"));
                    break;
                }
                DynamicObject beBank = TmcDataServiceHelper.loadSingle((Object)finOrgInfo.getDynamicObject("bebank").getPkValue(), (String)"bd_bebank");
                String union_number = beBank.getString("union_number");
                if (StringUtils.isEmpty((CharSequence)union_number)) {
                    this.getModel().setValue("accepterbankno", (Object)beBank.getString("number"));
                    break;
                }
                this.getModel().setValue("accepterbankno", (Object)union_number);
                break;
            }
            case "creditlimit": {
                if (propValue != null) break;
                this.getModel().setValue("creditcurrency", null);
                this.getModel().setValue("amountofcredit", null);
                break;
            }
            case "promisrate": 
            case "paybilltype": {
                this.fillAmountofcredit();
                if (propValue != null && StringUtils.contains((CharSequence)propValue.toString(), (CharSequence)"credit")) {
                    this.getModel().setValue("creditlimitorg", this.getModel().getValue("accepterfinorg"));
                }
                if (!"paybilltype".equals(key)) break;
                this.setCreditEnableAndValue(propValue);
                break;
            }
            case "creditamount": {
                BigDecimal creditamount = (BigDecimal)propValue;
                BigDecimal totalamount = (BigDecimal)this.getModel().getValue("amount");
                if (creditamount.compareTo(totalamount) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u5360\u7528\u6388\u4fe1\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u7968\u9762\u91d1\u989d\u3002", (String)"PayableBillEdit_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("creditamount", (Object)((BigDecimal)oldPropValue));
                }
                this.setSuretyAmount();
                break;
            }
            case "draftbillno": {
                this.setOriginalInfo();
                break;
            }
            case "creditlimitorg": 
            case "creditlimitcompany": {
                this.getModel().setValue("creditlimit", null);
                break;
            }
            case "accepteraccount": {
                Object accepterAcc = this.getModel().getValue("accepteraccount");
                if (!EmptyUtil.isEmpty((Object)accepterAcc)) break;
                this.skip = true;
                this.getModel().setValue("accepteraccountid", null);
            }
        }
    }

    private void setSuretyAmount() {
        String paybillType = this.getModel().getDataEntity().getString("paybilltype");
        if (EmptyUtil.isNoEmpty((String)paybillType) && StringUtils.contains((CharSequence)paybillType, (CharSequence)"guarantee")) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            BigDecimal creditAmount = (BigDecimal)this.getModel().getValue("creditamount");
            if (EmptyUtil.isEmpty((BigDecimal)creditAmount) || BigDecimal.ZERO.compareTo(creditAmount) == 0) {
                BigDecimal promisrate = (BigDecimal)this.getModel().getValue("promisrate");
                creditAmount = amount.multiply(new BigDecimal(1).subtract(promisrate.divide(new BigDecimal(100))));
            }
            BigDecimal suretyMoney = amount.subtract(creditAmount);
            this.skip = true;
            this.getModel().setValue("suretymoney", (Object)suretyMoney);
        }
    }

    private void setCreditAmount() {
        String paybillType = this.getModel().getDataEntity().getString("paybilltype");
        if (EmptyUtil.isEmpty((String)paybillType) || !StringUtils.contains((CharSequence)paybillType, (CharSequence)"credit")) {
            return;
        }
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal suretyMoney = (BigDecimal)this.getModel().getValue("suretymoney");
        if (EmptyUtil.isEmpty((BigDecimal)suretyMoney)) {
            suretyMoney = BigDecimal.ZERO;
        }
        BigDecimal creditAmount = amount.subtract(suretyMoney);
        this.skip = true;
        this.getModel().setValue("creditamount", (Object)creditAmount);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey) {
            case "remit": {
                this.transerOperate(operationResult, "payoff");
                break;
            }
            case "payinterestdeal": {
                this.transerOperate(operationResult, "payinterest");
                break;
            }
            case "invalid": {
                if (!operationResult.isSuccess()) break;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_del", "bar_save", "bar_submit", "bar_invalid", "bar_print", "bar_refresh"});
                this.getView().showSuccessNotification(new CdmBizResource().getTipInvalidSuccess());
                break;
            }
            case "remitreceive": {
                if (operationResult.isSuccess()) {
                    this.getView().invokeOperation("refresh");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u6210\u529f", (String)"PayableBillEdit_1_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                List list = operationResult.getAllErrorOrValidateInfo();
                StringBuilder sb = new StringBuilder();
                for (IOperateInfo iOperateInfo : list) {
                    sb.append(iOperateInfo.getMessage());
                }
                this.getView().showErrorNotification(sb.toString());
                break;
            }
            case "drawbillsave": {
                if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
                    this.getView().invokeOperation("refresh");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u51fa\u7968\u6210\u529f", (String)"PayableBillEdit_1_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                List list = operationResult.getAllErrorOrValidateInfo();
                StringBuilder sb = new StringBuilder();
                for (IOperateInfo iOperateInfo : list) {
                    sb.append(iOperateInfo.getMessage());
                }
                this.getView().showErrorNotification(sb.toString());
                break;
            }
            case "canceldrawbill": {
                if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
                    this.getView().invokeOperation("refresh");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u51fa\u7968\u6210\u529f\u3002", (String)"PayableBillEdit_1_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                List list = operationResult.getAllErrorOrValidateInfo();
                if (list == null || list.isEmpty()) break;
                break;
            }
            case "relatedprebill": {
                if (!operationResult.isSuccess() || operationResult.getSuccessPkIds().size() <= 0) break;
                DynamicObject payBill = this.getModel().getDataEntity();
                FormShowParameter para = new FormShowParameter();
                para.setFormId("cdm_relatedprebill");
                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                para.setCustomParam("srcbilltype", (Object)"cdm_payablebill");
                para.setCustomParam("srcbillid", (Object)payBill.getLong("id"));
                para.setCustomParam("id", (Object)new Long[]{payBill.getLong("id")});
                this.getView().showForm(para);
                break;
            }
            case "cancelrelatedprebill": {
                if (!operationResult.isSuccess() || operationResult.getSuccessPkIds().size() <= 0) break;
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5173\u8054\u6210\u529f\uff01", (String)"PayableBillList_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "guarantee": 
            case "unguarantee": {
                DynamicObject bill = this.getModel().getDataEntity(true);
                HashMap<String, Object> param = new HashMap<String, Object>();
                HashMap<String, Object> customParam = new HashMap<String, Object>();
                customParam.put("biztype", operateKey);
                customParam.put("billIds", Collections.singletonList(bill.getPkValue()));
                customParam.put("sourceBillId", bill.getPkValue());
                param.put("customParam", customParam);
                param.put("formId", "cdm_guarantee_discount");
                param.put("showType", ShowType.MainNewTabPage);
                CdmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
                break;
            }
        }
        if (!SourceEnum.CAS.getValue().equals(this.getModel().getValue("source")) || "A".equalsIgnoreCase((String)this.getModel().getValue("billstatus"))) {
            // empty if block
        }
        if (EmptyUtil.isNoEmpty((Object)operationResult) && operationResult.isSuccess() && ("save".equals(operateKey) || "submit".equals(operateKey))) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void fillAmountofcredit() {
        BigDecimal promisrate;
        String paybillType = this.getModel().getDataEntity().getString("paybilltype");
        if (EmptyUtil.isEmpty((String)paybillType)) {
            return;
        }
        DynamicObject draftbilltype = (DynamicObject)this.getModel().getValue("draftbilltype");
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        if (draftbilltype != null) {
            String settlementtype = draftbilltype.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                if (StringUtils.contains((CharSequence)paybillType, (CharSequence)"guarantee")) {
                    promisrate = (BigDecimal)this.getModel().getValue("promisrate");
                    BigDecimal amountofcredit = amount.multiply(new BigDecimal(1).subtract(promisrate.divide(new BigDecimal(100))));
                    this.getModel().setValue("creditamount", (Object)amountofcredit);
                } else {
                    this.getModel().setValue("creditamount", (Object)amount);
                }
            } else {
                this.getModel().setValue("creditamount", (Object)BigDecimal.ZERO);
            }
        }
        if (StringUtils.contains((CharSequence)paybillType, (CharSequence)"guarantee")) {
            BigDecimal amount2 = (BigDecimal)this.getModel().getValue("amount");
            promisrate = (BigDecimal)this.getModel().getValue("promisrate");
            BigDecimal suretymoney = amount2.multiply(promisrate.multiply(new BigDecimal("0.01")));
            this.getModel().setValue("suretymoney", (Object)suretymoney);
        }
    }

    private void transerOperate(OperationResult operationResult, String type) {
        if (operationResult != null && operationResult.isSuccess()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("tradeType", type);
            this.getView().invokeOperation("pushtradebill", option);
        }
    }

    private void issuePromiserAccountRegisterListener() {
        TextEdit receiveraccount = (TextEdit)this.getControl("issuepromiseraccount");
        receiveraccount.addButtonClickListener(new ClickListener(){

            public void click(EventObject evt) {
                PayableBillEdit.this.showBankInfo("issuepromiser", "issuepromisertype", "issuepromiseraccount");
            }
        });
    }

    private void acceptPromiserAccountRegisterListener() {
        TextEdit receiveraccount = (TextEdit)this.getControl("acceptpromiseraccount");
        receiveraccount.addButtonClickListener(new ClickListener(){

            public void click(EventObject evt) {
                PayableBillEdit.this.showBankInfo("acceptpromiser", "acceptpromisertype", "acceptpromiseraccount");
            }
        });
    }

    private void receiveraccountRegisterListener() {
        TextEdit receiveraccount = (TextEdit)this.getControl("receiveraccount");
        receiveraccount.addButtonClickListener(new ClickListener(){

            public void click(EventObject evt) {
                PayableBillEdit.this.showBankInfo("receiver", "payeetype", "receiveraccount");
            }
        });
    }

    private void draweraccountRegisterListener() {
        BasedataEdit draweraccount;
        if (this.getModel().getProperty("draweraccount") != null && (draweraccount = (BasedataEdit)this.getControl("draweraccount")) != null) {
            draweraccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject drawercompanyDO = this.getModel().getDataEntity().getDynamicObject("drawercompany");
                if (EmptyUtil.isNoEmpty((DynamicObject)drawercompanyDO)) {
                    long orgID = drawercompanyDO.getPkValue() == null ? 0L : Long.parseLong(drawercompanyDO.getPkValue().toString());
                    QFilter filter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgID);
                    QFilter filter1 = new QFilter("acctstatus", "=", (Object)"normal");
                    List qfilter = showParameter.getListFilterParameter().getQFilters();
                    qfilter.add(filter);
                    qfilter.add(filter1);
                }
                showParameter.getListFilterParameter().getQFilters().add(VisibleVirtualAcctHelper.notVirtualAcctQf());
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "draweraccount");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void drawerRegisterListener() {
        BasedataEdit company;
        if (this.getModel().getProperty("drawercompany") != null && (company = (BasedataEdit)this.getControl("drawercompany")) != null) {
            company.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                Long userPK = RequestContext.get().getCurrUserId();
                String appId = this.getView().getFormShowParameter().getAppId();
                String dataEntityName = this.getModel().getDataEntityType().getName();
                List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)dataEntityName, (String)"47150e89000000ac");
                showParameter.setCustomParam("range", (Object)orgIdSet);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "drawercompany");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void companyRegisterListener() {
        BasedataEdit company;
        if (this.getModel().getProperty("company") != null && (company = (BasedataEdit)this.getControl("company")) != null) {
            company.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "company");
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void creditlimitClick() {
        logger.info("creditlimitClick is start");
        BasedataEdit creditLimitEdit = (BasedataEdit)this.getControl("creditlimit");
        if (EmptyUtil.isNoEmpty((Object)creditLimitEdit)) {
            creditLimitEdit.addBeforeF7SelectListener(evt -> {
                Object[] applyIds;
                String message = this.creditLimitValidator();
                if (EmptyUtil.isNoEmpty((String)message)) {
                    this.getView().showErrorNotification(message);
                    evt.setCancel(true);
                    return;
                }
                CreditLimitUseBean useBean = new CreditLimitUseBean();
                Long id = (Long)this.getModel().getValue("id");
                if (id == null || id.equals(0L)) {
                    id = DB.genLongId((String)this.getModel().getDataEntityType().getAlias());
                    this.getModel().setValue("id", (Object)id);
                }
                useBean.setPkId(id);
                useBean.setBillNo((String)this.getModel().getValue("billno"));
                useBean.setEntityName("cdm_payablebill");
                useBean.setOrgId((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue());
                useBean.setCurrencyId((Long)((DynamicObject)this.getModel().getValue("currency")).getPkValue());
                DynamicObject draftbilltype = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
                if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltype)) {
                    String settlementType = draftbilltype.getString("settlementtype");
                    if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                        DynamicObject creditlimitorg = this.getModel().getDataEntity().getDynamicObject("creditlimitorg");
                        if (EmptyUtil.isEmpty((DynamicObject)creditlimitorg)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u627f\u5151\u4eba\u5168\u79f0\u3002", (String)"PayableBillEdit_11", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                            evt.setCancel(true);
                            return;
                        }
                        useBean.setFinOrgId(Long.valueOf(creditlimitorg.getLong("id")));
                        useBean.setCreditFinType("bd_finorginfo");
                    } else if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
                        boolean innerCreditLimit = (Boolean)this.getModel().getValue("innercreditlimit");
                        if (innerCreditLimit) {
                            DynamicObject creditlimitcompany = this.getModel().getDataEntity().getDynamicObject("creditlimitcompany");
                            if (EmptyUtil.isEmpty((DynamicObject)creditlimitcompany)) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u627f\u5151\u4eba\u5168\u79f0\u3002", (String)"PayableBillEdit_11", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                                evt.setCancel(true);
                                return;
                            }
                            useBean.setFinOrgId(Long.valueOf(creditlimitcompany.getLong("id")));
                            useBean.setCreditFinType("bos_org");
                        } else {
                            Object drawerBankName = this.getModel().getValue("drawerbankname");
                            DynamicObject drawerAccount = this.getModel().getDataEntity().getDynamicObject("draweraccount");
                            if (EmptyUtil.isEmpty((Object)drawerBankName) || EmptyUtil.isEmpty((DynamicObject)drawerAccount)) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u51fa\u7968\u4eba\u8d26\u53f7\u548c\u51fa\u7968\u4eba\u5f00\u6237\u94f6\u884c\u3002", (String)"PayableBillEdit_12", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                                evt.setCancel(true);
                                return;
                            }
                            DynamicObject bank = drawerAccount.getDynamicObject("bank");
                            useBean.setFinOrgId(Long.valueOf(bank.getLong("id")));
                            useBean.setCreditFinType("bd_finorginfo");
                        }
                    }
                    DynamicObject credittypeDO = draftbilltype.getDynamicObject("credittype");
                    if (EmptyUtil.isNoEmpty((DynamicObject)credittypeDO)) {
                        useBean.setCreditTypeId((Long)credittypeDO.getPkValue());
                    } else {
                        DynamicObject creditType = TmcDataServiceHelper.loadSingle((String)"cfm_credittype", (String)"iscomprehensive", (QFilter[])new QFilter[]{new QFilter("iscomprehensive", "=", (Object)"1")});
                        useBean.setCreditTypeId((Long)creditType.getPkValue());
                    }
                }
                useBean.setCreditVariety(draftbilltype.getString("name"));
                if (StringUtils.equals((CharSequence)SourceEnum.APPLY.getValue(), (CharSequence)((String)this.getModel().getValue("source"))) && EmptyUtil.isNoEmpty((Object[])(applyIds = TmcDataServiceHelper.load((String)"cdm_payablebill_ap_manual", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", this.getModel().getValue("sourcebillid"))})))) {
                    useBean.setSourceBillId(Long.valueOf(applyIds[0].getLong("id")));
                    useBean.setSourceType("cdm_payablebill_ap_manual");
                }
                useBean.setBizAmt((BigDecimal)this.getModel().getValue("creditamount"));
                useBean.setMaxAmt((BigDecimal)this.getModel().getValue("amount"));
                useBean.setStartDate((Date)this.getModel().getValue("issuedate"));
                useBean.setEndDate((Date)this.getModel().getValue("draftbillexpiredate"));
                FormShowParameter sp = evt.getFormShowParameter();
                sp.setCustomParam("KEY_F7PARAM", (Object)useBean);
                sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "creditlimit"));
            });
        }
    }

    private String creditLimitValidator() {
        StringBuilder message = new StringBuilder();
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("creditamount")) || ((BigDecimal)this.getModel().getValue("creditamount")).compareTo(BigDecimal.ZERO) == 0) {
            message.append(new CdmBizResource().getPbAmountChecknull());
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("draftbillexpiredate"))) {
            message.append(new CdmBizResource().getPbDraftbillexpiredateChecknull());
        }
        if (this.getModel().getValue("draweraccount") == null) {
            message.append(new CdmBizResource().getPbDraweraccountChecknull());
        }
        if (this.getModel().getValue("currency") == null) {
            message.append(new CdmBizResource().getPbCurrencyChecknull());
        }
        return message.toString();
    }

    private void draftbillexpiredateChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Date newValue = (Date)changeSet[0].getNewValue();
        Date oldValue = (Date)changeSet[0].getOldValue();
        if (oldValue != null && newValue != null) {
            Date draftBillExpiredate = this.getDraftBillExpireDate();
            Date issuedate = this.getModel().getDataEntity().getDate("issuedate");
            if (draftBillExpiredate != null && newValue.after(draftBillExpiredate)) {
                this.getView().showErrorNotification(new CdmBizResource().getRbDraftBillExpiredateCheck());
                this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpiredate);
            } else if (draftBillExpiredate != null && issuedate != null && !newValue.after(issuedate)) {
                this.getView().showErrorNotification(new CdmBizResource().getRbDraftBillExpiredateCheck2());
                this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpiredate);
            }
        }
    }

    private void receiveraccountCloseCallback(ListSelectedRow row, String user, String account) {
        Object entryKey = row.getEntryPrimaryKeyValue();
        DynamicObject receiver = this.getModel().getDataEntity().getDynamicObject(user);
        String entityName = receiver.getDataEntityType().getName();
        DynamicObject innerOrg = null;
        boolean isInternalOrg = false;
        if ("bd_supplier".equals(entityName) || "bd_customer".equals(entityName)) {
            innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)receiver);
            IDataModel model = this.getModel();
            DynamicObject draftTradeBill = model.getDataEntity();
            if (user.equalsIgnoreCase("receiver")) {
                isInternalOrg = BaseDataHelper.isInternalOrg((DynamicObject)draftTradeBill.getDynamicObject("company"));
            }
        }
        boolean isEmptyInerOrg = EmptyUtil.isEmpty((DynamicObject)innerOrg);
        boolean isNullInerOrg = innerOrg == null;
        logger.info("isInternalOrg" + isInternalOrg + "entityName is :" + entityName + "isEmptyInerOrg:" + isEmptyInerOrg + ",isNullInerOrg is null:" + isNullInerOrg);
        if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg == null) {
            this.dealSupplierOrCustomer(user, account, entryKey, receiver);
        } else if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg != null && isInternalOrg) {
            this.dealSupplierOrCustomer(user, account, entryKey, receiver);
        } else if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bos_user")) {
            this.getModel().setValue(account, (Object)row.getNumber());
            if (user.equalsIgnoreCase("receiver")) {
                this.fillUserData(row);
            }
        } else {
            logger.info("is other");
            this.getModel().setValue(account, (Object)row.getNumber());
            if (user.equalsIgnoreCase("receiver")) {
                this.fillOther(row);
            }
        }
    }

    private void dealSupplierOrCustomer(String user, String account, Object entryKey, DynamicObject receiver) {
        DynamicObjectCollection entryBank;
        DynamicObject bank = TmcDataServiceHelper.loadSingle((String)receiver.getDataEntityType().getName(), (String)"bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", entryKey)});
        if (!EmptyUtil.isEmpty((DynamicObject)bank) && !EmptyUtil.isEmpty((DynamicObjectCollection)(entryBank = bank.getDynamicObjectCollection("entry_bank")))) {
            for (DynamicObject entry : entryBank) {
                if (!entry.getPkValue().equals(entryKey)) continue;
                this.getModel().setValue(account, (Object)entry.getString("bankaccount"));
                if (!user.equalsIgnoreCase("receiver")) break;
                this.fillSupplierOrCustomer(entry);
                break;
            }
        }
    }

    private void fillOther(ListSelectedRow row) {
        DynamicObject bankDO;
        DynamicObject accountbanksDO = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"bd_accountbanks");
        if (!EmptyUtil.isEmpty((DynamicObject)accountbanksDO) && !EmptyUtil.isEmpty((DynamicObject)(bankDO = accountbanksDO.getDynamicObject("bank")))) {
            this.getModel().setValue("receiverbankno", (Object)bankDO.getString("union_number"));
            DynamicObject bebankDO = bankDO.getDynamicObject("bebank");
            if (!EmptyUtil.isEmpty((DynamicObject)bebankDO)) {
                this.getModel().setValue("receiverbank", bebankDO.getPkValue());
            } else {
                this.getModel().setValue("receiverbank", null);
            }
        }
    }

    private void fillUserData(ListSelectedRow row) {
        DynamicObject payeerDO = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"er_payeer");
        if (EmptyUtil.isNoEmpty((DynamicObject)payeerDO)) {
            DynamicObject payerbankDO = payeerDO.getDynamicObject("payerbank");
            this.getModel().setValue("receiverbank", (Object)payerbankDO);
            DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)payerbankDO.getPkValue(), (String)payerbankDO.getDataEntityType().getName());
            this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
        }
    }

    private void fillSupplierOrCustomer(DynamicObject entry) {
        this.getModel().setValue("receiverbank", (Object)entry.getDynamicObject("bank"));
        if (EmptyUtil.isNoEmpty((DynamicObject)entry.getDynamicObject("bank"))) {
            DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)entry.getDynamicObject("bank").getPkValue(), (String)entry.getDynamicObject("bank").getDataEntityType().getName());
            this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
        }
    }

    private void draweraccountCloseCallback(ListSelectedRow row) {
        this.getModel().setValue("draweraccountname", (Object)row.getNumber());
        this.getModel().setValue("draweraccount", row.getPrimaryKeyValue());
    }

    private void drawercompanyCloseCallback(ListSelectedRow row) {
        this.getModel().setValue("company", row.getPrimaryKeyValue());
        this.getModel().setValue("drawercompany", row.getPrimaryKeyValue());
        this.getModel().setValue("drawername", (Object)row.getName());
    }

    private void drawerorgChange() {
        DynamicObject drawerorgDO = (DynamicObject)this.getModel().getValue("drawerorg");
        this.getModel().setValue("drawerbankname", (Object)drawerorgDO.getString("name"));
        this.getModel().setValue("drawerbankno", (Object)drawerorgDO.getString("union_number"));
    }

    private void receiverChange() {
        this.getModel().setValue("receiveraccount", null);
        this.getModel().setValue("receiverbank", null);
        this.getModel().setValue("receiverbankno", null);
        DynamicObject receiverDO = this.getModel().getDataEntity().getDynamicObject("receiver");
        if (EmptyUtil.isNoEmpty((DynamicObject)receiverDO)) {
            DynamicObject payeerDO;
            this.getModel().setValue("receivername", (Object)receiverDO.getString("name"));
            String entityName = receiverDO.getDataEntityType().getName();
            DynamicObject innerOrg = null;
            if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) {
                innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)receiverDO);
                if (innerOrg == null) {
                    DynamicObject bank = TmcDataServiceHelper.loadSingle((String)entityName, (String)"entry_bank.isdefault_bank,entry_bank.bankaccount,entry_bank.bank,entry_bank.bank.union_number", (QFilter[])new QFilter[]{new QFilter("id", "=", receiverDO.getPkValue())});
                    DynamicObjectCollection entryBanks = bank.getDynamicObjectCollection("entry_bank");
                    for (DynamicObject entryBank : entryBanks) {
                        Boolean isdefaultBank = entryBank.getBoolean("isdefault_bank");
                        if (!isdefaultBank.booleanValue()) continue;
                        String bankaccount = entryBank.getString("bankaccount");
                        DynamicObject bankDO = entryBank.getDynamicObject("bank");
                        this.getModel().setValue("receiveraccount", (Object)bankaccount);
                        if (EmptyUtil.isEmpty((DynamicObject)bankDO)) continue;
                        this.getModel().setValue("receiverbank", bankDO.getPkValue());
                        DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)bankDO.getPkValue(), (String)bankDO.getDataEntityType().getName());
                        if (EmptyUtil.isEmpty((DynamicObject)bdBebankDO)) continue;
                        this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
                    }
                }
            } else if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bos_user") && EmptyUtil.isNoEmpty((DynamicObject)(payeerDO = TmcDataServiceHelper.loadSingle((String)"er_payeer", (String)"payerbank,payeraccount", (QFilter[])new QFilter[]{new QFilter("payer.id", "=", receiverDO.getPkValue()), new QFilter("isdefault", "=", (Object)"1")})))) {
                this.getModel().setValue("receiveraccount", (Object)payeerDO.getString("payeraccount"));
                DynamicObject payerbankDO = payeerDO.getDynamicObject("payerbank");
                this.getModel().setValue("receiverbank", payerbankDO.getPkValue());
                DynamicObject bdBebankDO = TmcDataServiceHelper.loadSingle((Object)payerbankDO.getPkValue(), (String)payerbankDO.getDataEntityType().getName());
                this.getModel().setValue("receiverbankno", (Object)bdBebankDO.getString("union_number"));
            }
        }
    }

    private void companyChange(Object draftbilltype) {
        this.getModel().setValue("drawername", null);
        this.getModel().setValue("draweraccount", null);
        this.getModel().setValue("draweraccountname", null);
        this.getModel().setValue("drawerbankname", null);
        this.getModel().setValue("drawerbankno", null);
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            DynamicObject companyDO = this.getModel().getDataEntity().getDynamicObject("drawercompany");
            if (EmptyUtil.isNoEmpty((DynamicObject)companyDO)) {
                DynamicObject baseCurrency;
                this.getModel().setValue("drawername", (Object)companyDO.getString("name"));
                if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                    this.getModel().setValue("acceptercompany", (Object)companyDO);
                    this.getModel().setValue("acceptername", (Object)companyDO.getString("name"));
                }
                if (!EmptyUtil.isEmpty((DynamicObject)(baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)companyDO.getPkValue()))))) {
                    this.getModel().setValue("currency", baseCurrency.getPkValue());
                }
            }
        }
    }

    private void drawerbanknameChange(DynamicObject draftbilltype) {
        DynamicObject draftbilltypeDO = draftbilltype;
        String settlementtype = draftbilltypeDO.getString("settlementtype");
        if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
            DynamicObject finorginfoDO;
            String drawerbankname = this.getModel().getValue("drawerbankname").toString();
            this.getModel().setValue("acceptername", (Object)drawerbankname);
            DynamicObject drawerAccount = this.getModel().getDataEntity().getDynamicObject("draweraccount");
            this.getModel().setValue("accepterfinorg", drawerAccount == null ? null : drawerAccount.getDynamicObject("bank"));
            DynamicObject draweraccountDO = this.getModel().getDataEntity().getDynamicObject("draweraccount");
            if (EmptyUtil.isNoEmpty((DynamicObject)draweraccountDO) && EmptyUtil.isNoEmpty((DynamicObject)(finorginfoDO = TmcDataServiceHelper.loadSingle((Object)draweraccountDO.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo")))) {
                this.getModel().setValue("accepterbankname", (Object)finorginfoDO.getString("name"));
                this.getModel().setValue("accepterbankno", (Object)finorginfoDO.getString("union_number"));
            }
        }
    }

    private void drawerAccountChange(Object draftBillType) {
        this.getModel().setValue("drawerbankname", null);
        this.getModel().setValue("drawerbankno", null);
        DynamicObject drawerAccount = this.getModel().getDataEntity().getDynamicObject("draweraccount");
        if (EmptyUtil.isNoEmpty((DynamicObject)drawerAccount)) {
            DynamicObject finOrgInfoDO;
            this.getModel().setValue("draweraccountname", (Object)drawerAccount.getString("name"));
            if (EmptyUtil.isEmpty((Object)draftBillType)) {
                return;
            }
            QFilter accountNumberFilter = new QFilter("account.bankaccountnumber", "=", (Object)drawerAccount.getString("bankaccountnumber"));
            Object[] accountmaintenances = TmcDataServiceHelper.load((String)"am_accountmaintenance", (String)"id,bank,billbank,billbankname", (QFilter[])new QFilter[]{accountNumberFilter});
            if (!EmptyUtil.isEmpty((Object[])accountmaintenances)) {
                if (!EmptyUtil.isEmpty((DynamicObject)accountmaintenances[0].getDynamicObject("billbank"))) {
                    this.getModel().setValue("drawerbankname", (Object)accountmaintenances[0].getDynamicObject("billbank").getString("name"));
                }
                this.getModel().setValue("drawerbankno", (Object)accountmaintenances[0].getString("billbankname"));
                logger.info("PayableBillEdit accountmaintenances not empty,billbank is \uff1a" + accountmaintenances[0].getDynamicObject("billbank") + ",billbankname is :" + accountmaintenances[0].getString("billbankname"));
            } else {
                if (EmptyUtil.isEmpty((DynamicObject)drawerAccount.getDynamicObject("bank"))) {
                    return;
                }
                finOrgInfoDO = TmcDataServiceHelper.loadSingle((Object)drawerAccount.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo");
                this.getModel().setValue("drawerbankname", (Object)drawerAccount.getDynamicObject("bank").getString("name"));
                if (finOrgInfoDO.getDynamicObject("bebank") == null) {
                    this.getModel().setValue("drawerbankno", (Object)finOrgInfoDO.getString("union_number"));
                } else {
                    DynamicObject beBank = TmcDataServiceHelper.loadSingle((Object)finOrgInfoDO.getDynamicObject("bebank").getPkValue(), (String)"bd_bebank");
                    String union_number = beBank.getString("union_number");
                    if (StringUtils.isEmpty((CharSequence)union_number)) {
                        this.getModel().setValue("drawerbankno", (Object)beBank.getString("number"));
                    } else {
                        this.getModel().setValue("drawerbankno", (Object)union_number);
                    }
                }
                logger.info("PayableBillEdit accountmaintenances is empty");
            }
            if (EmptyUtil.isEmpty((DynamicObject)drawerAccount.getDynamicObject("bank"))) {
                return;
            }
            DynamicObject draftBillTypeDy = (DynamicObject)draftBillType;
            String settlementType = draftBillTypeDy.getString("settlementtype");
            DynamicObject drawerCompany = (DynamicObject)this.getModel().getValue("drawercompany");
            DynamicObject accepterCompany = (DynamicObject)this.getModel().getValue("acceptercompany");
            long drawerCompanyId = drawerCompany == null ? 0L : drawerCompany.getLong("id");
            long accepterCompanyId = accepterCompany == null ? 0L : accepterCompany.getLong("id");
            finOrgInfoDO = TmcDataServiceHelper.loadSingle((Object)drawerAccount.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue()) && accepterCompanyId != 0L && drawerCompanyId == accepterCompanyId) {
                this.getModel().setValue("accepteraccount", (Object)drawerAccount.getString("bankaccountnumber"));
                this.getModel().setValue("accepteraccountid", drawerAccount.getPkValue());
                this.getModel().setValue("accepterbankname", (Object)drawerAccount.getDynamicObject("bank").getString("name"));
                if (finOrgInfoDO.getDynamicObject("bebank") == null) {
                    this.getModel().setValue("accepterbankno", (Object)finOrgInfoDO.getString("union_number"));
                } else {
                    DynamicObject beBank = TmcDataServiceHelper.loadSingle((Object)finOrgInfoDO.getDynamicObject("bebank").getPkValue(), (String)"bd_bebank");
                    String union_number = beBank.getString("union_number");
                    if (EmptyUtil.isNoEmpty((String)union_number)) {
                        this.getModel().setValue("accepterbankno", (Object)beBank.getString("union_number"));
                    } else {
                        this.getModel().setValue("accepterbankno", (Object)beBank.getString("number"));
                    }
                }
            }
        }
    }

    private void draftBillTypeDefault(PropertyChangedArgs e, Object draftBillType) {
        if (EmptyUtil.isNoEmpty((Object)draftBillType)) {
            DynamicObject draftBillTypeDy = (DynamicObject)draftBillType;
            String settlementType = draftBillTypeDy.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                Object accepterAcc = this.getModel().getValue("accepteraccount");
                if (EmptyUtil.isEmpty((Object)accepterAcc)) {
                    this.getModel().setValue("accepteraccount", (Object)"0");
                }
            } else {
                this.getModel().setValue("accepteraccount", (Object)"");
            }
            this.getView().setEnable(Boolean.valueOf(!StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())), new String[]{"accepterbankname", "accepterbankno"});
        }
    }

    private void draftbilltypeChange(PropertyChangedArgs e, Object draftbilltype) {
        if (EmptyUtil.isNoEmpty((Object)draftbilltype)) {
            DynamicObject draftbilltypeDO = (DynamicObject)draftbilltype;
            Date draftBillExpireDate = this.getDraftBillDefaultExpireDate();
            if (draftBillExpireDate != null) {
                this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpireDate);
            }
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            String billMedium = draftbilltypeDO.getString("billmedium");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                if ("1".equals(billMedium)) {
                    this.getModel().setValue("billtype", (Object)CdmBizConstant.PAYABLEBILL_BANK);
                } else {
                    this.getModel().setValue("billtype", (Object)CdmBizConstant.PAYABLEBILL_BANK_ELECT);
                }
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                if ("1".equals(billMedium)) {
                    this.getModel().setValue("billtype", (Object)CdmBizConstant.PAYABLEBILL_BUSINESS);
                } else {
                    this.getModel().setValue("billtype", (Object)CdmBizConstant.PAYABLEBILL_BUSINESS_ELECT);
                }
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                this.getModel().setValue("billtype", (Object)CdmBizConstant.PAYABLEBILL_CHECK);
                this.getModel().setValue("company", (Object)RequestContext.get().getOrgId());
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                this.getModel().setValue("billtype", (Object)CdmBizConstant.PAYABLEBILL_PROMISSORY);
                this.getDefaultDraftNo();
            }
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue()) || StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                this.getModel().setValue("issplit", (Object)Character.valueOf('0'));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"issplit"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"issplit"});
            }
            this.getModel().setValue("draftbilltype", (Object)((DynamicObject)e.getChangeSet()[0].getNewValue()));
            if (!StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                Object value = this.getModel().getValue("company");
                this.getModel().setValue("drawercompany", null);
                this.getModel().setValue("drawercompany", value);
            }
        }
    }

    private void issuedateChange() {
        Date draftBillExpireDate = this.getDraftBillDefaultExpireDate();
        Date date = this.getModel().getDataEntity().getDate("draftbillexpiredate");
        if (date == null && draftBillExpireDate != null || draftBillExpireDate != null && date != null && date.after(draftBillExpireDate)) {
            this.getModel().setValue("draftbillexpiredate", (Object)draftBillExpireDate);
        }
    }

    private Date getDraftBillExpireDate() {
        DynamicObject draftbilltypeDO = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            Date draftbillexpiredate = null;
            int validitytime = draftbilltypeDO.getInt("validitytime");
            String unit = draftbilltypeDO.getString("unit");
            Date issuedate = (Date)this.getModel().getValue("issuedate");
            if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.MONTH.getValue()) && issuedate != null) {
                draftbillexpiredate = DateUtils.getNextMonth((Date)issuedate, (int)validitytime);
                if (draftbillexpiredate.getDate() != issuedate.getDate()) {
                    draftbillexpiredate = DateUtils.getNextDay((Date)draftbillexpiredate, (int)(-draftbillexpiredate.getDate()));
                }
            } else if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.DAY.getValue()) && issuedate != null) {
                draftbillexpiredate = DateUtils.getNextDay((Date)issuedate, (int)validitytime);
            }
            return draftbillexpiredate;
        }
        return null;
    }

    private Date getDraftBillDefaultExpireDate() {
        DynamicObject draftbilltypeDO = this.getModel().getDataEntity().getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            Date draftbillexpiredate = null;
            int validitytime = draftbilltypeDO.getInt("defaulttime");
            String unit = draftbilltypeDO.getString("defaultunit");
            Date issuedate = (Date)this.getModel().getValue("issuedate");
            if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.MONTH.getValue()) && issuedate != null) {
                draftbillexpiredate = DateUtils.getNextMonth((Date)issuedate, (int)validitytime);
                if (draftbillexpiredate.getDate() != issuedate.getDate()) {
                    draftbillexpiredate = DateUtils.getNextDay((Date)draftbillexpiredate, (int)(-draftbillexpiredate.getDate()));
                }
            } else if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.DAY.getValue()) && issuedate != null) {
                draftbillexpiredate = DateUtils.getNextDay((Date)issuedate, (int)validitytime);
            }
            return draftbillexpiredate;
        }
        return null;
    }

    private void showBankInfo(String accountName, String accountType, String account) {
        IDataModel model = this.getModel();
        DynamicObject draftTradeBill = model.getDataEntity();
        DynamicObject receiver = draftTradeBill.getDynamicObject(accountName);
        if (EmptyUtil.isNoEmpty((DynamicObject)receiver)) {
            String receiverEntityType = receiver.getDataEntityType().getName();
            Object receiverId = receiver.getPkValue();
            Object innerOrgId = null;
            if (StringUtils.equals((CharSequence)receiverEntityType, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)receiverEntityType, (CharSequence)"bd_customer")) {
                DynamicObject innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)receiver);
                if (innerOrg == null) {
                    QFilter qFilter = new QFilter("id", "=", receiverId);
                    String entryBankDO = TmcDataServiceHelper.loadSingle((String)receiverEntityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                    if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                        this.getView().showTipNotification(new CdmBizResource().getTipCsNull());
                        return;
                    }
                } else {
                    innerOrgId = innerOrg.getPkValue();
                }
            }
            ListShowParameter lsp = new ListShowParameter();
            boolean isInternalOrg = BaseDataHelper.isInternalOrg((DynamicObject)draftTradeBill.getDynamicObject("company"));
            switch (receiverEntityType) {
                case "bd_supplier": {
                    if (innerOrgId != null) {
                        if (isInternalOrg && "receiveraccount".equalsIgnoreCase(account)) {
                            lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)receiverId);
                            break;
                        }
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)receiverId);
                    break;
                }
                case "bd_customer": {
                    if (innerOrgId != null) {
                        if (isInternalOrg && "receiveraccount".equalsIgnoreCase(account)) {
                            lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)receiverId);
                            break;
                        }
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)receiverId);
                    break;
                }
                case "bos_org": {
                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)receiverId);
                    break;
                }
                case "bos_user": {
                    lsp = ListConstructorHelper.getPayeerInfoShowParameter((Object)receiverId);
                    break;
                }
            }
            if (lsp != null) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, account);
                lsp.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)lsp);
            }
        } else {
            Object payeetypeObj = this.getModel().getValue(accountType);
            if (null != payeetypeObj) {
                String payeetype = payeetypeObj.toString();
                if (!StringUtils.equals((CharSequence)payeetype, (CharSequence)PayeeTypeEnum.OTHER.getValue())) {
                    this.switchPromiser(accountName);
                }
            } else {
                this.switchPromiser(accountName);
            }
        }
    }

    private void switchPromiser(String accountName) {
        switch (accountName) {
            case "issuepromiser": {
                this.getView().showTipNotification(new CdmBizResource().getIssuePromiserMsg());
                return;
            }
            case "acceptpromiser": {
                this.getView().showTipNotification(new CdmBizResource().getAcceptPromiserMsg());
                return;
            }
            case "receiver": {
                this.getView().showTipNotification(new CdmBizResource().getTipReceiverShort());
                return;
            }
        }
    }

    private void loadCreditUse(Long sourceBillId) {
        if (EmptyUtil.isEmpty((Long)sourceBillId)) {
            return;
        }
        QFilter source_qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        QFilter isrele_qFilter = new QFilter("isrelease", "=", (Object)"0");
        Object[] creditUses = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"sourcebillentryid, currency, realamt", (QFilter[])new QFilter[]{source_qFilter, isrele_qFilter});
        if (EmptyUtil.isNoEmpty((Object[])creditUses)) {
            Object creditUs = creditUses[0];
            Long currency = creditUs.getDynamicObject("currency").getLong("id");
            BigDecimal realamt = creditUs.getBigDecimal("realamt");
            this.getModel().setValue("creditcurrency", (Object)currency);
            this.getModel().setValue("amountofcredit", (Object)realamt);
        }
    }

    private void setBillStatus() {
        IDataEntityProperty property = this.getModel().getProperty("billstatus");
        if (property != null && this.getView() instanceof IBillView) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            logger.info("setBillStatus:" + status.toString());
            if (status == OperationStatus.ADDNEW) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                this.getModel().setValue("modifytag", (Object)"done");
            }
        }
    }

    private void setCreditEnableAndValue(Object payBillType) {
        if (payBillType == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"advconap_surety"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"guaranteeinfopage"});
        } else {
            String billingTypeStr = payBillType.toString();
            this.getView().setEnable(Boolean.valueOf(billingTypeStr.contains("guarantee")), new String[]{"advconap_surety"});
            this.getView().setEnable(Boolean.valueOf(billingTypeStr.contains("assure") || billingTypeStr.contains("pledge") || billingTypeStr.contains("mortgage")), new String[]{"guaranteeinfopage"});
            StringBuilder guarantee = new StringBuilder(",");
            for (String billingTypes : billingTypeStr.split(",")) {
                if ("assure".equals(billingTypes)) {
                    guarantee.append("2").append(",");
                    continue;
                }
                if ("pledge".equals(billingTypes)) {
                    guarantee.append("4").append(",");
                    continue;
                }
                if (!"mortgage".equals(billingTypes)) continue;
                guarantee.append("5").append(",");
            }
            this.getModel().setValue("guarantee", (Object)guarantee.toString());
        }
    }
}

