/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.payablebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.CdmCommonHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.GuaranteeHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class PayableBillList
extends AbstractTmcBillBaseList {
    private static Log logger = LogFactory.getLog(PayableBillList.class);
    private boolean isSearch = false;
    private FilterContainerInitArgs initArgs;
    private static final String KEY_FILTERORGS = "__KEY_FILTERORGS_";

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue()));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        if (!this.isSearch) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                if (!commonFilter.getFieldName().equals("org.id")) continue;
                this.cacheOrgIds(commonFilter.getDefaultValues());
                break;
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFilterValues = (List)filterValues.get("customfilter");
        if (customFilterValues != null) {
            for (Map map : customFilterValues) {
                if (!((List)map.get("FieldName")).get(0).equals("org.id")) continue;
                this.isSearch = true;
                this.cacheOrgIds((List)map.get("Value"));
                break;
            }
        }
        if (filterValues.containsKey("customfilter")) {
            this.filterContainerInit(this.initArgs);
        }
    }

    private void cacheOrgIds(List<Object> orgIds) {
        if (orgIds == null) {
            orgIds = Collections.emptyList();
        }
        List orgLongIds = orgIds.stream().map(Objects::toString).map(Long::parseLong).collect(Collectors.toList());
        this.getPageCache().put(KEY_FILTERORGS, JSON.toJSONString(orgLongIds));
    }

    private List<Long> getOrgIds() {
        String filterOrgIdsStr = this.getPageCache().get(KEY_FILTERORGS);
        if (!EmptyUtil.isEmpty((String)filterOrgIdsStr)) {
            return JSON.parseArray((String)filterOrgIdsStr, Long.class);
        }
        return Collections.emptyList();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        switch (itemKey = evt.getItemKey()) {
            case "tblunaudit": {
                QFilter qFilter2;
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(new CdmBizResource().getTipInvalidNorow());
                    break;
                }
                Set idsSet = selectedRows.stream().map(e -> e.getPrimaryKeyValue()).collect(Collectors.toSet());
                QFilter qFilter1 = new QFilter("id", "in", idsSet);
                DynamicObjectCollection cdmPayBillList = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,isvoucher,billno", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("isvoucher", "=", (Object)"1")});
                if (null == cdmPayBillList || cdmPayBillList.size() <= 0) break;
                Set filterIds = cdmPayBillList.stream().map(e -> e.getString("billno")).collect(Collectors.toSet());
                logger.info("isVoucher list is:" + filterIds);
                StringJoiner msg = new StringJoiner("");
                for (String idstr : filterIds) {
                    msg.add(idstr);
                    msg.add(";\r\n");
                }
                String billnoStr = msg.toString();
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1 ,\u662f\u5426\u7ee7\u7eed\u53cd\u5ba1\u6838\uff1f", (String)"PayableBillList_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billnoStr), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_UNAUDITBILLLIST_CALLBACK", (IFormPlugin)this));
                evt.setCancel(true);
                break;
            }
            case "tblsuretybill": {
                Set idsSet = selectedRows.stream().map(e -> (Long)e.getPrimaryKeyValue()).collect(Collectors.toSet());
                DynamicObject[] payBillApList = TmcDataServiceHelper.load((Object[])idsSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)listview.getBillFormId()));
                boolean isSuretyIng = false;
                for (int i = 0; i < payBillApList.length; ++i) {
                    BigDecimal suretyMoney;
                    DynamicObject payBillAp = payBillApList[i];
                    String billingType = payBillAp.getString("paybilltype");
                    if (!StringUtils.contains((CharSequence)billingType, (CharSequence)"guarantee")) continue;
                    DynamicObjectCollection suretyBills = payBillAp.getDynamicObjectCollection("entry_surety");
                    for (DynamicObject suretyBill : suretyBills) {
                        DynamicObject suretyBillBo = suretyBill.getDynamicObject("suretybill");
                        if ("surety_ing".equals(suretyBillBo.getString("bizstatus"))) continue;
                        isSuretyIng = true;
                        break;
                    }
                    if (BigDecimal.ZERO.compareTo(suretyMoney = payBillAp.getBigDecimal("suretymoney")) < 0) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u4fdd\u8bc1\u91d1\u91d1\u989d\u540e\u518d\u5b58\u5165\u4fdd\u8bc1\u91d1\u3002", (String)"PayableBillList_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (isSuretyIng) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u4fdd\u8bc1\u91d1\u5b58\u5165\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\u5b58\u5165\u4fdd\u8bc1\u91d1\uff1f", (String)"PayableBillList_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("surety_in", (IFormPlugin)this));
                    evt.setCancel(true);
                    break;
                }
                this.getView().invokeOperation("suretyconfigm");
                break;
            }
            case "providebginfo": {
                QFilter qFilter3;
                QFilter qFilter2;
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(new CdmBizResource().getTipInvalidNorow());
                    break;
                }
                Set idSet = selectedRows.stream().map(e -> e.getPrimaryKeyValue()).collect(Collectors.toSet());
                QFilter qFilter1 = new QFilter("id", "in", idSet);
                DynamicObjectCollection cdmPayableBillList = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,billstatus,backgroundinfo", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), qFilter3 = new QFilter("backgroundinfo", "=", (Object)"0")});
                if (null != cdmPayableBillList && cdmPayableBillList.size() == idSet.size()) {
                    this.provideBackgroundInfo();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u72b6\u6001\u4e14\u672a\u63d0\u4f9b\u80cc\u666f\u6750\u6599\u7684\u7968\u636e\u624d\u80fd\u64cd\u4f5c\u63d0\u4f9b\u80cc\u666f\u6750\u6599\u3002", (String)"PayableBillEdit_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "tbldraftinfoedit": {
                if (selectedRows.size() <= 1) break;
                this.getView().showTipNotification(new CdmBizResource().getNotMulitSelected());
                evt.setCancel(true);
                break;
            }
            case "relatedprebill": {
                if (selectedRows.size() != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u9700\u8981\u5173\u8054\u7684\u5e94\u4ed8\u7968\u636e\u3002", (String)"PayableApplyBillBatchList_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        switch (itemKey = evt.getItemKey()) {
            case "invalid": {
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(new CdmBizResource().getTipInvalidNorow());
                    break;
                }
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(new CdmBizResource().getTipInvalidCheck());
                    break;
                }
                DynamicObject cdmPayBill = TmcDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"cdm_payablebill");
                if (null == cdmPayBill) break;
                if (!BillStatusEnum.SAVE.getValue().equals(cdmPayBill.getString("billstatus"))) {
                    this.getView().showErrorNotification(new CdmBizResource().getTipInvalidStatus());
                    break;
                }
                if (SourceEnum.CAS.getValue().equals(cdmPayBill.get("source"))) {
                    this.getView().showConfirm(new CdmBizResource().getTipInvalidCom(), MessageBoxOptions.YesNo, new ConfirmCallBackListener("INVALID_CONFIRM", (IFormPlugin)this));
                    break;
                }
                this.getView().invokeOperation("invalid");
                break;
            }
            case "viewcaspaybills": {
                Object[] cdmPayBillIdArr = selectedRows.getPrimaryKeyValues();
                ListShowParameter parameter = new ListShowParameter();
                Set casPayBillIdSetAll = DraftHelper.getCasBillId((Object[])cdmPayBillIdArr, (String)"paybill", (String)"cas_paybill", (ListShowParameter)parameter);
                if (EmptyUtil.isEmpty((Collection)casPayBillIdSetAll)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u4e0d\u5b58\u5728\u51fa\u7eb3\u5355\u636e\u3002", (String)"PayableApplyBillBatchList_3_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("INVALID_CONFIRM".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getView().invokeOperation("invalid");
            }
        } else if ("CONFIRM_UNAUDITBILLLIST_CALLBACK".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getView().invokeOperation("unaudit");
            }
        } else if ("confirm_close".equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getView().invokeOperation("suretyconfigm");
            }
        } else if ("surety_in".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation("suretyconfigm");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("new".equals(operateKey) || "copy".equals(operateKey)) {
            List<Long> currFilterOrgList = this.getOrgIds();
            if (currFilterOrgList.size() != 1) {
                return;
            }
        } else if ("refund".equals(operateKey)) {
            if (!DraftHelper.isRefund((Object[])selectedRows.getPrimaryKeyValues(), (boolean)true)) {
                this.getView().showErrorNotification(new CdmBizResource().getNoReFund());
                args.setCancel(true);
            }
        } else if ("guarantee".equals(operateKey) || "unguarantee".equals(operateKey)) {
            if (selectedRows.size() == 0) {
                this.getView().showTipNotification(new CdmBizResource().getTipInvalidNorow());
                return;
            }
            Set idSet = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            String result = GuaranteeHelper.validatedGuaranteeTrade(idSet, (String)ReceivePayTypeEnum.PAYBILL.getValue(), (String)operateKey);
            if (EmptyUtil.isNoEmpty((String)result)) {
                this.getView().showTipNotification(result);
                args.setCancel(true);
                return;
            }
            result = GuaranteeHelper.validatedIsReleaseGuaranteeBill(idSet, (String)operateKey);
            if (EmptyUtil.isNoEmpty((String)result)) {
                this.getView().showTipNotification(result);
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        ArrayList<Object> selectIds = new ArrayList<Object>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            selectIds.add(row.getPrimaryKeyValue());
        }
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey) {
            case "remit": {
                this.transerOperate(operationResult, "payoff");
                break;
            }
            case "refund": {
                this.transerOperate(operationResult, "refund");
                break;
            }
            case "billsplit": {
                this.transerOperate(operationResult, "billsplit");
                break;
            }
            case "invalid": {
                if (!operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(new CdmBizResource().getTipInvalidSuccess());
                break;
            }
            case "remitreceive": {
                if (operationResult.isSuccess()) {
                    this.getView().invokeOperation("refresh");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u6210\u529f", (String)"PayableBillList_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                List list = operationResult.getAllErrorOrValidateInfo();
                StringBuilder sb = new StringBuilder();
                for (IOperateInfo iOperateInfo : list) {
                    sb.append(iOperateInfo.getMessage());
                }
                this.getView().showErrorNotification(sb.toString());
                break;
            }
            case "drawbillsave": {
                if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
                    this.getView().invokeOperation("refresh");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u51fa\u7968\u6210\u529f", (String)"PayableBillList_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                List list = operationResult.getAllErrorOrValidateInfo();
                StringBuilder sb = new StringBuilder();
                for (IOperateInfo iOperateInfo : list) {
                    sb.append(iOperateInfo.getMessage());
                }
                this.getView().showErrorNotification(sb.toString());
                break;
            }
            case "canceldrawbill": {
                if (!operationResult.isSuccess() || operationResult.getSuccessPkIds().size() <= 0) break;
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u51fa\u7968\u6210\u529f\u3002", (String)"PayableBillList_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "payinterestdeal": {
                this.transerOperate(operationResult, "payinterest");
                break;
            }
            case "modifydata": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                BillShowParameter parameter = new BillShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setPkId(listview.getFocusRowPkId());
                parameter.setFormId("cdm_payablebill");
                parameter.getCustomParams().put("modifydata", true);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "relatedprebill": {
                if (selectedRows == null || selectedRows.size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u9700\u8981\u5173\u8054\u7684\u5e94\u4ed8\u7968\u636e\u3002", (String)"PayableBillList_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Long> ids = new ArrayList<Long>(8);
                for (ListSelectedRow selectedRow : selectedRows) {
                    Long id = (Long)selectedRow.getPrimaryKeyValue();
                    ids.add(id);
                }
                if (!operationResult.isSuccess() || operationResult.getSuccessPkIds().size() <= 0) break;
                FormShowParameter para = new FormShowParameter();
                para.setFormId("cdm_relatedprebill");
                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                para.setCustomParam("srcbilltype", (Object)"cdm_payablebill");
                para.setCustomParam("id", (Object)ids.toArray(new Long[0]));
                this.getView().showForm(para);
                break;
            }
            case "cancelrelatedprebill": {
                if (!operationResult.isSuccess() || operationResult.getSuccessPkIds().size() <= 0) break;
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5173\u8054\u6210\u529f\uff01", (String)"PayableBillList_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "guarantee": 
            case "unguarantee": {
                HashMap<String, Object> param = new HashMap<String, Object>();
                HashMap<String, Object> customParam = new HashMap<String, Object>();
                customParam.put("biztype", operateKey);
                customParam.put("billIds", selectIds);
                param.put("customParam", customParam);
                param.put("formId", "cdm_guarantee_discount");
                param.put("showType", ShowType.MainNewTabPage);
                CdmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"cdm_providebackgroundinfo")) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (CollectionUtils.isEmpty((Map)returnData)) {
                return;
            }
            Date bgInfoDate = (Date)returnData.get("bgInfoDate");
            String bgInfoTransferee = (String)returnData.get("bgInfoTransferee");
            String bgInfoContent = (String)returnData.get("bgInfoContent");
            IListView listview = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            Set idsSet = selectedRows.stream().map(e -> e.getPrimaryKeyValue()).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("id", "in", idsSet);
            DynamicObject[] cdmPayBillList = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,backgroundinfo,backgroundinfodate,backgroundinfotransferee,backgroundinfocontent", (QFilter[])new QFilter[]{qFilter});
            if (cdmPayBillList == null || cdmPayBillList.length == 0) {
                logger.warn("PayableBillList cdmPayBillList \u5b9e\u4f53\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            for (DynamicObject obj : cdmPayBillList) {
                obj.set("backgroundinfo", (Object)"1");
                obj.set("backgroundinfodate", (Object)bgInfoDate);
                obj.set("backgroundinfotransferee", (Object)bgInfoTransferee);
                obj.set("backgroundinfocontent", (Object)bgInfoContent);
            }
            SaveServiceHelper.save((DynamicObject[])cdmPayBillList);
            this.getView().invokeOperation("refresh");
        }
    }

    private void transerOperate(OperationResult operationResult, String type) {
        if (operationResult != null && operationResult.isSuccess()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("tradeType", type);
            this.getView().invokeOperation("pushtradebill", option);
        }
    }

    private void provideBackgroundInfo() {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("cdm_providebackgroundinfo");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cdm_providebackgroundinfo"));
        this.getView().showForm(para);
    }
}

